/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.java.impl;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.java.JavaLocation;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class JavaLocationInfo
implements JavaLocation {
    private Location location;
    private final int bytecodeIndex;
    private final String className;
    private final String methodName;
    private final String methodSignature;
    private String targetClass;
    private String invokedMethod;
    private String variableName;
    private TreePathHandle cachedHandle;
    private boolean handleResolved;
    private static final EnumSet LOCAL_KINDS = EnumSet.of(ElementKind.EXCEPTION_PARAMETER, ElementKind.PARAMETER, ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE);

    JavaLocationInfo(int bytecodeIndex, String className, String methodName, String methodSignature) {
        this.bytecodeIndex = bytecodeIndex;
        this.className = className;
        this.methodName = methodName;
        this.methodSignature = methodSignature;
    }

    JavaLocationInfo withLocation(Location loc) {
        this.location = loc;
        return this;
    }

    public FileObject getFile() {
        return this.location.getOriginFile();
    }

    public int getLine() {
        return this.location.getLine();
    }

    void callToMethod(String classQN, String methodName) {
        this.invokedMethod = methodName;
        this.targetClass = classQN;
    }

    void referToField(String classQN, String field) {
        this.variableName = field;
        this.targetClass = classQN;
    }

    void referToVariable(String varName) {
        this.variableName = varName;
        this.targetClass = null;
    }

    @Override
    public int getBytecodeIndex() {
        return this.bytecodeIndex;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public boolean isResolved() {
        return this.location.isResolved();
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public String getTargetClass() {
        return this.targetClass;
    }

    @Override
    public String getInvokedMethod() {
        return this.invokedMethod;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreePathHandle setResolvedHandle(TreePathHandle handle) {
        JavaLocationInfo javaLocationInfo = this;
        synchronized (javaLocationInfo) {
            if (!this.handleResolved) {
                this.handleResolved = true;
                this.cachedHandle = handle;
            }
            return this.cachedHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreePathHandle findTreePath() {
        JavaLocationInfo javaLocationInfo = this;
        synchronized (javaLocationInfo) {
            if (this.handleResolved) {
                return this.cachedHandle;
            }
        }
        final TreePathHandle[] result = new TreePathHandle[1];
        FileObject f = this.location.getOriginFile();
        if (f == null) {
            return null;
        }
        try {
            JavaSource js = JavaSource.forFileObject((FileObject)f);
            if (js == null) {
                return this.setResolvedHandle(null);
            }
            js.runUserActionTask((Task)new Task<CompilationController>(){
                int offset;
                int endOffset;
                TreePath foundPath;

                public void run(final CompilationController parameter) throws Exception {
                    Snapshot ss = parameter.getSnapshot();
                    CharSequence contents = ss.getText();
                    this.offset = -1;
                    this.endOffset = contents.length();
                    int curLine = 0;
                    for (int index = 0; index < contents.length(); ++index) {
                        if (contents.charAt(index) != '\n') continue;
                        if (++curLine == JavaLocationInfo.this.location.getLine()) {
                            this.offset = index;
                            continue;
                        }
                        if (curLine != JavaLocationInfo.this.location.getLine() + 1) continue;
                        this.endOffset = index;
                        break;
                    }
                    if (this.offset == -1) {
                        return;
                    }
                    final SourcePositions spos = parameter.getTrees().getSourcePositions();
                    final CompilationUnitTree cut = parameter.getCompilationUnit();
                    final String dottedQN = JavaLocationInfo.this.targetClass == null ? null : JavaLocationInfo.this.targetClass.replace('$', '.');
                    new TreePathScanner(){
                        private boolean containsLine;
                        private boolean parentNotIncluded;

                        @Override
                        public Object scan(Tree tree, Object p) {
                            if (foundPath != null) {
                                return null;
                            }
                            boolean saveParent = this.parentNotIncluded;
                            boolean saveLine = this.containsLine;
                            int tStart = (int)spos.getStartPosition(cut, tree);
                            int tEnd = (int)spos.getEndPosition(cut, tree);
                            if (tStart >= offset && tEnd < endOffset) {
                                saveLine = true;
                            }
                            Object o = super.scan(tree, p);
                            this.containsLine = saveLine;
                            this.parentNotIncluded = saveParent;
                            return o;
                        }

                        @Override
                        public Object visitIdentifier(IdentifierTree node, Object p) {
                            Object o = super.visitIdentifier(node, p);
                            if (!this.containsLine) {
                                return o;
                            }
                            Element el = parameter.getTrees().getElement(this.getCurrentPath());
                            if (el != null) {
                                String fqn;
                                Element clazzEl;
                                String sn = el.getSimpleName().toString();
                                if (sn.equals(JavaLocationInfo.this.variableName)) {
                                    if (JavaLocationInfo.this.targetClass == null) {
                                        if (LOCAL_KINDS.contains((Object)el.getKind())) {
                                            foundPath = this.getCurrentPath();
                                            return o;
                                        }
                                    } else if (el.getKind() != ElementKind.ENUM_CONSTANT && el.getKind() != ElementKind.FIELD) {
                                        return o;
                                    }
                                } else if (sn.equals(JavaLocationInfo.this.methodName)) {
                                    if (el.getKind() != ElementKind.METHOD && el.getKind() != ElementKind.CONSTRUCTOR) {
                                        return o;
                                    }
                                } else {
                                    return o;
                                }
                                if (((clazzEl = el.getEnclosingElement()).getKind().isInterface() || clazzEl.getKind().isClass()) && (fqn = ((TypeElement)clazzEl).getQualifiedName().toString()).equals(dottedQN)) {
                                    foundPath = this.getCurrentPath();
                                    return o;
                                }
                            }
                            return o;
                        }
                    }.scan(new TreePath(parameter.getCompilationUnit()), null);
                    if (this.foundPath != null) {
                        result[0] = TreePathHandle.create((TreePath)this.foundPath, (CompilationInfo)parameter);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this.setResolvedHandle(result[0]);
    }

    public String toString() {
        return "javaloc[class = " + this.className + ", method = " + this.methodName + ", handle = " + this.cachedHandle + ", targetClass = " + this.targetClass + ", callMethod = " + this.invokedMethod + ", variable = " + this.variableName + "]";
    }
}

