/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.java.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.spi.LocationResolver;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class JavaResolver
implements LocationResolver.Factory,
GlobalPathRegistryListener,
PropertyChangeListener {
    private final Collection<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private Map<ClassPath, Reference<PropertyChangeListener>> pathListeners = new WeakHashMap<ClassPath, Reference<PropertyChangeListener>>();
    private final GlobalPathRegistry registry = GlobalPathRegistry.getDefault();
    private LocationResolver sharedInstance;
    private static boolean globalInitialized;

    public JavaResolver() {
        this.registry.addGlobalPathRegistryListener((GlobalPathRegistryListener)WeakListeners.create(GlobalPathRegistryListener.class, (EventListener)this, (Object)GlobalPathRegistry.getDefault()));
        JavaResolver.initGlobalRegistry();
        this.pathsAdded(null);
    }

    public LocationResolver create(InputGraph src) {
        return this.createInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Collection<ChangeListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Collection<ChangeListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
    }

    private void unregisterFrom(ClassPath cp) {
        PropertyChangeListener pl;
        Reference<PropertyChangeListener> rpl = this.pathListeners.remove(cp);
        if (rpl != null && (pl = rpl.get()) != null) {
            cp.removePropertyChangeListener(pl);
        }
    }

    public void pathsRemoved(GlobalPathRegistryEvent event) {
        for (ClassPath cp : event.getChangedPaths()) {
            this.unregisterFrom(cp);
        }
    }

    private boolean possibleJavaRoot(FileObject f, Set<Project> seen) {
        Project p = FileOwnerQuery.getOwner((FileObject)f);
        if (p != null) {
            Sources s;
            if (seen.contains(p) && (s = (Sources)p.getLookup().lookup(Sources.class)) != null) {
                for (SourceGroup sg : s.getSourceGroups("java")) {
                    FileObject root = sg.getRootFolder();
                    ClassPath srcPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
                    if (srcPath == null) continue;
                    return true;
                }
            }
            seen.add(p);
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pathsAdded(GlobalPathRegistryEvent event) {
        HashSet<Project> seen = new HashSet<Project>();
        JavaResolver javaResolver = this;
        synchronized (javaResolver) {
            Set spaths = this.registry.getPaths("classpath/source");
            ArrayList<ClassPath> ncp = new ArrayList<ClassPath>();
            HashSet<ClassPath> oldCp = new HashSet<ClassPath>(this.pathListeners.keySet());
            for (ClassPath cp : spaths) {
                FileObject[] roots = cp.getRoots();
                if (roots.length == 0) {
                    ncp.add(cp);
                    continue;
                }
                for (FileObject f : cp.getRoots()) {
                    if (!this.possibleJavaRoot(f, seen)) continue;
                    ncp.add(cp);
                }
            }
            if (oldCp.containsAll(ncp) && oldCp.size() == ncp.size()) {
                return;
            }
            oldCp.removeAll(ncp);
            for (ClassPath oc : oldCp) {
                this.unregisterFrom(oc);
            }
            ncp.removeAll(this.pathListeners.keySet());
            for (ClassPath nc : ncp) {
                PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nc);
                this.pathListeners.put(nc, new WeakReference<PropertyChangeListener>(l));
                nc.addPropertyChangeListener(l);
            }
        }
        if (event != null) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] ll;
        JavaResolver javaResolver = this;
        synchronized (javaResolver) {
            this.sharedInstance = null;
        }
        Collection<ChangeListener> collection = this.listeners;
        synchronized (collection) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(ev);
        }
    }

    synchronized LocationResolver createInstance() {
        if (this.sharedInstance == null) {
            this.sharedInstance = new GraphLocationResolver();
        }
        return this.sharedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initGlobalRegistry() {
        if (globalInitialized) {
            return;
        }
        try {
            HashSet cpset = new HashSet(GlobalPathRegistry.getDefault().getPaths("classpath/boot"));
            cpset.addAll(GlobalPathRegistry.getDefault().getPaths("classpath/compile"));
            for (ClassPath cp : cpset) {
                FileObject jlof = cp.findResource("java/lang/Object.class");
                if (jlof == null) continue;
                return;
            }
            JavaPlatform def = JavaPlatform.getDefault();
            if (def == null) {
                return;
            }
            ClassPath src = def.getBootstrapLibraries();
            GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{src});
        }
        finally {
            globalInitialized = true;
        }
    }

    public static class GraphLocationResolver
    implements LocationResolver {
        private ClassPath proxySource;
        private ClassPath proxyCompile;

        public GraphLocationResolver() {
            Set roots = GlobalPathRegistry.getDefault().getSourceRoots();
            this.proxySource = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
            Set compilePaths = GlobalPathRegistry.getDefault().getPaths("classpath/compile");
            this.proxyCompile = ClassPathSupport.createProxyClassPath((ClassPath[])compilePaths.toArray(new ClassPath[compilePaths.size()]));
        }

        public FileObject resolve(FileKey l) {
            FileObject ownerRoot;
            URL ownerURL;
            String javaSource = l.getFileSpec();
            if (!javaSource.endsWith(".java")) {
                return null;
            }
            String clazzSource = javaSource.substring(0, javaSource.length() - 4) + "class";
            FileObject src = this.proxySource.findResource(javaSource);
            if (src != null) {
                return src;
            }
            FileObject clazz = this.proxyCompile.findResource(clazzSource);
            if (clazz != null && (ownerURL = URLMapper.findURL((FileObject)(ownerRoot = this.proxyCompile.findOwnerRoot(clazz)), (int)0)) != null) {
                SourceForBinaryQuery.Result2 res = SourceForBinaryQuery.findSourceRoots2((URL)ownerURL);
                this.proxySource = ClassPathSupport.createClassPath((FileObject[])res.getRoots());
                src = this.proxySource.findResource(javaSource);
                return src;
            }
            return null;
        }
    }
}

