/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graal.filters;

import java.awt.Color;
import java.util.Collection;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;

public class GraalColoringFilter
extends AbstractFilter {
    private final String colorName;

    public GraalColoringFilter(String colorName) {
        this.colorName = colorName;
    }

    public String getName() {
        return "Graal Coloring Filter (" + this.colorName + ")";
    }

    public void apply(Diagram d) {
        String prop;
        Properties p;
        Collection figures = d.getFigures();
        int colors = 0;
        for (Figure f : figures) {
            p = f.getProperties();
            prop = p.getString(this.colorName + "Color", null);
            if (prop == null) continue;
            try {
                int color = Integer.parseInt(prop);
                if (color <= colors) continue;
                colors = color;
            }
            catch (NumberFormatException color) {}
        }
        ++colors;
        for (Figure f : figures) {
            p = f.getProperties();
            prop = p.getString(this.colorName + "Color", null);
            if (prop == null) continue;
            try {
                int color = Integer.parseInt(prop);
                Color c = Color.getHSBColor((float)color / (float)colors, 1.0f, 0.7f);
                f.setColor(c);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

