/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.Objects;
import org.openide.filesystems.FileObject;

public class FileKey {
    private final String mime;
    private final String fileSpec;
    private volatile FileObject resolvedFile;

    public FileKey(String mime, String fileSpec) {
        this.mime = mime;
        this.fileSpec = fileSpec;
    }

    public FileKey(String fileSpec, FileObject file) {
        this(file.getMIMEType(), fileSpec);
        this.resolvedFile = file;
    }

    public final String getMime() {
        return this.mime;
    }

    public final String getFileSpec() {
        return this.fileSpec;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.mime);
        hash = 79 * hash + Objects.hashCode(this.fileSpec);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileKey other = (FileKey)obj;
        if (!Objects.equals(this.mime, other.mime)) {
            return false;
        }
        return Objects.equals(this.fileSpec, other.fileSpec);
    }

    public FileObject getResolvedFile() {
        return this.resolvedFile;
    }

    public final boolean isResolved() {
        return this.resolvedFile != null;
    }

    final void setResolvedFile(FileObject f) {
        this.resolvedFile = f;
    }

    public String toString() {
        return this.resolvedFile != null ? this.resolvedFile.getPath() : this.fileSpec;
    }

    public static FileKey fromFile(FileObject f) {
        return new FileKey(f.getPath(), f);
    }
}

