/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.spi.LocationResolver;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.openide.filesystems.FileObject;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public final class FileRegistry {
    private final Map<String, Holder> langTypeResolvers = new HashMap<String, Holder>();
    private final Map<FileKey, Reference<FileKey>> keyMap = new WeakHashMap<FileKey, Reference<FileKey>>();
    private final Map<FileObject, Reference<FileKey>> file2KeyMap = new WeakHashMap<FileObject, Reference<FileKey>>();
    private final Map<R, Collection<InputGraph>> unresolvedKeys = new HashMap<R, Collection<InputGraph>>();
    private Collection<FileKey> resolved = new ArrayList<FileKey>();
    private final Collection<FileRegistryListener> listeners = new ArrayList<FileRegistryListener>();
    static final RequestProcessor RP = new RequestProcessor(FileRegistry.class);
    RequestProcessor.Task EVENT_TASK = RP.create(new Runnable(){

        @Override
        public void run() {
            FileRegistry.this.fireResolved();
        }
    }, true);
    private final Map<String, RequestProcessor.Task> revalidateTasks = new HashMap<String, RequestProcessor.Task>();

    public static FileRegistry getInstance() {
        return (FileRegistry)Lookup.getDefault().lookup(FileRegistry.class);
    }

    private void addUnresolvedGraph(FileKey key, Reference<FileKey> r, InputGraph usedIn) {
        if (r == null) {
            return;
        }
        R ref = !(r instanceof R) ? new R(key) : (R)r;
        WeakSet users = this.unresolvedKeys.get(ref);
        if (users == null) {
            users = new WeakSet();
            this.unresolvedKeys.put(ref, (Collection<InputGraph>)users);
        }
        users.add((InputGraph)usedIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileKey enter(FileKey k, InputGraph usedIn) {
        Map<FileKey, Reference<FileKey>> map = this.keyMap;
        synchronized (map) {
            Reference r;
            FileKey existing;
            Reference<FileKey> rK = this.keyMap.get(k);
            if (rK != null && (existing = rK.get()) != null) {
                if (k.isResolved() && !existing.isResolved()) {
                    this.markResolved(existing, k.getResolvedFile());
                    this.unresolvedKeys.remove(new R(existing));
                } else if (!k.isResolved()) {
                    this.addUnresolvedGraph(existing, rK, usedIn);
                }
                return existing;
            }
            FileObject resolved = k.getResolvedFile();
            if (resolved == null) {
                r = new R(k);
                this.addUnresolvedGraph(k, r, usedIn);
            } else {
                FileKey ref;
                r = this.file2KeyMap.get(resolved);
                FileKey fileKey = ref = r == null ? null : (FileKey)r.get();
                if (ref == null) {
                    r = new WeakReference<FileKey>(k);
                    this.file2KeyMap.put(resolved, r);
                } else {
                    throw new IllegalStateException("Key is missing, but file2Key is present: " + r);
                }
            }
            this.keyMap.put(k, r);
        }
        return k;
    }

    public void attemptResolve(FileKey fk) {
        RP.post((Runnable)new RevalidateTask(fk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireResolved() {
        FileRegistryListener[] ll;
        HashSet<FileKey> fireKeys;
        Collection<FileKey> collection = this.resolved;
        synchronized (collection) {
            if (this.resolved.isEmpty()) {
                return;
            }
            fireKeys = new HashSet<FileKey>(this.resolved);
            this.resolved.clear();
        }
        Collection<FileRegistryListener> collection2 = this.listeners;
        synchronized (collection2) {
            if (this.listeners.isEmpty()) {
                return;
            }
            ll = this.listeners.toArray(new FileRegistryListener[this.listeners.size()]);
        }
        FileRegistryEvent ev = new FileRegistryEvent(this, fireKeys);
        for (FileRegistryListener l : ll) {
            l.filesResolved(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markResolved(FileKey k, FileObject f) {
        k.setResolvedFile(f);
        Collection<FileKey> collection = this.resolved;
        synchronized (collection) {
            this.resolved.add(k);
        }
        this.EVENT_TASK.schedule(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyResolved(Collection<FileKey> keys) {
        Collection<FileKey> collection = this.resolved;
        synchronized (collection) {
            if (keys.isEmpty() && this.resolved.isEmpty()) {
                return;
            }
            this.resolved.addAll(keys);
        }
        this.EVENT_TASK.schedule(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileRegistryListener(FileRegistryListener frl) {
        Collection<FileRegistryListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(frl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileRegistryListener(FileRegistryListener frl) {
        Collection<FileRegistryListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(frl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<LocationResolver.Factory> findResolvers(String lang) {
        Holder h;
        Map<String, Holder> map = this.langTypeResolvers;
        synchronized (map) {
            h = this.langTypeResolvers.get(lang);
            if (h == null) {
                h = new Holder(lang, (Lookup.Result<LocationResolver.Factory>)MimeLookup.getLookup((String)lang).lookupResult(LocationResolver.Factory.class));
                this.langTypeResolvers.put(lang, h);
            }
        }
        return h.instances();
    }

    public void resolve(Location l, FileObject f) {
        this.resolve(l.getFile(), f);
    }

    public void resolve(FileKey fk, FileObject f) {
        this.resolve(fk, f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve(FileKey fk, FileObject f, boolean revalidate) {
        assert (f != null);
        R refKey = new R(fk);
        Object object = this.unresolvedKeys;
        synchronized (object) {
            if (fk.isResolved()) {
                return;
            }
            if (this.unresolvedKeys.remove(refKey) == null) {
                return;
            }
            fk.setResolvedFile(f);
            this.keyMap.put(fk, refKey);
        }
        object = this.resolved;
        synchronized (object) {
            this.resolved.add(fk);
        }
        if (revalidate) {
            this.postRevalidate(fk.getMime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRevalidate(String langID) {
        Map<String, RequestProcessor.Task> map = this.revalidateTasks;
        synchronized (map) {
            RequestProcessor.Task t = this.revalidateTasks.get(langID);
            if (t == null) {
                t = RP.post((Runnable)new RevalidateTask(langID), 200);
                this.revalidateTasks.put(langID, t);
                return;
            }
            t.schedule(100);
        }
    }

    List<LocationResolver> createResolvers(String langID, InputGraph g) {
        ArrayList<LocationResolver> ll = new ArrayList<LocationResolver>();
        for (LocationResolver.Factory f : this.findResolvers(langID)) {
            LocationResolver r = f.create(g);
            if (r == null) continue;
            ll.add(r);
        }
        return ll;
    }

    static void _testReset() {
        FileRegistry fr = FileRegistry.getInstance();
        fr.file2KeyMap.clear();
        fr.keyMap.clear();
        fr.langTypeResolvers.clear();
        fr.resolved.clear();
        fr.revalidateTasks.clear();
        fr.unresolvedKeys.clear();
    }

    private final class R
    extends WeakReference<FileKey>
    implements Runnable {
        private final int h;

        public R(FileKey referent) {
            super(referent, BaseUtilities.activeReferenceQueue());
            this.h = referent.hashCode();
        }

        public int hashCode() {
            return this.h;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            FileKey k = (FileKey)this.get();
            if (k == null || !(o instanceof R)) {
                return false;
            }
            return k == ((R)o).get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<FileKey, Reference<FileKey>> map = FileRegistry.this.keyMap;
            synchronized (map) {
                FileRegistry.this.unresolvedKeys.remove(this);
            }
        }

        public String toString() {
            FileKey k = (FileKey)this.get();
            if (k == null) {
                return "<obsolete>";
            }
            return k.getFileSpec();
        }
    }

    class RevalidateTask
    implements Runnable {
        private final String langID;
        private final Map<InputGraph, List<LocationResolver>> cachedResolvers = new HashMap<InputGraph, List<LocationResolver>>();
        private final FileKey fileKey;

        public RevalidateTask(String langID) {
            this.langID = langID;
            this.fileKey = null;
        }

        public RevalidateTask(FileKey fk) {
            this.langID = fk.getMime();
            this.fileKey = fk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<String, RequestProcessor.Task> map = FileRegistry.this.revalidateTasks;
            synchronized (map) {
                if (this.fileKey == null) {
                    FileRegistry.this.revalidateTasks.remove(this.langID);
                }
            }
            ArrayList<FileKey> resolved = new ArrayList<FileKey>();
            HashMap<FileKey, Collection<InputGraph>> toResolve = new HashMap<FileKey, Collection<InputGraph>>();
            Map<FileKey, Reference<FileKey>> map2 = FileRegistry.this.keyMap;
            synchronized (map2) {
                if (this.fileKey != null) {
                    R r = new R(this.fileKey);
                    Collection<InputGraph> collection = FileRegistry.this.unresolvedKeys.get(r);
                    if (collection == null) {
                        return;
                    }
                    toResolve.put(this.fileKey, collection);
                } else {
                    for (Map.Entry<R, Collection<InputGraph>> entry : FileRegistry.this.unresolvedKeys.entrySet()) {
                        Reference rfk = entry.getKey();
                        FileKey fk = (FileKey)rfk.get();
                        if (fk == null || !this.langID.equals(fk.getMime())) continue;
                        Collection<InputGraph> gr = entry.getValue();
                        toResolve.put(fk, gr);
                    }
                }
            }
            block7: for (Map.Entry entry : toResolve.entrySet()) {
                FileKey fileKey = (FileKey)entry.getKey();
                Collection gr = (Collection)entry.getValue();
                for (InputGraph g : gr) {
                    List<LocationResolver> cached = this.cachedResolvers.get(g);
                    if (cached == null) {
                        cached = FileRegistry.this.createResolvers(this.langID, g);
                        this.cachedResolvers.put(g, cached);
                    }
                    for (LocationResolver lr : cached) {
                        FileObject f = lr.resolve(fileKey);
                        if (f == null) continue;
                        FileRegistry.this.resolve(fileKey, f, this.fileKey != null);
                        resolved.add(fileKey);
                        continue block7;
                    }
                }
            }
            FileRegistry.this.notifyResolved(resolved);
        }
    }

    public static interface FileRegistryListener
    extends EventListener {
        public void filesResolved(FileRegistryEvent var1);
    }

    public static final class FileRegistryEvent
    extends EventObject {
        private Collection<FileKey> resolvedKeys;

        FileRegistryEvent(FileRegistry source, Collection resolvedKeys) {
            super(source);
            this.resolvedKeys = resolvedKeys;
        }

        public FileRegistry getRegistry() {
            return (FileRegistry)this.getSource();
        }

        public Collection<FileKey> getResolvedKeys() {
            return this.resolvedKeys;
        }
    }

    private class Holder
    implements LookupListener,
    ChangeListener {
        final String langID;
        final Lookup.Result<LocationResolver.Factory> lkpResult;
        Collection<LocationResolver.Factory> resolvers = new ArrayList<LocationResolver.Factory>();
        volatile boolean valid;

        public Holder(String langID, Lookup.Result<LocationResolver.Factory> lkpResult) {
            this.langID = langID;
            this.lkpResult = lkpResult;
        }

        synchronized Collection<LocationResolver.Factory> instances() {
            if (this.valid) {
                return this.resolvers;
            }
            ArrayList<LocationResolver.Factory> oldResolvers = new ArrayList<LocationResolver.Factory>(this.resolvers);
            ArrayList<LocationResolver.Factory> newResolvers = new ArrayList<LocationResolver.Factory>();
            for (LocationResolver.Factory f : this.lkpResult.allInstances()) {
                newResolvers.add(f);
                if (oldResolvers.remove(f)) continue;
                f.addChangeListener(this);
            }
            this.resolvers = newResolvers;
            this.valid = true;
            if (!oldResolvers.isEmpty()) {
                for (LocationResolver.Factory o : oldResolvers) {
                    o.removeChangeListener(this);
                }
            }
            return newResolvers;
        }

        public void resultChanged(LookupEvent ev) {
            this.valid = false;
            this.stateChanged(null);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FileRegistry.this.postRevalidate(this.langID);
        }
    }
}

