/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.FileRegistry;
import org.graalvm.visualizer.source.GraphSourceRegistry;
import org.graalvm.visualizer.source.Language;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.ProcessorContext;
import org.graalvm.visualizer.source.StackData;
import org.graalvm.visualizer.source.spi.LocationServices;
import org.graalvm.visualizer.source.spi.StackProcessor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class GraphSource {
    private final RequestProcessor loaderProc = new RequestProcessor(GraphSource.class.getName(), 3);
    private final Reference<InputGraph> graph;
    private final FileRegistry fileRegistry;
    private final Map<Location, Set<Location>> children = new HashMap<Location, Set<Location>>();
    private final Map<FileObject, List<Location>> fileLocations = new HashMap<FileObject, List<Location>>();
    private final Map<FileKey, Collection<Location>> keyLocations = new HashMap<FileKey, Collection<Location>>();
    private final Object[] stackData;
    private final Reference<NodeStack>[] nodeStacks;
    private final Map<Location, Object> nodeMap = new HashMap<Location, Object>();
    private final Map<Location, Location> uniqueLocations = new HashMap<Location, Location>();
    private volatile boolean computed;
    private ScheduledFuture computeTask;
    private static final String DEFAULT_MIME = "text/x-java";
    private final Map<String, NodeStack> nostackMarkers = new HashMap<String, NodeStack>();
    private static final Lookup[] NO_LOOKUPS = new Lookup[0];

    GraphSource(InputGraph graph, FileRegistry fileRegistry) {
        this.graph = new G(graph);
        this.fileRegistry = fileRegistry;
        int s = graph.getHighestNodeId() + 1;
        this.stackData = new Object[s];
        this.nodeStacks = new Reference[s];
        fileRegistry.addFileRegistryListener(new LocationUpdater(this));
    }

    FileRegistry getFileRegistry() {
        return this.fileRegistry;
    }

    public InputGraph getGraph() {
        return this.graph.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            this.computed = false;
            this.children.clear();
            this.fileLocations.clear();
            this.keyLocations.clear();
            this.nodeMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Location uniqueLocation(Location l) {
        Map<Location, Location> map = this.uniqueLocations;
        synchronized (map) {
            Location orig = this.uniqueLocations.putIfAbsent(l, l);
            return orig == null ? l : orig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location findNodeLocation(InputNode n) {
        InputGraph g = this.getGraph();
        if (g == null) {
            return null;
        }
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            if (!g.getNodes().contains(n)) {
                return null;
            }
        }
        NodeStack st = this.getNodeStack(n);
        return st == null ? null : st.top().getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<InputNode> getNodesAt(Location l) {
        HashSet<InputNode> nodes = new HashSet<InputNode>();
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            InputGraph g = this.getGraph();
            if (g == null) {
                return Collections.emptySet();
            }
            Object o = this.nodeMap.get(l);
            if (o == null) {
                return Collections.emptySet();
            }
            List<StackData> data = o instanceof Collection ? (List<StackData>)o : Collections.singletonList((StackData)o);
            for (StackData sd : data) {
                InputNode n = g.getNode(sd.getNodeId());
                if (n == null) continue;
                nodes.add(n);
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<FileKey> getFileKeys() {
        this.compute(null);
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            HashSet<FileKey> result = new HashSet<FileKey>(this.keyLocations.keySet());
            for (Map.Entry<FileObject, List<Location>> e : this.fileLocations.entrySet()) {
                FileKey k;
                FileObject f = e.getKey();
                Collection c = e.getValue();
                if (!c.isEmpty()) {
                    k = ((Location)c.iterator().next()).getFile();
                } else {
                    Language lng = Language.getRegistry().findLanguageByMime(f.getMIMEType());
                    if (lng == null) continue;
                    k = FileKey.fromFile(f);
                }
                result.add(k);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Location> getFileLocations(FileKey fk, boolean nodesPresent) {
        Collection<Location> locs;
        if (fk.isResolved()) {
            return this.getFileLocations(fk.getResolvedFile(), nodesPresent);
        }
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            locs = this.keyLocations.get(fk);
        }
        return this.filterLocations(new ArrayList<Location>(locs), nodesPresent);
    }

    private Loader createLoader(InputGraph g, Collection<InputNode> nodesToLoad) {
        Collection factories = Lookup.getDefault().lookupAll(StackProcessor.Factory.class);
        HashMap<String, ProcessorContext> contexts = new HashMap<String, ProcessorContext>();
        String[] allIds = null;
        for (StackProcessor.Factory f : factories) {
            String[] ids = f.getLanguageIDs();
            if (ids == null) {
                if (allIds == null) {
                    allIds = Language.getRegistry().getMimeTypes().toArray(new String[1]);
                }
                ids = allIds;
            }
            for (String m : ids) {
                ProcessorContext ctx = contexts.computeIfAbsent(m, mime -> new ProcessorContext(this, g, this.fileRegistry, (String)mime));
                StackProcessor p = f.createProcessor(ctx);
                if (p == null) continue;
                ctx.addProcessor(p);
            }
        }
        return new Loader(contexts.values(), nodesToLoad);
    }

    private int compareLine(Location l1, Location l2) {
        return l1.getLine() - l2.getLine();
    }

    private void mergeResults(ProcessorContext ctx) {
        List<Location> locs;
        List<Location> l;
        Object f;
        if (this.children.isEmpty()) {
            this.children.putAll(ctx.successors);
        } else {
            for (Map.Entry<Location, Set<Location>> entry : ctx.successors.entrySet()) {
                Location parent = entry.getKey();
                Set<Location> nue = entry.getValue();
                Set<Location> existing = this.children.get(parent);
                if (existing == null) {
                    this.children.put(parent, nue);
                    continue;
                }
                existing.addAll(nue);
            }
        }
        for (Map.Entry<Location, Collection<Location>> entry : ctx.fileLocations.entrySet()) {
            f = (FileObject)entry.getKey();
            locs = this.fileLocations.putIfAbsent((FileObject)f, l = (List<Location>)entry.getValue());
            if (locs != null) {
                HashSet<Location> x2 = new HashSet<Location>(locs);
                x2.addAll(l);
                locs = new ArrayList<Location>(x2);
                this.fileLocations.put((FileObject)f, locs);
            } else {
                locs = l;
            }
            Collections.sort(locs, this::compareLine);
        }
        for (Map.Entry<Object, Collection<Location>> entry : ctx.keyLocations.entrySet()) {
            f = (FileKey)entry.getKey();
            l = (List)entry.getValue();
            if (((FileKey)f).isResolved()) {
                locs = this.fileLocations.putIfAbsent(((FileKey)f).getResolvedFile(), l);
                if (locs != null) {
                    HashSet<Location> all = new HashSet<Location>(locs);
                    all.addAll(l);
                    locs = new ArrayList<Location>(all);
                    this.fileLocations.put(((FileKey)f).getResolvedFile(), locs);
                } else {
                    locs = l;
                }
                Collections.sort(locs, this::compareLine);
                continue;
            }
            this.keyLocations.computeIfAbsent((FileKey)f, x -> new HashSet()).addAll(l);
        }
        for (Map.Entry<Object, Collection<Object>> entry : ctx.finalLocations.entrySet()) {
            this.addNodeMap((Location)entry.getKey(), entry.getValue());
        }
    }

    private void addNodeMap(Location l, Collection<StackData> nodes) {
        Object o = this.nodeMap.get(l);
        if (o == null) {
            if (!nodes.isEmpty()) {
                if (nodes.size() == 1) {
                    this.nodeMap.put(l, nodes.iterator().next());
                } else {
                    this.nodeMap.put(l, nodes);
                }
            }
        } else if (o instanceof Collection) {
            ((Collection)o).addAll(nodes);
        } else if (!nodes.isEmpty()) {
            ArrayList<StackData> c = new ArrayList<StackData>();
            c.addAll(nodes);
            c.add((StackData)o);
            this.nodeMap.put(l, c);
        }
        for (StackData sd : nodes) {
            this.putStackData(sd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keysResolved(Collection<FileKey> keys) {
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            for (FileKey rk : keys) {
                Collection<Location> newLocs = this.keyLocations.remove(rk);
                if (newLocs == null) continue;
                FileObject f = rk.getResolvedFile();
                List<Location> locs = this.fileLocations.get(f);
                if (locs != null) {
                    newLocs.addAll(locs);
                    locs = new ArrayList<Location>(newLocs);
                } else {
                    locs = new ArrayList<Location>(newLocs);
                    this.fileLocations.put(f, locs);
                }
                Collections.sort(locs, this::compareLine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FileObject> getSourceFiles() {
        this.compute(null);
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            return new HashSet<FileObject>(this.fileLocations.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Location> getFileLocations(FileObject f, boolean nodePresent) {
        List<Location> locs;
        this.compute(null);
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            locs = this.fileLocations.get(f);
        }
        return this.filterLocations(locs, nodePresent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Location> filterLocations(List<Location> locs, boolean nodePresent) {
        if (locs == null || locs.isEmpty()) {
            return Collections.emptyList();
        }
        if (!nodePresent) {
            return locs;
        }
        ArrayList<Location> result = new ArrayList<Location>(locs);
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Location l = (Location)it.next();
                if (this.nodeMap.containsKey(l)) continue;
                it.remove();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<InputNode> findLangugageNodes(String mime) {
        this.compute(null);
        ArrayList<InputNode> result = new ArrayList<InputNode>();
        InputGraph g = this.graph.get();
        if (g == null) {
            return Collections.emptyList();
        }
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            for (int i = 0; i < this.stackData.length; ++i) {
                StackData sd = this.getStackData(i, mime);
                if (sd == null) continue;
                result.add(g.getNode(i));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> prepare(Collection<InputNode> nodes) {
        InputGraph g = this.getGraph();
        if (g == null) {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            cf.complete(null);
            return cf;
        }
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            ScheduledFuture task;
            boolean ready = this.computed;
            if (!ready && nodes != null) {
                ready = true;
                for (InputNode n : nodes) {
                    Reference<NodeStack> r = this.nodeStacks[n.getId()];
                    if (r != null) continue;
                    ready = false;
                    break;
                }
            }
            if (ready) {
                CompletableFuture<Void> cf = new CompletableFuture<Void>();
                cf.complete(null);
                return cf;
            }
            if (nodes == null) {
                if (this.computeTask == null) {
                    this.computeTask = this.loaderProc.schedule((Runnable)this.createLoader(g, nodes), 0L, TimeUnit.MILLISECONDS);
                }
                task = this.computeTask;
            } else {
                task = this.loaderProc.schedule((Runnable)this.createLoader(g, nodes), 0L, TimeUnit.MILLISECONDS);
            }
            return task;
        }
    }

    private void compute(Collection<InputNode> nodes) {
        try {
            this.prepare(nodes).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    private void addStackResult(Collection<NodeStack> result, Location l) {
        Object o = this.nodeMap.get(l);
        if (o instanceof Collection) {
            for (StackData sd : (Collection)o) {
                result.add(this.getNodeStack(sd.getNodeId(), l.getFile().getMime()));
            }
        } else if (o != null) {
            result.add(this.getNodeStack(((StackData)o).getNodeId(), l.getFile().getMime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<NodeStack> getNodesPassingThrough(Location l) {
        Set<Location> n;
        final HashSet<NodeStack> result = new HashSet<NodeStack>();
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            this.addStackResult(result, l);
            n = this.getNestedLocations(l);
            if (n == null || n.isEmpty()) {
                return result;
            }
        }
        return new Iterable<NodeStack>(){

            @Override
            public Iterator<NodeStack> iterator() {
                class I
                implements Iterator<NodeStack> {
                    private Iterator<NodeStack> resIter;
                    private Deque<Location> toProcess;
                    private Set<Location> seen;
                    private Set<NodeStack> seenStacks;
                    final /* synthetic */ Set val$result;
                    final /* synthetic */ Collection val$n;

                    I() {
                        this.val$result = set;
                        this.val$n = collection;
                        this.resIter = this.val$result.isEmpty() ? null : this.val$result.iterator();
                        this.toProcess = new ArrayDeque<Location>(this.val$n);
                        this.seen = new HashSet<Location>(this.val$n);
                        this.seenStacks = new HashSet<NodeStack>(this.val$result);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean hasNext() {
                        if (this.resIter != null) {
                            if (this.resIter.hasNext()) {
                                return true;
                            }
                            this.resIter = null;
                        }
                        HashSet<NodeStack> stacks = new HashSet<NodeStack>();
                        while (!this.toProcess.isEmpty()) {
                            HashSet locs;
                            Location l = this.toProcess.poll();
                            Map<Location, Set<Location>> map = GraphSource.this.children;
                            synchronized (map) {
                                GraphSource.this.addStackResult(stacks, l);
                                locs = new HashSet(GraphSource.this.children.getOrDefault(l, Collections.emptySet()));
                            }
                            locs.removeAll(this.seen);
                            stacks.removeAll(this.seenStacks);
                            this.toProcess.addAll(locs);
                            if (stacks.isEmpty()) continue;
                            this.seen.addAll(locs);
                            this.seenStacks.addAll(stacks);
                            this.resIter = stacks.iterator();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public NodeStack next() {
                        if (this.resIter != null) {
                            return this.resIter.next();
                        }
                        throw new NoSuchElementException();
                    }
                }
                return new I(GraphSource.this, result, n);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Location> getNestedLocations(Location l) {
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            Set<Location> locs = this.children.get(l);
            return locs == null ? Collections.emptySet() : locs;
        }
    }

    public NodeStack getNodeStack(InputNode n) {
        return this.getNodeStack(n, DEFAULT_MIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStack getNodeStack(InputNode n, String mime) {
        if (n == null) {
            return null;
        }
        this.compute(Collections.singleton(n));
        int id = n.getId();
        Map<Location, Set<Location>> map = this.children;
        synchronized (map) {
            return this.getNodeStack(id, mime);
        }
    }

    private NodeStack getNodeStack(int id, String mime) {
        NodeStack ns;
        Reference<NodeStack> rS = this.nodeStacks[id];
        if (rS != null && (ns = rS.get()) != null && (mime == null || Objects.equals(ns.getMime(), mime))) {
            return ns.isEmpty() ? null : ns;
        }
        StackData sd = this.getStackData(id, mime);
        if (sd == null) {
            NodeStack st = this.nostackMarkers.computeIfAbsent(mime, m -> new NodeStack(this, (String)m));
            this.nodeStacks[id] = new WeakReference<NodeStack>(st);
            return null;
        }
        NodeStack ns2 = new NodeStack(this, sd);
        this.nodeStacks[id] = new WeakReference<NodeStack>(ns2);
        return ns2;
    }

    Lookup[] findLookup(InputNode node, NodeStack.Frame f) {
        Location l = f.getLocation();
        Lookup lkp = GraphSourceRegistry.getDefault().providerLookup(l.getFile().getMime());
        ArrayList<Lookup> lkps = new ArrayList<Lookup>();
        Lookup s = null;
        for (LocationServices srv : lkp.lookupAll(LocationServices.class)) {
            s = srv.createLookup(f);
            if (s == null) continue;
            lkps.add(s);
        }
        if (lkps.isEmpty()) {
            return NO_LOOKUPS;
        }
        return lkps.toArray(new Lookup[lkps.size()]);
    }

    public static GraphSource getGraphSource(InputGraph g) {
        return GraphSourceRegistry.getDefault().getSource(g);
    }

    public Future<Void> prepare() {
        return this.prepare(null);
    }

    public boolean isPrepared() {
        return this.computed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStackLanguages(int nodeId) {
        Object[] objectArray = this.stackData;
        synchronized (this.stackData) {
            if (nodeId >= this.stackData.length) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Collections.emptyList();
            }
            Object o = this.stackData[nodeId];
            if (o == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Collections.emptyList();
            }
            if (o instanceof StackData) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Collections.singletonList(((StackData)o).getLanguageMimeType());
            }
            Collection c = (Collection)o;
            ArrayList<String> res = new ArrayList<String>(c.size());
            for (StackData sd : c) {
                res.add(sd.getLanguageMimeType());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }

    private StackData getStackData(int nodeId, String mime) {
        Object o = this.stackData[nodeId];
        if (o == null) {
            return null;
        }
        if (o instanceof StackData) {
            StackData sd = (StackData)o;
            if (mime == null || sd.getLanguageMimeType().equals(mime)) {
                return sd;
            }
        } else if (o instanceof Collection) {
            Collection c = (Collection)o;
            for (StackData sd : c) {
                if (mime != null && !sd.getLanguageMimeType().equals(mime)) continue;
                return sd;
            }
        }
        return null;
    }

    private void putStackData(StackData sd) {
        ArrayList<StackData> c;
        int nodeId = sd.getNodeId();
        if (this.stackData[nodeId] == null) {
            this.stackData[nodeId] = sd;
            return;
        }
        Object o = this.stackData[nodeId];
        if (o instanceof StackData) {
            StackData other = (StackData)o;
            if (other.getLanguageMimeType().equals(sd.getLanguageMimeType())) {
                this.stackData[nodeId] = sd;
                return;
            }
            c = new ArrayList<StackData>();
            c.add(other);
            this.stackData[nodeId] = c;
        } else {
            c = (ArrayList<StackData>)o;
        }
        c.add(sd);
    }

    class G
    extends WeakReference<InputGraph>
    implements Runnable {
        public G(InputGraph referent) {
            super(referent, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            GraphSource.this.reset();
        }
    }

    private static class LocationUpdater
    extends WeakReference<GraphSource>
    implements FileRegistry.FileRegistryListener,
    Runnable {
        public LocationUpdater(GraphSource referent) {
            super(referent, Utilities.activeReferenceQueue());
        }

        @Override
        public void filesResolved(FileRegistry.FileRegistryEvent ev) {
            GraphSource gs = (GraphSource)this.get();
            if (gs == null) {
                ev.getRegistry().removeFileRegistryListener(this);
                return;
            }
            gs.keysResolved(ev.getResolvedKeys());
        }

        @Override
        public void run() {
            FileRegistry.getInstance().removeFileRegistryListener(this);
        }
    }

    class Loader
    implements Runnable {
        private final Collection<ProcessorContext> contexts;
        private Collection<InputNode> nodesToLoad;

        public Loader(Collection<ProcessorContext> contexts, Collection<InputNode> nodesToLoad) {
            this.contexts = new ArrayList<ProcessorContext>(contexts);
            this.nodesToLoad = nodesToLoad == null ? null : new HashSet<InputNode>(nodesToLoad);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean fullLoad = this.nodesToLoad == null;
            try {
                Map<Location, Set<Location>> map;
                InputGraph g = GraphSource.this.graph.get();
                if (g == null) {
                    return;
                }
                if (!fullLoad) {
                    map = GraphSource.this.children;
                    synchronized (map) {
                        for (InputNode n : new ArrayList<InputNode>(this.nodesToLoad)) {
                            if (GraphSource.this.stackData[n.getId()] == null) continue;
                            this.nodesToLoad.remove(n);
                        }
                    }
                }
                if (this.nodesToLoad == null) {
                    this.nodesToLoad = g.getNodes();
                }
                for (InputNode n : this.nodesToLoad) {
                    for (ProcessorContext c : this.contexts) {
                        c.processNode(n);
                    }
                }
                map = GraphSource.this.children;
                synchronized (map) {
                    if (GraphSource.this.computed) {
                        return;
                    }
                    if (fullLoad) {
                        GraphSource.this.reset();
                    }
                    for (ProcessorContext c : this.contexts) {
                        GraphSource.this.mergeResults(c);
                    }
                    if (fullLoad) {
                        GraphSource.this.computed = true;
                    }
                    GraphSource.this.computeTask = null;
                }
            }
            catch (Throwable ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

