/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.graalvm.visualizer.source.Language;
import org.graalvm.visualizer.source.lang.DefaultLanguageProvider;
import org.graalvm.visualizer.source.spi.LanguageProvider;
import org.openide.util.Lookup;

public class LanguageRegistryImpl {
    private Map<String, Language> supported = new HashMap<String, Language>();
    private Collection<Language> executable = new HashSet<Language>();
    private volatile boolean initialized;
    private Map<String, Language> created = new HashMap<String, Language>();

    private void initialize() {
        if (!this.initialized) {
            this.loadProviders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language createLanguage(String graalID) {
        LanguageRegistryImpl languageRegistryImpl = this;
        synchronized (languageRegistryImpl) {
            Language l = this.created.get(graalID);
            if (l != null) {
                return l;
            }
            l = DefaultLanguageProvider.getInstance().createLanguage(graalID);
            this.created.put(graalID, l);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProviders() {
        HashMap<String, Language> langIds = new HashMap<String, Language>();
        ArrayList<Language> executables = new ArrayList<Language>();
        Collection providers = Lookup.getDefault().lookupAll(LanguageProvider.class);
        for (LanguageProvider prov : providers) {
            Collection<Language> langs = prov.findSupportedLanguages();
            for (Language l : langs) {
                if (langIds.containsKey(l.getGraalID())) continue;
                langIds.put(l.getGraalID(), l);
            }
        }
        for (Language l : langIds.values()) {
            for (LanguageProvider p : providers) {
                if (!p.isExecutable(l)) continue;
                executables.add(l);
            }
        }
        LanguageRegistryImpl languageRegistryImpl = this;
        synchronized (languageRegistryImpl) {
            if (this.initialized) {
                return;
            }
            this.created.keySet().removeAll(langIds.keySet());
            this.supported = Collections.unmodifiableMap(langIds);
            this.executable = Collections.unmodifiableCollection(executables);
            this.initialized = true;
        }
    }

    public Language finLanguageId(String id) {
        this.initialize();
        return this.supported.get(id);
    }

    public Collection<Language> getLanguages() {
        this.initialize();
        return this.supported.values();
    }

    public Collection<Language> getRunnableLanguages() {
        return this.executable;
    }
}

