/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.source.impl.Bundle;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.FileRoot;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.actions.RemoveSourceRootAction;
import org.graalvm.visualizer.source.impl.ui.NewGroupAction;
import org.graalvm.visualizer.source.impl.ui.NewSourceRootAction;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.actions.RenameAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class SourceRepositoryNode
extends AbstractNode {
    private final SourceRepositoryImpl repository;

    public SourceRepositoryNode(SourceRepositoryImpl repository) {
        this(repository, false);
    }

    public SourceRepositoryNode(SourceRepositoryImpl repository, boolean displayDefault) {
        super((Children)new Ch(repository, displayDefault));
        this.repository = repository;
        this.setDisplayName(Bundle.NAME_SourceRepository());
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new NewGroupAction(this.repository), new NewSourceRootAction(this.repository, null)};
    }

    static Node createFileRootNode(FileRoot r, SourceRepositoryImpl repository) {
        URL url = r.getLocation();
        FileObject f = URLMapper.findFileObject((URL)url);
        if (f != null) {
            Lookup fl = f.getLookup();
            ProxyLookup lkp = new ProxyLookup(new Lookup[]{fl, Lookups.fixed((Object[])new Object[]{r, repository})});
            Node original = (Node)fl.lookup(Node.class);
            if (original == null) {
                DataObject d = (DataObject)fl.lookup(DataObject.class);
                if (d == null) {
                    return null;
                }
                original = d.getNodeDelegate();
            }
            FilterNode.Children fch = new FilterNode.Children(original);
            return new RN(original, (Children)fch, (Lookup)lkp, r);
        }
        return null;
    }

    static class Ch
    extends Children.Keys
    implements ChangeListener,
    PropertyChangeListener {
        private final SourceRepositoryImpl repository;
        private final boolean displayDefaultGroup;
        private ChangeListener weakChangeL;
        private PropertyChangeListener weakPropL;

        public Ch(SourceRepositoryImpl repository, boolean displayDefaultGroup) {
            this.repository = repository;
            this.displayDefaultGroup = displayDefaultGroup;
        }

        protected void removeNotify() {
            super.removeNotify();
            if (this.weakChangeL != null) {
                this.repository.removeChangeListener(this.weakChangeL);
            }
            if (this.weakPropL != null) {
                ClassPath defCP = this.repository.getDefaultGroup().getSourcePath();
                defCP.removePropertyChangeListener(this.weakPropL);
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
            this.weakChangeL = WeakListeners.change((ChangeListener)this, (Object)this.repository);
            this.repository.addChangeListener(this.weakChangeL);
            ClassPath defCP = this.repository.getDefaultGroup().getSourcePath();
            this.weakPropL = WeakListeners.propertyChange((PropertyChangeListener)this, (String)"entries", (Object)defCP);
            defCP.addPropertyChangeListener(this.weakPropL);
        }

        private void refreshKeys() {
            ArrayList<Object> keys = new ArrayList<Object>();
            if (!this.displayDefaultGroup) {
                keys.addAll(this.repository.getDefaultGroup().getFileRoots());
            }
            ArrayList<FileGroup> groups = new ArrayList<FileGroup>(this.repository.getGroups());
            if (this.displayDefaultGroup) {
                groups.add(this.repository.getDefaultGroup());
            }
            groups.sort((g1, g2) -> g1.getDisplayName().compareTo(g2.getDisplayName()));
            keys.addAll(groups);
            this.setKeys(keys);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof FileRoot) {
                FileRoot r = (FileRoot)key;
                Node n = SourceRepositoryNode.createFileRootNode(r, this.repository);
                if (n != null) {
                    return new Node[]{n};
                }
            } else if (key instanceof FileGroup) {
                FileGroup g = (FileGroup)key;
                GCh children = new GCh(g, this.repository);
                Lookup lkp = Lookups.fixed((Object[])new Object[]{g});
                GN node = new GN(this.repository, (Children)children, lkp, g);
                return new Node[]{node};
            }
            return new Node[0];
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refreshKeys();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.refreshKeys();
        }
    }

    static final class RN
    extends AbstractNode
    implements PropertyChangeListener {
        FileRoot data;

        public RN(Node original, Children children, Lookup lookup, FileRoot r) {
            super(children, lookup);
            this.data = r;
            super.setDisplayName(r.getDisplayName());
            r.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)r));
            this.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/packageRoot.gif");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("displayName".equals(prop)) {
                super.setDisplayName(this.data.getDisplayName());
            }
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(RenameAction.class), SystemAction.get(RemoveSourceRootAction.class)};
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String s) {
            super.setName(s);
            this.data.setDisplayName(s);
        }

        public void destroy() throws IOException {
            super.destroy();
            this.data.discard();
        }
    }

    static final class GN
    extends AbstractNode
    implements PropertyChangeListener {
        private final SourceRepositoryImpl repository;
        private final FileGroup group;

        public GN(SourceRepositoryImpl repository, Children children, Lookup lookup, FileGroup group) {
            super(children, lookup);
            this.repository = repository;
            this.group = group;
            this.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/defaultFolder.gif");
            super.setName(group.getDisplayName());
            group.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group));
        }

        public void setName(String s) {
            super.setName(s);
            this.group.setDisplayName(s);
        }

        public void destroy() throws IOException {
            super.destroy();
            this.repository.deleteGroup(this.group);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("displayName".equals(evt.getPropertyName())) {
                super.setDisplayName(this.group.getDisplayName());
            }
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(RenameAction.class), SystemAction.get(RemoveSourceRootAction.class), new NewSourceRootAction(this.repository, this.group)};
        }

        public boolean canDestroy() {
            return true;
        }

        public boolean canRename() {
            return true;
        }
    }

    static final class GCh
    extends Children.Keys
    implements ChangeListener {
        private final FileGroup group;
        private final SourceRepositoryImpl repository;
        private ChangeListener weakChangeL;

        public GCh(FileGroup group, SourceRepositoryImpl repository) {
            this.group = group;
            this.repository = repository;
        }

        protected void removeNotify() {
            if (this.weakChangeL != null) {
                this.group.removeChangeListener(this.weakChangeL);
            }
            super.removeNotify();
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
            this.weakChangeL = WeakListeners.change((ChangeListener)this, (Object)this.group);
            this.group.addChangeListener(this.weakChangeL);
        }

        private void refreshKeys() {
            List<FileRoot> roots = this.group.getFileRoots();
            this.setKeys(roots.toArray(new FileRoot[roots.size()]));
        }

        protected Node[] createNodes(Object key) {
            Node[] nodeArray;
            Node n = SourceRepositoryNode.createFileRootNode((FileRoot)key, this.repository);
            if (n != null) {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            } else {
                nodeArray = new Node[]{};
            }
            return nodeArray;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refreshKeys();
        }
    }
}

