/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.Image;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.impl.FileGroup;
import org.graalvm.visualizer.source.impl.SourceRepositoryImpl;
import org.graalvm.visualizer.source.impl.ui.Bundle;
import org.graalvm.visualizer.source.impl.ui.RootContentPanel;
import org.graalvm.visualizer.source.spi.LocatorUI;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public class BasicLocatorUI
implements LocatorUI {
    @Override
    public String getDisplayName() {
        return Bundle.LBL_LocateFolder();
    }

    @Override
    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/graalvm/visualizer/source/resources/srcFolder.png");
    }

    @Override
    public boolean accepts(Location l) {
        return true;
    }

    @Override
    public Future<Boolean> resolve(Location l) {
        CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
        SwingUtilities.invokeLater(new LocatorRunner(cf, l));
        return cf;
    }

    private class LocatorRunner
    extends FileFilter
    implements Runnable,
    FileChooserBuilder.SelectionApprover {
        private final CompletableFuture future;
        private final Location loc;
        private final SourceRepositoryImpl repository = SourceRepositoryImpl.getInstance();
        private RootContentPanel contentPanel;

        public LocatorRunner(CompletableFuture future, Location loc) {
            this.future = future;
            this.loc = loc;
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            FileObject rootDir = FileUtil.toFileObject((File)f);
            return rootDir.getFileObject(this.loc.getFileName()) != null;
        }

        @Override
        public String getDescription() {
            return Bundle.Filter_FileHolder();
        }

        @Override
        public void run() {
            try {
                File dir = ProjectChooser.getProjectsFolder();
                if (dir == null) {
                    dir = new File(System.getProperty("user.home"));
                }
                SourceRepositoryImpl impl = SourceRepositoryImpl.getInstance();
                FileObject fDir = FileUtil.toFileObject((File)dir);
                JFileChooser choose = FileChooserBuilder.create((FileSystem)fDir.getFileSystem()).setDefaultWorkingDirectory(dir).setSelectionApprover((FileChooserBuilder.SelectionApprover)this).createFileChooser();
                choose.setFileFilter(this);
                choose.setMultiSelectionEnabled(false);
                choose.setAcceptAllFileFilterUsed(false);
                this.contentPanel = new RootContentPanel(this.loc, choose, impl);
                choose.setAccessory(this.contentPanel);
                this.contentPanel.setFileGroup(this.repository.getDefaultGroup());
                if (choose.showOpenDialog(null) != 0) {
                    this.future.complete(false);
                    return;
                }
                ProjectChooser.setProjectsFolder((File)choose.getCurrentDirectory());
                File f = choose.getSelectedFile();
                if (f == null) {
                    this.future.complete(false);
                    return;
                }
                FileObject theFile = FileUtil.toFileObject((File)f);
                String desc = this.contentPanel.getDescription();
                FileGroup parent = this.contentPanel.getParentGroup();
                if (parent == null) {
                    parent = this.repository.getDefaultGroup();
                }
                this.repository.addLocation(theFile, desc, parent);
            }
            catch (Exception ex) {
                this.future.completeExceptionally(ex);
            }
        }

        public boolean approve(File[] selection) {
            if (selection == null || selection.length != 1) {
                return false;
            }
            FileObject rootDir = FileUtil.toFileObject((File)selection[0]);
            return rootDir.getFileObject(this.loc.getFileName()) != null;
        }
    }
}

