/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.lang;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.graphio.parsing.LocationStackFrame;
import jdk.graal.compiler.graphio.parsing.LocationStratum;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.source.FileKey;
import org.graalvm.visualizer.source.Language;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.ProcessorContext;
import org.graalvm.visualizer.source.spi.StackProcessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class FileStackProcessor
implements StackProcessor {
    private final String langID;
    private final String langMime;
    private ProcessorContext context;

    public FileStackProcessor(String langID, String langMime) {
        this.langID = langID;
        this.langMime = langMime;
    }

    @Override
    public void attach(ProcessorContext ctx) {
        this.context = ctx;
    }

    @Override
    public List<Location> processStack(InputNode node) {
        Properties props = node.getProperties();
        Object o = props.get("nodeSourcePosition", Object.class);
        if (!(o instanceof LocationStackFrame)) {
            return null;
        }
        return new Proc((LocationStackFrame)o).process();
    }

    private class Proc {
        private final LocationStackFrame top;
        private LocationStackFrame frame;
        private final List<Location> locs = new ArrayList<Location>();
        private Location lastloc;
        private LocationStratum langStratum;
        private int depth;
        private int lastDepth = -1;

        public Proc(LocationStackFrame top) {
            this.top = top;
        }

        private void replaceTop(Location loc) {
            this.locs.set(this.locs.size() - 1, loc);
        }

        private List<Location> process() {
            this.frame = this.top;
            while (this.frame != null) {
                boolean found = false;
                for (LocationStratum stratum : this.frame.getStrata()) {
                    if (!FileStackProcessor.this.langID.equals(stratum.language)) continue;
                    found = true;
                    this.langStratum = stratum;
                    try {
                        Location l = this.processFrame();
                        if (l == null) break;
                        this.locs.add(l);
                        this.lastloc = l;
                        this.lastDepth = this.depth;
                        break;
                    }
                    catch (IOException | URISyntaxException exception) {
                    }
                }
                ++this.depth;
                if (!found) {
                    this.lastDepth = -1;
                }
                this.frame = this.frame.getParent();
            }
            return this.locs.isEmpty() ? null : this.locs;
        }

        private Location processFrame() throws IOException, URISyntaxException {
            FileKey fk;
            Location newLoc;
            URI uri = new URI(this.langStratum.uri);
            FileObject fo = null;
            if (uri.isAbsolute()) {
                URL possibleURL = uri.toURL();
                fo = URLMapper.findFileObject((URL)possibleURL);
            }
            if ((newLoc = new Location(this.langStratum.uri, fk = fo != null ? new FileKey(this.langStratum.uri, fo) : new FileKey(FileStackProcessor.this.langMime, this.langStratum.uri), this.langStratum.line, this.langStratum.startOffset, this.langStratum.endOffset, this.lastloc, this.lastDepth, this.depth)).equals(this.lastloc)) {
                this.replaceTop(newLoc);
                return null;
            }
            return newLoc;
        }
    }

    public static final class RegisteredLangFactory
    implements StackProcessor.Factory {
        @Override
        public String[] getLanguageIDs() {
            return null;
        }

        @Override
        public StackProcessor createProcessor(ProcessorContext ctx) {
            Language lng = Language.getRegistry().findLanguageByMime(ctx.getLangID());
            if (lng == null) {
                return null;
            }
            return new FileStackProcessor(lng.getGraalID(), lng.getMimeType());
        }
    }
}

