/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.htmlui.impl;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.modules.htmlui.impl.HtmlComponent;
import org.netbeans.modules.htmlui.impl.HtmlToolkit;
import org.netbeans.spi.htmlui.HTMLViewerSpi;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Lookup;

public class SwingFXViewer
implements HTMLViewerSpi<SFXView, JButton> {
    public SFXView newView(HTMLViewerSpi.Context ctx) {
        return new SFXView(ctx);
    }

    public JButton createButton(SFXView view, String id) {
        JButton b = new JButton();
        b.setName(id);
        if (view == null || view.buttons == null) {
            throw new NullPointerException("Am I: " + this + " view: " + view);
        }
        view.buttons.add(b);
        return b;
    }

    public String getId(SFXView view, JButton b) {
        return b.getName();
    }

    public void setText(SFXView view, JButton b, String text) {
        b.setText(text);
    }

    public void setEnabled(SFXView view, JButton b, boolean enabled) {
        b.setEnabled(enabled);
    }

    public void runLater(SFXView view, Runnable r) {
        EventQueue.invokeLater(r);
    }

    public <C> C component(SFXView view, Class<C> type) {
        if (type == Void.class) {
            view.makeVisible();
            return null;
        }
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (loader == null) {
            loader = SwingFXViewer.class.getClassLoader();
        }
        return HtmlToolkit.getDefault().convertToComponent(type, view.ctx.getPage(), loader, () -> ((HTMLViewerSpi.Context)view.ctx).onPageLoad(), Arrays.asList(view.ctx.getTechIds()));
    }

    public static final class SFXView {
        final HTMLViewerSpi.Context ctx;
        final HtmlComponent component;
        final ChromeWithButtons buttons;

        SFXView(HTMLViewerSpi.Context ctx) {
            this.ctx = ctx;
            if (ctx.isDialog()) {
                this.component = null;
                this.buttons = new ChromeWithButtons(ctx);
            } else if (ctx.isWindow()) {
                this.component = new HtmlComponent();
                this.buttons = null;
            } else {
                this.component = null;
                this.buttons = null;
            }
        }

        void makeVisible() {
            if (this.ctx.isWindow()) {
                this.component.open();
                this.component.requestActive();
                HtmlToolkit.getDefault().execute(() -> this.component.loadFX(this.ctx.getClassLoader(), this.ctx.getPage(), () -> ((HTMLViewerSpi.Context)this.ctx).onPageLoad(), this.ctx.getTechIds()));
            } else if (this.ctx.isDialog()) {
                if (this.ctx.isBlocking()) {
                    this.buttons.showAndWait();
                } else {
                    this.buttons.showLater();
                }
            }
        }

        private static final class ChromeWithButtons {
            private final HTMLViewerSpi.Context ctx;
            private final JComponent p;
            private final DialogDescriptor dd;
            private final List<JButton> buttons = new ArrayList<JButton>();

            public ChromeWithButtons(HTMLViewerSpi.Context ctx) {
                this.ctx = ctx;
                this.p = HtmlToolkit.getDefault().newPanel();
                this.dd = new DialogDescriptor((Object)this.p, "");
                this.dd.setOptions(new Object[0]);
            }

            void add(JButton b) {
                this.buttons.add(b);
            }

            String getValueName() {
                Object val = this.dd.getValue();
                return val instanceof JButton ? ((JButton)val).getName() : null;
            }

            String showAndWait() {
                if (EventQueue.isDispatchThread()) {
                    this.initializationSequence(null).run();
                    this.showDialog();
                } else {
                    Runnable initSeq = this.initializationNestedLoop();
                    if (HtmlToolkit.getDefault().isApplicationThread()) {
                        EventQueue.invokeLater(initSeq);
                        HtmlToolkit.getDefault().enterNestedLoop(this);
                    } else {
                        try {
                            EventQueue.invokeAndWait(initSeq);
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            throw new IllegalStateException(ex);
                        }
                    }
                }
                Object val = this.dd.getValue();
                return val instanceof JButton ? ((JButton)val).getName() : null;
            }

            void showLater() {
                this.initializationSequence(this::showDialog).run();
            }

            void showDialog() {
                this.p.setPreferredSize(new Dimension(600, 400));
                Dialog modalDialog = DialogDisplayer.getDefault().createDialog(this.dd);
                this.dd.setButtonListener(ev -> {
                    String id = null;
                    if (ev.getSource() instanceof JButton) {
                        id = ((JButton)ev.getSource()).getName();
                    }
                    if (!this.ctx.onSubmit(id)) {
                        return;
                    }
                    modalDialog.setVisible(false);
                });
                modalDialog.setVisible(true);
            }

            void initButtons() {
                this.dd.setOptions((Object[])this.buttons.toArray(new JButton[0]));
                this.dd.setClosingOptions(new Object[0]);
            }

            final Runnable initializationSequence(Runnable afterInitPage) {
                return () -> HtmlToolkit.getDefault().execute(() -> HtmlToolkit.getDefault().initHtmlDialog(this.ctx.getPage(), this.dd, this.p, () -> {
                    this.ctx.onPageLoad();
                    this.initButtons();
                    if (afterInitPage != null) {
                        EventQueue.invokeLater(afterInitPage);
                    }
                }, this.ctx.getTechIds()));
            }

            final Runnable initializationNestedLoop() {
                return this.initializationSequence(() -> {
                    this.showDialog();
                    this.ctx.onSubmit(null);
                    HtmlToolkit.getDefault().execute(() -> HtmlToolkit.getDefault().exitNestedLoop(this));
                });
            }
        }
    }
}

