/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.settings.ui;

import java.awt.Dimension;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.graalvm.visualizer.settings.Settings;
import org.graalvm.visualizer.settings.graal.GraalSettings;
import org.graalvm.visualizer.settings.ui.GraalOptionsPanelController;
import org.graalvm.visualizer.settings.ui.SettingsPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class GraalPanel
extends SettingsPanel<GraalPanel, GraalOptionsPanelController> {
    private final GraalSettings setting;
    private final DefaultListModel<String> fileListModel = new DefaultListModel();
    private final JFileChooser fc = FileChooserBuilder.create((FileSystem)FileUtil.createMemoryFileSystem()).setFileFilter(new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return !f.isHidden();
            }
            return f.getName().endsWith(".map");
        }

        @Override
        public String getDescription() {
            return "ProGuard Map Files";
        }
    }).setFilesOnly(true).createFileChooser();
    private JCheckBox acceptNetworkCheckBox;
    private JButton addFileButton;
    private JCheckBox autoSeparateSessionsCheckBox;
    private JCheckBox cleanCachesCheckBox;
    private JList<String> filesList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField mavenTextField;
    private JFormattedTextField portFormattedTextField;
    private JButton removeFileButton;
    private JFormattedTextField sessionCloseTimeoutFormattedTextField;
    private JLabel strippingMapLocationsLabel;

    public GraalPanel(GraalOptionsPanelController controller) {
        super(controller);
        this.setting = GraalSettings.obtain();
        this.initComponents();
        GraalPanel.setMin(this.portFormattedTextField, Integer.valueOf(0));
        GraalPanel.setMin(this.sessionCloseTimeoutFormattedTextField, Integer.valueOf(0));
        this.filesList.setModel(this.fileListModel);
        this.fc.setMultiSelectionEnabled(true);
        this.tieComponentsToProperties();
        SwingUtilities.invokeLater(() -> GraalPanel.setPreferredSizeRecursive(this.getParent()));
    }

    @Override
    protected Settings getSettings() {
        return this.setting;
    }

    private void tieComponentsToProperties() {
        this.tie(BOOL, this.acceptNetworkCheckBox, "acceptNetwork");
        this.tie(BOOL, this.autoSeparateSessionsCheckBox, "autoSeparateSessions");
        this.tie(INT_FORM, this.portFormattedTextField, "portBinary");
        this.tie(INT_FORM, this.sessionCloseTimeoutFormattedTextField, "sessionCloseTimeout");
        this.tie(STRING, this.mavenTextField, "repository");
        this.tie(BOOL, this.cleanCachesCheckBox, "cleanCaches");
        this.addLoad(() -> this.setting.getFileMap().forEach(fn -> this.fileListModel.addElement((String)fn)));
        this.addFileButton.addActionListener(e -> {
            this.fc.setCurrentDirectory(new File(this.setting.getDirectory()));
            if (0 == this.fc.showDialog(this, "Add file")) {
                List<String> fileNames = Arrays.stream(this.fc.getSelectedFiles()).map(f -> f.getAbsolutePath()).collect(Collectors.toList());
                fileNames.forEach(fn -> this.fileListModel.addElement((String)fn));
                this.setting.addFilesToMap(fileNames);
                this.settingsChanged();
            }
        });
        this.removeFileButton.addActionListener(e -> {
            List<String> fileNames = this.filesList.getSelectedValuesList();
            fileNames.forEach(s -> this.fileListModel.removeElement(s));
            this.setting.removeFilesFromMap(fileNames);
            this.settingsChanged();
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.portFormattedTextField = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.acceptNetworkCheckBox = new JCheckBox();
        this.autoSeparateSessionsCheckBox = new JCheckBox();
        this.sessionCloseTimeoutFormattedTextField = new JFormattedTextField();
        this.jLabel2 = new JLabel();
        this.cleanCachesCheckBox = new JCheckBox();
        this.mavenTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.addFileButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.filesList = new JList();
        this.removeFileButton = new JButton();
        this.strippingMapLocationsLabel = new JLabel();
        this.portFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.portFormattedTextField.setText(NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.portFormattedTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.acceptNetworkCheckBox, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.acceptNetworkCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoSeparateSessionsCheckBox, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.autoSeparateSessionsCheckBox.text"));
        this.sessionCloseTimeoutFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.sessionCloseTimeoutFormattedTextField.setText(NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.sessionCloseTimeoutFormattedTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cleanCachesCheckBox, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.cleanCachesCheckBox.text"));
        this.mavenTextField.setText(NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.mavenTextField.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.jLabel3.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFileButton, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.addFileButton.text"));
        this.jScrollPane2.setPreferredSize(new Dimension(22, 22));
        this.jScrollPane2.setViewportView(this.filesList);
        Mnemonics.setLocalizedText((AbstractButton)this.removeFileButton, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.removeFileButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.strippingMapLocationsLabel, (String)NbBundle.getMessage(GraalPanel.class, (String)"GraalPanel.strippingMapLocationsLabel.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.addFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeFileButton)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.portFormattedTextField, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addComponent(this.acceptNetworkCheckBox).addComponent(this.autoSeparateSessionsCheckBox).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.sessionCloseTimeoutFormattedTextField, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)).addComponent(this.cleanCachesCheckBox).addComponent(this.mavenTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)).addComponent(this.strippingMapLocationsLabel).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portFormattedTextField, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.acceptNetworkCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSeparateSessionsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sessionCloseTimeoutFormattedTextField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cleanCachesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mavenTextField, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.strippingMapLocationsLabel).addGap(1, 1, 1).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addFileButton).addComponent(this.removeFileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, -1, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
    }
}

