/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Selector;

public class ConnectionFilter
extends AbstractFilter {
    private final List<ConnectionStyleRule> connectionStyleRules;
    private final String name;

    public ConnectionFilter(String name) {
        this.name = name;
        this.connectionStyleRules = new ArrayList<ConnectionStyleRule>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void apply(Diagram diagram) {
        for (ConnectionStyleRule rule : this.connectionStyleRules) {
            Collection figures = rule.getSelector() != null ? rule.getSelector().selected(diagram) : diagram.getFigures();
            for (Figure f : figures) {
                for (OutputSlot os : f.getOutputSlots()) {
                    for (Connection c : os.getConnections()) {
                        if (!figures.contains(c.getInputSlot().getFigure())) continue;
                        c.setStyle(rule.getLineStyle());
                        c.setColor(rule.getLineColor());
                    }
                }
            }
        }
    }

    public void addRule(ConnectionStyleRule r) {
        this.connectionStyleRules.add(r);
    }

    public static class ConnectionStyleRule {
        private final Color lineColor;
        private final Connection.ConnectionStyle lineStyle;
        private final Selector selector;

        public ConnectionStyleRule(Selector selector, Color lineColor, Connection.ConnectionStyle lineStyle) {
            this.selector = selector;
            this.lineColor = lineColor;
            this.lineStyle = lineStyle;
        }

        public Selector getSelector() {
            return this.selector;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public Connection.ConnectionStyle getLineStyle() {
            return this.lineStyle;
        }
    }
}

