/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterEnvironment;
import org.graalvm.visualizer.filter.FilterEvent;
import org.graalvm.visualizer.filter.FilterListener;
import org.graalvm.visualizer.filter.FilterSequence;
import org.graalvm.visualizer.filter.Filters;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.script.ScriptEnvironment;

public class FilterChain
implements FilterSequence<FilterChain>,
ChangedEventProvider<FilterChain> {
    private final List<Filter> filters;
    private final transient ChangedEvent<FilterChain> changedEvent;
    private final transient List<FilterListener> listeners = new ArrayList<FilterListener>();
    private final ChangedListener<Filter> changedListener = new ChangedListener<Filter>(){

        public void changed(Filter source) {
            FilterChain.this.changedEvent.fire();
        }
    };

    public FilterChain() {
        this.filters = new ArrayList<Filter>();
        this.changedEvent = new ChangedEvent((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterChain(FilterChain f) {
        this.filters = new ArrayList<Filter>(f.filters);
        List<FilterListener> list = f.listeners;
        synchronized (list) {
            this.listeners.addAll(f.listeners);
        }
        this.changedEvent = new ChangedEvent((Object)this);
    }

    public FilterChain(FilterSequence f) {
        this.filters = new ArrayList<Filter>(f.getFilters());
        this.changedEvent = new ChangedEvent((Object)this);
    }

    @Override
    public ChangedEvent<FilterChain> getChangedEvent() {
        return this.changedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilterListener(FilterListener l) {
        List<FilterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilterListener(FilterListener l) {
        List<FilterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilterAt(int index) {
        FilterChain filterChain = this;
        synchronized (filterChain) {
            assert (index >= 0 && index < this.filters.size());
            return this.filters.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireFilterEvent(FilterEvent e, boolean startEnd) {
        FilterListener[] filterListenerArray = this.listeners;
        synchronized (this.listeners) {
            if (this.listeners.isEmpty()) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            FilterListener[] ll = this.listeners.toArray(new FilterListener[this.listeners.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (FilterListener l : ll) {
                if (startEnd) {
                    l.filterStart(e);
                    continue;
                }
                l.filterEnd(e);
            }
            return;
        }
    }

    void apply(Diagram d) {
        Filters.applyWithCancel(this, d, null).process();
    }

    public final List<Filter> getFilters(FilterChain ordering) {
        List<Filter> applyFilters = this.getFilters();
        ArrayList<Filter> orderedFilters = new ArrayList<Filter>(applyFilters.size());
        if (ordering != null) {
            for (Filter f : ordering.getFilters()) {
                if (!applyFilters.contains(f)) continue;
                orderedFilters.add(f);
            }
        }
        for (Filter f : applyFilters) {
            if (orderedFilters.contains(f)) continue;
            orderedFilters.add(f);
        }
        return orderedFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceFilters(List<Filter> newFilters) {
        FilterChain filterChain = this;
        synchronized (filterChain) {
            if (this.filters.equals(newFilters)) {
                return;
            }
            for (Filter f : this.filters) {
                f.getChangedEvent().removeListener(this.changedListener);
            }
            this.filters.clear();
            this.filters.addAll(newFilters);
            for (Filter f : newFilters) {
                f.getChangedEvent().addListener(this.changedListener);
            }
        }
        this.changedEvent.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(Filter filter) {
        assert (filter != null);
        FilterChain filterChain = this;
        synchronized (filterChain) {
            this.filters.add(filter);
        }
        filter.getChangedEvent().addListener(this.changedListener);
        this.changedEvent.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFilter(Filter filter) {
        FilterChain filterChain = this;
        synchronized (filterChain) {
            return this.filters.contains(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(Filter filter) {
        FilterChain filterChain = this;
        synchronized (filterChain) {
            assert (this.filters.contains(filter));
            this.filters.remove(filter);
        }
        filter.getChangedEvent().removeListener(this.changedListener);
        this.changedEvent.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFilterUp(Filter filter) {
        FilterChain filterChain = this;
        synchronized (filterChain) {
            assert (this.filters.contains(filter));
            int index = this.filters.indexOf(filter);
            if (index != 0) {
                this.filters.remove(index);
                this.filters.add(index - 1, filter);
            }
        }
        this.changedEvent.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFilterDown(Filter filter) {
        FilterChain filterChain = this;
        synchronized (filterChain) {
            assert (this.filters.contains(filter));
            int index = this.filters.indexOf(filter);
            if (index != this.filters.size() - 1) {
                this.filters.remove(index);
                this.filters.add(index + 1, filter);
            }
        }
        this.changedEvent.fire();
    }

    @Override
    public synchronized List<Filter> getFilters() {
        return Collections.unmodifiableList(new ArrayList<Filter>(this.filters));
    }

    static FEImpl createStub(Diagram d) {
        return new FEImpl(d, null);
    }

    static class FEImpl
    extends FilterEnvironment {
        private final boolean closeScript;

        public FEImpl(Diagram d, ScriptEnvironment e) {
            super(d, e == null ? new ScriptEnvImpl() : e);
            this.closeScript = e == null;
        }

        @Override
        public void close() throws IOException {
            if (this.closeScript) {
                this.getScriptEnvironment().close();
            }
        }
    }

    static class ScriptEnvImpl
    extends ScriptEnvironment {
        Map<Object, Object> vals = new HashMap<Object, Object>();

        ScriptEnvImpl() {
        }

        public <T> T setValue(Object key, T val) {
            return (T)this.vals.put(key, val);
        }

        public <T> T getValue(Object key) {
            return (T)this.vals.get(key);
        }

        public Set keys() {
            return this.vals.keySet();
        }

        public Iterable values() {
            return this.vals.values();
        }
    }
}

