/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.actions;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.graalvm.visualizer.data.SuppressFBWarnings;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.Presenter;

public abstract class EditorContextActionBase
extends AbstractAction
implements ContextAwareAction,
Presenter.Toolbar,
Presenter.Menu,
Presenter.Popup {
    protected static final int LARGE_ICON_SIZE = 24;
    protected static final String LARGE_ICON_SIZE_STRING = "24";
    protected final Map<String, ?> attributes;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private static final Object MASK_NULL_VALUE = new Object();

    EditorContextActionBase(Map<String, ?> attrs) {
        if (attrs == null) {
            attrs = new HashMap();
        }
        this.attributes = attrs;
    }

    public static Icon createSmallIcon(Action a) {
        String iconBase = (String)a.getValue("iconBase");
        if (iconBase != null) {
            return ImageUtilities.loadImageIcon((String)iconBase, (boolean)true);
        }
        return null;
    }

    public static Icon createLargeIcon(Action a) {
        Object iconBase = (String)a.getValue("iconBase");
        if (iconBase != null) {
            iconBase = (String)iconBase + LARGE_ICON_SIZE_STRING;
            return ImageUtilities.loadImageIcon((String)iconBase, (boolean)true);
        }
        return null;
    }

    protected Object createValue(String key) {
        Object value = "SmallIcon".equals(key) ? EditorContextActionBase.createSmallIcon(this) : ("SwingLargeIconKey".equals(key) ? EditorContextActionBase.createLargeIcon(this) : (this.attributes != null ? this.attributes.get(key) : null));
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"}, justification="Swing library defines the constant and also uses identity comparison")
    public final void putValue(String key, Object value) {
        Object oldValue;
        if (value == null && this.properties == null) {
            return;
        }
        if ("enabled" == key) {
            oldValue = this.enabled;
            this.enabled = Boolean.TRUE.equals(value);
        } else {
            Map<String, Object> map = this.properties;
            synchronized (map) {
                oldValue = this.properties.put(key, value != null ? value : MASK_NULL_VALUE);
            }
        }
        this.firePropertyChange(key, oldValue, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(String key) {
        if ("enabled" == key) {
            return this.enabled;
        }
        Map<String, Object> map = this.properties;
        synchronized (map) {
            Object value = this.properties.get(key);
            if (value == null) {
                if ("instanceCreate".equals(key)) {
                    return null;
                }
                if (value == null) {
                    value = this.createValue(key);
                    if (value == null) {
                        value = MASK_NULL_VALUE;
                    }
                    this.properties.put(key, value);
                }
            }
            if (value == MASK_NULL_VALUE) {
                value = null;
            }
            return value;
        }
    }

    public Component getToolbarPresenter() {
        return ActionPresenterProvider.getDefault().createToolbarPresenter((Action)this);
    }

    public JMenuItem getMenuPresenter() {
        return ActionPresenterProvider.getDefault().createMenuPresenter((Action)this);
    }

    public JMenuItem getPopupPresenter() {
        return ActionPresenterProvider.getDefault().createPopupPresenter((Action)this);
    }
}

