/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.impl;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.filter.Filter;
import org.graalvm.visualizer.filter.FilterProvider;
import org.graalvm.visualizer.filter.spi.GraphFilterLocator;
import org.graalvm.visualizer.shell.ShellUtils;
import org.graalvm.visualizer.shell.impl.FileChainProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ScriptFilterChainLocator
implements GraphFilterLocator {
    private LookupBasedProvider globalProvider;
    private final Map<FileObject, Reference<FilterProvider>> fileCache = new WeakHashMap<FileObject, Reference<FilterProvider>>();
    private static final FilterProvider NULL_SOURCE = new NullSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterProvider findChain(Lookup lkp) {
        FileObject f = null;
        FileObject fp = null;
        if (lkp != null) {
            DataShadow sh = null;
            Collection ff = lkp.lookupAll(FileObject.class);
            if (!ff.isEmpty()) {
                Iterator it = ff.iterator();
                f = (FileObject)it.next();
                try {
                    DataObject d = DataObject.find((FileObject)f);
                    if (d instanceof DataShadow) {
                        sh = (DataShadow)d;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (sh == null) {
                    sh = (DataShadow)lkp.lookup(DataShadow.class);
                }
                if (it.hasNext()) {
                    f = null;
                }
            }
            if (sh != null && f != null) {
                fp = sh.getPrimaryFile();
                try {
                    FileObject target = DataShadow.findOriginal((FileObject)f);
                    if (target != null) {
                        f = target;
                    }
                }
                catch (IOException target) {}
            } else {
                fp = f;
            }
        }
        if (f != null && f.isValid() && f.isData()) {
            FilterProvider ch;
            if (!ShellUtils.isScriptMimeType(f.getMIMEType()) || !ShellUtils.isScriptObject(f)) {
                return null;
            }
            ScriptFilterChainLocator scriptFilterChainLocator = this;
            synchronized (scriptFilterChainLocator) {
                Reference<FilterProvider> ref = this.fileCache.get(fp);
                FilterProvider filterProvider = ch = ref == null ? null : ref.get();
                if (ch != null) {
                    return ch;
                }
                ch = new FileChainProvider(f);
                this.fileCache.put(fp, new WeakReference<FilterProvider>(ch));
            }
            return ch;
        }
        if (lkp != null) {
            return null;
        }
        return this.globalProvider();
    }

    private synchronized LookupBasedProvider globalProvider() {
        if (this.globalProvider == null) {
            this.globalProvider = new LookupBasedProvider(Utilities.actionsGlobalContext(), this);
        }
        return this.globalProvider;
    }

    class LookupBasedProvider
    implements FilterProvider,
    LookupListener {
        private FilterProvider delegate = NULL_SOURCE;
        private final ScriptFilterChainLocator master;
        private final Lookup context;
        private final Lookup.Result<FileObject> fileResult;
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private FileObject currentFile;

        public LookupBasedProvider(Lookup context, ScriptFilterChainLocator master) {
            this.context = context;
            this.fileResult = context.lookupResult(FileObject.class);
            this.fileResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)context));
            this.master = master;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FilterProvider updateFile() {
            Collection c = this.fileResult.allInstances();
            FileObject newFile = c == null || c.isEmpty() ? null : (FileObject)c.iterator().next();
            LookupBasedProvider lookupBasedProvider = this;
            synchronized (lookupBasedProvider) {
                if (this.currentFile == newFile) {
                    return this.delegate;
                }
                this.currentFile = newFile;
                if (newFile == null) {
                    this.delegate = NULL_SOURCE;
                    return this.delegate;
                }
            }
            FilterProvider prov = this.master.findChain(newFile.getLookup());
            if (prov == null || prov == this) {
                prov = NULL_SOURCE;
            }
            LookupBasedProvider lookupBasedProvider2 = this;
            synchronized (lookupBasedProvider2) {
                if (this.currentFile == newFile) {
                    this.delegate = prov;
                }
            }
            this.fireChangeEvent();
            return prov;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Filter getFilter() {
            LookupBasedProvider lookupBasedProvider = this;
            synchronized (lookupBasedProvider) {
                if (this.delegate != null) {
                    return this.delegate.getFilter();
                }
            }
            return this.createFilter(false);
        }

        public Filter createFilter(boolean createNew) throws IllegalStateException {
            Filter result;
            FilterProvider cur = this.delegate;
            FilterProvider dele = this.updateFile();
            if (dele != cur) {
                this.fireChangeEvent();
                result = dele == null ? null : dele.createFilter(createNew);
            } else {
                result = null;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            FilterProvider src;
            LookupBasedProvider lookupBasedProvider = this;
            synchronized (lookupBasedProvider) {
                src = this.delegate;
            }
            FilterProvider newDele = this.updateFile();
            if (newDele != src) {
                this.fireChangeEvent();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            ChangeListener[] ll;
            LookupBasedProvider lookupBasedProvider = this;
            synchronized (lookupBasedProvider) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                ll = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : ll) {
                l.stateChanged(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            LookupBasedProvider lookupBasedProvider = this;
            synchronized (lookupBasedProvider) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            LookupBasedProvider lookupBasedProvider = this;
            synchronized (lookupBasedProvider) {
                this.listeners.remove(l);
            }
        }
    }

    static class NullSource
    implements FilterProvider {
        NullSource() {
        }

        public Filter createFilter(boolean createNew) throws IllegalStateException {
            return null;
        }

        public Filter getFilter() {
            return null;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

