/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.ControllableChangedListener;
import org.graalvm.visualizer.data.Source;
import org.graalvm.visualizer.data.services.GraphSelections;
import org.graalvm.visualizer.data.src.ImplementationClass;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;
import org.graalvm.visualizer.selectioncoordinator.SelectionCoordinator;
import org.graalvm.visualizer.settings.layout.LayoutSettings;
import org.graalvm.visualizer.util.ColorIcon;
import org.graalvm.visualizer.util.DoubleClickAction;
import org.graalvm.visualizer.util.DoubleClickHandler;
import org.graalvm.visualizer.util.PropertiesSheet;
import org.graalvm.visualizer.view.Bundle;
import org.graalvm.visualizer.view.DiagramViewModel;
import org.graalvm.visualizer.view.ExtendedSatelliteComponent;
import org.graalvm.visualizer.view.SceneUpdater;
import org.graalvm.visualizer.view.SceneViewport;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerEvent;
import org.graalvm.visualizer.view.api.DiagramViewerListener;
import org.graalvm.visualizer.view.widgets.BlockWidget;
import org.graalvm.visualizer.view.widgets.FigureWidget;
import org.graalvm.visualizer.view.widgets.FogWidget;
import org.graalvm.visualizer.view.widgets.InputSlotWidget;
import org.graalvm.visualizer.view.widgets.OutputSlotWidget;
import org.graalvm.visualizer.view.widgets.SlotWidget;
import org.graalvm.visualizer.view.widgets.actions.CustomizablePanAction;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ComponentWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.openide.awt.UndoRedo;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;

public class DiagramScene
extends ObjectScene
implements DiagramViewer {
    private static final Logger LOG = Logger.getLogger(DiagramScene.class.getName());
    private final TopComponent topComponent;
    private final CustomizablePanAction panAction;
    private final WidgetAction hoverAction;
    private final WidgetAction selectAction;
    private final Lookup lookup;
    private final InstanceContent content;
    private final JScrollPane scrollPane;
    private UndoRedo.Manager undoRedoManager;
    private final LayerWidget centeringLayer;
    private final LayerWidget connectionLayer;
    private final LayerWidget mainLayer;
    private final LayerWidget blockLayer;
    private final LayerWidget selectLayer;
    private final Overlay overlayLayer;
    private final LayerWidget backgroundLayer;
    private final Widget topLeft;
    private final Widget bottomRight;
    private final FogWidget fogOfWorkWiget;
    private DiagramViewModel model;
    private DiagramViewModel modelCopy;
    private final WidgetAction zoomAction;
    private volatile boolean rebuilding;
    private Point previousViewportPosition;
    private final List<VL> viewports = new ArrayList<VL>(3);
    private SelectionCoordinator selectionCoordinator;
    private final ThreadLocal<SelMode> forceSelectionMode = new ThreadLocal<SelMode>(){

        @Override
        protected SelMode initialValue() {
            return SelMode.DEFAULT;
        }
    };
    private Diagram currentDiagram;
    private InputGraph currentGraph;
    public static final float ALPHA = 0.4f;
    public static final int BORDER_SIZE = 20;
    public static final int UNDOREDO_LIMIT = 100;
    public static final int SCROLL_UNIT_INCREMENT = 80;
    public static final int SCROLL_BLOCK_INCREMENT = 400;
    public static final float ZOOM_MAX_FACTOR = 3.0f;
    public static final float ZOOM_MIN_FACTOR = 0.0f;
    public static final float ZOOM_INCREMENT = 1.5f;
    public static final int SLOT_OFFSET = 8;
    public static final int ANIMATION_LIMIT = 40;
    private final PopupMenuProvider popupMenuProvider = (widget, localLocation) -> this.createPopupMenu();
    private final SceneUpdater updater;
    private final ViewportCenteringBridge viewportCenteringBridge;
    private final RectangularSelectDecorator rectangularSelectDecorator = () -> {
        Widget widget = new Widget((Scene)this);
        widget.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        widget.setForeground(Color.red);
        return widget;
    };
    private final ControllableChangedListener<SelectionCoordinator> highlightedCoordinatorListener = new ControllableChangedListener<SelectionCoordinator>(){

        public void filteredChanged(SelectionCoordinator source) {
            assert (source == DiagramScene.this.selectionCoordinator);
            DiagramScene.this.setHighlightedObjects(DiagramScene.this.idSetToObjectSet(source.getHighlightedObjects()));
            DiagramScene.this.validate();
        }
    };
    private final ControllableChangedListener<SelectionCoordinator> selectedCoordinatorListener = new ControllableChangedListener<SelectionCoordinator>(){

        public void filteredChanged(SelectionCoordinator source) {
            assert (source == DiagramScene.this.selectionCoordinator);
            DiagramScene.this.gotoSelection(source.getSelectedObjects());
            DiagramScene.this.validate();
        }
    };
    private final RectangularSelectProvider rectangularSelectProvider = rectangle -> {
        if (rectangle.width < 0) {
            rectangle.x += rectangle.width;
            rectangle.width *= -1;
        }
        if (rectangle.height < 0) {
            rectangle.y += rectangle.height;
            rectangle.height *= -1;
        }
        HashSet<Object> selectedObjects = new HashSet<Object>();
        for (Figure f : this.getDiagram().getFigures()) {
            FigureWidget w = (FigureWidget)((Object)((Object)this.getWidget(f)));
            if (w == null) continue;
            Rectangle r = new Rectangle(w.getBounds());
            r.setLocation(w.getLocation());
            if (r.intersects(rectangle)) {
                selectedObjects.add(f);
            }
            for (Slot s : f.getSlots()) {
                SlotWidget sw = (SlotWidget)((Object)((Object)this.getWidget(s)));
                Rectangle r2 = new Rectangle(sw.getBounds());
                r2.setLocation(sw.convertLocalToScene(new Point(0, 0)));
                if (!r2.intersects(rectangle)) continue;
                selectedObjects.add(s);
            }
        }
        this.setSelectedObjects(selectedObjects);
    };
    private final ObjectSceneListener selectionChangedListener = new ObjectSceneListener(){

        public void objectAdded(ObjectSceneEvent arg0, Object arg1) {
        }

        public void objectRemoved(ObjectSceneEvent arg0, Object arg1) {
        }

        public void objectStateChanged(ObjectSceneEvent e, Object o, ObjectState oldState, ObjectState newState) {
        }

        public void selectionChanged(ObjectSceneEvent e, Set<Object> oldSet, Set<Object> newSet) {
            DiagramScene scene = (DiagramScene)e.getObjectScene();
            SelMode m = DiagramScene.this.forceSelectionMode.get();
            if (m == SelMode.ACCEPT || m != SelMode.API && scene.isRebuilding()) {
                return;
            }
            ArrayList<Object> x = new ArrayList<Object>(newSet);
            HashSet<InputNode> nodeSelection = new HashSet<InputNode>();
            HashSet<Integer> nodeSelectionIds = new HashSet<Integer>();
            DiagramScene.computeSelectionContent(DiagramScene.this.getDiagram().getGraph(), newSet, x, nodeSelection, nodeSelectionIds);
            DiagramScene.this.model.setSelectedNodes(nodeSelection);
            x.add(DiagramScene.this.topComponent);
            DiagramScene.this.content.set(x, null);
            boolean b = DiagramScene.this.selectedCoordinatorListener.isEnabled();
            DiagramScene.this.selectedCoordinatorListener.setEnabled(false);
            DiagramScene.this.selectionCoordinator.setSelectedObjects(nodeSelectionIds);
            DiagramScene.this.selectedCoordinatorListener.setEnabled(b);
            DiagramScene.this.fireViewerEvent(DiagramViewerListener::stateChanged, new DiagramViewerEvent((DiagramViewer)DiagramScene.this));
        }

        public void highlightingChanged(ObjectSceneEvent e, Set<Object> oldSet, Set<Object> newSet) {
            HashSet nodeHighlighting = new HashSet();
            for (Object o : newSet) {
                if (!(o instanceof Source.Provider)) continue;
                ((Source.Provider)o).getSource().collectIds(nodeHighlighting);
            }
            boolean b = DiagramScene.this.highlightedCoordinatorListener.isEnabled();
            DiagramScene.this.highlightedCoordinatorListener.setEnabled(false);
            DiagramScene.this.selectionCoordinator.setHighlightedObjects(nodeHighlighting);
            DiagramScene.this.highlightedCoordinatorListener.setEnabled(b);
            DiagramScene.this.fireViewerEvent(DiagramViewerListener::stateChanged, new DiagramViewerEvent((DiagramViewer)DiagramScene.this));
        }

        public void hoverChanged(ObjectSceneEvent e, Object oldObject, Object newObject) {
            HashSet<Object> newHighlightedObjects = new HashSet<Object>(DiagramScene.this.getHighlightedObjects());
            if (oldObject != null) {
                newHighlightedObjects.remove(oldObject);
            }
            if (newObject != null) {
                newHighlightedObjects.add(newObject);
            }
            DiagramScene.this.setHighlightedObjects(newHighlightedObjects);
        }

        public void focusChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
        }
    };
    private final SceneViewport vp1 = new SceneViewport(){

        @Override
        public Rectangle getSceneViewRect() {
            return DiagramScene.this.getScrollPane().getVisibleRect();
        }

        @Override
        public Rectangle getViewportRect() {
            return DiagramScene.this.getScrollPane().getViewport().getViewRect();
        }

        @Override
        public void sceneContentsUpdated(boolean finished, Rectangle validRectangle) {
            Rectangle toUpdate = validRectangle.intersection(this.getSceneViewRect());
            if (!toUpdate.isEmpty()) {
                LOG.log(Level.FINE, "Repainting rect: {0}", toUpdate);
                DiagramScene.this.getScrollPane().getViewport().repaint(toUpdate);
            } else {
                LOG.log(Level.FINE, "Won't update invisible area.");
            }
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            DiagramScene.this.getScrollPane().getViewport().addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            DiagramScene.this.getScrollPane().getViewport().removeChangeListener(l);
        }
    };
    private boolean undoRedoEnabled = true;
    private final ChangedListener<DiagramViewModel> diagramChange = new ChangedListener<DiagramViewModel>(){

        public void changed(DiagramViewModel source) {
            assert (source == DiagramScene.this.model) : "Receive only changed event from current model!";
            assert (source != null);
            DiagramScene.this.update();
        }
    };
    private Pair<Figure, Point> lastSelectedFigureAndScrollPosition;
    private final PropertyChangeListener selectionChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LOG.log(Level.FINE, "Diagram selected figures changed.");
            DiagramScene.this.setSelected(DiagramScene.this.model.getSelectedFigures());
            Set olds = (Set)evt.getOldValue();
            if (olds != null) {
                Figure f;
                HashSet news = new HashSet((Set)evt.getNewValue());
                news.removeAll(olds);
                if (!news.isEmpty() && (f = DiagramScene.this.getDiagram().getFigureById(((InputNode)news.iterator().next()).getId())) != null) {
                    Point p = DiagramScene.this.convertSceneToView(f.getPosition());
                    Point scroll = DiagramScene.this.getScrollPosition();
                    DiagramScene.this.lastSelectedFigureAndScrollPosition = Pair.of((Object)f, (Object)new Point(scroll.x - p.x, scroll.y - p.y));
                    return;
                }
                DiagramScene.this.lastSelectedFigureAndScrollPosition = null;
            }
        }
    };
    private final PropertyChangeListener hiddenChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() == DiagramScene.this.model);
            LOG.log(Level.FINE, "Diagram hidden figures changed.");
            DiagramScene.this.selectionCoordinator.removeAllSelected((Set)evt.getNewValue());
        }
    };
    private final PropertyChangeListener containerChanged = evt -> {
        assert (evt.getSource() == this.model);
        LOG.log(Level.FINE, "Graph container changed.");
        if (this.getTopComponent().isShowing()) {
            this.componentHidden();
            this.selectionCoordinator = SelectionCoordinator.getInstanceForContainer((GraphContainer)this.model.getContainer());
            this.componentShowing();
        } else {
            this.selectionCoordinator = SelectionCoordinator.getInstanceForContainer((GraphContainer)this.model.getContainer());
        }
    };
    private Rectangle temporaryViewRect;
    private final Set<Widget> animatingWidgets = new HashSet<Widget>();
    private final List<DiagramViewerListener> viewerListeners = new ArrayList<DiagramViewerListener>();

    public <T> T getWidget(Object o) {
        Widget w = this.findWidget(o);
        return (T)w;
    }

    public <T> T getWidget(Object o, Class<T> klass) {
        Widget w = this.findWidget(o);
        return (T)w;
    }

    public void zoomOut() {
        double zoom = this.getZoomFactor();
        this.zoomTo(zoom / 1.5);
    }

    public JComponent createSatelliteView() {
        return new ExtendedSatelliteComponent(this);
    }

    public void centerSelectedFigures() {
        this.getScrollPane().getViewport().invalidate();
        this.getScrollPane().getViewport().validate();
        Collection figures = this.getSelectedObjects().stream().filter(o -> o instanceof Figure).collect(Collectors.toList());
        Rectangle u = this.unionRectangle(figures);
        if (u == null) {
            u = this.getScrollPane().getViewport().getViewRect();
            u = this.convertViewToScene(u);
        }
        Point rCenter = new Point((int)u.getCenterX(), (int)u.getCenterY());
        Dimension size = this.getScrollPane().getViewport().getExtentSize();
        Point scenePoint = this.convertSceneToView(rCenter);
        Point newPos = new Point(Math.max(0, scenePoint.x - size.width / 2), Math.max(0, scenePoint.y - size.height / 2));
        this.getScrollPane().getViewport().setViewPosition(newPos);
    }

    public void zoomIn() {
        double zoom = this.getZoomFactor();
        this.zoomTo(zoom * 1.5);
    }

    public void zoomTo(double newZoom) {
        if (newZoom <= 0.0 || newZoom > 3.0) {
            return;
        }
        this.setZoomFactor(newZoom);
        this.validate();
        this.executeWithDiagramShown(() -> {
            this.centerSelectedFigures();
            this.fireViewerEvent(DiagramViewerListener::displayChanged, new DiagramViewerEvent((DiagramViewer)this));
        });
    }

    public void centerFigures(Collection<Figure> list) {
        this.centerFigures(list, false);
    }

    private void centerFigures(Collection<Figure> list, boolean ignoreIfVisible) {
        boolean b = this.getUndoRedoEnabled();
        this.setUndoRedoEnabled(false);
        this.gotoFigures(list, ignoreIfVisible);
        this.setUndoRedoEnabled(b);
    }

    public Point getScrollPosition() {
        return this.getScrollPane().getViewport().getViewPosition();
    }

    public void setScrollPosition(Point p) {
        this.getScrollPane().getViewport().setViewPosition(p);
    }

    private JScrollPane createScrollPane() {
        JComponent comp = this.createView();
        comp.setDoubleBuffered(true);
        comp.setBackground(Color.WHITE);
        comp.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        JScrollPane result = new JScrollPane(comp);
        result.setBackground(Color.WHITE);
        result.getVerticalScrollBar().setUnitIncrement(80);
        result.getVerticalScrollBar().setBlockIncrement(400);
        result.getHorizontalScrollBar().setUnitIncrement(80);
        result.getHorizontalScrollBar().setBlockIncrement(400);
        return result;
    }

    static void computeSelectionContent(InputGraph graph, Set<Object> selectedObjects, Collection<Object> fillToLookup, Set<InputNode> nodeSelection, Set<Integer> nodeSelectionIds) {
        for (Object o : selectedObjects) {
            InstanceContent nodeContent = new InstanceContent();
            AbstractLookup nodeLookup = new AbstractLookup((AbstractLookup.Content)nodeContent);
            AbstractNode node = null;
            if (o instanceof Properties.Provider) {
                final Properties.Provider provider = (Properties.Provider)o;
                node = new AbstractNode(Children.LEAF, (Lookup)nodeLookup){

                    protected Sheet createSheet() {
                        Sheet s = super.createSheet();
                        PropertiesSheet.initializeSheet((Properties)provider.getProperties(), (Sheet)s);
                        return s;
                    }
                };
                Object className = provider.getProperties().get("class");
                if (className instanceof String) {
                    fillToLookup.add(new ImplementationClass((String)className));
                }
                node.setDisplayName(provider.getProperties().getString("name", Bundle.NAME_MissingName()));
                nodeContent.add(o);
            }
            if (o instanceof Slot || o instanceof Figure) {
                Source.Provider p = (Source.Provider)o;
                for (InputNode n : p.getSource().getSourceNodes()) {
                    fillToLookup.add(n);
                    nodeContent.add((Object)n);
                }
                nodeSelection.addAll(p.getSource().getSourceNodes());
                nodeSelectionIds.addAll(p.getSource().getSourceNodeIds());
            }
            nodeContent.add((Object)graph);
            if (node == null) continue;
            fillToLookup.add(node);
        }
    }

    public DiagramScene(DiagramViewModel model, TopComponent tc) {
        assert (tc != null);
        this.topComponent = tc;
        this.setCheckClipping(true);
        this.getInputBindings().setZoomActionModifiers(2);
        this.selectionCoordinator = SelectionCoordinator.getInstanceForContainer((GraphContainer)model.getContainer());
        this.content = new InstanceContent();
        this.content.add((Object)tc);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.content);
        this.scrollPane = this.createScrollPane();
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.centeringLayer = new LayerWidget((Scene)this);
        this.blockLayer = new LayerWidget((Scene)this);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.mainLayer = new LayerWidget((Scene)this);
        this.selectLayer = new LayerWidget((Scene)this);
        this.overlayLayer = new Overlay(this);
        this.topLeft = new Widget((Scene)this);
        this.topLeft.setPreferredLocation(new Point(-20, -20));
        this.bottomRight = new Widget((Scene)this);
        this.bottomRight.setPreferredLocation(new Point(-20, -20));
        this.fogOfWorkWiget = new FogWidget(this);
        this.addChild((Widget)this.backgroundLayer);
        this.addChild(this.topLeft);
        this.addChild(this.bottomRight);
        this.setLayout(LayoutFactory.createAbsoluteLayout());
        this.addChild((Widget)this.centeringLayer);
        this.addChild((Widget)this.overlayLayer);
        this.backgroundLayer.addChild((Widget)this.fogOfWorkWiget);
        this.centeringLayer.setLayout((Layout)new CenteringLayout(LayoutFactory.createAbsoluteLayout()));
        this.hoverAction = this.createObjectHoverAction();
        this.panAction = new CustomizablePanAction(-1, 1024);
        this.selectAction = this.createSelectAction();
        this.zoomAction = ActionFactory.createMouseCenteredZoomAction((double)1.2);
        this.getActions().addAction((WidgetAction)this.panAction);
        this.getActions().addAction(this.selectAction);
        this.getActions().addAction(this.zoomAction);
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this.popupMenuProvider));
        this.getActions().addAction(ActionFactory.createWheelPanAction());
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)this.rectangularSelectDecorator, (LayerWidget)this.selectLayer, (RectangularSelectProvider)this.rectangularSelectProvider));
        boolean b = this.getUndoRedoEnabled();
        this.setUndoRedoEnabled(false);
        this.setNewModel(model);
        this.setUndoRedoEnabled(b);
        this.updater = new SceneUpdater(this);
        this.viewportCenteringBridge = new ViewportCenteringBridge(this.getScrollPane().getViewport());
        this.updater.addChangeListener(e -> this.fogOfWorkWiget.setValidShape(this.updater.getValidatedShape()));
        this.addObjectSceneListener(this.selectionChangedListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED, ObjectSceneEventType.OBJECT_HIGHLIGHTING_CHANGED, ObjectSceneEventType.OBJECT_HOVER_CHANGED});
        this.getSceneAnimator().getPreferredLocationAnimator().addAnimatorListener(new AnimatorListener(){

            public void animatorStarted(AnimatorEvent ae) {
            }

            public void animatorReset(AnimatorEvent ae) {
            }

            public void animatorFinished(AnimatorEvent ae) {
                DiagramScene.this.animationStopped(ae);
            }

            public void animatorPreTick(AnimatorEvent ae) {
            }

            public void animatorPostTick(AnimatorEvent ae) {
            }
        });
        this.viewports.add(new VL(this.vp1));
        this.getScrollPane().getViewport().addChangeListener(this.viewportCenteringBridge);
    }

    public DiagramViewModel getModel() {
        return this.model;
    }

    private Diagram getDiagram() {
        return this.model.getDiagramToView();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public Component getComponent() {
        return this.scrollPane;
    }

    TopComponent getTopComponent() {
        return this.topComponent;
    }

    public boolean isAllVisible() {
        return this.model.getHiddenNodes().isEmpty();
    }

    public Action createGotoAction(final Figure f) {
        final DiagramScene diagramScene = this;
        String l = f.getLines()[0];
        int h = f.isVisible() ? 0 : 1;
        String name = f.getCluster() == null ? Bundle.FMT_GotoFigureActionName(l, h) : Bundle.FMT_GotoFigureActionName_Clustered(l, f.getCluster().toString(), h);
        AbstractAction a = new AbstractAction(name, (Icon)new ColorIcon(f.getColor())){

            @Override
            public void actionPerformed(ActionEvent e) {
                diagramScene.gotoFigure(f);
            }
        };
        a.setEnabled(true);
        return a;
    }

    public final void setNewModel(DiagramViewModel model) {
        assert (this.model == null) : "can set model only once!";
        this.model = model;
        this.modelCopy = model.copy();
        model.getDiagramChangedEvent().addListener(this.diagramChange);
        model.addPropertyChangeListener("selectedNodes", this.selectionChange);
        model.addPropertyChangeListener("hiddenNodes", this.hiddenChange);
        model.addPropertyChangeListener("graphContainerChanged", this.containerChanged);
        this.currentDiagram = model.getDiagramToView();
    }

    private void update() {
        Diagram dg = this.getDiagram();
        Diagram old = this.currentDiagram;
        if (dg == null || dg == old) {
            return;
        }
        if (this.model.isStubDiagram(dg)) {
            this.previousViewportPosition = this.currentGraph == this.getGraph() ? this.getScrollPosition() : null;
        } else {
            boolean b = this.getUndoRedoEnabled();
            this.setUndoRedoEnabled(b && !this.model.isStubDiagram(this.currentDiagram));
            this.addUndo();
            if (this.currentGraph != this.getGraph()) {
                this.previousViewportPosition = null;
            }
            this.currentDiagram = dg;
            this.currentGraph = this.getGraph();
            this.setUndoRedoEnabled(b);
            this.validate();
            this.fireViewerEvent(DiagramViewerListener::diagramChanged, new DiagramViewerEvent((Object)this, old));
            this.executeWithDiagramShown(() -> {
                this.centerSelectionAfterChange();
                this.fireViewerEvent(DiagramViewerListener::diagramReady, new DiagramViewerEvent((Object)this, old));
            });
        }
    }

    private void recenterLastNode(boolean selected, Collection<Figure> figs) {
        Figure f;
        if (this.lastSelectedFigureAndScrollPosition != null && (f = this.getDiagram().getFigureById(((Figure)this.lastSelectedFigureAndScrollPosition.first()).getId())) != null && f.isVisible() && figs.contains(f)) {
            Point dest = this.convertSceneToView(f.getPosition());
            dest.translate(((Point)this.lastSelectedFigureAndScrollPosition.second()).x, ((Point)this.lastSelectedFigureAndScrollPosition.second()).y);
            this.setScrollPosition(dest);
            return;
        }
        if (!selected && this.previousViewportPosition != null) {
            this.setScrollPosition(this.previousViewportPosition);
        } else {
            this.centerFigures(figs, true);
        }
    }

    public boolean isRebuilding() {
        return this.rebuilding;
    }

    public void relayout(LayoutSettings.LayoutSettingBean layoutSetting) {
        this.model.setLayoutSetting(layoutSetting);
    }

    public void setInteractionMode(DiagramViewer.InteractionMode mode) {
        this.panAction.setEnabled(mode == DiagramViewer.InteractionMode.PANNING);
        this.fireViewerEvent(DiagramViewerListener::interactionChanged, new DiagramViewerEvent((DiagramViewer)this));
    }

    public DiagramViewer.InteractionMode getInteractionMode() {
        return this.panAction.isEnabled() ? DiagramViewer.InteractionMode.PANNING : DiagramViewer.InteractionMode.SELECTION;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    void initialize() {
        Figure f = this.getDiagram().getRootFigure();
        if (f != null) {
            this.setUndoRedoEnabled(false);
            this.gotoFigure(f);
            this.setUndoRedoEnabled(true);
        }
    }

    private Rectangle unionRectangle(Collection<Figure> figures) {
        Rectangle overall = null;
        for (Figure f : figures) {
            Rectangle r = f.getBounds();
            if (r == null) continue;
            overall = this.union(overall, r);
        }
        return overall;
    }

    public void executeWithDiagramShown(Runnable r) {
        this.updater.whenDiagramShown(r);
    }

    public void gotoFigures(List<Figure> figures) {
        this.gotoFigures(figures, false);
    }

    private void gotoFigures(Collection<Figure> figures, boolean ignoreIfVisible) {
        this.model.showFigures(figures);
        this.executeWithDiagramShown(() -> {
            Rectangle overall = this.unionRectangle(figures);
            if (overall != null) {
                this.centerRectangle(overall, ignoreIfVisible);
            }
        });
    }

    private Set<Source.Provider> idSetToObjectSet(Set<Object> ids) {
        return this.getDiagram().forSources(ids, Source.Provider.class);
    }

    public void gotoSelection(Set<Object> ids) {
        this.gotoNodes(ids, true);
    }

    public void gotoNodes(Set<Object> ids, boolean select) {
        HashSet<Object> unhideIds = new HashSet<Object>();
        for (Object o : ids) {
            if (o instanceof InputNode) {
                unhideIds.add(((InputNode)o).getId());
                continue;
            }
            if (!(o instanceof Integer)) continue;
            unhideIds.add((Integer)o);
        }
        InputGraph g = this.model.getGraphToView();
        Rectangle overall = null;
        HashSet<Integer> hiddenNodes = new HashSet<Integer>(this.model.getHiddenNodes());
        if (hiddenNodes.removeAll(unhideIds)) {
            this.model.showNot(hiddenNodes);
        }
        Set<Source.Provider> objects = this.idSetToObjectSet(unhideIds);
        for (Source.Provider o : objects) {
            Point p;
            Rectangle r;
            Widget w = (Widget)this.getWidget(o);
            if (w != null) {
                r = w.getBounds();
                p = w.convertLocalToScene(new Point(0, 0));
            } else {
                Figure f;
                if (o instanceof Figure) {
                    f = (Figure)o;
                } else {
                    if (!(o instanceof Slot)) continue;
                    f = ((Slot)o).getFigure();
                }
                r = f.getBounds();
                p = r.getLocation();
            }
            if (r == null) continue;
            Rectangle r2 = new Rectangle(p.x, p.y, r.width, r.height);
            if (overall == null) {
                overall = r2;
                continue;
            }
            overall = overall.union(r2);
        }
        Set c = this.getSelectedObjects();
        if (overall != null) {
            this.centerRectangle(overall, false);
        }
        if (c.equals(objects)) {
            return;
        }
        if (select) {
            List<InputNode> toSelect = unhideIds.stream().map(i -> g.getNode(i.intValue())).filter(Objects::nonNull).collect(Collectors.toList());
            this.model.setSelectedNodes(toSelect);
        }
    }

    public void selectNodes(Set<InputNode> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        HashSet<Object> unhideIds = new HashSet<Object>();
        for (InputNode n : nodes) {
            unhideIds.add(n.getId());
        }
        Rectangle overall = null;
        Rectangle overallFigures = null;
        HashSet<Integer> hiddenNodes = new HashSet<Integer>(this.model.getHiddenNodes());
        if (hiddenNodes.removeAll(unhideIds)) {
            this.model.showNot(hiddenNodes);
        }
        Set<Source.Provider> objects = this.idSetToObjectSet(unhideIds);
        HashSet<Figure> figuresToSelect = new HashSet<Figure>();
        for (Source.Provider o : objects) {
            Rectangle r;
            Widget w;
            if (o instanceof Figure) {
                figuresToSelect.add((Figure)o);
            }
            if ((w = (Widget)this.getWidget(o)) == null || (r = w.getBounds()) == null) continue;
            Point p = w.convertLocalToScene(new Point(0, 0));
            overall = this.union(overall, new Rectangle(p.x, p.y, r.width, r.height));
            if (!(o instanceof Figure)) continue;
            overallFigures = this.union(overallFigures, new Rectangle(p.x, p.y, r.width, r.height));
        }
        if (!figuresToSelect.isEmpty()) {
            overall = overallFigures;
        }
        if (overall != null) {
            this.centerRectangle(overall, true);
        }
        this.setSelection(figuresToSelect);
    }

    private Rectangle union(Rectangle overall, Rectangle r2) {
        overall = overall == null ? r2 : overall.union(r2);
        return overall;
    }

    private Point calcCenter(Rectangle r) {
        JViewport viewport = this.getScrollPane().getViewport();
        Rectangle rect = viewport.getViewRect();
        Point center = new Point((int)r.getCenterX(), (int)r.getCenterY());
        center.x -= rect.width / 2;
        center.y -= rect.height / 2;
        Dimension viewSize = viewport.getViewSize();
        center.x = Math.min(viewSize.width - rect.width, Math.max(0, center.x));
        center.y = Math.min(viewSize.height - rect.height, Math.max(0, center.y));
        return center;
    }

    private void centerRectangle(Rectangle r, boolean ignoreIfVisible) {
        JViewport viewport = this.getScrollPane().getViewport();
        Rectangle rect = viewport.getViewRect();
        if (rect.isEmpty()) {
            return;
        }
        Rectangle r2 = this.convertSceneToView(r);
        if (ignoreIfVisible && rect.contains(r2)) {
            return;
        }
        double factor = Math.max((double)r2.width / (double)rect.width, (double)r2.height / (double)rect.height);
        if (factor >= 1.0) {
            this.setZoomFactor(this.getZoomFactor() / factor);
        } else {
            this.setZoomFactor(1.0);
            this.validate();
        }
        r2 = this.convertSceneToView(r);
        this.lastSelectedFigureAndScrollPosition = null;
        viewport.setViewPosition(this.calcCenter(r2));
    }

    public void setSelection(Collection<Figure> list) {
        this.model.setSelectedFigures(list);
    }

    private void setSelected(Collection<Figure> list) {
        if (this.getSelectedObjects().equals(list)) {
            return;
        }
        SelMode m = this.forceSelectionMode.get();
        this.forceSelectionMode.set(SelMode.API);
        try {
            super.setSelectedObjects(new HashSet<Figure>(list));
        }
        finally {
            this.forceSelectionMode.set(m);
        }
    }

    public GraphContainer getContainer() {
        return this.model.getContainer();
    }

    public List<Figure> getSelection() {
        ArrayList<Figure> al = new ArrayList<Figure>(this.getSelectedObjects());
        return al;
    }

    private UndoRedo.Manager getUndoRedoManager() {
        if (this.undoRedoManager == null) {
            this.undoRedoManager = new UndoRedo.Manager();
            this.undoRedoManager.setLimit(100);
        }
        return this.undoRedoManager;
    }

    public UndoRedo getUndoRedo() {
        return this.getUndoRedoManager();
    }

    private boolean isVisible(Figure f) {
        Collection hiddenNodes = this.model.getHiddenNodes();
        for (InputNode n : f.getSource().getSourceNodes()) {
            if (!hiddenNodes.contains(n.getId())) continue;
            return false;
        }
        return true;
    }

    public static boolean doesIntersect(Collection<?> s1, Set<?> s2) {
        for (Object o : s1) {
            if (!s2.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesIntersect(Set<?> s1, Set<?> s2) {
        if (s1.size() > s2.size()) {
            Set<?> tmp = s1;
            s1 = s2;
            s2 = tmp;
        }
        return DiagramScene.doesIntersect(s1, s2);
    }

    void componentHidden() {
        this.selectionCoordinator.getHighlightedChangedEvent().removeListener(this.highlightedCoordinatorListener);
        this.selectionCoordinator.getSelectedChangedEvent().removeListener(this.selectedCoordinatorListener);
    }

    void componentShowing() {
        this.selectionCoordinator.getHighlightedChangedEvent().addListener(this.highlightedCoordinatorListener);
        this.selectionCoordinator.getSelectedChangedEvent().addListener(this.selectedCoordinatorListener);
    }

    private void showFigure(Figure f) {
        HashSet<Integer> newHiddenNodes = new HashSet<Integer>(this.model.getHiddenNodes());
        newHiddenNodes.removeAll(f.getSource().getSourceNodeIds());
        this.model.setHiddenNodes(newHiddenNodes);
    }

    public void show(Figure f) {
        this.showFigure(f);
    }

    public void setSelectedObjects(Object ... args) {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(Arrays.asList(args));
        super.setSelectedObjects(set);
    }

    public void gotoFigure(Figure f) {
        if (!this.isVisible(f)) {
            this.showFigure(f);
        }
        this.executeWithDiagramShown(() -> {
            Rectangle r = f.getBounds();
            this.centerRectangle(r, false);
            this.setSelection(List.of(f));
        });
    }

    public JPopupMenu createPopupMenu() {
        return new JPopupMenu();
    }

    public void setUndoRedoEnabled(boolean b) {
        this.undoRedoEnabled = b;
    }

    public boolean getUndoRedoEnabled() {
        return this.undoRedoEnabled;
    }

    private void addUndo() {
        DiagramViewModel newModelCopy = this.model.copy();
        LOG.log(Level.FINE, "Possible undo operation, enabled = {2}, new model: {0}, old model copy: {1}", new Object[]{newModelCopy, this.modelCopy, this.undoRedoEnabled});
        if (this.undoRedoEnabled && this.modelCopy != null) {
            LOG.log(Level.FINER, "Undo operation created.");
            this.getUndoRedoManager().undoableEditHappened(new UndoableEditEvent((Object)this, new DiagramUndoRedo(this, this.modelCopy, newModelCopy)));
        }
        this.modelCopy = newModelCopy;
    }

    void prepareUpdate() {
        if (!this.overlayLayer.isBlockScene()) {
            this.overlayLayer.setBlockScene(true);
            this.cleanUp();
        } else {
            LOG.log(Level.FINE, "Scene is already prepared.");
        }
    }

    void finishUpdate() {
        assert (!this.model.isStubDiagram(this.currentDiagram));
        if (this.overlayLayer.isBlockScene()) {
            this.rebuilding = false;
            Runnable r = () -> {
                this.overlayLayer.setBlockScene(false);
                this.centeringLayer.addChild(0, (Widget)this.blockLayer);
                this.centeringLayer.addChild(1, (Widget)this.connectionLayer);
                this.centeringLayer.addChild(2, (Widget)this.mainLayer);
                this.centeringLayer.addChild(3, (Widget)this.selectLayer);
                this.validate();
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        } else {
            LOG.log(Level.FINE, "Scene is already finished.");
        }
    }

    void addConnection(Widget w) {
        this.connectionLayer.addChild(w);
    }

    WidgetAction getHoverAction() {
        return this.hoverAction;
    }

    private static void maybeRemoveChild(Widget from, Widget child, boolean erase) {
        if (child.getParentWidget() != null) {
            from.removeChild(child);
        }
        if (erase) {
            child.removeChildren();
        }
    }

    void cleanupConnections() {
        DiagramScene.maybeRemoveChild((Widget)this.centeringLayer, (Widget)this.connectionLayer, true);
        this.rebuilding = true;
    }

    void cleanUp() {
        DiagramScene.maybeRemoveChild((Widget)this.centeringLayer, (Widget)this.mainLayer, true);
        DiagramScene.maybeRemoveChild((Widget)this.centeringLayer, (Widget)this.blockLayer, true);
        DiagramScene.maybeRemoveChild((Widget)this.centeringLayer, (Widget)this.selectLayer, true);
        this.cleanupConnections();
        ArrayList obs = new ArrayList(this.getObjects());
        for (Object o : obs) {
            this.removeObject(o);
        }
        this.setBottomRightLocation(new Point(0, 0));
        this.setScrollPosition(new Point(0, 0));
        this.validate();
    }

    void setBottomRightLocation(Point pt) {
        this.bottomRight.setPreferredLocation(pt);
    }

    public Dimension getSceneSize() {
        Point pt = this.bottomRight.getPreferredLocation();
        return new Dimension(pt.x, pt.y);
    }

    private void centerSelectionAfterChange() {
        boolean doSelect;
        Diagram dg = this.getDiagram();
        if (this.model.isStubDiagram(dg)) {
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        HashSet<Figure> figs = new HashSet<Figure>();
        Set s = this.selectionCoordinator.getSelectedObjects();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Optional f = dg.getFigure(i);
            if (!f.isPresent()) continue;
            figs.add((Figure)f.get());
        }
        boolean bl = doSelect = !figs.isEmpty();
        if (figs.isEmpty()) {
            ArrayList ids = new ArrayList(dg.getGraph().getNodeIds());
            Collections.sort(ids);
            Iterator iterator2 = ids.iterator();
            while (iterator2.hasNext()) {
                Figure fig;
                int i = (Integer)iterator2.next();
                Optional f = dg.getFigure(i);
                if (!f.isPresent() || !(fig = (Figure)f.get()).isVisible() || fig.isBoundary()) continue;
                figs.add(fig);
                break;
            }
        }
        if (!figs.isEmpty()) {
            if (doSelect) {
                this.setSelectedObjects(figs);
            }
            this.recenterLastNode(doSelect, new ArrayList<Figure>(figs));
        } else {
            LOG.log(Level.FINE, "There are no figures to center on.");
        }
    }

    BlockWidget createBlockWidget(InputBlock bn) {
        BlockWidget w = (BlockWidget)((Object)this.getWidget(bn));
        if (w != null) {
            if (w.getParentWidget() == null) {
                this.mainLayer.addChild((Widget)w);
            }
            return w;
        }
        w = new BlockWidget((Scene)this, bn);
        w.setVisible(false);
        this.addObject(bn, new Widget[]{w});
        this.blockLayer.addChild((Widget)w);
        return w;
    }

    FigureWidget createFigureWidget(Figure f) {
        SlotWidget sw;
        FigureWidget w = (FigureWidget)((Object)this.getWidget(f));
        if (w != null) {
            if (w.getParentWidget() == null) {
                this.mainLayer.addChild((Widget)w);
            }
            return w;
        }
        if (!f.isVisible()) {
            return null;
        }
        w = new FigureWidget(f, this.hoverAction, this.selectAction, this, (Widget)this.mainLayer);
        w.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)w));
        w.getActions().addAction(this.selectAction);
        w.getActions().addAction(this.hoverAction);
        w.setVisible(false);
        this.addObject(f, new Widget[]{w});
        for (InputSlot s : f.getInputSlots()) {
            sw = new InputSlotWidget(s, this, (Widget)w, w);
            this.addObject(s, new Widget[]{sw});
            if (s.getSource().getSourceNodes().size() <= 0 && !s.getConnections().isEmpty()) continue;
            sw.getActions().addAction((WidgetAction)new DoubleClickAction((DoubleClickHandler)sw));
            sw.getActions().addAction(this.hoverAction);
            sw.getActions().addAction(this.selectAction);
        }
        for (InputSlot s : f.getOutputSlots()) {
            sw = new OutputSlotWidget((OutputSlot)s, this, (Widget)w, w);
            this.addObject(s, new Widget[]{sw});
            if (s.getSource().getSourceNodes().size() <= 0 && !s.getConnections().isEmpty()) continue;
            sw.getActions().addAction((WidgetAction)new DoubleClickAction((DoubleClickHandler)sw));
            sw.getActions().addAction(this.hoverAction);
            sw.getActions().addAction(this.selectAction);
        }
        return w;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSceneViewport(SceneViewport v) {
        DiagramScene diagramScene = this;
        synchronized (diagramScene) {
            for (Reference reference : this.viewports) {
                if (reference.get() != v) continue;
                return;
            }
            VL ref = new VL(v);
            this.viewports.add(ref);
            v.addChangeListener(ref);
        }
        this.updater.refreshView(false);
    }

    public synchronized Rectangle getBoundingViewportsRect() {
        assert (SwingUtilities.isEventDispatchThread());
        JViewport viewport = this.getScrollPane().getViewport();
        Rectangle r = viewport.getViewRect();
        for (VL vl : this.viewports) {
            SceneViewport v = (SceneViewport)vl.get();
            if (v == null) continue;
            r.add(v.getViewportRect());
        }
        return r;
    }

    public synchronized Rectangle getVisibleSceneRect() {
        assert (SwingUtilities.isEventDispatchThread());
        JViewport viewport = this.getScrollPane().getViewport();
        Rectangle r = this.convertViewToScene(viewport.getViewRect());
        for (VL vl : this.viewports) {
            SceneViewport v = (SceneViewport)vl.get();
            if (v == null) continue;
            r.add(v.getSceneViewRect());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireSceneUpdated(boolean finished) {
        int idx = 0;
        SceneViewport[] sceneViewportArray = this;
        synchronized (this) {
            if (this.viewports.isEmpty()) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            SceneViewport[] ll = new SceneViewport[this.viewports.size()];
            for (VL vl : this.viewports) {
                SceneViewport v = (SceneViewport)vl.get();
                if (v == null) continue;
                ll[idx++] = v;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (idx == 0) {
                return;
            }
            for (SceneViewport vp : ll) {
                if (ll == null) break;
                vp.sceneContentsUpdated(finished, this.updater.getValidatedRectangle());
            }
            return;
        }
    }

    public synchronized void removeSceneViewport(SceneViewport v) {
        SceneViewport removed = null;
        Iterator<VL> it = this.viewports.iterator();
        while (it.hasNext()) {
            VL vl = it.next();
            if (vl.get() != v) continue;
            it.remove();
            v.removeChangeListener(vl);
            removed = v;
            break;
        }
        if (removed == null) {
            return;
        }
        this.updater.cleanViewport();
    }

    Rectangle getSceneViewportSize() {
        Rectangle r = this.temporaryViewRect != null ? this.convertViewToScene(this.temporaryViewRect) : this.convertViewToScene(this.getScrollPane().getViewport().getViewRect());
        return r;
    }

    public void paintOnViewport(SceneViewport v, Graphics2D gr) {
        this.temporaryViewRect = v.getViewportRect();
        try {
            this.paint(gr);
        }
        finally {
            this.temporaryViewRect = null;
        }
    }

    void animationStopped(AnimatorEvent ev) {
        this.animatingWidgets.clear();
    }

    void moveWidget(Widget w, Rectangle rect) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.animatingWidgets.contains(w)) {
            this.getSceneAnimator().animatePreferredBounds(w, rect);
        } else {
            w.setPreferredBounds(rect);
        }
    }

    void moveWidget(Widget w, Point targetLocation) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.animatingWidgets.contains(w)) {
            this.getSceneAnimator().animatePreferredLocation(w, targetLocation);
        } else {
            w.setPreferredLocation(targetLocation);
        }
    }

    void animateMoveWidget(Widget w, Point targetLocation) {
        assert (SwingUtilities.isEventDispatchThread());
        this.animatingWidgets.add(w);
        this.getSceneAnimator().animatePreferredLocation(w, targetLocation);
    }

    void animateBounds(Widget w, Rectangle rect) {
        assert (SwingUtilities.isEventDispatchThread());
        this.animatingWidgets.add(w);
        this.getSceneAnimator().animatePreferredBounds(w, rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiagramViewerListener(DiagramViewerListener l) {
        List<DiagramViewerListener> list = this.viewerListeners;
        synchronized (list) {
            this.viewerListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiagramViewerListener(DiagramViewerListener l) {
        List<DiagramViewerListener> list = this.viewerListeners;
        synchronized (list) {
            this.viewerListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireViewerEvent(BiConsumer<DiagramViewerListener, DiagramViewerEvent> callback, DiagramViewerEvent ev) {
        DiagramViewerListener[] ll;
        List<DiagramViewerListener> list = this.viewerListeners;
        synchronized (list) {
            if (this.viewerListeners.isEmpty()) {
                return;
            }
            ll = this.viewerListeners.toArray(new DiagramViewerListener[this.viewerListeners.size()]);
        }
        SwingUtilities.invokeLater(() -> {
            for (DiagramViewerListener l : ll) {
                callback.accept(l, ev);
            }
        });
    }

    public GraphSelections getSelections() {
        return (GraphSelections)this.topComponent.getLookup().lookup(GraphSelections.class);
    }

    public Set<InputNode> nodesForFigure(Figure f) {
        assert (SwingUtilities.isEventDispatchThread());
        return new HashSet<InputNode>(f.getSource().getSourceNodes());
    }

    public void requestActive(boolean toFront, boolean attention) {
        if (attention) {
            this.topComponent.requestAttention(true);
        } else if (toFront) {
            this.topComponent.requestActive();
        } else {
            this.topComponent.requestVisible();
        }
    }

    public Collection<Figure> figuresForNodes(Collection<InputNode> nodes) {
        assert (SwingUtilities.isEventDispatchThread());
        Diagram d = this.getDiagram();
        HashSet<Figure> figuresToSelect = new HashSet<Figure>();
        for (InputNode n : nodes) {
            Collection provs = d.forSource(n.getId());
            for (Source.Provider p : provs) {
                if (p instanceof Figure) {
                    figuresToSelect.add((Figure)p);
                    continue;
                }
                if (!(p instanceof Slot)) continue;
                figuresToSelect.add(((Slot)p).getFigure());
            }
        }
        return figuresToSelect;
    }

    public InputGraph getGraph() {
        return this.getModel().getGraphToView();
    }

    public void setSelectedNodes(Set<InputNode> nodes) {
        this.getSelections().setSelectedNodes(nodes);
    }

    public Iterable<InputGraph> searchForward() {
        return this.model.getGraphsForward();
    }

    public Iterable<InputGraph> searchBackward() {
        return this.model.getGraphsBackward();
    }

    private void justifyCenteringLayer() {
        Point log = this.centeringLayer.getLocation();
        Point max = this.bottomRight.getLocation();
        int maxX = max.x;
        int maxY = max.y;
        int offx = 0;
        int offy = 0;
        int curWidth = maxX + 40;
        int curHeight = maxY + 40;
        Rectangle bounds = this.getScrollPane().getBounds();
        bounds.width = (int)((double)bounds.width / this.getZoomFactor());
        bounds.height = (int)((double)bounds.height / this.getZoomFactor());
        if (curWidth < bounds.width) {
            offx = (bounds.width - curWidth) / 2;
        }
        if (curHeight < bounds.height) {
            offy = (bounds.height - curHeight) / 2;
        }
        LOG.log(Level.FINE, "Center offset: {0}, {1}", new Object[]{offx, offy});
        Point pt = new Point(offx, offy);
        if (!log.equals(pt)) {
            this.centeringLayer.setPreferredLocation(pt);
        }
    }

    private static class Overlay
    extends LayerWidget {
        private final Widget waitWidget;
        private boolean blockScene = true;
        private final Rectangle oldviewRect = new Rectangle(0, 0, 0, 0);

        public Overlay(DiagramScene scene) {
            super((Scene)scene);
            this.setLayout(LayoutFactory.createAbsoluteLayout());
            JLabel label = new JLabel(Bundle.LBL_PleaseWaitPreparingGraph(), 11);
            ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("org/graalvm/visualizer/view/images/wait16.gif"));
            label.setIcon(icon);
            icon.setImageObserver(label);
            this.waitWidget = new ComponentWidget((Scene)scene, (Component)label);
            this.addChild(this.waitWidget);
            this.setOpaque(false);
            scene.getScrollPane().getViewport().addChangeListener(e -> {
                if (this.blockScene) {
                    Rectangle newViewRect = scene.getScrollPane().getViewport().getViewRect();
                    if (!this.oldviewRect.equals(newViewRect)) {
                        LOG.log(Level.FINER, "Viewport change from {1} to {0}, moving label", new Object[]{newViewRect.getBounds(), this.oldviewRect.getBounds()});
                        this.moveLabel(newViewRect);
                    } else {
                        LOG.log(Level.FINER, "Viewport dont change from {1} to {0}", new Object[]{newViewRect.getBounds(), this.oldviewRect.getBounds()});
                    }
                }
            });
        }

        public boolean isBlockScene() {
            return this.blockScene;
        }

        private void moveLabel(Rectangle newViewRect) {
            if (!this.blockScene) {
                return;
            }
            Point r = this.calc(newViewRect);
            if (r != null) {
                this.waitWidget.setPreferredLocation(r);
            }
        }

        public void setBlockScene(boolean blockScene) {
            assert (SwingUtilities.isEventDispatchThread());
            if (blockScene == this.blockScene) {
                return;
            }
            this.blockScene = blockScene;
            if (blockScene) {
                this.addChild(this.waitWidget);
                Rectangle newViewRect = ((DiagramScene)this.getScene()).getScrollPane().getViewport().getViewRect();
                if (!this.oldviewRect.equals(newViewRect)) {
                    this.moveLabel(newViewRect);
                }
            } else {
                this.removeChild(this.waitWidget);
            }
        }

        private Point calc(Rectangle newViewRect) {
            if (newViewRect.isEmpty()) {
                LOG.log(Level.FINER, "view rect:{0} is empty.", newViewRect.getBounds());
                return null;
            }
            if (this.oldviewRect.getSize().equals(newViewRect.getSize())) {
                return this.diffPosition(newViewRect);
            }
            this.oldviewRect.setBounds(newViewRect);
            Rectangle r = this.getScene().convertViewToScene(newViewRect);
            LOG.log(Level.FINER, "view rect:{0}, converted:{1}", new Object[]{newViewRect.getBounds(), r.getBounds()});
            Rectangle b = this.waitWidget.getPreferredBounds();
            assert (b != null);
            Point out = new Point(r.x + (r.width - b.width) / 2, r.y + (r.height - b.height) / 2);
            Point cur = b.getLocation();
            if (cur.equals(out)) {
                LOG.log(Level.FINER, "Label is already at {0}", cur);
                return null;
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Label moves from {0} to {1}", new Object[]{cur, out});
            }
            return out;
        }

        private Point diffPosition(Rectangle newViewRect) {
            Point cur = this.waitWidget.getPreferredLocation();
            assert (cur != null);
            Point out = cur.getLocation();
            out.translate(newViewRect.x - this.oldviewRect.x, newViewRect.y - this.oldviewRect.y);
            this.oldviewRect.setBounds(newViewRect);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Label moves from {0} to {1}", new Object[]{cur, out});
            }
            return out;
        }

        public boolean isHitAt(Point localLocation) {
            return this.blockScene;
        }
    }

    class CenteringLayout
    implements Layout {
        private final Layout delegate;

        public CenteringLayout(Layout delegate) {
            this.delegate = delegate;
        }

        public void layout(Widget widget) {
            this.delegate.layout(widget);
        }

        public boolean requiresJustification(Widget widget) {
            if (widget == DiagramScene.this.centeringLayer) {
                return true;
            }
            return this.delegate.requiresJustification(widget);
        }

        public void justify(Widget widget) {
            if (widget != DiagramScene.this.centeringLayer) {
                this.delegate.justify(widget);
            } else {
                DiagramScene.this.justifyCenteringLayer();
            }
        }
    }

    class ViewportCenteringBridge
    implements ChangeListener {
        private final JViewport viewport;
        private Dimension savedViewportSize;

        public ViewportCenteringBridge(JViewport viewport) {
            this.viewport = viewport;
            this.savedViewportSize = viewport.getVisibleRect().getSize();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.savedViewportSize.equals(this.viewport.getVisibleRect().getSize())) {
                DiagramScene.this.updater.whenDiagramShown(this::run);
            }
        }

        public void run() {
            this.savedViewportSize = this.viewport.getVisibleRect().getSize();
            DiagramScene.this.justifyCenteringLayer();
        }
    }

    class VL
    extends WeakReference<SceneViewport>
    implements ChangeListener,
    Runnable {
        public VL(SceneViewport viewport) {
            super(viewport, BaseUtilities.activeReferenceQueue());
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            DiagramScene.this.updater.refreshView(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DiagramScene diagramScene = DiagramScene.this;
            synchronized (diagramScene) {
                DiagramScene.this.viewports.remove(this);
            }
        }
    }

    static enum SelMode {
        DEFAULT,
        API,
        ACCEPT;

    }

    private static class DiagramUndoRedo
    extends AbstractUndoableEdit {
        private final DiagramViewModel oldModel;
        private final DiagramViewModel newModel;
        private final DiagramScene scene;

        public DiagramUndoRedo(DiagramScene scene, DiagramViewModel oldModel, DiagramViewModel newModel) {
            assert (oldModel != null);
            assert (newModel != null);
            this.oldModel = oldModel;
            this.newModel = newModel;
            this.scene = scene;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            boolean b = this.scene.getUndoRedoEnabled();
            this.scene.setUndoRedoEnabled(false);
            this.scene.selectedCoordinatorListener.setEnabled(false);
            try {
                this.scene.model.setData(this.newModel);
                this.updateSelection(this.newModel.getSelectedNodes());
            }
            finally {
                this.scene.selectedCoordinatorListener.setEnabled(true);
                this.scene.setUndoRedoEnabled(b);
            }
        }

        private void updateSelection(Collection<InputNode> selectedNodes) {
            this.scene.selectionCoordinator.setSelectedObjects(selectedNodes.stream().map(InputNode::getId).collect(Collectors.toSet()));
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            boolean b = this.scene.getUndoRedoEnabled();
            this.scene.setUndoRedoEnabled(false);
            this.scene.selectedCoordinatorListener.setEnabled(false);
            try {
                this.scene.model.setData(this.oldModel);
                this.updateSelection(this.oldModel.getSelectedNodes());
            }
            finally {
                this.scene.selectedCoordinatorListener.setEnabled(true);
                this.scene.setUndoRedoEnabled(b);
            }
        }
    }
}

