/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.editors;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.graphio.parsing.LocationStackFrame;
import jdk.graal.compiler.graphio.parsing.LocationStratum;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertyEditorRegistration;

@PropertyEditorRegistration(targetType={LocationStackFrame.class})
public class StacktracePropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private PropertyEnv env;
    private PropertyEditor delegate;
    private static final String LANG_JAVA = "Java";

    public void attachEnv(PropertyEnv pe) {
        this.env = pe;
        this.delegate = PropertyEditorManager.findEditor(String.class);
        if (this.delegate instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.delegate).attachEnv(pe);
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAsText() {
        HashMap langLines = new HashMap();
        for (LocationStackFrame elem = (LocationStackFrame)this.getValue(); elem != null; elem = elem.getParent()) {
            HashSet<String> langSeen = new HashSet<String>();
            for (LocationStratum st : elem.getStrata()) {
                ArrayList<String> trace;
                if (!langSeen.add(st.language)) continue;
                StringBuilder sb = new StringBuilder();
                boolean j = LANG_JAVA.equals(st.language);
                if (j && elem.getFullMethodName() != null) {
                    sb.append(elem.getFullMethodName());
                    sb.append(" ");
                }
                if (st.file != null) {
                    sb.append("(").append(st.file).append(":").append(st.line).append(")");
                } else if (st.uri != null) {
                    sb.append("(").append(st.uri).append(":").append(st.line).append(")");
                }
                if (j) {
                    sb.append(" [bci:").append(elem.getBci()).append(']');
                }
                if ((trace = (ArrayList<String>)langLines.get(st.language)) == null) {
                    trace = new ArrayList<String>();
                    langLines.put(st.language, trace);
                    trace.add(sb.toString());
                    continue;
                }
                String ll = sb.toString();
                if (((String)trace.get(trace.size() - 1)).equals(ll)) continue;
                trace.add(ll);
            }
        }
        StringBuilder sb = new StringBuilder();
        List lines = (List)langLines.get(LANG_JAVA);
        if (lines != null) {
            sb.append("Java:");
            this.printLanguageTrace(sb, lines);
        }
        for (String l : langLines.keySet()) {
            if (LANG_JAVA.equals(l)) continue;
            sb.append("\n\n");
            sb.append(l).append(':');
            this.printLanguageTrace(sb, (List)langLines.get(l));
        }
        return sb.toString();
    }

    private void printLanguageTrace(StringBuilder sb, List<String> lines) {
        for (String s : lines) {
            sb.append("\n\t");
            sb.append(s);
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return this.delegate.supportsCustomEditor();
    }

    @Override
    public Component getCustomEditor() {
        this.delegate.setValue(this.getAsText());
        return this.delegate.getCustomEditor();
    }
}

