/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public final class BlockWidget
extends Widget {
    public static final Color BACKGROUND_COLOR = new Color(235, 235, 255);
    public static final Color CORRUPTED_COLOR = new Color(255, 200, 200);
    private static final Font TITLE_FONT = new Font("Serif", 0, 14).deriveFont(1);
    private final InputBlock blockNode;

    public BlockWidget(Scene scene, InputBlock blockNode) {
        super(scene);
        this.blockNode = blockNode;
        this.setBackground(blockNode.getNodes().isEmpty() ? CORRUPTED_COLOR : BACKGROUND_COLOR);
        this.setOpaque(true);
        this.setCheckClipping(true);
    }

    protected void paintWidget() {
        super.paintWidget();
        Graphics2D g = this.getGraphics();
        Stroke old = g.getStroke();
        g.setColor(this.blockNode.getNodes().isEmpty() ? Color.RED : Color.BLUE);
        Rectangle r = this.getPreferredBounds();
        if (r.width > 0 && r.height > 0) {
            g.setStroke(new BasicStroke(2.0f));
            g.drawRect(r.x, r.y, r.width, r.height);
        }
        Color titleColor = Color.BLACK;
        g.setColor(titleColor);
        g.setFont(TITLE_FONT);
        String s = "B" + this.blockNode.getName();
        Rectangle2D r1 = g.getFontMetrics().getStringBounds(s, g);
        g.drawString(s, r.x + 5, r.y + (int)r1.getHeight());
        g.setStroke(old);
    }
}

