/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.view.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.graalvm.visualizer.view.DiagramScene;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class FogWidget
extends Widget {
    private final TexturePaint hatchPaint;
    private Area validArea;

    public FogWidget(DiagramScene scene) {
        super((Scene)scene);
        this.setOpaque(false);
        this.setCheckClipping(false);
        this.hatchPaint = FogWidget.makeHatch();
        this.validArea = new Area();
    }

    private static TexturePaint makeHatch() {
        int size = 10;
        BufferedImage hatchImage = new BufferedImage(size, size, 2);
        Graphics2D g2 = (Graphics2D)hatchImage.getGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, size, size);
        g2.setColor(Color.gray);
        g2.drawLine(0, 0, size, size);
        g2.dispose();
        return new TexturePaint(hatchImage, new Rectangle2D.Double(0.0, 0.0, size, size));
    }

    public void setValidShape(Area a) {
        this.validArea = a;
        this.revalidate();
    }

    public DiagramScene getDiagramScene() {
        return (DiagramScene)super.getScene();
    }

    protected Rectangle calculateClientArea() {
        Dimension sceneSize = this.getDiagramScene().getSceneSize();
        int curWidth = sceneSize.width + 20;
        int curHeight = sceneSize.height + 20;
        return new Rectangle(new Dimension(curWidth, curHeight));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintWidget() {
        float z = (float)this.getScene().getZoomFactor();
        Graphics ng = null;
        try {
            Area enlarged;
            Rectangle rect = this.getDiagramScene().getVisibleSceneRect();
            Area view = new Area(rect);
            view.subtract(this.validArea);
            if (view.isEmpty()) {
                return;
            }
            Area view2 = new Area(new Rectangle(this.getDiagramScene().getSceneSize()));
            view2.subtract(this.validArea);
            if (view2.isEmpty()) {
                return;
            }
            Graphics2D g = this.getGraphics();
            ng = (Graphics2D)g.create();
            if (z != 1.0f) {
                AffineTransform zoom = AffineTransform.getScaleInstance(z, z);
                enlarged = view.createTransformedArea(zoom);
                try {
                    ((Graphics2D)ng).transform(zoom.createInverse());
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {}
            } else {
                enlarged = view;
            }
            ng.setColor(new Color(240, 240, 240));
            ((Graphics2D)ng).setPaint(this.hatchPaint);
            ((Graphics2D)ng).fill(enlarged);
        }
        finally {
            if (ng != null) {
                ng.dispose();
            }
        }
    }
}

