/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.localization.LocalizationSupport;

final class HostNameValidator
extends StringValidator {
    private static final Pattern IPV6_REGEX = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");
    private static final Pattern IPV6_REGEX_WITH_PORT = Pattern.compile("^\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]:\\d+");
    private static final Pattern IP_V6_HOST_AND_PORT = Pattern.compile("^\\[([0-9A-Za-z\\:]*)\\]\\:(\\d+)$");
    private final boolean allowPort;
    private static final Pattern ALL_NUMBERS = Pattern.compile("^\\d+$");

    HostNameValidator(boolean allowPort) {
        this.allowPort = allowPort;
    }

    static boolean isIpV6(String model) {
        return IPV6_REGEX.matcher(model).matches() || IPV6_REGEX_WITH_PORT.matcher(model).matches();
    }

    private void validateIpV6(Problems problems, String compName, String model) {
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        Matcher m;
        if (model == null) {
            return;
        }
        if (IPV6_REGEX.matcher(model).matches()) {
            this.validateIpV6(problems, compName, model);
            return;
        }
        if (this.allowPort && !model.isEmpty() && model.charAt(0) == '[' && IPV6_REGEX_WITH_PORT.matcher(model).matches() && (m = IP_V6_HOST_AND_PORT.matcher(model)).find()) {
            String actualHost = m.group(1);
            String actualPort = m.group(2);
            this.validateIpV6(problems, compName, actualHost);
            try {
                int port = Integer.parseInt(actualPort);
                if (port < 0) {
                    problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "NEGATIVE_PORT", port));
                    return;
                }
                if (port >= 65536) {
                    problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "PORT_TOO_HIGH", port));
                    return;
                }
            }
            catch (NumberFormatException e) {
                problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "INVALID_PORT", compName, actualPort));
            }
            return;
        }
        if (model.length() == 0) {
            problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "INVALID_HOST_NAME", compName, model));
            return;
        }
        if (model.startsWith(".") || model.endsWith(".")) {
            problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "HOST_STARTS_OR_ENDS_WITH_PERIOD", model));
            return;
        }
        String[] parts = model.split("\\.");
        if (!this.allowPort && model.contains(":")) {
            problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "MSG_PORT_NOT_ALLOWED", compName, model));
            return;
        }
        StringValidators.NO_WHITESPACE.validate(problems, compName, model);
        if (model.endsWith("-") || model.startsWith("-")) {
            problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "INVALID_HOST_NAME", compName, model));
            return;
        }
        boolean[] numbers = new boolean[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String label = parts[i];
            if (label.length() > 63) {
                problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "LABEL_TOO_LONG", label));
                return;
            }
            if (i == parts.length - 1 && label.indexOf(":") > 0) {
                String[] labelAndPort = label.split(":");
                if (labelAndPort.length > 2) {
                    problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "INVALID_PORT", compName, label));
                    return;
                }
                if (labelAndPort.length == 1) {
                    problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "INVALID_PORT", compName, "''"));
                    return;
                }
                if (label.endsWith(":")) {
                    problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "TOO_MANY_COLONS", compName, label));
                    return;
                }
                try {
                    int port = Integer.parseInt(labelAndPort[1]);
                    if (port < 0) {
                        problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "NEGATIVE_PORT", port));
                        return;
                    }
                    if (port >= 65536) {
                        problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "PORT_TOO_HIGH", port));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "INVALID_PORT", compName, labelAndPort[1]));
                    return;
                }
                if (this.checkHostPart(labelAndPort[0], problems, compName, i, numbers)) continue;
                return;
            }
            this.checkHostPart(label, problems, compName, i, numbers);
        }
        if (numbers[numbers.length - 1]) {
            problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "NUMBER_PART_IN_HOSTNAME", parts[numbers.length - 1]));
        }
    }

    private boolean checkHostPart(String label, Problems problems, String compName, int index, boolean[] numbers) {
        if (label.length() > 63) {
            problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "LABEL_TOO_LONG", label));
            return false;
        }
        if (label.length() == 0) {
            problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "LABEL_EMPTY", compName, label));
            return false;
        }
        if (ALL_NUMBERS.matcher(label).matches()) {
            numbers[index] = true;
        }
        Problems tmp = new Problems();
        StringValidators.encodableInCharset("UTF-8").validate(tmp, compName, label);
        problems.addAll(tmp);
        if (!tmp.hasFatal()) {
            for (char c : label.toLowerCase().toCharArray()) {
                if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') continue;
                problems.append(LocalizationSupport.getMessage(HostNameValidator.class, "BAD_CHAR_IN_HOSTNAME", new String(new char[]{c})));
                return false;
            }
        }
        return true;
    }
}

