/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.graalvm.visualizer.coordinator.OutlineTopComponent;
import org.graalvm.visualizer.coordinator.actions.Bundle;
import org.graalvm.visualizer.coordinator.actions.SaveActionPerformer;
import org.graalvm.visualizer.coordinator.actions.SaveOperation;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class SaveAllAction
extends CallableSystemAction {
    boolean shiftPressed;

    public void performAction() {
        OutlineTopComponent component = OutlineTopComponent.findInstance();
        if (this.shiftPressed) {
            this.saveAsAllSessions();
        } else {
            this.saveSessions();
        }
    }

    private void saveAsAllSessions() {
        SaveOperation oper = new SaveOperation(true, SessionManagerImpl.getInstance().getSessions(), SessionManagerImpl.getInstance());
        oper.setSaveStyle(SaveOperation.Style.SESSIONS);
        new SaveActionPerformer(oper).doSave();
    }

    private void saveSessions() {
        SaveOperation oper = new SaveOperation(false, SessionManagerImpl.getInstance().getSessions(), SessionManagerImpl.getInstance());
        oper.setSaveStyle(SaveOperation.Style.FILES);
        new SaveActionPerformer(oper).doSave();
    }

    public void actionPerformed(ActionEvent ev) {
        this.shiftPressed = (ev.getModifiers() & 1) > 0;
        super.actionPerformed(ev);
    }

    public String getName() {
        return NbBundle.getMessage(SaveAllAction.class, (String)"CTL_SaveAllAction");
    }

    public SaveAllAction() {
        this.putValue("ShortDescription", Bundle.MSG_SavesAllGroupsToFile());
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
    }

    protected String iconResource() {
        return "org/graalvm/visualizer/coordinator/images/saveall.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

