/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.coordinator.impl;

import java.util.Collection;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import org.graalvm.visualizer.coordinator.impl.Bundle;
import org.graalvm.visualizer.coordinator.impl.FolderNode;
import org.graalvm.visualizer.coordinator.impl.SessionManagerImpl;
import org.graalvm.visualizer.util.ListenerSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class SessionNode
extends FolderNode
implements ChangedListener<GraphDocument>,
LookupListener {
    private static final String ICON_PREFIX = "org/graalvm/visualizer/coordinator/images/";
    private Lookup.Result<FileObject> storageResult;
    private FileObject file;

    public SessionNode(Folder folder) {
        super(folder);
        Lookup.Provider p = (Lookup.Provider)folder;
        this.storageResult = p.getLookup().lookupResult(FileObject.class);
        this.updateUI();
        ListenerSupport.addWeakListener((ChangedListener)this, (ChangedEvent)((GraphDocument)folder).getPropertyChangedEvent());
        this.storageResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.storageResult));
    }

    private GraphDocument doc() {
        return (GraphDocument)this.folder;
    }

    public void resultChanged(LookupEvent le) {
        this.updateUI();
    }

    public void changed(GraphDocument source) {
        SwingUtilities.invokeLater(this::updateUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUI() {
        boolean hasFile;
        SessionNode sessionNode = this;
        synchronized (sessionNode) {
            Collection col = this.storageResult.allInstances();
            hasFile = !col.isEmpty();
            this.file = hasFile ? (FileObject)col.iterator().next() : null;
            FileObject f = this.file;
        }
        this.setIconBaseWithExtension(ICON_PREFIX + (hasFile ? "file.png" : "graal.png"));
        String name = this.doc().getName();
        String label = this.doc().getProperties().getString("igv.userLabel", null);
        String n = SessionManagerImpl.getInstance().getSessionDisplayName(this.doc());
        this.setDisplayName(n);
        this.fireDisplayNameChange(null, null);
    }

    public String getHtmlDisplayName() {
        boolean modified = this.doc().isModified();
        if (modified) {
            return Bundle.FMT_ModifiedHtmlDecoration(super.getDisplayName());
        }
        return super.getHtmlDisplayName();
    }
}

