/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.function.Consumer;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;

public interface GraphDocumentVisitor {
    public static void visitAll(GraphDocument doc, Consumer<InputGraph> visit) {
        GraphDocumentVisitor visitor = inputGraph -> {
            visit.accept(inputGraph);
            return true;
        };
        visitor.visit(doc);
    }

    default public boolean visit(Folder folder) {
        for (FolderElement folderElement : folder.getElements()) {
            if (this.visit(folderElement)) continue;
            return false;
        }
        return true;
    }

    public boolean visit(InputGraph var1);

    default public boolean visit(Group g) {
        return this.visit((Folder)g);
    }

    default public boolean visit(GraphDocument document) {
        return this.visit((Folder)document);
    }

    default public boolean visit(FolderElement element) {
        if (element instanceof Group) {
            Group group = (Group)element;
            return this.visit(group);
        }
        if (element instanceof InputGraph) {
            InputGraph inputGraph = (InputGraph)element;
            return this.visit(inputGraph);
        }
        if (element instanceof Folder) {
            Folder folder = (Folder)element;
            return this.visit(folder);
        }
        return true;
    }
}

