/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;

public class InputNode
extends Properties.Entity {
    private int id;
    private final Object keep;
    private final Builder.NodeClass nodeClass;
    private final Map<Builder.Port, List<Integer>> portIdsMap = new LinkedHashMap<Builder.Port, List<Integer>>();
    private List<InputGraph> subgraphs;
    public static final Comparator<InputNode> COMPARATOR = Comparator.comparingInt(InputNode::getId);

    public InputNode(int id) {
        this(id, null, null);
    }

    private void mapPorts() {
        this.portIdsMap.clear();
        if (this.nodeClass != null) {
            for (Builder.TypedPort typedPort : this.nodeClass.inputs) {
                this.portIdsMap.put(typedPort, typedPort.ids);
            }
            for (Builder.Port port : this.nodeClass.sux) {
                this.portIdsMap.put(port, port.ids);
            }
        }
    }

    public Map<Builder.Port, List<Integer>> getIdsMap() {
        return this.portIdsMap;
    }

    public Builder.NodeClass getNodeClass() {
        return this.nodeClass;
    }

    public boolean hasPredecessors() {
        return "true".equals(this.getProperties().getString("hasPredecessor", null));
    }

    private static Properties nodeProperties(InputNode n, int id) {
        Properties properties = n == null ? Properties.newProperties() : Properties.newProperties(n.getProperties());
        properties.setProperty("id", String.valueOf(id));
        return properties;
    }

    public InputNode(InputNode n, Builder.NodeClass nodeClass, Object keep) {
        super(InputNode.nodeProperties(n, n.id));
        this.id = n.id;
        this.nodeClass = nodeClass;
        this.mapPorts();
        this.keep = keep;
    }

    public InputNode(int id, Builder.NodeClass nodeClass, Object keep) {
        super(InputNode.nodeProperties(null, id));
        this.id = id;
        this.nodeClass = nodeClass;
        this.mapPorts();
        this.keep = keep;
    }

    public InputNode(InputNode n) {
        this(n, n.nodeClass, n.keep);
    }

    public InputNode(int id, Builder.NodeClass nodeClass) {
        this(id, nodeClass, null);
    }

    public void setId(int id) {
        this.id = id;
        this.getProperties().setProperty("id", "" + id);
    }

    public int getId() {
        return this.id;
    }

    public void addSubgraph(InputGraph graph) {
        if (this.subgraphs == null) {
            this.subgraphs = new ArrayList<InputGraph>();
        }
        this.subgraphs.add(graph);
    }

    public List<InputGraph> getSubgraphs() {
        return this.subgraphs;
    }

    public void getSubgraphs(Map<String, Object> props) {
        if (this.subgraphs != null) {
            for (InputGraph x : this.subgraphs) {
                String name = x.getName();
                props.put(name.substring(name.indexOf(58) + 1).trim(), x);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof InputNode)) {
            return false;
        }
        InputNode n = (InputNode)o;
        return n.id == this.id;
    }

    public int hashCode() {
        return this.id * 13;
    }

    public String toString() {
        return "Node " + this.id + " " + this.getProperties().toString();
    }
}

