/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.ChangedListener;
import jdk.graal.compiler.graphio.parsing.model.Group;
import org.graalvm.visualizer.data.serialization.lazy.Completer;
import org.graalvm.visualizer.data.serialization.lazy.Env;
import org.graalvm.visualizer.data.serialization.lazy.StreamEntry;

abstract class BaseCompleter<T, E extends Group.LazyContent & ChangedEventProvider>
implements Completer<T>,
Runnable {
    private static final Logger LOG = Logger.getLogger(BaseCompleter.class.getName());
    public static final int RESCHEDULE_DELAY = 5000;
    public static final int ATTEMPT_COUNT = 10;
    protected final ConstantPool initialPool;
    protected final StreamEntry entry;
    private final Env env;
    protected E toComplete;
    private volatile KeepDataFuture future;
    private Group.Feedback feedbackToFinish;
    private T partialData = this.createEmpty();
    private T keepElements;
    private String name;
    private final ThreadLocal<Boolean> completingThread = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    BaseCompleter(Env env, StreamEntry entry) {
        this.env = env;
        this.initialPool = entry.getInitialPool();
        this.entry = entry;
    }

    protected T filter(T data) {
        return data;
    }

    protected synchronized void attachTo(E group, String name) {
        this.toComplete = group;
        this.name = name;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Created completer for {0}, pool id {1}, start = {2}, end = {3}", new Object[]{name, Integer.toHexString(System.identityHashCode(this.initialPool)), this.entry.getStart(), this.entry.getEnd()});
        }
    }

    protected final Env env() {
        return this.env;
    }

    E getModel() {
        return this.toComplete;
    }

    protected final E element() {
        return this.toComplete;
    }

    protected long size() {
        return this.entry.size();
    }

    public synchronized void end(long end) {
        LOG.log(Level.FINER, "End mark for group {0}", this.name);
    }

    @Override
    public synchronized Future<T> completeContents(Group.Feedback feedback) {
        if (this.future != null) {
            return this.future;
        }
        this.feedbackToFinish = feedback;
        this.future = new KeepDataFuture(this.scheduleFetch(feedback));
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Group.Feedback f;
        BaseCompleter baseCompleter = this;
        synchronized (baseCompleter) {
            this.partialData = null;
        }
        ((ChangedEventProvider)this.toComplete).getChangedEvent().fire();
        baseCompleter = this;
        synchronized (baseCompleter) {
            this.keepElements = null;
            f = this.feedbackToFinish;
            this.feedbackToFinish = null;
        }
        if (f != null) {
            f.finish();
        }
    }

    protected T load(ReadableByteChannel channel, int majorVersion, int minorVersion, Group.Feedback feedback) throws IOException {
        return null;
    }

    protected Future<T> future() {
        return this.future;
    }

    Future<T> scheduleFetch(Group.Feedback feedback) {
        LOG.log(Level.FINER, "Scheduling completion for {0}", this.name);
        return this.env.getFetchExecutor().schedule(new Worker(feedback), 0L, TimeUnit.MILLISECONDS);
    }

    protected T createEmpty() {
        return null;
    }

    protected T hookData(T data) {
        return data;
    }

    @Override
    public boolean canComplete() {
        return this.completingThread.get() == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPartialData(T partialData) {
        BaseCompleter baseCompleter = this;
        synchronized (baseCompleter) {
            this.partialData = partialData;
        }
        ((ChangedEventProvider)this.toComplete).getChangedEvent().fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T partialData() {
        Object x;
        T p;
        KeepDataFuture f;
        BaseCompleter baseCompleter = this;
        synchronized (baseCompleter) {
            f = this.future;
            p = this.partialData;
        }
        if (f != null && (x = this.future.tryGet()) != null) {
            return x;
        }
        return p;
    }

    class KeepDataFuture
    implements Future<T>,
    ChangedListener {
        private final Future<T> delegate;
        private volatile boolean done;
        private volatile T items;
        private volatile boolean cancel;

        public KeepDataFuture(Future<T> delegate) {
            this.delegate = delegate;
        }

        void complete(T data) {
            this.done = true;
            BaseCompleter.this.hookData(data);
            this.items = data;
        }

        void cancel() {
            this.cancel = true;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.cancel || this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.done && this.delegate.isDone();
        }

        public synchronized T tryGet() {
            if (this.isDone()) {
                return this.items;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() throws InterruptedException, ExecutionException {
            Object res = this.delegate.get();
            KeepDataFuture keepDataFuture = this;
            synchronized (keepDataFuture) {
                this.items = res;
            }
            return res;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }

        public void changed(Object source) {
        }
    }

    private class Worker
    implements Callable<T> {
        private final Group.Feedback feedback;

        public Worker(Group.Feedback feedback) {
            this.feedback = feedback;
        }

        private T invokeEvent(T newElements) {
            newElements = BaseCompleter.this.filter(newElements);
            BaseCompleter.this.future.complete(newElements);
            BaseCompleter.this.future = null;
            BaseCompleter.this.env.getFetchExecutor().schedule(BaseCompleter.this, 0L, TimeUnit.MILLISECONDS);
            BaseCompleter.this.completingThread.remove();
            return newElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object newElements = BaseCompleter.this.createEmpty();
            LOG.log(Level.FINER, "Reading group {0}, range {1}-{2}", new Object[]{BaseCompleter.this.name, BaseCompleter.this.entry.getStart(), BaseCompleter.this.entry.getEnd()});
            BaseCompleter.this.completingThread.set(true);
            try {
                newElements = BaseCompleter.this.load(BaseCompleter.this.env.getContent().subChannel(BaseCompleter.this.entry.getStart(), BaseCompleter.this.entry.getEnd()), BaseCompleter.this.entry.getMajorVersion(), BaseCompleter.this.entry.getMinorVersion(), this.feedback);
            }
            catch (InterruptedIOException ex) {
                BaseCompleter.this.future.cancel();
            }
            catch (ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, "Error during completion of group " + BaseCompleter.this.name, ex);
                newElements = BaseCompleter.this.partialData();
            }
            finally {
                BaseCompleter ex = BaseCompleter.this;
                synchronized (ex) {
                    BaseCompleter.this.keepElements = newElements;
                    LOG.log(Level.FINER, "Scheduling expansion of group  {0}", BaseCompleter.this.name);
                    this.invokeEvent(newElements);
                }
            }
            return newElements;
        }
    }
}

