/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.serialization.lazy;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jdk.graal.compiler.graphio.parsing.ConstantPool;

class StreamPool
extends ConstantPool {
    private List<Object> originalData;
    protected final BitSet itemRead = new BitSet();
    protected final int generation;
    private int entriesAdded;
    private boolean frozen;

    public StreamPool() {
        this.generation = 0;
    }

    public StreamPool(int generation, List<Object> data) {
        super(data);
        this.generation = generation;
    }

    @Override
    protected StreamPool create(List<Object> data) {
        return new StreamPool(this.generation + 1, data);
    }

    @Override
    public Object get(int index, long where) {
        this.itemRead.set(index);
        Object res = super.get(index, where);
        if (res == null) {
            throw new IllegalStateException("Pool inconsistency");
        }
        return res;
    }

    @Override
    public synchronized Object addPoolEntry(int index, Object obj, long where) {
        if (this.frozen) {
            throw new IllegalStateException("Pool copy is frozen");
        }
        if (this.size() > index && this.itemRead.get(index)) {
            if (this.originalData == null) {
                this.originalData = this.snapshot();
            }
            this.itemRead.clear();
        }
        return super.addPoolEntry(index, obj, where);
    }

    @Override
    public synchronized ConstantPool copy() {
        if (this.frozen || this.originalData == null) {
            return super.copy();
        }
        return this.create(new ArrayList<Object>(this.originalData));
    }

    public synchronized StreamPool forkIfNeeded() {
        totalEntries.addAndGet(this.entriesAdded);
        this.entriesAdded = 0;
        if (this.originalData != null) {
            ConstantPool r = this.swap(this.originalData);
            this.originalData = null;
            this.frozen = true;
            this.itemRead.clear();
            return (StreamPool)r;
        }
        return this;
    }

    public boolean modified() {
        return this.originalData != null;
    }
}

