/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.data.services;

import jdk.graal.compiler.graphio.parsing.model.GraphContainer;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.openide.util.Lookup;

public final class NodeContext {
    private final InputNode node;
    private final InputGraph graph;
    private final GraphContainer parent;

    public NodeContext(InputNode node, InputGraph graph, GraphContainer parent) {
        this.node = node;
        this.graph = graph;
        this.parent = parent;
    }

    public InputNode getNode() {
        return this.node;
    }

    public InputGraph getGraph() {
        return this.graph;
    }

    public GraphContainer getParent() {
        return this.parent;
    }

    public static NodeContext fromNode(InputNode n) {
        Provider p;
        if (n instanceof Provider) {
            return ((Provider)((Object)n)).nodeContext();
        }
        if (n instanceof Lookup.Provider && (p = (Provider)((Lookup.Provider)n).getLookup().lookup(Provider.class)) != null) {
            return p.nodeContext();
        }
        return null;
    }

    public static interface Provider
    extends Lookup.Provider {
        public NodeContext nodeContext();
    }
}

