/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graal.filters;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;

public class PropertyColorFilter
extends AbstractFilter {
    Map<String, Map<String, Color>> stringColorMap = new HashMap<String, Map<String, Color>>();

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void apply(Diagram diagram) {
        this.applyColorMap(diagram);
    }

    private void applyColorMap(Diagram diagram) {
        Set<String> keys = this.stringColorMap.keySet();
        for (Figure f : diagram.getFigures()) {
            for (String property : keys) {
                Color color;
                Object value = f.getProperties().get(property);
                if (value == null || (color = this.stringColorMap.get(property).get(value.toString())) == null) continue;
                f.setColor(color);
            }
        }
    }

    public void addRule(String property, String value, Color color) {
        this.stringColorMap.computeIfAbsent(property, x -> new HashMap()).put(value, color);
    }
}

