/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.graph;

import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputEdge;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.Source;
import org.graalvm.visualizer.graph.Block;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.InputSlot;
import org.graalvm.visualizer.graph.OutputSlot;
import org.graalvm.visualizer.graph.Slot;

public class Diagram {
    private static final Font FONT = new Font("Arial", 0, 12);
    private static final Font FONT_SLOT = new Font("Arial", 0, 10);
    private static final Font FONT_BOLD = FONT.deriveFont(1);
    private final InputGraph graph;
    private final String nodeText;
    private final Map<Integer, Figure> figureMap;
    private final Map<InputBlock, Block> blocks;
    private final ReadWriteLock diagramLock = new ReentrantReadWriteLock();
    private Map<Integer, Collection<Source.Provider>> sourceMap;
    private Dimension size;

    public static Font getFont() {
        return FONT;
    }

    public static Font getSlotFont() {
        return FONT_SLOT;
    }

    public static Font getBoldFont() {
        return FONT_BOLD;
    }

    private Diagram(InputGraph graph, String text) {
        this.graph = graph;
        this.nodeText = text;
        this.figureMap = new LinkedHashMap<Integer, Figure>();
        this.blocks = new LinkedHashMap<InputBlock, Block>(8);
        this.updateBlocks();
    }

    public Block getBlock(InputBlock b) {
        assert (this.blocks.containsKey(b));
        return this.blocks.get(b);
    }

    public String getNodeText() {
        return this.nodeText;
    }

    public void render(Runnable r) {
        Lock l = this.diagramLock.readLock();
        l.lock();
        try {
            r.run();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T render(Callable<T> r) throws Exception {
        Lock l = this.diagramLock.readLock();
        l.lock();
        try {
            T t = r.call();
            return t;
        }
        finally {
            l.unlock();
        }
    }

    public void change(Runnable r) {
        Lock l = this.diagramLock.writeLock();
        l.lock();
        try {
            r.run();
        }
        finally {
            l.unlock();
        }
    }

    private void updateBlocks() {
        this.blocks.clear();
        for (InputBlock b : this.graph.getBlocks()) {
            Block curBlock = new Block(b, this);
            this.blocks.put(b, curBlock);
        }
    }

    public Collection<Block> getBlocks() {
        return Collections.unmodifiableCollection(this.blocks.values());
    }

    public Collection<Figure> getFigures() {
        return Collections.unmodifiableCollection(this.figureMap.values());
    }

    public List<Figure> getFigureList() {
        return Collections.unmodifiableList(new ArrayList<Figure>(this.figureMap.values()));
    }

    private Map<Integer, Figure> createFigures() {
        for (InputNode n : this.graph.getNodes()) {
            Figure f = new Figure(this, n.getId());
            f.getSource().addSourceNode(n);
            f.getProperties().add(n.getProperties());
            f.setSubgraphs(n.getSubgraphs());
            assert (!this.figureMap.containsKey(f.getId()));
            this.figureMap.put(f.getId(), f);
        }
        return this.figureMap;
    }

    public Connection createConnection(InputSlot inputSlot, OutputSlot outputSlot, String label, String type) {
        assert (inputSlot.getFigure().getDiagram() == this);
        assert (outputSlot.getFigure().getDiagram() == this);
        return new Connection(inputSlot, outputSlot, label, type);
    }

    public Map<InputNode, Set<Figure>> calcSourceToFigureRelation() {
        HashMap<InputNode, Set<Figure>> map = new HashMap<InputNode, Set<Figure>>();
        for (InputNode node : this.graph.getNodes()) {
            map.put(node, new HashSet());
        }
        for (Figure f : this.figureMap.values()) {
            for (InputNode node : f.getSource().getSourceNodes()) {
                ((Set)map.get(node)).add(f);
            }
        }
        return map;
    }

    public Diagram copy() {
        Diagram d = new Diagram(this.graph, this.nodeText);
        this.render(() -> {
            for (Figure figure : this.figureMap.values()) {
                Figure cf = figure.makeCopy(d);
                d.figureMap.put(cf.getId(), cf);
            }
            Diagram.replaceConnections(this, d);
            for (Map.Entry entry : this.blocks.entrySet()) {
                d.getBlock((InputBlock)entry.getKey()).setBounds(((Block)entry.getValue()).getBounds());
            }
        });
        return d;
    }

    private static void replaceConnections(Diagram from, Diagram to) {
        for (Figure f : from.figureMap.values()) {
            Figure cfrom = to.figureMap.get(f.getId());
            List<OutputSlot> outputSlots = f.getOutputSlots();
            for (int i = 0; i < outputSlots.size(); ++i) {
                Slot s = outputSlots.get(i);
                OutputSlot cs = cfrom.getOutputSlots().get(i);
                for (Connection c : s.getConnections()) {
                    InputSlot ts = c.getInputSlot();
                    int tsIndex = ts.getPosition();
                    Figure tf = ts.getFigure();
                    Figure cto = to.figureMap.get(tf.getId());
                    InputSlot cts = cto.getInputSlots().get(tsIndex);
                    c.makeCopy(cts, cs);
                }
            }
        }
    }

    public void replaceFrom(Diagram source) {
        source.render(() -> this.change(() -> this.replaceFrom0(source)));
    }

    private void replaceFrom0(Diagram source) {
        assert (this.graph == source.graph);
        ArrayList<Figure> unmapped = new ArrayList<Figure>();
        HashSet<Integer> mapped = new HashSet<Integer>();
        for (Map.Entry<Integer, Figure> entry : source.figureMap.entrySet()) {
            Figure fig = this.figureMap.get(entry.getKey());
            if (fig == null) {
                unmapped.add(entry.getValue());
                continue;
            }
            fig.replaceFrom(entry.getValue());
            mapped.add(fig.getId());
        }
        this.figureMap.keySet().retainAll(mapped);
        for (Figure um : unmapped) {
            Figure cf = um.makeCopy(this);
            this.figureMap.put(cf.getId(), cf);
        }
        Diagram.replaceConnections(source, this);
    }

    public static Diagram createEmptyDiagram(InputGraph graph) {
        return new Diagram(graph, "");
    }

    public static Diagram createEmptyDiagram(InputGraph graph, String nodeText) {
        return new Diagram(graph, nodeText == null ? "" : nodeText);
    }

    public static Diagram createDiagram(InputGraph graph, String nodeText) {
        if (graph == null) {
            return null;
        }
        Diagram d = new Diagram(graph, nodeText == null ? "" : nodeText);
        Map<Integer, Figure> figureHash = d.createFigures();
        for (InputEdge e : graph.getEdges()) {
            int from = e.getFrom();
            int to = e.getTo();
            Figure fromFigure = figureHash.get(from);
            Figure toFigure = figureHash.get(to);
            if (fromFigure == null || toFigure == null) continue;
            assert (fromFigure != null && toFigure != null);
            char fromIndex = e.getFromIndex();
            for (int i = fromFigure.getOutputSlots().size(); i <= fromIndex; ++i) {
                fromFigure.createOutputSlot();
            }
            assert (fromFigure.getOutputSlots().size() >= fromIndex + '\u0001') : "os: " + fromFigure.getOutputSlots().size() + "; fi: " + fromIndex;
            OutputSlot outputSlot = fromFigure.getOutputSlots().get(fromIndex);
            char toIndex = e.getToIndex();
            for (int i = toFigure.getInputSlots().size(); i <= toIndex; ++i) {
                toFigure.createInputSlot();
            }
            assert (toFigure.getInputSlots().size() >= toIndex + '\u0001');
            InputSlot inputSlot = toFigure.getInputSlots().get(toIndex);
            Connection c = d.createConnection(inputSlot, outputSlot, e.getDisplayLabel(), e.getType());
            if (e.getState() == InputEdge.State.NEW) {
                c.setStyle(Connection.ConnectionStyle.BOLD);
                continue;
            }
            if (e.getState() != InputEdge.State.DELETED) continue;
            c.setStyle(Connection.ConnectionStyle.DASHED);
        }
        return d;
    }

    public void removeAllFigures(Set<Figure> figuresToRemove) {
        if (!figuresToRemove.isEmpty()) {
            this.invalidateSlotMap();
        }
        for (Figure f : figuresToRemove) {
            f.setDeleted();
        }
        HashSet<Object> cleaned = new HashSet<Object>();
        for (Figure f : figuresToRemove) {
            this.freeFigure(f, cleaned);
        }
        for (Figure f : figuresToRemove) {
            this.figureMap.remove(f.getId());
        }
    }

    private Set<Integer> collectFigureIds(Figure succ) {
        HashSet<Integer> representedIds = new HashSet<Integer>();
        succ.getSource().collectIds(representedIds);
        succ.getInputSlots().forEach(is -> is.getSource().collectIds((Collection)representedIds));
        succ.getOutputSlots().forEach(is -> is.getSource().collectIds((Collection)representedIds));
        return representedIds;
    }

    private void freeFigure(Figure succ, HashSet<Object> cleaned) {
        Set<Integer> representedIds = this.sourceMap == null ? null : this.collectFigureIds(succ);
        ArrayList<InputSlot> inputSlots = new ArrayList<InputSlot>(succ.getInputSlots());
        for (InputSlot s : inputSlots) {
            succ.removeInputSlot(s, cleaned);
        }
        ArrayList<OutputSlot> outputSlots = new ArrayList<OutputSlot>(succ.getOutputSlots());
        for (OutputSlot s : outputSlots) {
            succ.removeOutputSlot(s, cleaned);
        }
        if (cleaned != null) {
            succ.clear();
        }
        assert (succ.getInputSlots().isEmpty());
        assert (succ.getOutputSlots().isEmpty());
        assert (succ.getPredecessors().isEmpty());
        assert (succ.getSuccessors().isEmpty());
        if (representedIds != null) {
            this.invalidateSlotMap();
        }
    }

    public void removeFigure(Figure succ) {
        assert (this.figureMap.containsValue(succ));
        this.freeFigure(succ, null);
        this.figureMap.remove(succ.getId());
        this.invalidateSlotMap();
    }

    public String getName() {
        return this.graph.getName();
    }

    public InputGraph getGraph() {
        return this.graph;
    }

    public Iterable<Connection> iterateConnections() {
        return new Iterable<Connection>(){

            @Override
            public Iterator<Connection> iterator() {
                return new Iterator<Connection>(){
                    final Iterator<Figure> figureMapIterator;
                    Iterator<InputSlot> inputSlotIterator;
                    Iterator<Connection> connectionIterator;
                    {
                        this.figureMapIterator = Diagram.this.figureMap.values().iterator();
                        this.inputSlotIterator = Collections.emptyIterator();
                        this.connectionIterator = Collections.emptyIterator();
                    }

                    @Override
                    public boolean hasNext() {
                        while (true) {
                            if (this.connectionIterator.hasNext()) {
                                return true;
                            }
                            if (this.inputSlotIterator.hasNext()) {
                                this.connectionIterator = this.inputSlotIterator.next().getConnections().iterator();
                                continue;
                            }
                            if (!this.figureMapIterator.hasNext()) break;
                            this.inputSlotIterator = this.figureMapIterator.next().getInputSlots().iterator();
                        }
                        return false;
                    }

                    @Override
                    public Connection next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.connectionIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Connection> action) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Set<Connection> getConnections() {
        HashSet<Connection> connections = new HashSet<Connection>();
        for (Figure f : this.figureMap.values()) {
            for (InputSlot s : f.getInputSlots()) {
                connections.addAll(s.getConnections());
            }
        }
        return connections;
    }

    public Figure getRootFigure() {
        Properties.PropertySelector selector = new Properties.PropertySelector(this.getFigures());
        Figure root = (Figure)selector.selectSingle((Properties.PropertyMatcher)new Properties.EqualityPropertyMatcher("name", (Object)"Root"));
        if (root == null) {
            root = (Figure)selector.selectSingle((Properties.PropertyMatcher)new Properties.EqualityPropertyMatcher("name", (Object)"Start"));
        }
        if (root == null) {
            List<Figure> rootFigures = this.getRootFigures();
            if (rootFigures.size() > 0) {
                root = rootFigures.get(0);
            } else if (!this.figureMap.isEmpty()) {
                root = this.figureMap.values().iterator().next();
            }
        }
        return root;
    }

    public void printStatistics() {
        System.out.println("=============================================================");
        System.out.println("Diagram statistics");
        Collection<Figure> tmpFigures = this.getFigures();
        Set<Connection> connections = this.getConnections();
        System.out.println("Number of figures: " + tmpFigures.size());
        System.out.println("Number of connections: " + connections.size());
        ArrayList<Figure> figuresSorted = new ArrayList<Figure>(tmpFigures);
        Collections.sort(figuresSorted, (a, b) -> b.getPredecessors().size() + b.getSuccessors().size() - a.getPredecessors().size() - a.getSuccessors().size());
        int COUNT = 10;
        int z = 0;
        for (Figure f : figuresSorted) {
            int sum = f.getPredecessors().size() + f.getSuccessors().size();
            System.out.println("#" + ++z + ": " + f + ", predCount=" + f.getPredecessors().size() + " succCount=" + f.getSuccessors().size());
            if (sum >= 10) continue;
            break;
        }
        System.out.println("=============================================================");
    }

    public List<Figure> getRootFigures() {
        ArrayList<Figure> rootFigures = new ArrayList<Figure>();
        for (Figure f : this.figureMap.values()) {
            if (!f.getPredecessors().isEmpty()) continue;
            rootFigures.add(f);
        }
        return rootFigures;
    }

    public Collection<Source.Provider> forSource(int id) {
        return Collections.unmodifiableCollection(this.ensureSlotMap().getOrDefault(id, Collections.emptyList()));
    }

    public Optional<Figure> getFigure(int id) {
        for (Source.Provider p : this.forSource(id)) {
            if (!(p instanceof Figure)) continue;
            return Optional.of((Figure)p);
        }
        return Optional.empty();
    }

    public Figure getFigureById(int id) {
        return this.figureMap.get(id);
    }

    public <T extends Source.Provider> Set<T> forSources(Collection ids, Class<T> clazz) {
        HashSet<Source.Provider> r = new HashSet<Source.Provider>(ids.size());
        Map<Integer, Collection<Source.Provider>> slots = this.ensureSlotMap();
        for (Object o : ids) {
            int i;
            if (clazz.isInstance(o)) {
                r.add((Source.Provider)o);
                continue;
            }
            if (o instanceof InputNode) {
                i = ((InputNode)o).getId();
            } else {
                if (!(o instanceof Integer)) continue;
                i = (Integer)o;
            }
            for (Source.Provider s : (Collection)slots.getOrDefault(i, Collections.emptyList())) {
                if (!clazz.isInstance(s)) continue;
                r.add((Source.Provider)clazz.cast(s));
            }
        }
        return r;
    }

    private Map<Integer, Collection<Source.Provider>> ensureSlotMap() {
        if (this.sourceMap != null) {
            return this.sourceMap;
        }
        HashMap<Integer, Collection<Source.Provider>> m = new HashMap<Integer, Collection<Source.Provider>>();
        this.getFigures().stream().flatMap(f -> Stream.concat(Stream.of(f), f.getSlots().stream())).forEach(s -> {
            for (InputNode in : s.getSource().getSourceNodes()) {
                m.computeIfAbsent(in.getId(), id -> new ArrayList(2)).add(s);
            }
        });
        this.sourceMap = m;
        return this.sourceMap;
    }

    void invalidateSlotMap() {
        this.sourceMap = null;
    }

    public Dimension getSize() {
        if (this.size == null) {
            return null;
        }
        return this.size.getSize();
    }

    public void setSize(Dimension size) {
        assert (this.size == null);
        this.size = size.getSize();
    }
}

