/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.GraphSelections;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeStack;
import org.graalvm.visualizer.source.SourceLocationUtils;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class SourceUtils {
    public static Collection<InputNode> findLineNodes(JTextComponent target, GraphSource src, Collection<Location> outLocs, boolean direct) {
        int line;
        FileObject fo = EditorDocumentUtils.getFileObject((Document)target.getDocument());
        Caret c = target.getCaret();
        Document doc = target.getDocument();
        if (fo == null || c == null | doc == null) {
            return null;
        }
        int caretOffset = c.getDot();
        try {
            line = LineDocumentUtils.getLineIndex((LineDocument)((LineDocument)LineDocumentUtils.asRequired((Document)doc, LineDocument.class)), (int)caretOffset) + 1;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        if (line == -1) {
            return null;
        }
        return SourceUtils.findLineNodes(fo, line, line, src, outLocs, direct);
    }

    public static Collection<InputNode> findLineNodes(FileObject fo, int lineFrom, int lineTo, GraphSource src, Collection<Location> outLocs, boolean direct) {
        GraphSource gs;
        NodeLocationContext context = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        List<Location> locs = src == null ? context.getFileLocations(fo, direct) : src.getFileLocations(fo, direct);
        Collection<Location> lineLocs = SourceLocationUtils.atLine(locs, lineFrom, lineTo);
        if (outLocs != null) {
            outLocs.addAll(lineLocs);
        }
        GraphSource graphSource = gs = src != null ? src : context.getGraphSource();
        if (gs == null || lineLocs.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<InputNode> nodes = new HashSet<InputNode>();
        for (Location l : lineLocs) {
            nodes.addAll(gs.getNodesAt(l));
        }
        if (nodes.isEmpty()) {
            HashSet<Location> parents = new HashSet<Location>();
            for (Location l : lineLocs) {
                Iterable<NodeStack> i = gs.getNodesPassingThrough(l);
                if (i == null) continue;
                Iterator<NodeStack> nsI = i.iterator();
                while (nsI.hasNext()) {
                    boolean add = true;
                    NodeStack stack = nsI.next();
                    Iterator<NodeStack.Frame> fit = stack.iterator();
                    while (fit.hasNext()) {
                        if (!parents.contains(fit.next().getLocation())) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    nodes.add(stack.getNode());
                    parents.add(stack.bottom().getLocation());
                }
            }
        }
        return nodes;
    }

    public static void resolveSelectableNodes(Collection<InputNode> nodes, DiagramViewer viewer, Consumer<Collection<InputNode>> callback, boolean all) {
        viewer.getModel().withDiagramToView(dg -> SwingUtilities.invokeLater(() -> {
            if (nodes == null) {
                callback.accept(Collections.emptySet());
                return;
            }
            if (all) {
                callback.accept(SourceUtils.findTopNodes(viewer, nodes));
            } else {
                Collection<InputNode> in = SourceUtils.selectNext(dg, viewer, nodes, false);
                if (in != null) {
                    callback.accept(in);
                }
            }
        }));
    }

    public static Collection<InputNode> findTopNodes(DiagramViewer view, Collection<InputNode> nodes) {
        ArrayList<InputNode> newSel = new ArrayList<InputNode>(nodes.size());
        for (InputNode in : nodes) {
            Set ints;
            Collection figs = view.figuresForNodes(Collections.singletonList(in));
            if (figs.size() != 1 || (ints = ((Figure)figs.iterator().next()).getSource().getSourceNodeIds()).size() != 1 || ((Integer)ints.iterator().next()).intValue() != in.getId()) continue;
            newSel.add(in);
        }
        return newSel;
    }

    public static Collection<InputNode> selectNext(Diagram dg, DiagramViewer view, Collection<InputNode> selection, boolean doNothingIfComplete) {
        HashSet curFig;
        GraphSelections gs = view.getSelections();
        Collection figs = view.figuresForNodes(selection);
        Set newSel = null;
        Collection curSel = gs.getSelectedNodes();
        Set firstSel = null;
        if (doNothingIfComplete && (curFig = new HashSet(view.figuresForNodes(curSel))).removeAll(figs)) {
            return null;
        }
        boolean useNext = false;
        for (Figure f : figs) {
            Set nn = view.nodesForFigure(f);
            if (firstSel == null) {
                firstSel = nn;
            }
            if (curSel.containsAll(nn)) {
                useNext = true;
            } else if (useNext) {
                newSel = nn;
                break;
            }
            if (!curSel.isEmpty()) continue;
            break;
        }
        if (firstSel == null) {
            return null;
        }
        if (newSel == null) {
            newSel = firstSel;
        }
        return newSel;
    }
}

