/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.InputGraphProvider;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.NodeLocationEvent;
import org.graalvm.visualizer.source.NodeLocationListener;
import org.graalvm.visualizer.source.SourceUtils;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerAdapter;
import org.graalvm.visualizer.view.api.DiagramViewerEvent;
import org.graalvm.visualizer.view.api.DiagramViewerListener;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class LocContextSynchronizer
implements PropertyChangeListener,
Runnable,
LookupListener,
NodeLocationListener {
    private final NodeLocationContext locContext;
    private final TopComponent.Registry registry;
    private Reference<TopComponent> lastGraphComponentRef = new WeakReference<Object>(null);
    private boolean inSync;
    private static final RequestProcessor EDITSYNC_RP = new RequestProcessor();
    private RequestProcessor.Task delayedSync;
    private EditorAndViewerListener evListener;

    public LocContextSynchronizer() {
        this.locContext = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        this.registry = WindowManager.getDefault().getRegistry();
        this.registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.registry));
        this.locContext.addNodeLocationListener((NodeLocationListener)WeakListeners.create(NodeLocationListener.class, (EventListener)this, (Object)this.locContext));
    }

    @Override
    public void run() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupIfLast(Reference<TopComponent> ref) {
        LocContextSynchronizer locContextSynchronizer = this;
        synchronized (locContextSynchronizer) {
            if (this.lastGraphComponentRef != ref) {
                return;
            }
        }
        this.locContext.setGraphContext(null, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String p = evt.getPropertyName();
        if ("tcClosed".equals(p)) {
            TopComponent last;
            TopComponent cl = (TopComponent)evt.getNewValue();
            if (cl == (last = this.lastGraphComponentRef.get())) {
                LocContextSynchronizer locContextSynchronizer = this;
                synchronized (locContextSynchronizer) {
                    this.lastGraphComponentRef = new WeakReference<Object>(null);
                }
                this.locContext.setGraphContext(null, Collections.emptyList());
            }
            return;
        }
        if (!"activatedNodes".equals(p)) {
            return;
        }
        if (this.inSync) {
            return;
        }
        TopComponent tc = this.registry.getActivated();
        if (tc == null || !tc.isOpened()) {
            return;
        }
        InputGraph graph = this.findGraph(tc);
        TopComponent last = this.lastGraphComponentRef.get();
        Collection<InputNode> graphNodes = this.findNodes(tc, graph);
        if (graphNodes.isEmpty()) {
            EditorCookie ck = (EditorCookie)tc.getLookup().lookup(EditorCookie.class);
            if (ck != null) {
                JEditorPane[] panes;
                DiagramViewerLocator loc = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
                if (loc != null && loc.getActiveViewer() != null && (panes = ck.getOpenedPanes()) != null) {
                    for (JEditorPane ep : panes) {
                        if (!SwingUtilities.isDescendingFrom(ep, (Component)tc)) continue;
                        this.updateContextFromEditor(ep);
                        return;
                    }
                }
            } else if (this.evListener != null) {
                this.evListener.detach();
                this.evListener = null;
            }
        } else {
            LocContextSynchronizer locContextSynchronizer = this;
            synchronized (locContextSynchronizer) {
                if (tc != last) {
                    this.lastGraphComponentRef = new R(tc);
                }
                last = tc;
            }
        }
        if (graph == null && last != null) {
            return;
        }
        this.inSync = true;
        try {
            this.locContext.setGraphContext(graph, graphNodes);
        }
        finally {
            this.inSync = false;
        }
    }

    private void updateContextFromEditor(JEditorPane pane) {
        if (!SwingUtilities.isDescendingFrom(pane, (Component)this.registry.getActivated())) {
            return;
        }
        DiagramViewerLocator locator = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        DiagramViewer viewer = locator.getActiveViewer();
        boolean immediate = false;
        if (this.evListener != null && !this.evListener.matches(viewer, pane)) {
            this.evListener.detach();
            this.evListener = null;
            this.delayedSync = null;
        }
        if (this.evListener == null) {
            if (pane == null || viewer == null) {
                return;
            }
            this.evListener = new EditorAndViewerListener(viewer, pane);
            immediate = true;
        }
        if (immediate) {
            this.evListener.run();
        } else {
            if (this.delayedSync == null) {
                this.delayedSync = EDITSYNC_RP.create((Runnable)this.evListener);
            }
            this.delayedSync.cancel();
            this.delayedSync.schedule(200);
        }
    }

    private InputGraph findGraph(TopComponent tc) {
        if (tc == null) {
            return null;
        }
        InputGraphProvider provider = (InputGraphProvider)tc.getLookup().lookup(InputGraphProvider.class);
        if (provider == null) {
            return null;
        }
        return provider.getGraph();
    }

    private Collection<InputNode> findNodes(TopComponent tc) {
        return this.findNodes(tc, this.findGraph(tc));
    }

    private Collection<InputNode> findNodes(TopComponent tc, InputGraph graph) {
        if (graph == null) {
            return Collections.emptyList();
        }
        Node[] nodes = tc.getActivatedNodes();
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<InputNode> graphNodes = new ArrayList<InputNode>(nodes.length);
        DiagramViewer vwr = (DiagramViewer)tc.getLookup().lookup(DiagramViewer.class);
        for (Node n : nodes) {
            Collection figs;
            InputNode in = (InputNode)n.getLookup().lookup(InputNode.class);
            if (in == null) continue;
            InputGraph g = (InputGraph)n.getLookup().lookup(InputGraph.class);
            if (g != null && graph != null && graph != g) {
                return Collections.emptyList();
            }
            if (vwr != null && (figs = vwr.figuresForNodes(Collections.singletonList(in))).size() != 1) continue;
            graphNodes.add(in);
        }
        return graphNodes;
    }

    public void resultChanged(LookupEvent ev) {
        TopComponent tc = this.lastGraphComponentRef.get();
        Collection<InputNode> nodes = this.findNodes(tc);
        if (!nodes.isEmpty()) {
            InputGraph graph = (InputGraph)tc.getLookup().lookup(InputGraph.class);
            this.locContext.setGraphContext(graph, nodes);
        }
    }

    @Override
    public void selectedNodeChanged(NodeLocationEvent evt) {
    }

    @Override
    public void nodesChanged(NodeLocationEvent evt) {
        if (this.inSync) {
            return;
        }
        Collection<InputNode> nodes = evt.getNodes();
        InputGraph graph = evt.getContext().getGraph();
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        DiagramViewerLocator loc = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        List vwrList = loc.find(graph);
        if (vwrList == null || vwrList.isEmpty()) {
            return;
        }
        InputNode selNode = evt.getSelectedNode();
        if (selNode != null) {
            nodes = Collections.singletonList(selNode);
        }
        ArrayList<InputNode> fNodes = new ArrayList<InputNode>(nodes);
        DiagramViewer vwr = (DiagramViewer)vwrList.iterator().next();
        SwingUtilities.invokeLater(() -> {
            Collection figs = vwr.figuresForNodes(fNodes);
            if (!figs.isEmpty()) {
                vwr.centerFigures(Collections.singletonList((Figure)figs.iterator().next()));
            }
        });
    }

    @Override
    public void locationsResolved(NodeLocationEvent evt) {
    }

    @Override
    public void selectedLocationChanged(NodeLocationEvent evt) {
    }

    class EditorAndViewerListener
    extends DiagramViewerAdapter
    implements CaretListener,
    Runnable {
        private final Reference<DiagramViewer> refViewer;
        private final DiagramViewerListener viewerL;
        private final CaretListener caretL;
        private final Reference<JEditorPane> refPane;

        public EditorAndViewerListener(DiagramViewer viewer, JEditorPane pane) {
            this.refViewer = new WeakReference<DiagramViewer>(viewer);
            this.refPane = new WeakReference<JEditorPane>(pane);
            this.caretL = (CaretListener)WeakListeners.create(CaretListener.class, (EventListener)this, (Object)pane);
            pane.addCaretListener(this.caretL);
            this.viewerL = (DiagramViewerListener)WeakListeners.create(DiagramViewerListener.class, (EventListener)this, (Object)viewer);
            viewer.addDiagramViewerListener(this.viewerL);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            LocContextSynchronizer.this.updateContextFromEditor((JEditorPane)e.getSource());
        }

        public void diagramChanged(DiagramViewerEvent ev) {
            JEditorPane pane = this.refPane.get();
            if (pane == null) {
                this.detach();
            }
            LocContextSynchronizer.this.updateContextFromEditor(pane);
        }

        void detach() {
            JEditorPane p = this.refPane.get();
            DiagramViewer v = this.refViewer.get();
            if (p != null && this.caretL != null) {
                p.removeCaretListener(this.caretL);
            }
            if (v != null && this.viewerL != null) {
                v.removeDiagramViewerListener(this.viewerL);
            }
            this.refPane.clear();
        }

        boolean matches(DiagramViewer v, JEditorPane p) {
            return this.refViewer.get() == v && this.refPane.get() == p;
        }

        @Override
        public void run() {
            ArrayList<Location> lineLocs;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
                return;
            }
            JEditorPane pane = this.refPane.get();
            if (pane == null || !SwingUtilities.isDescendingFrom(pane, (Component)LocContextSynchronizer.this.registry.getActivated())) {
                return;
            }
            DiagramViewerLocator locator = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
            DiagramViewer viewer = locator.getActiveViewer();
            DiagramViewer cached = this.refViewer.get();
            if (cached != viewer) {
                return;
            }
            InputGraph graph = viewer.getModel().getGraphToView();
            GraphSource gs = GraphSource.getGraphSource(graph);
            Collection<InputNode> nodes = SourceUtils.findLineNodes(pane, gs, lineLocs = new ArrayList<Location>(), true);
            if (nodes == null || nodes.isEmpty()) {
                nodes = new HashSet<InputNode>(SourceUtils.findLineNodes(pane, gs, lineLocs, false));
                nodes.retainAll(LocContextSynchronizer.this.locContext.getContextNodes());
            }
            SourceUtils.resolveSelectableNodes(nodes, viewer, nn -> {
                if (!nn.isEmpty()) {
                    LocContextSynchronizer.this.inSync = true;
                    LocContextSynchronizer.this.inSync = false;
                }
            }, true);
        }
    }

    class R
    extends WeakReference<TopComponent>
    implements Runnable {
        public R(TopComponent referent) {
            super(referent, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            LocContextSynchronizer.this.cleanupIfLast(this);
        }
    }
}

