/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputNode;
import org.graalvm.visualizer.data.services.GraphSelections;
import org.graalvm.visualizer.source.GraphSource;
import org.graalvm.visualizer.source.Location;
import org.graalvm.visualizer.source.NodeLocationContext;
import org.graalvm.visualizer.source.impl.editor.Bundle;
import org.graalvm.visualizer.source.impl.editor.SelectOrExtractNodesAction;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.netbeans.api.editor.document.EditorDocumentUtils;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseAction;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class TrackNodesAction
extends BaseAction
implements Presenter.Toolbar,
ContextAwareAction {
    public static final String ID = "graph-track-nodes";
    private Reference<JEditorPane> paneRef;
    private Reference<JToggleButton> toggleButtonRef;
    static final RequestProcessor DELAY_RP = new RequestProcessor(TrackNodesAction.class);
    private static final int DELAY = 500;
    private boolean trackNodes;
    private final Tracker tracker = new Tracker();

    public TrackNodesAction() {
        super(ID);
        this.putValue("ShortDescription", Bundle.SHORT_TrackNodesFromEditor());
        this.putValue("LongDescription", Bundle.HINT_TrackNodesFromEditor());
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/graalvm/visualizer/source/resources/followSource.png", (boolean)false));
    }

    JEditorPane getPane() {
        return this.paneRef != null ? this.paneRef.get() : null;
    }

    JToggleButton getToggleButton() {
        return this.toggleButtonRef != null ? this.toggleButtonRef.get() : null;
    }

    void updateState() {
        JToggleButton tog = this.getToggleButton();
        if (tog == null) {
            return;
        }
        tog.setSelected(this.trackNodes);
    }

    public Component getToolbarPresenter() {
        JToggleButton toggleButton = new JToggleButton();
        this.toggleButtonRef = new WeakReference<JToggleButton>(toggleButton);
        toggleButton.putClientProperty("hideActionText", Boolean.TRUE);
        toggleButton.setIcon((Icon)this.getValue("SmallIcon"));
        toggleButton.setAction((Action)((Object)this));
        return toggleButton;
    }

    void setPane(JEditorPane pane) {
        assert (pane != null);
        this.paneRef = new WeakReference<JEditorPane>(pane);
        Object o = pane.getClientProperty(TrackNodesAction.class);
        if (o == this) {
            return;
        }
        pane.putClientProperty(TrackNodesAction.class, (Object)this);
        pane.addCaretListener(this.tracker);
        this.updateState();
    }

    public void actionPerformed(ActionEvent ae, JTextComponent jtc) {
        this.trackNodes = !this.trackNodes;
        this.updateState();
        if (this.trackNodes) {
            this.selectNodesForCurrentLine();
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        JEditorPane pane = (JEditorPane)actionContext.lookup(JEditorPane.class);
        if (pane != null) {
            TrackNodesAction action = (TrackNodesAction)((Object)pane.getClientProperty(TrackNodesAction.class));
            if (action == null) {
                action = new TrackNodesAction();
            }
            action.setPane(pane);
            return action;
        }
        return this;
    }

    private void selectNodesForCurrentLine() {
        int lineno;
        JEditorPane pane = this.getPane();
        if (pane == null || !this.trackNodes) {
            return;
        }
        int caretDot = pane.getCaret().getDot();
        LineDocument ldoc = (LineDocument)LineDocumentUtils.as((Document)pane.getDocument(), LineDocument.class);
        if (ldoc == null) {
            return;
        }
        try {
            lineno = LineDocumentUtils.getLineIndex((LineDocument)ldoc, (int)caretDot) + 1;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        FileObject fo = EditorDocumentUtils.getFileObject((Document)ldoc);
        if (fo == null) {
            return;
        }
        NodeLocationContext ctx = (NodeLocationContext)Lookup.getDefault().lookup(NodeLocationContext.class);
        GraphSource gSource = ctx.getGraphSource();
        if (gSource == null) {
            return;
        }
        InputGraph gr = gSource.getGraph();
        DiagramViewerLocator locator = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        if (gr == null || locator == null) {
            return;
        }
        DiagramViewer active = locator.getActiveViewer();
        if (active == null || active.getModel().getGraphToView() != gr) {
            return;
        }
        List<Location> locs = gSource.getFileLocations(fo, true);
        if (locs.isEmpty()) {
            return;
        }
        HashSet<InputNode> nodes = new HashSet<InputNode>(locs.size());
        for (Location l : locs) {
            if (l.getLine() != lineno) continue;
            nodes.addAll(gSource.getNodesAt(l));
        }
        GraphSelections sel = active.getSelections();
        SelectOrExtractNodesAction.selectFirstOrNext(active.getModel().getDiagramToView(), active, nodes, false, true, newSel -> active.getSelections().setSelectedNodes(newSel));
    }

    private class Tracker
    implements CaretListener,
    Runnable {
        RequestProcessor.Task task;

        private Tracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent e) {
            Tracker tracker = this;
            synchronized (tracker) {
                if (this.task != null) {
                    this.task.cancel();
                }
                this.task = DELAY_RP.post((Runnable)this, 500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                TrackNodesAction.this.selectNodesForCurrentLine();
            } else {
                Tracker tracker = this;
                synchronized (tracker) {
                    this.task = null;
                }
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

