/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.source.impl.ui;

import java.awt.Image;
import java.util.Collections;
import org.graalvm.visualizer.source.Language;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ImageDecorator;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.lookup.Lookups;

public class LanguageNode
extends AbstractNode {
    private final Language lang;
    private Image icon;
    private FileObject iconFile;

    public LanguageNode(Language l) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{l}));
        this.lang = l;
        this.setDisplayName(this.lang.getDisplayName());
        this.setName(this.lang.getGraalID());
        if (this.lang.isHostLanguage()) {
            this.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/lang-truffle.png");
            this.iconFile = null;
        } else {
            FileObject f = FileUtil.getConfigFile((String)"IGV/Languages").getFileObject(this.lang.getGraalID());
            if (f == null) {
                this.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/lang-guest.png");
            }
            this.iconFile = f;
        }
    }

    public Image getOpenedIcon(int type) {
        if (this.icon != null) {
            return this.icon;
        }
        return super.getOpenedIcon(type);
    }

    public Image getIcon(int type) {
        if (this.icon != null) {
            return this.icon;
        }
        boolean set = false;
        if (this.iconFile != null) {
            try {
                ImageDecorator deco = (ImageDecorator)this.iconFile.getFileSystem().getDecorator();
                Image ico = deco.annotateIcon(null, type, Collections.singleton(this.iconFile));
                if (ico != null) {
                    return ico;
                }
                this.setIconBaseWithExtension("org/graalvm/visualizer/source/resources/lang-guest.png");
                this.iconFile = null;
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                set = true;
            }
        }
        Image i = super.getIcon(1);
        if (set) {
            this.icon = i;
        }
        return i;
    }
}

