/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import org.graalvm.visualizer.data.DataElementHandle;
import org.graalvm.visualizer.search.ResultItem;

public class GraphItem
implements ResultItem {
    public static final GraphItem ROOT = new GraphItem("<root>", (DataElementHandle)null);
    private final DataElementHandle handle;
    private final String type;
    private String displayName;
    private Reference<FolderElement> resolved = new WeakReference<Object>(null);

    public GraphItem(String type, DataElementHandle handle) {
        this.type = type;
        this.handle = handle;
    }

    public GraphItem(String type, FolderElement item) {
        this.type = type;
        this.handle = DataElementHandle.create((GraphDocument)item.getOwner(), (FolderElement)item);
        this.resolved = new WeakReference<FolderElement>(item);
        this.displayName = item.getName();
    }

    public CompletableFuture<FolderElement> resolve(Group.Feedback fb) {
        return this.handle.resolve(fb).thenApply(this::setData);
    }

    private FolderElement setData(FolderElement f) {
        this.resolved = new WeakReference<FolderElement>(f);
        return f;
    }

    public Properties getProperties() {
        FolderElement d = this.getData();
        if (d instanceof Properties.Provider) {
            return ((Properties.Provider)d).getProperties();
        }
        return Properties.immutableEmpty();
    }

    public DataElementHandle getHandle() {
        return this.handle;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphItem other = (GraphItem)obj;
        return Objects.equals(this.handle, other.handle);
    }

    public FolderElement getData() {
        return this.resolved.get();
    }
}

