/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.search;

import java.util.EventObject;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import org.graalvm.visualizer.search.SearchController;
import org.graalvm.visualizer.search.SearchResultsModel;
import org.graalvm.visualizer.search.SearchTask;

public final class SearchEvent
extends EventObject {
    private final SearchTask searchTask;
    private final FolderElement searchedElement;
    private final SearchResultsModel model;
    private final int traversed;
    private final int matched;
    private final boolean completed;
    private final boolean itemCompleted;
    private boolean terminate;

    public SearchEvent(SearchController source, SearchTask searchTask, FolderElement entered, SearchResultsModel model) {
        super(source);
        this.searchTask = searchTask;
        this.searchedElement = entered;
        this.model = model;
        this.matched = 0;
        this.traversed = 0;
        this.completed = false;
        this.itemCompleted = false;
    }

    public SearchEvent(SearchController source, SearchTask searchTask, FolderElement entered, SearchResultsModel model, int traversed, int matched, boolean completed, boolean completedAll) {
        super(source);
        this.searchTask = searchTask;
        this.searchedElement = entered;
        this.model = model;
        this.traversed = traversed;
        this.matched = matched;
        this.completed = completedAll;
        this.itemCompleted = completed;
    }

    public SearchEvent(SearchController source, SearchTask searchTask, SearchResultsModel model, boolean completed) {
        super(source);
        this.searchTask = searchTask;
        this.model = model;
        this.searchedElement = null;
        this.matched = 0;
        this.traversed = 0;
        this.itemCompleted = false;
        this.completed = completed;
    }

    @Override
    public SearchController getSource() {
        return (SearchController)super.getSource();
    }

    public void terminate() {
        this.terminate = true;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public SearchTask getSearchTask() {
        return this.searchTask;
    }

    public FolderElement getSearchedElement() {
        return this.searchedElement;
    }

    public SearchResultsModel getModel() {
        return this.model;
    }

    public int getTraversed() {
        return this.traversed;
    }

    public int getMatched() {
        return this.matched;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isItemCompleted() {
        return this.itemCompleted;
    }
}

