/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.filter;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import org.graalvm.visualizer.filter.AbstractFilter;
import org.graalvm.visualizer.graph.Connection;
import org.graalvm.visualizer.graph.Diagram;
import org.graalvm.visualizer.graph.Figure;
import org.graalvm.visualizer.graph.Slot;

public class EdgeColorIndexFilter
extends AbstractFilter {
    public static final String INPUTS = "INPUTS";
    public static final String OUTPUTS = "OUTPUTS";
    private final String applyTo;
    private final Color[] colors;

    public EdgeColorIndexFilter(String applyTo, Color ... color) {
        if (!applyTo.equals(INPUTS) && !applyTo.equals(OUTPUTS)) {
            throw new IllegalArgumentException("applyTo");
        }
        this.applyTo = applyTo;
        this.colors = color;
    }

    @Override
    public String getName() {
        return "Edge Color Index Filter";
    }

    @Override
    public void apply(Diagram d) {
        Collection figures = d.getFigures();
        for (Figure f : figures) {
            Slot[] slots;
            if (this.applyTo.equals(INPUTS)) {
                List inputSlots = f.getInputSlots();
                slots = inputSlots.toArray(new Slot[inputSlots.size()]);
            } else {
                List outputSlots = f.getOutputSlots();
                slots = outputSlots.toArray(new Slot[outputSlots.size()]);
            }
            int index = 0;
            for (Slot slot : slots) {
                this.checkCancelled();
                if (index < this.colors.length && this.colors[index] != null) {
                    slot.setColor(this.colors[index]);
                    for (Connection c : slot.getConnections()) {
                        c.setColor(this.colors[index]);
                    }
                }
                ++index;
            }
        }
    }
}

