/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.controlflow;

import java.awt.Point;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public class DoubleClickSelectAction
extends WidgetAction.LockedAdapter {
    private final SelectProvider provider;

    public DoubleClickSelectAction(SelectProvider provider) {
        this.provider = provider;
    }

    protected boolean isLocked() {
        return false;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (event.getClickCount() >= 2 && (event.getButton() == 1 || event.getButton() == 2)) {
            boolean invert = (event.getModifiersEx() & 0x80) != 0;
            Point point = event.getPoint();
            if (this.provider.isSelectionAllowed(widget, point, invert)) {
                this.provider.select(widget, point, invert);
                return WidgetAction.State.CHAIN_ONLY;
            }
        }
        return WidgetAction.State.REJECTED;
    }
}

