/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.layout;

import org.graalvm.visualizer.layout.Cluster;
import org.graalvm.visualizer.layout.Port;
import org.graalvm.visualizer.layout.Vertex;
import org.graalvm.visualizer.settings.TestUtils;
import org.junit.Assert;

public class LayoutTestUtil {
    public static void assertPortEquals(Port a, Port b) {
        if (TestUtils.checkNotNulls((Object)a, (Object)b)) {
            LayoutTestUtil.assertVertexEquals(a.getVertex(), b.getVertex());
            Assert.assertEquals(a.getRelativePosition(), b.getRelativePosition());
        }
    }

    public static void assertVertexEquals(Vertex a, Vertex b) {
        if (TestUtils.checkNotNulls((Object)a, (Object)b)) {
            LayoutTestUtil.assertClusterEquals(a.getCluster(), b.getCluster());
            Assert.assertEquals(a.getPosition(), b.getPosition());
            Assert.assertEquals(a.getSize(), b.getSize());
        }
    }

    public static void assertClusterEquals(Cluster a, Cluster b) {
        if (TestUtils.checkNotNulls((Object)a, (Object)b)) {
            LayoutTestUtil.assertClusterEquals(a.getOuter(), b.getOuter());
            Assert.assertEquals(a.toString(), b.toString());
        }
    }
}

