/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.netbeans.html.presenters.spi.Generic;
import org.netbeans.html.presenters.spi.Level;
import org.netbeans.html.presenters.spi.ProtoPresenter;

public final class ProtoPresenterBuilder {
    private Evaluator loadScript;
    private Executor executor;
    private Preparator onReady;
    private boolean sync;
    private boolean eval;
    private String type;
    private String app;
    private Displayer displayer;
    private Logger logger;
    private boolean implementExecutor;
    private final List<Object> data = new ArrayList<Object>();

    private ProtoPresenterBuilder() {
    }

    public static ProtoPresenterBuilder newBuilder() {
        return new ProtoPresenterBuilder();
    }

    public ProtoPresenterBuilder loadJavaScript(Evaluator loadScript, boolean synchronous) {
        this.loadScript = loadScript;
        this.sync = synchronous;
        return this;
    }

    public ProtoPresenterBuilder dispatcher(Executor executor, boolean implementExecutor) {
        this.executor = executor;
        this.implementExecutor = implementExecutor;
        return this;
    }

    public ProtoPresenterBuilder preparator(Preparator onReady, boolean evalJavaScript) {
        this.onReady = onReady;
        this.eval = evalJavaScript;
        return this;
    }

    public ProtoPresenterBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ProtoPresenterBuilder app(String app) {
        this.app = app;
        return this;
    }

    public ProtoPresenterBuilder displayer(Displayer displayer) {
        this.displayer = displayer;
        return this;
    }

    public ProtoPresenterBuilder register(Object data) {
        this.data.add(data);
        return this;
    }

    public ProtoPresenterBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public ProtoPresenter build() {
        if (this.implementExecutor) {
            return new GenPresenterWithExecutor(this);
        }
        return new GenPresenter(this);
    }

    @FunctionalInterface
    public static interface Logger {
        public void log(int var1, String var2, Object ... var3);
    }

    @FunctionalInterface
    public static interface Displayer {
        public void displayPage(URL var1, Runnable var2);
    }

    @FunctionalInterface
    public static interface Preparator {
        public void prepare(OnPrepared var1);
    }

    @FunctionalInterface
    public static interface Evaluator {
        public void eval(String var1);
    }

    private static final class GenPresenterWithExecutor
    extends GenPresenter
    implements Executor {
        GenPresenterWithExecutor(ProtoPresenterBuilder b) {
            super(b);
        }

        @Override
        public void execute(Runnable command) {
            this.dispatch(command);
        }
    }

    private static class GenPresenter
    extends Generic
    implements ProtoPresenter {
        private final Evaluator loadScript;
        private final Executor executor;
        private final Preparator onReady;
        private final Displayer displayer;
        private final Logger logger;
        private final Object[] data;

        GenPresenter(ProtoPresenterBuilder b) {
            super(b.sync, b.eval, b.type, b.app);
            this.loadScript = b.loadScript;
            this.executor = b.executor;
            this.onReady = b.onReady;
            this.displayer = b.displayer;
            this.logger = b.logger;
            this.data = b.data.toArray();
        }

        @Override
        void handleLog(Level level, String msg, Object ... args) {
            if (this.logger != null) {
                this.logger.log(level.intValue(), msg, args);
            }
        }

        @Override
        void callbackFn(OnPrepared onReady) {
            this.onReady.prepare(onReady);
        }

        @Override
        void loadJS(String js) {
            this.loadScript.eval(js);
        }

        @Override
        void dispatch(Runnable r) {
            this.executor.execute(r);
        }

        public void displayPage(URL url, Runnable r) {
            if (url == null && r == null) {
                this.init();
            } else {
                this.displayer.displayPage(url, r);
            }
        }

        @Override
        public <T> T lookup(Class<T> type) {
            for (Object o : this.data) {
                if (type != o.getClass()) continue;
                return type.cast(o);
            }
            return null;
        }
    }

    public static abstract class OnPrepared {
        OnPrepared() {
        }

        public abstract void callbackIsPrepared(String var1);
    }
}

