package com.oracle.svm.shadowed.org.bytedeco.javacpp.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.tools.Generator;

/**
 * A shorthand for {@code @Cast("std::wstring&") @Adapter("StringAdapter<wchar_t>")}.
 *
 * @see Adapter
 * @see Generator
 *
 * @author Samuel Audet
 */
@Documented @Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.PARAMETER})
@Cast({"std::basic_string", "&"}) @Adapter("StringAdapter")
public @interface StdWString {
    String value() default "wchar_t";
}