// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package com.oracle.svm.shadowed.org.bytedeco.llvm.global;

import com.oracle.svm.shadowed.org.bytedeco.llvm.LLVM.*;

import java.nio.*;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.*;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.annotation.*;

import static com.oracle.svm.shadowed.org.bytedeco.javacpp.presets.javacpp.*;

public class LLVM extends com.oracle.svm.shadowed.org.bytedeco.llvm.presets.LLVM {
    static { Loader.load(); }

// Parsed from <llvm-c/DataTypes.h>

/*===-- include/llvm-c/DataTypes.h - Define fixed size types ------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file contains definitions to figure out the size of _HOST_ data types.*|
|* This file is important because different host OS's define different macros,*|
|* which makes portability tough.  This file exports the following            *|
|* definitions:                                                               *|
|*                                                                            *|
|*   [u]int(32|64)_t : typedefs for signed and unsigned 32/64 bit system types*|
|*   [U]INT(8|16|32|64)_(MIN|MAX) : Constants for the min and max values.     *|
|*                                                                            *|
|* No library is required when using these functions.                         *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*/

/* Please leave this file C-compatible. */

// #ifndef LLVM_C_DATATYPES_H
// #define LLVM_C_DATATYPES_H

// #include <inttypes.h>
// #include <stdint.h>

// #ifndef _MSC_VER

// #if !defined(UINT32_MAX)
// # error "The standard header <cstdint> is not C++11 compliant. Must #define "
//         "__STDC_LIMIT_MACROS before #including llvm-c/DataTypes.h"
// #endif

// #if !defined(UINT32_C)
// # error "The standard header <cstdint> is not C++11 compliant. Must #define "
//         "__STDC_CONSTANT_MACROS before #including llvm-c/DataTypes.h"
// #endif

/* Note that <inttypes.h> includes <stdint.h>, if this is a C99 system. */
// #include <sys/types.h>

// #ifdef _AIX
// GCC is strict about defining large constants: they must have LL modifier.
// #undef INT64_MAX
// #undef INT64_MIN
// #endif

// #else /* _MSC_VER */
// #ifdef __cplusplus
// #include <cstddef>
// #include <cstdlib>
// #else
// #include <stddef.h>
// #include <stdlib.h>
// #endif
// #include <sys/types.h>

// #if defined(_WIN64)
// #else
// #endif /* _WIN64 */

// #endif /* _MSC_VER */

/* Set defaults for constants which we cannot find. */
// #if !defined(INT64_MAX)
public static final long INT64_MAX = 9223372036854775807L;
// #endif
// #if !defined(INT64_MIN)
public static final long INT64_MIN = ((-INT64_MAX)-1);
// #endif
// #if !defined(UINT64_MAX)
public static final long UINT64_MAX = 0xffffffffffffffffL;
// #endif

// #endif /* LLVM_C_DATATYPES_H */


// Parsed from <llvm-c/Types.h>

/*===-- llvm-c/Support.h - C Interface Types declarations ---------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file defines types used by the C interface to LLVM.                   *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TYPES_H
// #define LLVM_C_TYPES_H

// #include "llvm-c/DataTypes.h"
// #include "llvm-c/ExternC.h"

/**
 * \defgroup LLVMCSupportTypes Types and Enumerations
 *
 * \{
 */
// Targeting ../LLVM/LLVMMemoryBufferRef.java


// Targeting ../LLVM/LLVMContextRef.java


// Targeting ../LLVM/LLVMModuleRef.java


// Targeting ../LLVM/LLVMTypeRef.java


// Targeting ../LLVM/LLVMValueRef.java


// Targeting ../LLVM/LLVMBasicBlockRef.java


// Targeting ../LLVM/LLVMMetadataRef.java


// Targeting ../LLVM/LLVMNamedMDNodeRef.java


// Targeting ../LLVM/LLVMValueMetadataEntry.java


// Targeting ../LLVM/LLVMBuilderRef.java


// Targeting ../LLVM/LLVMDIBuilderRef.java


// Targeting ../LLVM/LLVMModuleProviderRef.java


// Targeting ../LLVM/LLVMPassManagerRef.java


// Targeting ../LLVM/LLVMPassRegistryRef.java


// Targeting ../LLVM/LLVMUseRef.java


// Targeting ../LLVM/LLVMAttributeRef.java


// Targeting ../LLVM/LLVMDiagnosticInfoRef.java


// Targeting ../LLVM/LLVMComdatRef.java


// Targeting ../LLVM/LLVMModuleFlagEntry.java


// Targeting ../LLVM/LLVMJITEventListenerRef.java


// Targeting ../LLVM/LLVMBinaryRef.java



/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Support.h>

/*===-- llvm-c/Support.h - Support C Interface --------------------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file defines the C interface to the LLVM support library.             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_SUPPORT_H
// #define LLVM_C_SUPPORT_H

// #include "llvm-c/DataTypes.h"
// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \addtogroup LLVMCCore
 *
 * \{
 */

/**
 * This function permanently loads the dynamic library at the given path.
 * It is safe to call this function multiple times for the same library.
 *
 * @see sys::DynamicLibrary::LoadLibraryPermanently()
  */
public static native @Cast("LLVMBool") int LLVMLoadLibraryPermanently(@Cast("const char*") BytePointer Filename);
public static native @Cast("LLVMBool") int LLVMLoadLibraryPermanently(String Filename);

/**
 * This function parses the given arguments using the LLVM command line parser.
 * Note that the only stable thing about this function is its signature; you
 * cannot rely on any particular set of command line arguments being interpreted
 * the same way across LLVM versions.
 *
 * @see llvm::cl::ParseCommandLineOptions()
 */
public static native void LLVMParseCommandLineOptions(int argc, @Cast("const char*const*") PointerPointer argv,
                                 @Cast("const char*") BytePointer Overview);
public static native void LLVMParseCommandLineOptions(int argc, @Cast("const char*const*") @ByPtrPtr BytePointer argv,
                                 @Cast("const char*") BytePointer Overview);
public static native void LLVMParseCommandLineOptions(int argc, @Cast("const char*const*") @ByPtrPtr ByteBuffer argv,
                                 String Overview);
public static native void LLVMParseCommandLineOptions(int argc, @Cast("const char*const*") @ByPtrPtr byte[] argv,
                                 @Cast("const char*") BytePointer Overview);
public static native void LLVMParseCommandLineOptions(int argc, @Cast("const char*const*") @ByPtrPtr BytePointer argv,
                                 String Overview);
public static native void LLVMParseCommandLineOptions(int argc, @Cast("const char*const*") @ByPtrPtr ByteBuffer argv,
                                 @Cast("const char*") BytePointer Overview);
public static native void LLVMParseCommandLineOptions(int argc, @Cast("const char*const*") @ByPtrPtr byte[] argv,
                                 String Overview);

/**
 * This function will search through all previously loaded dynamic
 * libraries for the symbol \p symbolName. If it is found, the address of
 * that symbol is returned. If not, null is returned.
 *
 * @see sys::DynamicLibrary::SearchForAddressOfSymbol()
 */
public static native Pointer LLVMSearchForAddressOfSymbol(@Cast("const char*") BytePointer symbolName);
public static native Pointer LLVMSearchForAddressOfSymbol(String symbolName);

/**
 * This functions permanently adds the symbol \p symbolName with the
 * value \p symbolValue.  These symbols are searched before any
 * libraries.
 *
 * @see sys::DynamicLibrary::AddSymbol()
 */
public static native void LLVMAddSymbol(@Cast("const char*") BytePointer symbolName, Pointer symbolValue);
public static native void LLVMAddSymbol(String symbolName, Pointer symbolValue);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Core.h>

/*===-- llvm-c/Core.h - Core Library C Interface ------------------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMCore.a, which implements    *|
|* the LLVM intermediate representation.                                      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_CORE_H
// #define LLVM_C_CORE_H

// #include "llvm-c/Deprecated.h"
// #include "llvm-c/ErrorHandling.h"
// #include "llvm-c/ExternC.h"

// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMC LLVM-C: C interface to LLVM
 *
 * This module exposes parts of the LLVM library as a C API.
 *
 * \{
 */

/**
 * \defgroup LLVMCTransforms Transforms
 */

/**
 * \defgroup LLVMCCore Core
 *
 * This modules provide an interface to libLLVMCore, which implements
 * the LLVM intermediate representation as well as other related types
 * and utilities.
 *
 * Many exotic languages can interoperate with C code but have a harder time
 * with C++ due to name mangling. So in addition to C, this interface enables
 * tools written in such languages.
 *
 * \{
 */

/**
 * \defgroup LLVMCCoreTypes Types and Enumerations
 *
 * \{
 */

/** External users depend on the following values being stable. It is not safe
/** to reorder them. */
/** enum LLVMOpcode */
public static final int
  /* Terminator Instructions */
  LLVMRet            = 1,
  LLVMBr             = 2,
  LLVMSwitch         = 3,
  LLVMIndirectBr     = 4,
  LLVMInvoke         = 5,
  /* removed 6 due to API changes */
  LLVMUnreachable    = 7,
  LLVMCallBr         = 67,

  /* Standard Unary Operators */
  LLVMFNeg           = 66,

  /* Standard Binary Operators */
  LLVMAdd            = 8,
  LLVMFAdd           = 9,
  LLVMSub            = 10,
  LLVMFSub           = 11,
  LLVMMul            = 12,
  LLVMFMul           = 13,
  LLVMUDiv           = 14,
  LLVMSDiv           = 15,
  LLVMFDiv           = 16,
  LLVMURem           = 17,
  LLVMSRem           = 18,
  LLVMFRem           = 19,

  /* Logical Operators */
  LLVMShl            = 20,
  LLVMLShr           = 21,
  LLVMAShr           = 22,
  LLVMAnd            = 23,
  LLVMOr             = 24,
  LLVMXor            = 25,

  /* Memory Operators */
  LLVMAlloca         = 26,
  LLVMLoad           = 27,
  LLVMStore          = 28,
  LLVMGetElementPtr  = 29,

  /* Cast Operators */
  LLVMTrunc          = 30,
  LLVMZExt           = 31,
  LLVMSExt           = 32,
  LLVMFPToUI         = 33,
  LLVMFPToSI         = 34,
  LLVMUIToFP         = 35,
  LLVMSIToFP         = 36,
  LLVMFPTrunc        = 37,
  LLVMFPExt          = 38,
  LLVMPtrToInt       = 39,
  LLVMIntToPtr       = 40,
  LLVMBitCast        = 41,
  LLVMAddrSpaceCast  = 60,

  /* Other Operators */
  LLVMICmp           = 42,
  LLVMFCmp           = 43,
  LLVMPHI            = 44,
  LLVMCall           = 45,
  LLVMSelect         = 46,
  LLVMUserOp1        = 47,
  LLVMUserOp2        = 48,
  LLVMVAArg          = 49,
  LLVMExtractElement = 50,
  LLVMInsertElement  = 51,
  LLVMShuffleVector  = 52,
  LLVMExtractValue   = 53,
  LLVMInsertValue    = 54,
  LLVMFreeze         = 68,

  /* Atomic operators */
  LLVMFence          = 55,
  LLVMAtomicCmpXchg  = 56,
  LLVMAtomicRMW      = 57,

  /* Exception Handling Operators */
  LLVMResume         = 58,
  LLVMLandingPad     = 59,
  LLVMCleanupRet     = 61,
  LLVMCatchRet       = 62,
  LLVMCatchPad       = 63,
  LLVMCleanupPad     = 64,
  LLVMCatchSwitch    = 65;

/** enum LLVMTypeKind */
public static final int
  /** type with no size */
  LLVMVoidTypeKind = 0,
  /** 16 bit floating point type */
  LLVMHalfTypeKind = 1,
  /** 32 bit floating point type */
  LLVMFloatTypeKind = 2,
  /** 64 bit floating point type */
  LLVMDoubleTypeKind = 3,
  /** 80 bit floating point type (X87) */
  LLVMX86_FP80TypeKind = 4,
  /** 128 bit floating point type (112-bit mantissa)*/
  LLVMFP128TypeKind = 5,
  /** 128 bit floating point type (two 64-bits) */
  LLVMPPC_FP128TypeKind = 6,
  /** Labels */
  LLVMLabelTypeKind = 7,
  /** Arbitrary bit width integers */
  LLVMIntegerTypeKind = 8,
  /** Functions */
  LLVMFunctionTypeKind = 9,
  /** Structures */
  LLVMStructTypeKind = 10,
  /** Arrays */
  LLVMArrayTypeKind = 11,
  /** Pointers */
  LLVMPointerTypeKind = 12,
  /** Fixed width SIMD vector type */
  LLVMVectorTypeKind = 13,
  /** Metadata */
  LLVMMetadataTypeKind = 14,
  /** X86 MMX */
  LLVMX86_MMXTypeKind = 15,
  /** Tokens */
  LLVMTokenTypeKind = 16,
  /** Scalable SIMD vector type */
  LLVMScalableVectorTypeKind = 17,
  /** 16 bit brain floating point type */
  LLVMBFloatTypeKind = 18,
  /** X86 AMX */
  LLVMX86_AMXTypeKind = 19;

/** enum LLVMLinkage */
public static final int
  /** Externally visible function */
  LLVMExternalLinkage = 0,
  LLVMAvailableExternallyLinkage = 1,
  /** Keep one copy of function when linking (inline)*/
  LLVMLinkOnceAnyLinkage = 2,
  /** Same, but only replaced by something
                            equivalent. */
  LLVMLinkOnceODRLinkage = 3,
  /** Obsolete */
  LLVMLinkOnceODRAutoHideLinkage = 4,
  /** Keep one copy of function when linking (weak) */
  LLVMWeakAnyLinkage = 5,
  /** Same, but only replaced by something
                            equivalent. */
  LLVMWeakODRLinkage = 6,
  /** Special purpose, only applies to global arrays */
  LLVMAppendingLinkage = 7,
  /** Rename collisions when linking (static
                               functions) */
  LLVMInternalLinkage = 8,
  /** Like Internal, but omit from symbol table */
  LLVMPrivateLinkage = 9,
  /** Obsolete */
  LLVMDLLImportLinkage = 10,
  /** Obsolete */
  LLVMDLLExportLinkage = 11,
  /** ExternalWeak linkage description */
  LLVMExternalWeakLinkage = 12,
  /** Obsolete */
  LLVMGhostLinkage = 13,
  /** Tentative definitions */
  LLVMCommonLinkage = 14,
  /** Like Private, but linker removes. */
  LLVMLinkerPrivateLinkage = 15,
  /** Like LinkerPrivate, but is weak. */
  LLVMLinkerPrivateWeakLinkage = 16;

/** enum LLVMVisibility */
public static final int
  /** The GV is visible */
  LLVMDefaultVisibility = 0,
  /** The GV is hidden */
  LLVMHiddenVisibility = 1,
  /** The GV is protected */
  LLVMProtectedVisibility = 2;

/** enum LLVMUnnamedAddr */
public static final int
  /** Address of the GV is significant. */
  LLVMNoUnnamedAddr = 0,
  /** Address of the GV is locally insignificant. */
  LLVMLocalUnnamedAddr = 1,
  /** Address of the GV is globally insignificant. */
  LLVMGlobalUnnamedAddr = 2;

/** enum LLVMDLLStorageClass */
public static final int
  LLVMDefaultStorageClass   = 0,
  /** Function to be imported from DLL. */
  LLVMDLLImportStorageClass = 1,
  /** Function to be accessible from DLL. */
  LLVMDLLExportStorageClass = 2;

/** enum LLVMCallConv */
public static final int
  LLVMCCallConv             = 0,
  LLVMFastCallConv          = 8,
  LLVMColdCallConv          = 9,
  LLVMGHCCallConv           = 10,
  LLVMHiPECallConv          = 11,
  LLVMWebKitJSCallConv      = 12,
  LLVMAnyRegCallConv        = 13,
  LLVMPreserveMostCallConv  = 14,
  LLVMPreserveAllCallConv   = 15,
  LLVMSwiftCallConv         = 16,
  LLVMCXXFASTTLSCallConv    = 17,
  LLVMX86StdcallCallConv    = 64,
  LLVMX86FastcallCallConv   = 65,
  LLVMARMAPCSCallConv       = 66,
  LLVMARMAAPCSCallConv      = 67,
  LLVMARMAAPCSVFPCallConv   = 68,
  LLVMMSP430INTRCallConv    = 69,
  LLVMX86ThisCallCallConv   = 70,
  LLVMPTXKernelCallConv     = 71,
  LLVMPTXDeviceCallConv     = 72,
  LLVMSPIRFUNCCallConv      = 75,
  LLVMSPIRKERNELCallConv    = 76,
  LLVMIntelOCLBICallConv    = 77,
  LLVMX8664SysVCallConv     = 78,
  LLVMWin64CallConv         = 79,
  LLVMX86VectorCallCallConv = 80,
  LLVMHHVMCallConv          = 81,
  LLVMHHVMCCallConv         = 82,
  LLVMX86INTRCallConv       = 83,
  LLVMAVRINTRCallConv       = 84,
  LLVMAVRSIGNALCallConv     = 85,
  LLVMAVRBUILTINCallConv    = 86,
  LLVMAMDGPUVSCallConv      = 87,
  LLVMAMDGPUGSCallConv      = 88,
  LLVMAMDGPUPSCallConv      = 89,
  LLVMAMDGPUCSCallConv      = 90,
  LLVMAMDGPUKERNELCallConv  = 91,
  LLVMX86RegCallCallConv    = 92,
  LLVMAMDGPUHSCallConv      = 93,
  LLVMMSP430BUILTINCallConv = 94,
  LLVMAMDGPULSCallConv      = 95,
  LLVMAMDGPUESCallConv      = 96;

/** enum LLVMValueKind */
public static final int
  LLVMArgumentValueKind = 0,
  LLVMBasicBlockValueKind = 1,
  LLVMMemoryUseValueKind = 2,
  LLVMMemoryDefValueKind = 3,
  LLVMMemoryPhiValueKind = 4,

  LLVMFunctionValueKind = 5,
  LLVMGlobalAliasValueKind = 6,
  LLVMGlobalIFuncValueKind = 7,
  LLVMGlobalVariableValueKind = 8,
  LLVMBlockAddressValueKind = 9,
  LLVMConstantExprValueKind = 10,
  LLVMConstantArrayValueKind = 11,
  LLVMConstantStructValueKind = 12,
  LLVMConstantVectorValueKind = 13,

  LLVMUndefValueValueKind = 14,
  LLVMConstantAggregateZeroValueKind = 15,
  LLVMConstantDataArrayValueKind = 16,
  LLVMConstantDataVectorValueKind = 17,
  LLVMConstantIntValueKind = 18,
  LLVMConstantFPValueKind = 19,
  LLVMConstantPointerNullValueKind = 20,
  LLVMConstantTokenNoneValueKind = 21,

  LLVMMetadataAsValueValueKind = 22,
  LLVMInlineAsmValueKind = 23,

  LLVMInstructionValueKind = 24,
  LLVMPoisonValueValueKind = 25;

/** enum LLVMIntPredicate */
public static final int
  /** equal */
  LLVMIntEQ = 32,
  /** not equal */
  LLVMIntNE = 33,
  /** unsigned greater than */
  LLVMIntUGT = 34,
  /** unsigned greater or equal */
  LLVMIntUGE = 35,
  /** unsigned less than */
  LLVMIntULT = 36,
  /** unsigned less or equal */
  LLVMIntULE = 37,
  /** signed greater than */
  LLVMIntSGT = 38,
  /** signed greater or equal */
  LLVMIntSGE = 39,
  /** signed less than */
  LLVMIntSLT = 40,
  /** signed less or equal */
  LLVMIntSLE = 41;

/** enum LLVMRealPredicate */
public static final int
  /** Always false (always folded) */
  LLVMRealPredicateFalse = 0,
  /** True if ordered and equal */
  LLVMRealOEQ = 1,
  /** True if ordered and greater than */
  LLVMRealOGT = 2,
  /** True if ordered and greater than or equal */
  LLVMRealOGE = 3,
  /** True if ordered and less than */
  LLVMRealOLT = 4,
  /** True if ordered and less than or equal */
  LLVMRealOLE = 5,
  /** True if ordered and operands are unequal */
  LLVMRealONE = 6,
  /** True if ordered (no nans) */
  LLVMRealORD = 7,
  /** True if unordered: isnan(X) | isnan(Y) */
  LLVMRealUNO = 8,
  /** True if unordered or equal */
  LLVMRealUEQ = 9,
  /** True if unordered or greater than */
  LLVMRealUGT = 10,
  /** True if unordered, greater than, or equal */
  LLVMRealUGE = 11,
  /** True if unordered or less than */
  LLVMRealULT = 12,
  /** True if unordered, less than, or equal */
  LLVMRealULE = 13,
  /** True if unordered or not equal */
  LLVMRealUNE = 14,
  /** Always true (always folded) */
  LLVMRealPredicateTrue = 15;

/** enum LLVMLandingPadClauseTy */
public static final int
  /** A catch clause   */
  LLVMLandingPadCatch = 0,
  /** A filter clause  */
  LLVMLandingPadFilter = 1;

/** enum LLVMThreadLocalMode */
public static final int
  LLVMNotThreadLocal = 0,
  LLVMGeneralDynamicTLSModel = 1,
  LLVMLocalDynamicTLSModel = 2,
  LLVMInitialExecTLSModel = 3,
  LLVMLocalExecTLSModel = 4;

/** enum LLVMAtomicOrdering */
public static final int
  /** A load or store which is not atomic */
  LLVMAtomicOrderingNotAtomic = 0,
  /** Lowest level of atomicity, guarantees
                                     somewhat sane results, lock free. */
  LLVMAtomicOrderingUnordered = 1,
  /** guarantees that if you take all the
                                     operations affecting a specific address,
                                     a consistent ordering exists */
  LLVMAtomicOrderingMonotonic = 2,
  /** Acquire provides a barrier of the sort
                                   necessary to acquire a lock to access other
                                   memory with normal loads and stores. */
  LLVMAtomicOrderingAcquire = 4,
  /** Release is similar to Acquire, but with
                                   a barrier of the sort necessary to release
                                   a lock. */
  LLVMAtomicOrderingRelease = 5,
  /** provides both an Acquire and a
                                          Release barrier (for fences and
                                          operations which both read and write
                                           memory). */
  LLVMAtomicOrderingAcquireRelease = 6,
  /** provides Acquire semantics
                                                 for loads and Release
                                                 semantics for stores.
                                                 Additionally, it guarantees
                                                 that a total ordering exists
                                                 between all
                                                 SequentiallyConsistent
                                                 operations. */
  LLVMAtomicOrderingSequentiallyConsistent = 7;

/** enum LLVMAtomicRMWBinOp */
public static final int
    /** Set the new value and return the one old */
    LLVMAtomicRMWBinOpXchg = 0,
    /** Add a value and return the old one */
    LLVMAtomicRMWBinOpAdd = 1,
    /** Subtract a value and return the old one */
    LLVMAtomicRMWBinOpSub = 2,
    /** And a value and return the old one */
    LLVMAtomicRMWBinOpAnd = 3,
    /** Not-And a value and return the old one */
    LLVMAtomicRMWBinOpNand = 4,
    /** OR a value and return the old one */
    LLVMAtomicRMWBinOpOr = 5,
    /** Xor a value and return the old one */
    LLVMAtomicRMWBinOpXor = 6,
    /** Sets the value if it's greater than the
                             original using a signed comparison and return
                             the old one */
    LLVMAtomicRMWBinOpMax = 7,
    /** Sets the value if it's Smaller than the
                             original using a signed comparison and return
                             the old one */
    LLVMAtomicRMWBinOpMin = 8,
    /** Sets the value if it's greater than the
                             original using an unsigned comparison and return
                             the old one */
    LLVMAtomicRMWBinOpUMax = 9,
    /** Sets the value if it's greater than the
                              original using an unsigned comparison and return
                              the old one */
    LLVMAtomicRMWBinOpUMin = 10,
    /** Add a floating point value and return the
                              old one */
    LLVMAtomicRMWBinOpFAdd = 11,
    /** Subtract a floating point value and return the
                            old one */
    LLVMAtomicRMWBinOpFSub = 12,
    /** Sets the value if it's greater than the
                             original using an floating point comparison and
                             return the old one */
    LLVMAtomicRMWBinOpFMax = 13,
    /** Sets the value if it's smaller than the
                             original using an floating point comparison and
                             return the old one */
    LLVMAtomicRMWBinOpFMin = 14;

/** enum LLVMDiagnosticSeverity */
public static final int
    LLVMDSError = 0,
    LLVMDSWarning = 1,
    LLVMDSRemark = 2,
    LLVMDSNote = 3;

/** enum LLVMInlineAsmDialect */
public static final int
  LLVMInlineAsmDialectATT = 0,
  LLVMInlineAsmDialectIntel = 1;

/** enum LLVMModuleFlagBehavior */
public static final int
  /**
   * Emits an error if two values disagree, otherwise the resulting value is
   * that of the operands.
   *
   * @see Module::ModFlagBehavior::Error
   */
  LLVMModuleFlagBehaviorError = 0,
  /**
   * Emits a warning if two values disagree. The result value will be the
   * operand for the flag from the first module being linked.
   *
   * @see Module::ModFlagBehavior::Warning
   */
  LLVMModuleFlagBehaviorWarning = 1,
  /**
   * Adds a requirement that another module flag be present and have a
   * specified value after linking is performed. The value must be a metadata
   * pair, where the first element of the pair is the ID of the module flag
   * to be restricted, and the second element of the pair is the value the
   * module flag should be restricted to. This behavior can be used to
   * restrict the allowable results (via triggering of an error) of linking
   * IDs with the **Override** behavior.
   *
   * @see Module::ModFlagBehavior::Require
   */
  LLVMModuleFlagBehaviorRequire = 2,
  /**
   * Uses the specified value, regardless of the behavior or value of the
   * other module. If both modules specify **Override**, but the values
   * differ, an error will be emitted.
   *
   * @see Module::ModFlagBehavior::Override
   */
  LLVMModuleFlagBehaviorOverride = 3,
  /**
   * Appends the two values, which are required to be metadata nodes.
   *
   * @see Module::ModFlagBehavior::Append
   */
  LLVMModuleFlagBehaviorAppend = 4,
  /**
   * Appends the two values, which are required to be metadata
   * nodes. However, duplicate entries in the second list are dropped
   * during the append operation.
   *
   * @see Module::ModFlagBehavior::AppendUnique
   */
  LLVMModuleFlagBehaviorAppendUnique = 5;

/**
 * Attribute index are either LLVMAttributeReturnIndex,
 * LLVMAttributeFunctionIndex or a parameter number from 1 to N.
 */
/** enum  */
public static final int
  LLVMAttributeReturnIndex = 0,
  // ISO C restricts enumerator values to range of 'int'
  // (4294967295 is too large)
  // LLVMAttributeFunctionIndex = ~0U,
  LLVMAttributeFunctionIndex = -1;

/**
 * \}
 */

public static native void LLVMInitializeCore(LLVMPassRegistryRef R);

/** Deallocate and destroy all ManagedStatic variables.
    @see llvm::llvm_shutdown
    @see ManagedStatic */
public static native void LLVMShutdown();

/*===-- Error handling ----------------------------------------------------===*/

public static native @Cast("char*") BytePointer LLVMCreateMessage(@Cast("const char*") BytePointer Message);
public static native @Cast("char*") ByteBuffer LLVMCreateMessage(String Message);
public static native void LLVMDisposeMessage(@Cast("char*") BytePointer Message);
public static native void LLVMDisposeMessage(@Cast("char*") ByteBuffer Message);
public static native void LLVMDisposeMessage(@Cast("char*") byte[] Message);
// Targeting ../LLVM/LLVMDiagnosticHandler.java


// Targeting ../LLVM/LLVMYieldCallback.java



/**
 * Create a new context.
 *
 * Every call to this function should be paired with a call to
 * LLVMContextDispose() or the context will leak memory.
 */
public static native LLVMContextRef LLVMContextCreate();

/**
 * Obtain the global context instance.
 */
public static native LLVMContextRef LLVMGetGlobalContext();

/**
 * Set the diagnostic handler for this context.
 */
public static native void LLVMContextSetDiagnosticHandler(LLVMContextRef C,
                                     LLVMDiagnosticHandler Handler,
                                     Pointer DiagnosticContext);

/**
 * Get the diagnostic handler of this context.
 */
public static native LLVMDiagnosticHandler LLVMContextGetDiagnosticHandler(LLVMContextRef C);

/**
 * Get the diagnostic context of this context.
 */
public static native Pointer LLVMContextGetDiagnosticContext(LLVMContextRef C);

/**
 * Set the yield callback function for this context.
 *
 * @see LLVMContext::setYieldCallback()
 */
public static native void LLVMContextSetYieldCallback(LLVMContextRef C, LLVMYieldCallback Callback,
                                 Pointer OpaqueHandle);

/**
 * Retrieve whether the given context is set to discard all value names.
 *
 * @see LLVMContext::shouldDiscardValueNames()
 */
public static native @Cast("LLVMBool") int LLVMContextShouldDiscardValueNames(LLVMContextRef C);

/**
 * Set whether the given context discards all value names.
 *
 * If true, only the names of GlobalValue objects will be available in the IR.
 * This can be used to save memory and runtime, especially in release mode.
 *
 * @see LLVMContext::setDiscardValueNames()
 */
public static native void LLVMContextSetDiscardValueNames(LLVMContextRef C, @Cast("LLVMBool") int Discard);

/**
 * Set whether the given context is in opaque pointer mode.
 *
 * @see LLVMContext::setOpaquePointers()
 */
public static native void LLVMContextSetOpaquePointers(LLVMContextRef C, @Cast("LLVMBool") int OpaquePointers);

/**
 * Destroy a context instance.
 *
 * This should be called for every call to LLVMContextCreate() or memory
 * will be leaked.
 */
public static native void LLVMContextDispose(LLVMContextRef C);

/**
 * Return a string representation of the DiagnosticInfo. Use
 * LLVMDisposeMessage to free the string.
 *
 * @see DiagnosticInfo::print()
 */
public static native @Cast("char*") BytePointer LLVMGetDiagInfoDescription(LLVMDiagnosticInfoRef DI);

/**
 * Return an enum LLVMDiagnosticSeverity.
 *
 * @see DiagnosticInfo::getSeverity()
 */
public static native @Cast("LLVMDiagnosticSeverity") int LLVMGetDiagInfoSeverity(LLVMDiagnosticInfoRef DI);

public static native @Cast("unsigned") int LLVMGetMDKindIDInContext(LLVMContextRef C, @Cast("const char*") BytePointer Name,
                                  @Cast("unsigned") int SLen);
public static native @Cast("unsigned") int LLVMGetMDKindIDInContext(LLVMContextRef C, String Name,
                                  @Cast("unsigned") int SLen);
public static native @Cast("unsigned") int LLVMGetMDKindID(@Cast("const char*") BytePointer Name, @Cast("unsigned") int SLen);
public static native @Cast("unsigned") int LLVMGetMDKindID(String Name, @Cast("unsigned") int SLen);

/**
 * Return an unique id given the name of a enum attribute,
 * or 0 if no attribute by that name exists.
 *
 * See http://llvm.org/docs/LangRef.html#parameter-attributes
 * and http://llvm.org/docs/LangRef.html#function-attributes
 * for the list of available attributes.
 *
 * NB: Attribute names and/or id are subject to change without
 * going through the C API deprecation cycle.
 */
public static native @Cast("unsigned") int LLVMGetEnumAttributeKindForName(@Cast("const char*") BytePointer Name, @Cast("size_t") long SLen);
public static native @Cast("unsigned") int LLVMGetEnumAttributeKindForName(String Name, @Cast("size_t") long SLen);
public static native @Cast("unsigned") int LLVMGetLastEnumAttributeKind();

/**
 * Create an enum attribute.
 */
public static native LLVMAttributeRef LLVMCreateEnumAttribute(LLVMContextRef C, @Cast("unsigned") int KindID,
                                         @Cast("uint64_t") long Val);

/**
 * Get the unique id corresponding to the enum attribute
 * passed as argument.
 */
public static native @Cast("unsigned") int LLVMGetEnumAttributeKind(LLVMAttributeRef A);

/**
 * Get the enum attribute's value. 0 is returned if none exists.
 */
public static native @Cast("uint64_t") long LLVMGetEnumAttributeValue(LLVMAttributeRef A);

/**
 * Create a type attribute
 */
public static native LLVMAttributeRef LLVMCreateTypeAttribute(LLVMContextRef C, @Cast("unsigned") int KindID,
                                         LLVMTypeRef type_ref);

/**
 * Get the type attribute's value.
 */
public static native LLVMTypeRef LLVMGetTypeAttributeValue(LLVMAttributeRef A);

/**
 * Create a string attribute.
 */
public static native LLVMAttributeRef LLVMCreateStringAttribute(LLVMContextRef C,
                                           @Cast("const char*") BytePointer K, @Cast("unsigned") int KLength,
                                           @Cast("const char*") BytePointer V, @Cast("unsigned") int VLength);
public static native LLVMAttributeRef LLVMCreateStringAttribute(LLVMContextRef C,
                                           String K, @Cast("unsigned") int KLength,
                                           String V, @Cast("unsigned") int VLength);

/**
 * Get the string attribute's kind.
 */
public static native @Cast("const char*") BytePointer LLVMGetStringAttributeKind(LLVMAttributeRef A, @Cast("unsigned*") IntPointer Length);
public static native String LLVMGetStringAttributeKind(LLVMAttributeRef A, @Cast("unsigned*") IntBuffer Length);
public static native @Cast("const char*") BytePointer LLVMGetStringAttributeKind(LLVMAttributeRef A, @Cast("unsigned*") int[] Length);

/**
 * Get the string attribute's value.
 */
public static native @Cast("const char*") BytePointer LLVMGetStringAttributeValue(LLVMAttributeRef A, @Cast("unsigned*") IntPointer Length);
public static native String LLVMGetStringAttributeValue(LLVMAttributeRef A, @Cast("unsigned*") IntBuffer Length);
public static native @Cast("const char*") BytePointer LLVMGetStringAttributeValue(LLVMAttributeRef A, @Cast("unsigned*") int[] Length);

/**
 * Check for the different types of attributes.
 */
public static native @Cast("LLVMBool") int LLVMIsEnumAttribute(LLVMAttributeRef A);
public static native @Cast("LLVMBool") int LLVMIsStringAttribute(LLVMAttributeRef A);
public static native @Cast("LLVMBool") int LLVMIsTypeAttribute(LLVMAttributeRef A);

/**
 * Obtain a Type from a context by its registered name.
 */
public static native LLVMTypeRef LLVMGetTypeByName2(LLVMContextRef C, @Cast("const char*") BytePointer Name);
public static native LLVMTypeRef LLVMGetTypeByName2(LLVMContextRef C, String Name);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreModule Modules
 *
 * Modules represent the top-level structure in an LLVM program. An LLVM
 * module is effectively a translation unit or a collection of
 * translation units merged together.
 *
 * \{
 */

/**
 * Create a new, empty module in the global context.
 *
 * This is equivalent to calling LLVMModuleCreateWithNameInContext with
 * LLVMGetGlobalContext() as the context parameter.
 *
 * Every invocation should be paired with LLVMDisposeModule() or memory
 * will be leaked.
 */
public static native LLVMModuleRef LLVMModuleCreateWithName(@Cast("const char*") BytePointer ModuleID);
public static native LLVMModuleRef LLVMModuleCreateWithName(String ModuleID);

/**
 * Create a new, empty module in a specific context.
 *
 * Every invocation should be paired with LLVMDisposeModule() or memory
 * will be leaked.
 */
public static native LLVMModuleRef LLVMModuleCreateWithNameInContext(@Cast("const char*") BytePointer ModuleID,
                                                LLVMContextRef C);
public static native LLVMModuleRef LLVMModuleCreateWithNameInContext(String ModuleID,
                                                LLVMContextRef C);
/**
 * Return an exact copy of the specified module.
 */
public static native LLVMModuleRef LLVMCloneModule(LLVMModuleRef M);

/**
 * Destroy a module instance.
 *
 * This must be called for every created module or memory will be
 * leaked.
 */
public static native void LLVMDisposeModule(LLVMModuleRef M);

/**
 * Obtain the identifier of a module.
 *
 * @param M Module to obtain identifier of
 * @param Len Out parameter which holds the length of the returned string.
 * @return The identifier of M.
 * @see Module::getModuleIdentifier()
 */
public static native @Cast("const char*") BytePointer LLVMGetModuleIdentifier(LLVMModuleRef M, @Cast("size_t*") SizeTPointer Len);

/**
 * Set the identifier of a module to a string Ident with length Len.
 *
 * @param M The module to set identifier
 * @param Ident The string to set M's identifier to
 * @param Len Length of Ident
 * @see Module::setModuleIdentifier()
 */
public static native void LLVMSetModuleIdentifier(LLVMModuleRef M, @Cast("const char*") BytePointer Ident, @Cast("size_t") long Len);
public static native void LLVMSetModuleIdentifier(LLVMModuleRef M, String Ident, @Cast("size_t") long Len);

/**
 * Obtain the module's original source file name.
 *
 * @param M Module to obtain the name of
 * @param Len Out parameter which holds the length of the returned string
 * @return The original source file name of M
 * @see Module::getSourceFileName()
 */
public static native @Cast("const char*") BytePointer LLVMGetSourceFileName(LLVMModuleRef M, @Cast("size_t*") SizeTPointer Len);

/**
 * Set the original source file name of a module to a string Name with length
 * Len.
 *
 * @param M The module to set the source file name of
 * @param Name The string to set M's source file name to
 * @param Len Length of Name
 * @see Module::setSourceFileName()
 */
public static native void LLVMSetSourceFileName(LLVMModuleRef M, @Cast("const char*") BytePointer Name, @Cast("size_t") long Len);
public static native void LLVMSetSourceFileName(LLVMModuleRef M, String Name, @Cast("size_t") long Len);

/**
 * Obtain the data layout for a module.
 *
 * @see Module::getDataLayoutStr()
 *
 * LLVMGetDataLayout is DEPRECATED, as the name is not only incorrect,
 * but match the name of another method on the module. Prefer the use
 * of LLVMGetDataLayoutStr, which is not ambiguous.
 */
public static native @Cast("const char*") BytePointer LLVMGetDataLayoutStr(LLVMModuleRef M);
public static native @Cast("const char*") BytePointer LLVMGetDataLayout(LLVMModuleRef M);

/**
 * Set the data layout for a module.
 *
 * @see Module::setDataLayout()
 */
public static native void LLVMSetDataLayout(LLVMModuleRef M, @Cast("const char*") BytePointer DataLayoutStr);
public static native void LLVMSetDataLayout(LLVMModuleRef M, String DataLayoutStr);

/**
 * Obtain the target triple for a module.
 *
 * @see Module::getTargetTriple()
 */
public static native @Cast("const char*") BytePointer LLVMGetTarget(LLVMModuleRef M);

/**
 * Set the target triple for a module.
 *
 * @see Module::setTargetTriple()
 */
public static native void LLVMSetTarget(LLVMModuleRef M, @Cast("const char*") BytePointer Triple);
public static native void LLVMSetTarget(LLVMModuleRef M, String Triple);

/**
 * Returns the module flags as an array of flag-key-value triples.  The caller
 * is responsible for freeing this array by calling
 * \c LLVMDisposeModuleFlagsMetadata.
 *
 * @see Module::getModuleFlagsMetadata()
 */
public static native LLVMModuleFlagEntry LLVMCopyModuleFlagsMetadata(LLVMModuleRef M, @Cast("size_t*") SizeTPointer Len);

/**
 * Destroys module flags metadata entries.
 */
public static native void LLVMDisposeModuleFlagsMetadata(LLVMModuleFlagEntry Entries);

/**
 * Returns the flag behavior for a module flag entry at a specific index.
 *
 * @see Module::ModuleFlagEntry::Behavior
 */
public static native @Cast("LLVMModuleFlagBehavior") int LLVMModuleFlagEntriesGetFlagBehavior(LLVMModuleFlagEntry Entries,
                                     @Cast("unsigned") int Index);

/**
 * Returns the key for a module flag entry at a specific index.
 *
 * @see Module::ModuleFlagEntry::Key
 */
public static native @Cast("const char*") BytePointer LLVMModuleFlagEntriesGetKey(LLVMModuleFlagEntry Entries,
                                        @Cast("unsigned") int Index, @Cast("size_t*") SizeTPointer Len);

/**
 * Returns the metadata for a module flag entry at a specific index.
 *
 * @see Module::ModuleFlagEntry::Val
 */
public static native LLVMMetadataRef LLVMModuleFlagEntriesGetMetadata(LLVMModuleFlagEntry Entries,
                                                 @Cast("unsigned") int Index);

/**
 * Add a module-level flag to the module-level flags metadata if it doesn't
 * already exist.
 *
 * @see Module::getModuleFlag()
 */
public static native LLVMMetadataRef LLVMGetModuleFlag(LLVMModuleRef M,
                                  @Cast("const char*") BytePointer Key, @Cast("size_t") long KeyLen);
public static native LLVMMetadataRef LLVMGetModuleFlag(LLVMModuleRef M,
                                  String Key, @Cast("size_t") long KeyLen);

/**
 * Add a module-level flag to the module-level flags metadata if it doesn't
 * already exist.
 *
 * @see Module::addModuleFlag()
 */
public static native void LLVMAddModuleFlag(LLVMModuleRef M, @Cast("LLVMModuleFlagBehavior") int Behavior,
                       @Cast("const char*") BytePointer Key, @Cast("size_t") long KeyLen,
                       LLVMMetadataRef Val);
public static native void LLVMAddModuleFlag(LLVMModuleRef M, @Cast("LLVMModuleFlagBehavior") int Behavior,
                       String Key, @Cast("size_t") long KeyLen,
                       LLVMMetadataRef Val);

/**
 * Dump a representation of a module to stderr.
 *
 * @see Module::dump()
 */
public static native void LLVMDumpModule(LLVMModuleRef M);

/**
 * Print a representation of a module to a file. The ErrorMessage needs to be
 * disposed with LLVMDisposeMessage. Returns 0 on success, 1 otherwise.
 *
 * @see Module::print()
 */
public static native @Cast("LLVMBool") int LLVMPrintModuleToFile(LLVMModuleRef M, @Cast("const char*") BytePointer Filename,
                               @Cast("char**") PointerPointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMPrintModuleToFile(LLVMModuleRef M, @Cast("const char*") BytePointer Filename,
                               @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMPrintModuleToFile(LLVMModuleRef M, String Filename,
                               @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMPrintModuleToFile(LLVMModuleRef M, @Cast("const char*") BytePointer Filename,
                               @Cast("char**") @ByPtrPtr byte[] ErrorMessage);
public static native @Cast("LLVMBool") int LLVMPrintModuleToFile(LLVMModuleRef M, String Filename,
                               @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMPrintModuleToFile(LLVMModuleRef M, @Cast("const char*") BytePointer Filename,
                               @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMPrintModuleToFile(LLVMModuleRef M, String Filename,
                               @Cast("char**") @ByPtrPtr byte[] ErrorMessage);

/**
 * Return a string representation of the module. Use
 * LLVMDisposeMessage to free the string.
 *
 * @see Module::print()
 */
public static native @Cast("char*") BytePointer LLVMPrintModuleToString(LLVMModuleRef M);

/**
 * Get inline assembly for a module.
 *
 * @see Module::getModuleInlineAsm()
 */
public static native @Cast("const char*") BytePointer LLVMGetModuleInlineAsm(LLVMModuleRef M, @Cast("size_t*") SizeTPointer Len);

/**
 * Set inline assembly for a module.
 *
 * @see Module::setModuleInlineAsm()
 */
public static native void LLVMSetModuleInlineAsm2(LLVMModuleRef M, @Cast("const char*") BytePointer Asm, @Cast("size_t") long Len);
public static native void LLVMSetModuleInlineAsm2(LLVMModuleRef M, String Asm, @Cast("size_t") long Len);

/**
 * Append inline assembly to a module.
 *
 * @see Module::appendModuleInlineAsm()
 */
public static native void LLVMAppendModuleInlineAsm(LLVMModuleRef M, @Cast("const char*") BytePointer Asm, @Cast("size_t") long Len);
public static native void LLVMAppendModuleInlineAsm(LLVMModuleRef M, String Asm, @Cast("size_t") long Len);

/**
 * Create the specified uniqued inline asm string.
 *
 * @see InlineAsm::get()
 */
public static native LLVMValueRef LLVMGetInlineAsm(LLVMTypeRef Ty, @Cast("char*") BytePointer AsmString,
                              @Cast("size_t") long AsmStringSize, @Cast("char*") BytePointer Constraints,
                              @Cast("size_t") long ConstraintsSize, @Cast("LLVMBool") int HasSideEffects,
                              @Cast("LLVMBool") int IsAlignStack,
                              @Cast("LLVMInlineAsmDialect") int Dialect, @Cast("LLVMBool") int CanThrow);
public static native LLVMValueRef LLVMGetInlineAsm(LLVMTypeRef Ty, @Cast("char*") ByteBuffer AsmString,
                              @Cast("size_t") long AsmStringSize, @Cast("char*") ByteBuffer Constraints,
                              @Cast("size_t") long ConstraintsSize, @Cast("LLVMBool") int HasSideEffects,
                              @Cast("LLVMBool") int IsAlignStack,
                              @Cast("LLVMInlineAsmDialect") int Dialect, @Cast("LLVMBool") int CanThrow);
public static native LLVMValueRef LLVMGetInlineAsm(LLVMTypeRef Ty, @Cast("char*") byte[] AsmString,
                              @Cast("size_t") long AsmStringSize, @Cast("char*") byte[] Constraints,
                              @Cast("size_t") long ConstraintsSize, @Cast("LLVMBool") int HasSideEffects,
                              @Cast("LLVMBool") int IsAlignStack,
                              @Cast("LLVMInlineAsmDialect") int Dialect, @Cast("LLVMBool") int CanThrow);

/**
 * Obtain the context to which this module is associated.
 *
 * @see Module::getContext()
 */
public static native LLVMContextRef LLVMGetModuleContext(LLVMModuleRef M);

/** Deprecated: Use LLVMGetTypeByName2 instead. */
public static native LLVMTypeRef LLVMGetTypeByName(LLVMModuleRef M, @Cast("const char*") BytePointer Name);
public static native LLVMTypeRef LLVMGetTypeByName(LLVMModuleRef M, String Name);

/**
 * Obtain an iterator to the first NamedMDNode in a Module.
 *
 * @see llvm::Module::named_metadata_begin()
 */
public static native LLVMNamedMDNodeRef LLVMGetFirstNamedMetadata(LLVMModuleRef M);

/**
 * Obtain an iterator to the last NamedMDNode in a Module.
 *
 * @see llvm::Module::named_metadata_end()
 */
public static native LLVMNamedMDNodeRef LLVMGetLastNamedMetadata(LLVMModuleRef M);

/**
 * Advance a NamedMDNode iterator to the next NamedMDNode.
 *
 * Returns NULL if the iterator was already at the end and there are no more
 * named metadata nodes.
 */
public static native LLVMNamedMDNodeRef LLVMGetNextNamedMetadata(LLVMNamedMDNodeRef NamedMDNode);

/**
 * Decrement a NamedMDNode iterator to the previous NamedMDNode.
 *
 * Returns NULL if the iterator was already at the beginning and there are
 * no previous named metadata nodes.
 */
public static native LLVMNamedMDNodeRef LLVMGetPreviousNamedMetadata(LLVMNamedMDNodeRef NamedMDNode);

/**
 * Retrieve a NamedMDNode with the given name, returning NULL if no such
 * node exists.
 *
 * @see llvm::Module::getNamedMetadata()
 */
public static native LLVMNamedMDNodeRef LLVMGetNamedMetadata(LLVMModuleRef M,
                                        @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen);
public static native LLVMNamedMDNodeRef LLVMGetNamedMetadata(LLVMModuleRef M,
                                        String Name, @Cast("size_t") long NameLen);

/**
 * Retrieve a NamedMDNode with the given name, creating a new node if no such
 * node exists.
 *
 * @see llvm::Module::getOrInsertNamedMetadata()
 */
public static native LLVMNamedMDNodeRef LLVMGetOrInsertNamedMetadata(LLVMModuleRef M,
                                                @Cast("const char*") BytePointer Name,
                                                @Cast("size_t") long NameLen);
public static native LLVMNamedMDNodeRef LLVMGetOrInsertNamedMetadata(LLVMModuleRef M,
                                                String Name,
                                                @Cast("size_t") long NameLen);

/**
 * Retrieve the name of a NamedMDNode.
 *
 * @see llvm::NamedMDNode::getName()
 */
public static native @Cast("const char*") BytePointer LLVMGetNamedMetadataName(LLVMNamedMDNodeRef NamedMD,
                                     @Cast("size_t*") SizeTPointer NameLen);

/**
 * Obtain the number of operands for named metadata in a module.
 *
 * @see llvm::Module::getNamedMetadata()
 */
public static native @Cast("unsigned") int LLVMGetNamedMetadataNumOperands(LLVMModuleRef M, @Cast("const char*") BytePointer Name);
public static native @Cast("unsigned") int LLVMGetNamedMetadataNumOperands(LLVMModuleRef M, String Name);

/**
 * Obtain the named metadata operands for a module.
 *
 * The passed LLVMValueRef pointer should refer to an array of
 * LLVMValueRef at least LLVMGetNamedMetadataNumOperands long. This
 * array will be populated with the LLVMValueRef instances. Each
 * instance corresponds to a llvm::MDNode.
 *
 * @see llvm::Module::getNamedMetadata()
 * @see llvm::MDNode::getOperand()
 */
public static native void LLVMGetNamedMetadataOperands(LLVMModuleRef M, @Cast("const char*") BytePointer Name,
                                  @ByPtrPtr LLVMValueRef Dest);
public static native void LLVMGetNamedMetadataOperands(LLVMModuleRef M, String Name,
                                  @Cast("LLVMValueRef*") PointerPointer Dest);

/**
 * Add an operand to named metadata.
 *
 * @see llvm::Module::getNamedMetadata()
 * @see llvm::MDNode::addOperand()
 */
public static native void LLVMAddNamedMetadataOperand(LLVMModuleRef M, @Cast("const char*") BytePointer Name,
                                 LLVMValueRef Val);
public static native void LLVMAddNamedMetadataOperand(LLVMModuleRef M, String Name,
                                 LLVMValueRef Val);

/**
 * Return the directory of the debug location for this value, which must be
 * an llvm::Instruction, llvm::GlobalVariable, or llvm::Function.
 *
 * @see llvm::Instruction::getDebugLoc()
 * @see llvm::GlobalVariable::getDebugInfo()
 * @see llvm::Function::getSubprogram()
 */
public static native @Cast("const char*") BytePointer LLVMGetDebugLocDirectory(LLVMValueRef Val, @Cast("unsigned*") IntPointer Length);
public static native String LLVMGetDebugLocDirectory(LLVMValueRef Val, @Cast("unsigned*") IntBuffer Length);
public static native @Cast("const char*") BytePointer LLVMGetDebugLocDirectory(LLVMValueRef Val, @Cast("unsigned*") int[] Length);

/**
 * Return the filename of the debug location for this value, which must be
 * an llvm::Instruction, llvm::GlobalVariable, or llvm::Function.
 *
 * @see llvm::Instruction::getDebugLoc()
 * @see llvm::GlobalVariable::getDebugInfo()
 * @see llvm::Function::getSubprogram()
 */
public static native @Cast("const char*") BytePointer LLVMGetDebugLocFilename(LLVMValueRef Val, @Cast("unsigned*") IntPointer Length);
public static native String LLVMGetDebugLocFilename(LLVMValueRef Val, @Cast("unsigned*") IntBuffer Length);
public static native @Cast("const char*") BytePointer LLVMGetDebugLocFilename(LLVMValueRef Val, @Cast("unsigned*") int[] Length);

/**
 * Return the line number of the debug location for this value, which must be
 * an llvm::Instruction, llvm::GlobalVariable, or llvm::Function.
 *
 * @see llvm::Instruction::getDebugLoc()
 * @see llvm::GlobalVariable::getDebugInfo()
 * @see llvm::Function::getSubprogram()
 */
public static native @Cast("unsigned") int LLVMGetDebugLocLine(LLVMValueRef Val);

/**
 * Return the column number of the debug location for this value, which must be
 * an llvm::Instruction.
 *
 * @see llvm::Instruction::getDebugLoc()
 */
public static native @Cast("unsigned") int LLVMGetDebugLocColumn(LLVMValueRef Val);

/**
 * Add a function to a module under a specified name.
 *
 * @see llvm::Function::Create()
 */
public static native LLVMValueRef LLVMAddFunction(LLVMModuleRef M, @Cast("const char*") BytePointer Name,
                             LLVMTypeRef FunctionTy);
public static native LLVMValueRef LLVMAddFunction(LLVMModuleRef M, String Name,
                             LLVMTypeRef FunctionTy);

/**
 * Obtain a Function value from a Module by its name.
 *
 * The returned value corresponds to a llvm::Function value.
 *
 * @see llvm::Module::getFunction()
 */
public static native LLVMValueRef LLVMGetNamedFunction(LLVMModuleRef M, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMGetNamedFunction(LLVMModuleRef M, String Name);

/**
 * Obtain an iterator to the first Function in a Module.
 *
 * @see llvm::Module::begin()
 */
public static native LLVMValueRef LLVMGetFirstFunction(LLVMModuleRef M);

/**
 * Obtain an iterator to the last Function in a Module.
 *
 * @see llvm::Module::end()
 */
public static native LLVMValueRef LLVMGetLastFunction(LLVMModuleRef M);

/**
 * Advance a Function iterator to the next Function.
 *
 * Returns NULL if the iterator was already at the end and there are no more
 * functions.
 */
public static native LLVMValueRef LLVMGetNextFunction(LLVMValueRef Fn);

/**
 * Decrement a Function iterator to the previous Function.
 *
 * Returns NULL if the iterator was already at the beginning and there are
 * no previous functions.
 */
public static native LLVMValueRef LLVMGetPreviousFunction(LLVMValueRef Fn);

/** Deprecated: Use LLVMSetModuleInlineAsm2 instead. */
public static native void LLVMSetModuleInlineAsm(LLVMModuleRef M, @Cast("const char*") BytePointer Asm);
public static native void LLVMSetModuleInlineAsm(LLVMModuleRef M, String Asm);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreType Types
 *
 * Types represent the type of a value.
 *
 * Types are associated with a context instance. The context internally
 * deduplicates types so there is only 1 instance of a specific type
 * alive at a time. In other words, a unique type is shared among all
 * consumers within a context.
 *
 * A Type in the C API corresponds to llvm::Type.
 *
 * Types have the following hierarchy:
 *
 *   types:
 *     integer type
 *     real type
 *     function type
 *     sequence types:
 *       array type
 *       pointer type
 *       vector type
 *     void type
 *     label type
 *     opaque type
 *
 * \{
 */

/**
 * Obtain the enumerated type of a Type instance.
 *
 * @see llvm::Type:getTypeID()
 */
public static native @Cast("LLVMTypeKind") int LLVMGetTypeKind(LLVMTypeRef Ty);

/**
 * Whether the type has a known size.
 *
 * Things that don't have a size are abstract types, labels, and void.a
 *
 * @see llvm::Type::isSized()
 */
public static native @Cast("LLVMBool") int LLVMTypeIsSized(LLVMTypeRef Ty);

/**
 * Obtain the context to which this type instance is associated.
 *
 * @see llvm::Type::getContext()
 */
public static native LLVMContextRef LLVMGetTypeContext(LLVMTypeRef Ty);

/**
 * Dump a representation of a type to stderr.
 *
 * @see llvm::Type::dump()
 */
public static native void LLVMDumpType(LLVMTypeRef Val);

/**
 * Return a string representation of the type. Use
 * LLVMDisposeMessage to free the string.
 *
 * @see llvm::Type::print()
 */
public static native @Cast("char*") BytePointer LLVMPrintTypeToString(LLVMTypeRef Val);

/**
 * \defgroup LLVMCCoreTypeInt Integer Types
 *
 * Functions in this section operate on integer types.
 *
 * \{
 */

/**
 * Obtain an integer type from a context with specified bit width.
 */
public static native LLVMTypeRef LLVMInt1TypeInContext(LLVMContextRef C);
public static native LLVMTypeRef LLVMInt8TypeInContext(LLVMContextRef C);
public static native LLVMTypeRef LLVMInt16TypeInContext(LLVMContextRef C);
public static native LLVMTypeRef LLVMInt32TypeInContext(LLVMContextRef C);
public static native LLVMTypeRef LLVMInt64TypeInContext(LLVMContextRef C);
public static native LLVMTypeRef LLVMInt128TypeInContext(LLVMContextRef C);
public static native LLVMTypeRef LLVMIntTypeInContext(LLVMContextRef C, @Cast("unsigned") int NumBits);

/**
 * Obtain an integer type from the global context with a specified bit
 * width.
 */
public static native LLVMTypeRef LLVMInt1Type();
public static native LLVMTypeRef LLVMInt8Type();
public static native LLVMTypeRef LLVMInt16Type();
public static native LLVMTypeRef LLVMInt32Type();
public static native LLVMTypeRef LLVMInt64Type();
public static native LLVMTypeRef LLVMInt128Type();
public static native LLVMTypeRef LLVMIntType(@Cast("unsigned") int NumBits);
public static native @Cast("unsigned") int LLVMGetIntTypeWidth(LLVMTypeRef IntegerTy);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreTypeFloat Floating Point Types
 *
 * \{
 */

/**
 * Obtain a 16-bit floating point type from a context.
 */
public static native LLVMTypeRef LLVMHalfTypeInContext(LLVMContextRef C);

/**
 * Obtain a 16-bit brain floating point type from a context.
 */
public static native LLVMTypeRef LLVMBFloatTypeInContext(LLVMContextRef C);

/**
 * Obtain a 32-bit floating point type from a context.
 */
public static native LLVMTypeRef LLVMFloatTypeInContext(LLVMContextRef C);

/**
 * Obtain a 64-bit floating point type from a context.
 */
public static native LLVMTypeRef LLVMDoubleTypeInContext(LLVMContextRef C);

/**
 * Obtain a 80-bit floating point type (X87) from a context.
 */
public static native LLVMTypeRef LLVMX86FP80TypeInContext(LLVMContextRef C);

/**
 * Obtain a 128-bit floating point type (112-bit mantissa) from a
 * context.
 */
public static native LLVMTypeRef LLVMFP128TypeInContext(LLVMContextRef C);

/**
 * Obtain a 128-bit floating point type (two 64-bits) from a context.
 */
public static native LLVMTypeRef LLVMPPCFP128TypeInContext(LLVMContextRef C);

/**
 * Obtain a floating point type from the global context.
 *
 * These map to the functions in this group of the same name.
 */
public static native LLVMTypeRef LLVMHalfType();
public static native LLVMTypeRef LLVMBFloatType();
public static native LLVMTypeRef LLVMFloatType();
public static native LLVMTypeRef LLVMDoubleType();
public static native LLVMTypeRef LLVMX86FP80Type();
public static native LLVMTypeRef LLVMFP128Type();
public static native LLVMTypeRef LLVMPPCFP128Type();

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreTypeFunction Function Types
 *
 * \{
 */

/**
 * Obtain a function type consisting of a specified signature.
 *
 * The function is defined as a tuple of a return Type, a list of
 * parameter types, and whether the function is variadic.
 */
public static native LLVMTypeRef LLVMFunctionType(LLVMTypeRef ReturnType,
                             @ByPtrPtr LLVMTypeRef ParamTypes, @Cast("unsigned") int ParamCount,
                             @Cast("LLVMBool") int IsVarArg);
public static native LLVMTypeRef LLVMFunctionType(LLVMTypeRef ReturnType,
                             @Cast("LLVMTypeRef*") PointerPointer ParamTypes, @Cast("unsigned") int ParamCount,
                             @Cast("LLVMBool") int IsVarArg);

/**
 * Returns whether a function type is variadic.
 */
public static native @Cast("LLVMBool") int LLVMIsFunctionVarArg(LLVMTypeRef FunctionTy);

/**
 * Obtain the Type this function Type returns.
 */
public static native LLVMTypeRef LLVMGetReturnType(LLVMTypeRef FunctionTy);

/**
 * Obtain the number of parameters this function accepts.
 */
public static native @Cast("unsigned") int LLVMCountParamTypes(LLVMTypeRef FunctionTy);

/**
 * Obtain the types of a function's parameters.
 *
 * The Dest parameter should point to a pre-allocated array of
 * LLVMTypeRef at least LLVMCountParamTypes() large. On return, the
 * first LLVMCountParamTypes() entries in the array will be populated
 * with LLVMTypeRef instances.
 *
 * @param FunctionTy The function type to operate on.
 * @param Dest Memory address of an array to be filled with result.
 */
public static native void LLVMGetParamTypes(LLVMTypeRef FunctionTy, @ByPtrPtr LLVMTypeRef Dest);
public static native void LLVMGetParamTypes(LLVMTypeRef FunctionTy, @Cast("LLVMTypeRef*") PointerPointer Dest);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreTypeStruct Structure Types
 *
 * These functions relate to LLVMTypeRef instances.
 *
 * @see llvm::StructType
 *
 * \{
 */

/**
 * Create a new structure type in a context.
 *
 * A structure is specified by a list of inner elements/types and
 * whether these can be packed together.
 *
 * @see llvm::StructType::create()
 */
public static native LLVMTypeRef LLVMStructTypeInContext(LLVMContextRef C, @ByPtrPtr LLVMTypeRef ElementTypes,
                                    @Cast("unsigned") int ElementCount, @Cast("LLVMBool") int Packed);
public static native LLVMTypeRef LLVMStructTypeInContext(LLVMContextRef C, @Cast("LLVMTypeRef*") PointerPointer ElementTypes,
                                    @Cast("unsigned") int ElementCount, @Cast("LLVMBool") int Packed);

/**
 * Create a new structure type in the global context.
 *
 * @see llvm::StructType::create()
 */
public static native LLVMTypeRef LLVMStructType(@ByPtrPtr LLVMTypeRef ElementTypes, @Cast("unsigned") int ElementCount,
                           @Cast("LLVMBool") int Packed);
public static native LLVMTypeRef LLVMStructType(@Cast("LLVMTypeRef*") PointerPointer ElementTypes, @Cast("unsigned") int ElementCount,
                           @Cast("LLVMBool") int Packed);

/**
 * Create an empty structure in a context having a specified name.
 *
 * @see llvm::StructType::create()
 */
public static native LLVMTypeRef LLVMStructCreateNamed(LLVMContextRef C, @Cast("const char*") BytePointer Name);
public static native LLVMTypeRef LLVMStructCreateNamed(LLVMContextRef C, String Name);

/**
 * Obtain the name of a structure.
 *
 * @see llvm::StructType::getName()
 */
public static native @Cast("const char*") BytePointer LLVMGetStructName(LLVMTypeRef Ty);

/**
 * Set the contents of a structure type.
 *
 * @see llvm::StructType::setBody()
 */
public static native void LLVMStructSetBody(LLVMTypeRef StructTy, @ByPtrPtr LLVMTypeRef ElementTypes,
                       @Cast("unsigned") int ElementCount, @Cast("LLVMBool") int Packed);
public static native void LLVMStructSetBody(LLVMTypeRef StructTy, @Cast("LLVMTypeRef*") PointerPointer ElementTypes,
                       @Cast("unsigned") int ElementCount, @Cast("LLVMBool") int Packed);

/**
 * Get the number of elements defined inside the structure.
 *
 * @see llvm::StructType::getNumElements()
 */
public static native @Cast("unsigned") int LLVMCountStructElementTypes(LLVMTypeRef StructTy);

/**
 * Get the elements within a structure.
 *
 * The function is passed the address of a pre-allocated array of
 * LLVMTypeRef at least LLVMCountStructElementTypes() long. After
 * invocation, this array will be populated with the structure's
 * elements. The objects in the destination array will have a lifetime
 * of the structure type itself, which is the lifetime of the context it
 * is contained in.
 */
public static native void LLVMGetStructElementTypes(LLVMTypeRef StructTy, @ByPtrPtr LLVMTypeRef Dest);
public static native void LLVMGetStructElementTypes(LLVMTypeRef StructTy, @Cast("LLVMTypeRef*") PointerPointer Dest);

/**
 * Get the type of the element at a given index in the structure.
 *
 * @see llvm::StructType::getTypeAtIndex()
 */
public static native LLVMTypeRef LLVMStructGetTypeAtIndex(LLVMTypeRef StructTy, @Cast("unsigned") int i);

/**
 * Determine whether a structure is packed.
 *
 * @see llvm::StructType::isPacked()
 */
public static native @Cast("LLVMBool") int LLVMIsPackedStruct(LLVMTypeRef StructTy);

/**
 * Determine whether a structure is opaque.
 *
 * @see llvm::StructType::isOpaque()
 */
public static native @Cast("LLVMBool") int LLVMIsOpaqueStruct(LLVMTypeRef StructTy);

/**
 * Determine whether a structure is literal.
 *
 * @see llvm::StructType::isLiteral()
 */
public static native @Cast("LLVMBool") int LLVMIsLiteralStruct(LLVMTypeRef StructTy);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreTypeSequential Sequential Types
 *
 * Sequential types represents "arrays" of types. This is a super class
 * for array, vector, and pointer types.
 *
 * \{
 */

/**
 * Obtain the element type of an array or vector type.
 *
 * This currently also works for pointer types, but this usage is deprecated.
 *
 * @see llvm::SequentialType::getElementType()
 */
public static native LLVMTypeRef LLVMGetElementType(LLVMTypeRef Ty);

/**
 * Returns type's subtypes
 *
 * @see llvm::Type::subtypes()
 */
public static native void LLVMGetSubtypes(LLVMTypeRef Tp, @ByPtrPtr LLVMTypeRef Arr);
public static native void LLVMGetSubtypes(LLVMTypeRef Tp, @Cast("LLVMTypeRef*") PointerPointer Arr);

/**
 *  Return the number of types in the derived type.
 *
 * @see llvm::Type::getNumContainedTypes()
 */
public static native @Cast("unsigned") int LLVMGetNumContainedTypes(LLVMTypeRef Tp);

/**
 * Create a fixed size array type that refers to a specific type.
 *
 * The created type will exist in the context that its element type
 * exists in.
 *
 * @see llvm::ArrayType::get()
 */
public static native LLVMTypeRef LLVMArrayType(LLVMTypeRef ElementType, @Cast("unsigned") int ElementCount);

/**
 * Obtain the length of an array type.
 *
 * This only works on types that represent arrays.
 *
 * @see llvm::ArrayType::getNumElements()
 */
public static native @Cast("unsigned") int LLVMGetArrayLength(LLVMTypeRef ArrayTy);

/**
 * Create a pointer type that points to a defined type.
 *
 * The created type will exist in the context that its pointee type
 * exists in.
 *
 * @see llvm::PointerType::get()
 */
public static native LLVMTypeRef LLVMPointerType(LLVMTypeRef ElementType, @Cast("unsigned") int AddressSpace);

/**
 * Determine whether a pointer is opaque.
 *
 * True if this is an instance of an opaque PointerType.
 *
 * @see llvm::Type::isOpaquePointerTy()
 */
public static native @Cast("LLVMBool") int LLVMPointerTypeIsOpaque(LLVMTypeRef Ty);

/**
 * Create an opaque pointer type in a context.
 *
 * @see llvm::PointerType::get()
 */
public static native LLVMTypeRef LLVMPointerTypeInContext(LLVMContextRef C, @Cast("unsigned") int AddressSpace);

/**
 * Obtain the address space of a pointer type.
 *
 * This only works on types that represent pointers.
 *
 * @see llvm::PointerType::getAddressSpace()
 */
public static native @Cast("unsigned") int LLVMGetPointerAddressSpace(LLVMTypeRef PointerTy);

/**
 * Create a vector type that contains a defined type and has a specific
 * number of elements.
 *
 * The created type will exist in the context thats its element type
 * exists in.
 *
 * @see llvm::VectorType::get()
 */
public static native LLVMTypeRef LLVMVectorType(LLVMTypeRef ElementType, @Cast("unsigned") int ElementCount);

/**
 * Create a vector type that contains a defined type and has a scalable
 * number of elements.
 *
 * The created type will exist in the context thats its element type
 * exists in.
 *
 * @see llvm::ScalableVectorType::get()
 */
public static native LLVMTypeRef LLVMScalableVectorType(LLVMTypeRef ElementType,
                                   @Cast("unsigned") int ElementCount);

/**
 * Obtain the (possibly scalable) number of elements in a vector type.
 *
 * This only works on types that represent vectors (fixed or scalable).
 *
 * @see llvm::VectorType::getNumElements()
 */
public static native @Cast("unsigned") int LLVMGetVectorSize(LLVMTypeRef VectorTy);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreTypeOther Other Types
 *
 * \{
 */

/**
 * Create a void type in a context.
 */
public static native LLVMTypeRef LLVMVoidTypeInContext(LLVMContextRef C);

/**
 * Create a label type in a context.
 */
public static native LLVMTypeRef LLVMLabelTypeInContext(LLVMContextRef C);

/**
 * Create a X86 MMX type in a context.
 */
public static native LLVMTypeRef LLVMX86MMXTypeInContext(LLVMContextRef C);

/**
 * Create a X86 AMX type in a context.
 */
public static native LLVMTypeRef LLVMX86AMXTypeInContext(LLVMContextRef C);

/**
 * Create a token type in a context.
 */
public static native LLVMTypeRef LLVMTokenTypeInContext(LLVMContextRef C);

/**
 * Create a metadata type in a context.
 */
public static native LLVMTypeRef LLVMMetadataTypeInContext(LLVMContextRef C);

/**
 * These are similar to the above functions except they operate on the
 * global context.
 */
public static native LLVMTypeRef LLVMVoidType();
public static native LLVMTypeRef LLVMLabelType();
public static native LLVMTypeRef LLVMX86MMXType();
public static native LLVMTypeRef LLVMX86AMXType();

/**
 * \}
 */

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValues Values
 *
 * The bulk of LLVM's object model consists of values, which comprise a very
 * rich type hierarchy.
 *
 * LLVMValueRef essentially represents llvm::Value. There is a rich
 * hierarchy of classes within this type. Depending on the instance
 * obtained, not all APIs are available.
 *
 * Callers can determine the type of an LLVMValueRef by calling the
 * LLVMIsA* family of functions (e.g. LLVMIsAArgument()). These
 * functions are defined by a macro, so it isn't obvious which are
 * available by looking at the Doxygen source code. Instead, look at the
 * source definition of LLVM_FOR_EACH_VALUE_SUBCLASS and note the list
 * of value names given. These value names also correspond to classes in
 * the llvm::Value hierarchy.
 *
 * \{
 */

// #define LLVM_FOR_EACH_VALUE_SUBCLASS(macro)
//   macro(Argument)
//   macro(BasicBlock)
//   macro(InlineAsm)
//   macro(User)
//     macro(Constant)
//       macro(BlockAddress)
//       macro(ConstantAggregateZero)
//       macro(ConstantArray)
//       macro(ConstantDataSequential)
//         macro(ConstantDataArray)
//         macro(ConstantDataVector)
//       macro(ConstantExpr)
//       macro(ConstantFP)
//       macro(ConstantInt)
//       macro(ConstantPointerNull)
//       macro(ConstantStruct)
//       macro(ConstantTokenNone)
//       macro(ConstantVector)
//       macro(GlobalValue)
//         macro(GlobalAlias)
//         macro(GlobalObject)
//           macro(Function)
//           macro(GlobalVariable)
//           macro(GlobalIFunc)
//       macro(UndefValue)
//       macro(PoisonValue)
//     macro(Instruction)
//       macro(UnaryOperator)
//       macro(BinaryOperator)
//       macro(CallInst)
//         macro(IntrinsicInst)
//           macro(DbgInfoIntrinsic)
//             macro(DbgVariableIntrinsic)
//               macro(DbgDeclareInst)
//             macro(DbgLabelInst)
//           macro(MemIntrinsic)
//             macro(MemCpyInst)
//             macro(MemMoveInst)
//             macro(MemSetInst)
//       macro(CmpInst)
//         macro(FCmpInst)
//         macro(ICmpInst)
//       macro(ExtractElementInst)
//       macro(GetElementPtrInst)
//       macro(InsertElementInst)
//       macro(InsertValueInst)
//       macro(LandingPadInst)
//       macro(PHINode)
//       macro(SelectInst)
//       macro(ShuffleVectorInst)
//       macro(StoreInst)
//       macro(BranchInst)
//       macro(IndirectBrInst)
//       macro(InvokeInst)
//       macro(ReturnInst)
//       macro(SwitchInst)
//       macro(UnreachableInst)
//       macro(ResumeInst)
//       macro(CleanupReturnInst)
//       macro(CatchReturnInst)
//       macro(CatchSwitchInst)
//       macro(CallBrInst)
//       macro(FuncletPadInst)
//         macro(CatchPadInst)
//         macro(CleanupPadInst)
//       macro(UnaryInstruction)
//         macro(AllocaInst)
//         macro(CastInst)
//           macro(AddrSpaceCastInst)
//           macro(BitCastInst)
//           macro(FPExtInst)
//           macro(FPToSIInst)
//           macro(FPToUIInst)
//           macro(FPTruncInst)
//           macro(IntToPtrInst)
//           macro(PtrToIntInst)
//           macro(SExtInst)
//           macro(SIToFPInst)
//           macro(TruncInst)
//           macro(UIToFPInst)
//           macro(ZExtInst)
//         macro(ExtractValueInst)
//         macro(LoadInst)
//         macro(VAArgInst)
//         macro(FreezeInst)
//       macro(AtomicCmpXchgInst)
//       macro(AtomicRMWInst)
//       macro(FenceInst)

/**
 * \defgroup LLVMCCoreValueGeneral General APIs
 *
 * Functions in this section work on all LLVMValueRef instances,
 * regardless of their sub-type. They correspond to functions available
 * on llvm::Value.
 *
 * \{
 */

/**
 * Obtain the type of a value.
 *
 * @see llvm::Value::getType()
 */
public static native LLVMTypeRef LLVMTypeOf(LLVMValueRef Val);

/**
 * Obtain the enumerated type of a Value instance.
 *
 * @see llvm::Value::getValueID()
 */
public static native @Cast("LLVMValueKind") int LLVMGetValueKind(LLVMValueRef Val);

/**
 * Obtain the string name of a value.
 *
 * @see llvm::Value::getName()
 */
public static native @Cast("const char*") BytePointer LLVMGetValueName2(LLVMValueRef Val, @Cast("size_t*") SizeTPointer Length);

/**
 * Set the string name of a value.
 *
 * @see llvm::Value::setName()
 */
public static native void LLVMSetValueName2(LLVMValueRef Val, @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen);
public static native void LLVMSetValueName2(LLVMValueRef Val, String Name, @Cast("size_t") long NameLen);

/**
 * Dump a representation of a value to stderr.
 *
 * @see llvm::Value::dump()
 */
public static native void LLVMDumpValue(LLVMValueRef Val);

/**
 * Return a string representation of the value. Use
 * LLVMDisposeMessage to free the string.
 *
 * @see llvm::Value::print()
 */
public static native @Cast("char*") BytePointer LLVMPrintValueToString(LLVMValueRef Val);

/**
 * Replace all uses of a value with another one.
 *
 * @see llvm::Value::replaceAllUsesWith()
 */
public static native void LLVMReplaceAllUsesWith(LLVMValueRef OldVal, LLVMValueRef NewVal);

/**
 * Determine whether the specified value instance is constant.
 */
public static native @Cast("LLVMBool") int LLVMIsConstant(LLVMValueRef Val);

/**
 * Determine whether a value instance is undefined.
 */
public static native @Cast("LLVMBool") int LLVMIsUndef(LLVMValueRef Val);

/**
 * Determine whether a value instance is poisonous.
 */
public static native @Cast("LLVMBool") int LLVMIsPoison(LLVMValueRef Val);

/**
 * Convert value instances between types.
 *
 * Internally, an LLVMValueRef is "pinned" to a specific type. This
 * series of functions allows you to cast an instance to a specific
 * type.
 *
 * If the cast is not valid for the specified type, NULL is returned.
 *
 * @see llvm::dyn_cast_or_null<>
 */
// #define LLVM_DECLARE_VALUE_CAST(name)
//   LLVMValueRef LLVMIsA##name(LLVMValueRef Val);
public static native LLVMValueRef LLVMIsAArgument(LLVMValueRef Val);
  public static native LLVMValueRef LLVMIsABasicBlock(LLVMValueRef Val);
  public static native LLVMValueRef LLVMIsAInlineAsm(LLVMValueRef Val);
  public static native LLVMValueRef LLVMIsAUser(LLVMValueRef Val);
    public static native LLVMValueRef LLVMIsAConstant(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsABlockAddress(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantAggregateZero(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantArray(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantDataSequential(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAConstantDataArray(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAConstantDataVector(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantExpr(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantFP(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantInt(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantPointerNull(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantStruct(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantTokenNone(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAConstantVector(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAGlobalValue(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAGlobalAlias(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAGlobalObject(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAFunction(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAGlobalVariable(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAGlobalIFunc(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAUndefValue(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAPoisonValue(LLVMValueRef Val);
    public static native LLVMValueRef LLVMIsAInstruction(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAUnaryOperator(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsABinaryOperator(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsACallInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAIntrinsicInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsADbgInfoIntrinsic(LLVMValueRef Val);
            public static native LLVMValueRef LLVMIsADbgVariableIntrinsic(LLVMValueRef Val);
              public static native LLVMValueRef LLVMIsADbgDeclareInst(LLVMValueRef Val);
            public static native LLVMValueRef LLVMIsADbgLabelInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAMemIntrinsic(LLVMValueRef Val);
            public static native LLVMValueRef LLVMIsAMemCpyInst(LLVMValueRef Val);
            public static native LLVMValueRef LLVMIsAMemMoveInst(LLVMValueRef Val);
            public static native LLVMValueRef LLVMIsAMemSetInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsACmpInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAFCmpInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAICmpInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAExtractElementInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAGetElementPtrInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAInsertElementInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAInsertValueInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsALandingPadInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAPHINode(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsASelectInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAShuffleVectorInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAStoreInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsABranchInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAIndirectBrInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAInvokeInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAReturnInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsASwitchInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAUnreachableInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAResumeInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsACleanupReturnInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsACatchReturnInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsACatchSwitchInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsACallBrInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAFuncletPadInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsACatchPadInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsACleanupPadInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAUnaryInstruction(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAAllocaInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsACastInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAAddrSpaceCastInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsABitCastInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAFPExtInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAFPToSIInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAFPToUIInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAFPTruncInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAIntToPtrInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAPtrToIntInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsASExtInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsASIToFPInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsATruncInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAUIToFPInst(LLVMValueRef Val);
          public static native LLVMValueRef LLVMIsAZExtInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAExtractValueInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsALoadInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAVAArgInst(LLVMValueRef Val);
        public static native LLVMValueRef LLVMIsAFreezeInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAAtomicCmpXchgInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAAtomicRMWInst(LLVMValueRef Val);
      public static native LLVMValueRef LLVMIsAFenceInst(LLVMValueRef Val);

public static native LLVMValueRef LLVMIsAMDNode(LLVMValueRef Val);
public static native LLVMValueRef LLVMIsAMDString(LLVMValueRef Val);

/** Deprecated: Use LLVMGetValueName2 instead. */
public static native @Cast("const char*") BytePointer LLVMGetValueName(LLVMValueRef Val);
/** Deprecated: Use LLVMSetValueName2 instead. */
public static native void LLVMSetValueName(LLVMValueRef Val, @Cast("const char*") BytePointer Name);
public static native void LLVMSetValueName(LLVMValueRef Val, String Name);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueUses Usage
 *
 * This module defines functions that allow you to inspect the uses of a
 * LLVMValueRef.
 *
 * It is possible to obtain an LLVMUseRef for any LLVMValueRef instance.
 * Each LLVMUseRef (which corresponds to a llvm::Use instance) holds a
 * llvm::User and llvm::Value.
 *
 * \{
 */

/**
 * Obtain the first use of a value.
 *
 * Uses are obtained in an iterator fashion. First, call this function
 * to obtain a reference to the first use. Then, call LLVMGetNextUse()
 * on that instance and all subsequently obtained instances until
 * LLVMGetNextUse() returns NULL.
 *
 * @see llvm::Value::use_begin()
 */
public static native LLVMUseRef LLVMGetFirstUse(LLVMValueRef Val);

/**
 * Obtain the next use of a value.
 *
 * This effectively advances the iterator. It returns NULL if you are on
 * the final use and no more are available.
 */
public static native LLVMUseRef LLVMGetNextUse(LLVMUseRef U);

/**
 * Obtain the user value for a user.
 *
 * The returned value corresponds to a llvm::User type.
 *
 * @see llvm::Use::getUser()
 */
public static native LLVMValueRef LLVMGetUser(LLVMUseRef U);

/**
 * Obtain the value this use corresponds to.
 *
 * @see llvm::Use::get().
 */
public static native LLVMValueRef LLVMGetUsedValue(LLVMUseRef U);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueUser User value
 *
 * Function in this group pertain to LLVMValueRef instances that descent
 * from llvm::User. This includes constants, instructions, and
 * operators.
 *
 * \{
 */

/**
 * Obtain an operand at a specific index in a llvm::User value.
 *
 * @see llvm::User::getOperand()
 */
public static native LLVMValueRef LLVMGetOperand(LLVMValueRef Val, @Cast("unsigned") int Index);

/**
 * Obtain the use of an operand at a specific index in a llvm::User value.
 *
 * @see llvm::User::getOperandUse()
 */
public static native LLVMUseRef LLVMGetOperandUse(LLVMValueRef Val, @Cast("unsigned") int Index);

/**
 * Set an operand at a specific index in a llvm::User value.
 *
 * @see llvm::User::setOperand()
 */
public static native void LLVMSetOperand(LLVMValueRef User, @Cast("unsigned") int Index, LLVMValueRef Val);

/**
 * Obtain the number of operands in a llvm::User value.
 *
 * @see llvm::User::getNumOperands()
 */
public static native int LLVMGetNumOperands(LLVMValueRef Val);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueConstant Constants
 *
 * This section contains APIs for interacting with LLVMValueRef that
 * correspond to llvm::Constant instances.
 *
 * These functions will work for any LLVMValueRef in the llvm::Constant
 * class hierarchy.
 *
 * \{
 */

/**
 * Obtain a constant value referring to the null instance of a type.
 *
 * @see llvm::Constant::getNullValue()
 */
public static native LLVMValueRef LLVMConstNull(LLVMTypeRef Ty); /* all zeroes */

/**
 * Obtain a constant value referring to the instance of a type
 * consisting of all ones.
 *
 * This is only valid for integer types.
 *
 * @see llvm::Constant::getAllOnesValue()
 */
public static native LLVMValueRef LLVMConstAllOnes(LLVMTypeRef Ty);

/**
 * Obtain a constant value referring to an undefined value of a type.
 *
 * @see llvm::UndefValue::get()
 */
public static native LLVMValueRef LLVMGetUndef(LLVMTypeRef Ty);

/**
 * Obtain a constant value referring to a poison value of a type.
 *
 * @see llvm::PoisonValue::get()
 */
public static native LLVMValueRef LLVMGetPoison(LLVMTypeRef Ty);

/**
 * Determine whether a value instance is null.
 *
 * @see llvm::Constant::isNullValue()
 */
public static native @Cast("LLVMBool") int LLVMIsNull(LLVMValueRef Val);

/**
 * Obtain a constant that is a constant pointer pointing to NULL for a
 * specified type.
 */
public static native LLVMValueRef LLVMConstPointerNull(LLVMTypeRef Ty);

/**
 * \defgroup LLVMCCoreValueConstantScalar Scalar constants
 *
 * Functions in this group model LLVMValueRef instances that correspond
 * to constants referring to scalar types.
 *
 * For integer types, the LLVMTypeRef parameter should correspond to a
 * llvm::IntegerType instance and the returned LLVMValueRef will
 * correspond to a llvm::ConstantInt.
 *
 * For floating point types, the LLVMTypeRef returned corresponds to a
 * llvm::ConstantFP.
 *
 * \{
 */

/**
 * Obtain a constant value for an integer type.
 *
 * The returned value corresponds to a llvm::ConstantInt.
 *
 * @see llvm::ConstantInt::get()
 *
 * @param IntTy Integer type to obtain value of.
 * @param N The value the returned instance should refer to.
 * @param SignExtend Whether to sign extend the produced value.
 */
public static native LLVMValueRef LLVMConstInt(LLVMTypeRef IntTy, @Cast("unsigned long long") long N,
                          @Cast("LLVMBool") int SignExtend);

/**
 * Obtain a constant value for an integer of arbitrary precision.
 *
 * @see llvm::ConstantInt::get()
 */
public static native LLVMValueRef LLVMConstIntOfArbitraryPrecision(LLVMTypeRef IntTy,
                                              @Cast("unsigned") int NumWords,
                                              @Cast("const uint64_t*") LongPointer Words);
public static native LLVMValueRef LLVMConstIntOfArbitraryPrecision(LLVMTypeRef IntTy,
                                              @Cast("unsigned") int NumWords,
                                              @Cast("const uint64_t*") LongBuffer Words);
public static native LLVMValueRef LLVMConstIntOfArbitraryPrecision(LLVMTypeRef IntTy,
                                              @Cast("unsigned") int NumWords,
                                              @Cast("const uint64_t*") long[] Words);

/**
 * Obtain a constant value for an integer parsed from a string.
 *
 * A similar API, LLVMConstIntOfStringAndSize is also available. If the
 * string's length is available, it is preferred to call that function
 * instead.
 *
 * @see llvm::ConstantInt::get()
 */
public static native LLVMValueRef LLVMConstIntOfString(LLVMTypeRef IntTy, @Cast("const char*") BytePointer Text,
                                  @Cast("uint8_t") byte Radix);
public static native LLVMValueRef LLVMConstIntOfString(LLVMTypeRef IntTy, String Text,
                                  @Cast("uint8_t") byte Radix);

/**
 * Obtain a constant value for an integer parsed from a string with
 * specified length.
 *
 * @see llvm::ConstantInt::get()
 */
public static native LLVMValueRef LLVMConstIntOfStringAndSize(LLVMTypeRef IntTy, @Cast("const char*") BytePointer Text,
                                         @Cast("unsigned") int SLen, @Cast("uint8_t") byte Radix);
public static native LLVMValueRef LLVMConstIntOfStringAndSize(LLVMTypeRef IntTy, String Text,
                                         @Cast("unsigned") int SLen, @Cast("uint8_t") byte Radix);

/**
 * Obtain a constant value referring to a double floating point value.
 */
public static native LLVMValueRef LLVMConstReal(LLVMTypeRef RealTy, double N);

/**
 * Obtain a constant for a floating point value parsed from a string.
 *
 * A similar API, LLVMConstRealOfStringAndSize is also available. It
 * should be used if the input string's length is known.
 */
public static native LLVMValueRef LLVMConstRealOfString(LLVMTypeRef RealTy, @Cast("const char*") BytePointer Text);
public static native LLVMValueRef LLVMConstRealOfString(LLVMTypeRef RealTy, String Text);

/**
 * Obtain a constant for a floating point value parsed from a string.
 */
public static native LLVMValueRef LLVMConstRealOfStringAndSize(LLVMTypeRef RealTy, @Cast("const char*") BytePointer Text,
                                          @Cast("unsigned") int SLen);
public static native LLVMValueRef LLVMConstRealOfStringAndSize(LLVMTypeRef RealTy, String Text,
                                          @Cast("unsigned") int SLen);

/**
 * Obtain the zero extended value for an integer constant value.
 *
 * @see llvm::ConstantInt::getZExtValue()
 */
public static native @Cast("unsigned long long") long LLVMConstIntGetZExtValue(LLVMValueRef ConstantVal);

/**
 * Obtain the sign extended value for an integer constant value.
 *
 * @see llvm::ConstantInt::getSExtValue()
 */
public static native long LLVMConstIntGetSExtValue(LLVMValueRef ConstantVal);

/**
 * Obtain the double value for an floating point constant value.
 * losesInfo indicates if some precision was lost in the conversion.
 *
 * @see llvm::ConstantFP::getDoubleValue
 */
public static native double LLVMConstRealGetDouble(LLVMValueRef ConstantVal, @Cast("LLVMBool*") IntPointer losesInfo);
public static native double LLVMConstRealGetDouble(LLVMValueRef ConstantVal, @Cast("LLVMBool*") IntBuffer losesInfo);
public static native double LLVMConstRealGetDouble(LLVMValueRef ConstantVal, @Cast("LLVMBool*") int[] losesInfo);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueConstantComposite Composite Constants
 *
 * Functions in this group operate on composite constants.
 *
 * \{
 */

/**
 * Create a ConstantDataSequential and initialize it with a string.
 *
 * @see llvm::ConstantDataArray::getString()
 */
public static native LLVMValueRef LLVMConstStringInContext(LLVMContextRef C, @Cast("const char*") BytePointer Str,
                                      @Cast("unsigned") int Length, @Cast("LLVMBool") int DontNullTerminate);
public static native LLVMValueRef LLVMConstStringInContext(LLVMContextRef C, String Str,
                                      @Cast("unsigned") int Length, @Cast("LLVMBool") int DontNullTerminate);

/**
 * Create a ConstantDataSequential with string content in the global context.
 *
 * This is the same as LLVMConstStringInContext except it operates on the
 * global context.
 *
 * @see LLVMConstStringInContext()
 * @see llvm::ConstantDataArray::getString()
 */
public static native LLVMValueRef LLVMConstString(@Cast("const char*") BytePointer Str, @Cast("unsigned") int Length,
                             @Cast("LLVMBool") int DontNullTerminate);
public static native LLVMValueRef LLVMConstString(String Str, @Cast("unsigned") int Length,
                             @Cast("LLVMBool") int DontNullTerminate);

/**
 * Returns true if the specified constant is an array of i8.
 *
 * @see ConstantDataSequential::getAsString()
 */
public static native @Cast("LLVMBool") int LLVMIsConstantString(LLVMValueRef c);

/**
 * Get the given constant data sequential as a string.
 *
 * @see ConstantDataSequential::getAsString()
 */
public static native @Cast("const char*") BytePointer LLVMGetAsString(LLVMValueRef c, @Cast("size_t*") SizeTPointer Length);

/**
 * Create an anonymous ConstantStruct with the specified values.
 *
 * @see llvm::ConstantStruct::getAnon()
 */
public static native LLVMValueRef LLVMConstStructInContext(LLVMContextRef C,
                                      @ByPtrPtr LLVMValueRef ConstantVals,
                                      @Cast("unsigned") int Count, @Cast("LLVMBool") int Packed);
public static native LLVMValueRef LLVMConstStructInContext(LLVMContextRef C,
                                      @Cast("LLVMValueRef*") PointerPointer ConstantVals,
                                      @Cast("unsigned") int Count, @Cast("LLVMBool") int Packed);

/**
 * Create a ConstantStruct in the global Context.
 *
 * This is the same as LLVMConstStructInContext except it operates on the
 * global Context.
 *
 * @see LLVMConstStructInContext()
 */
public static native LLVMValueRef LLVMConstStruct(@ByPtrPtr LLVMValueRef ConstantVals, @Cast("unsigned") int Count,
                             @Cast("LLVMBool") int Packed);
public static native LLVMValueRef LLVMConstStruct(@Cast("LLVMValueRef*") PointerPointer ConstantVals, @Cast("unsigned") int Count,
                             @Cast("LLVMBool") int Packed);

/**
 * Create a ConstantArray from values.
 *
 * @see llvm::ConstantArray::get()
 */
public static native LLVMValueRef LLVMConstArray(LLVMTypeRef ElementTy,
                            @ByPtrPtr LLVMValueRef ConstantVals, @Cast("unsigned") int Length);
public static native LLVMValueRef LLVMConstArray(LLVMTypeRef ElementTy,
                            @Cast("LLVMValueRef*") PointerPointer ConstantVals, @Cast("unsigned") int Length);

/**
 * Create a non-anonymous ConstantStruct from values.
 *
 * @see llvm::ConstantStruct::get()
 */
public static native LLVMValueRef LLVMConstNamedStruct(LLVMTypeRef StructTy,
                                  @ByPtrPtr LLVMValueRef ConstantVals,
                                  @Cast("unsigned") int Count);
public static native LLVMValueRef LLVMConstNamedStruct(LLVMTypeRef StructTy,
                                  @Cast("LLVMValueRef*") PointerPointer ConstantVals,
                                  @Cast("unsigned") int Count);

/**
 * Get element of a constant aggregate (struct, array or vector) at the
 * specified index. Returns null if the index is out of range, or it's not
 * possible to determine the element (e.g., because the constant is a
 * constant expression.)
 *
 * @see llvm::Constant::getAggregateElement()
 */
public static native LLVMValueRef LLVMGetAggregateElement(LLVMValueRef C, @Cast("unsigned") int Idx);

/**
 * Get an element at specified index as a constant.
 *
 * @see ConstantDataSequential::getElementAsConstant()
 */


/**
 * Create a ConstantVector from values.
 *
 * @see llvm::ConstantVector::get()
 */
public static native LLVMValueRef LLVMConstVector(@ByPtrPtr LLVMValueRef ScalarConstantVals, @Cast("unsigned") int Size);
public static native LLVMValueRef LLVMConstVector(@Cast("LLVMValueRef*") PointerPointer ScalarConstantVals, @Cast("unsigned") int Size);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueConstantExpressions Constant Expressions
 *
 * Functions in this group correspond to APIs on llvm::ConstantExpr.
 *
 * @see llvm::ConstantExpr.
 *
 * \{
 */
public static native @Cast("LLVMOpcode") int LLVMGetConstOpcode(LLVMValueRef ConstantVal);
public static native LLVMValueRef LLVMAlignOf(LLVMTypeRef Ty);
public static native LLVMValueRef LLVMSizeOf(LLVMTypeRef Ty);
public static native LLVMValueRef LLVMConstNeg(LLVMValueRef ConstantVal);
public static native LLVMValueRef LLVMConstNSWNeg(LLVMValueRef ConstantVal);
public static native LLVMValueRef LLVMConstNUWNeg(LLVMValueRef ConstantVal);
public static native LLVMValueRef LLVMConstFNeg(LLVMValueRef ConstantVal);
public static native LLVMValueRef LLVMConstNot(LLVMValueRef ConstantVal);
public static native LLVMValueRef LLVMConstAdd(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstNSWAdd(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstNUWAdd(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstSub(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstNSWSub(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstNUWSub(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstMul(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstNSWMul(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstNUWMul(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstAnd(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstOr(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstXor(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstICmp(@Cast("LLVMIntPredicate") int Predicate,
                           LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstFCmp(@Cast("LLVMRealPredicate") int Predicate,
                           LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstShl(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstLShr(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);
public static native LLVMValueRef LLVMConstAShr(LLVMValueRef LHSConstant, LLVMValueRef RHSConstant);




public static native LLVMValueRef LLVMConstTrunc(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstSExt(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstZExt(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstFPTrunc(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstFPExt(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstUIToFP(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstSIToFP(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstFPToUI(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstFPToSI(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstPtrToInt(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstIntToPtr(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstBitCast(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstAddrSpaceCast(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstZExtOrBitCast(LLVMValueRef ConstantVal,
                                    LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstSExtOrBitCast(LLVMValueRef ConstantVal,
                                    LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstTruncOrBitCast(LLVMValueRef ConstantVal,
                                     LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstPointerCast(LLVMValueRef ConstantVal,
                                  LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstIntCast(LLVMValueRef ConstantVal, LLVMTypeRef ToType,
                              @Cast("LLVMBool") int isSigned);
public static native LLVMValueRef LLVMConstFPCast(LLVMValueRef ConstantVal, LLVMTypeRef ToType);
public static native LLVMValueRef LLVMConstSelect(LLVMValueRef ConstantCondition,
                             LLVMValueRef ConstantIfTrue,
                             LLVMValueRef ConstantIfFalse);
public static native LLVMValueRef LLVMConstExtractElement(LLVMValueRef VectorConstant,
                                     LLVMValueRef IndexConstant);
public static native LLVMValueRef LLVMConstInsertElement(LLVMValueRef VectorConstant,
                                    LLVMValueRef ElementValueConstant,
                                    LLVMValueRef IndexConstant);
public static native LLVMValueRef LLVMConstShuffleVector(LLVMValueRef VectorAConstant,
                                    LLVMValueRef VectorBConstant,
                                    LLVMValueRef MaskConstant);
public static native LLVMValueRef LLVMBlockAddress(LLVMValueRef F, LLVMBasicBlockRef BB);

/** Deprecated: Use LLVMGetInlineAsm instead. */
public static native LLVMValueRef LLVMConstInlineAsm(LLVMTypeRef Ty,
                                @Cast("const char*") BytePointer AsmString, @Cast("const char*") BytePointer Constraints,
                                @Cast("LLVMBool") int HasSideEffects, @Cast("LLVMBool") int IsAlignStack);
public static native LLVMValueRef LLVMConstInlineAsm(LLVMTypeRef Ty,
                                String AsmString, String Constraints,
                                @Cast("LLVMBool") int HasSideEffects, @Cast("LLVMBool") int IsAlignStack);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueConstantGlobals Global Values
 *
 * This group contains functions that operate on global values. Functions in
 * this group relate to functions in the llvm::GlobalValue class tree.
 *
 * @see llvm::GlobalValue
 *
 * \{
 */

public static native LLVMModuleRef LLVMGetGlobalParent(LLVMValueRef Global);
public static native @Cast("LLVMBool") int LLVMIsDeclaration(LLVMValueRef Global);
public static native @Cast("LLVMLinkage") int LLVMGetLinkage(LLVMValueRef Global);
public static native void LLVMSetLinkage(LLVMValueRef Global, @Cast("LLVMLinkage") int Linkage);
public static native @Cast("const char*") BytePointer LLVMGetSection(LLVMValueRef Global);
public static native void LLVMSetSection(LLVMValueRef Global, @Cast("const char*") BytePointer Section);
public static native void LLVMSetSection(LLVMValueRef Global, String Section);
public static native @Cast("LLVMVisibility") int LLVMGetVisibility(LLVMValueRef Global);
public static native void LLVMSetVisibility(LLVMValueRef Global, @Cast("LLVMVisibility") int Viz);
public static native @Cast("LLVMDLLStorageClass") int LLVMGetDLLStorageClass(LLVMValueRef Global);
public static native void LLVMSetDLLStorageClass(LLVMValueRef Global, @Cast("LLVMDLLStorageClass") int Class);
public static native @Cast("LLVMUnnamedAddr") int LLVMGetUnnamedAddress(LLVMValueRef Global);
public static native void LLVMSetUnnamedAddress(LLVMValueRef Global, @Cast("LLVMUnnamedAddr") int UnnamedAddr);

/**
 * Returns the "value type" of a global value.  This differs from the formal
 * type of a global value which is always a pointer type.
 *
 * @see llvm::GlobalValue::getValueType()
 */
public static native LLVMTypeRef LLVMGlobalGetValueType(LLVMValueRef Global);

/** Deprecated: Use LLVMGetUnnamedAddress instead. */
public static native @Cast("LLVMBool") int LLVMHasUnnamedAddr(LLVMValueRef Global);
/** Deprecated: Use LLVMSetUnnamedAddress instead. */
public static native void LLVMSetUnnamedAddr(LLVMValueRef Global, @Cast("LLVMBool") int HasUnnamedAddr);

/**
 * \defgroup LLVMCCoreValueWithAlignment Values with alignment
 *
 * Functions in this group only apply to values with alignment, i.e.
 * global variables, load and store instructions.
 */

/**
 * Obtain the preferred alignment of the value.
 * @see llvm::AllocaInst::getAlignment()
 * @see llvm::LoadInst::getAlignment()
 * @see llvm::StoreInst::getAlignment()
 * @see llvm::AtomicRMWInst::setAlignment()
 * @see llvm::AtomicCmpXchgInst::setAlignment()
 * @see llvm::GlobalValue::getAlignment()
 */
public static native @Cast("unsigned") int LLVMGetAlignment(LLVMValueRef V);

/**
 * Set the preferred alignment of the value.
 * @see llvm::AllocaInst::setAlignment()
 * @see llvm::LoadInst::setAlignment()
 * @see llvm::StoreInst::setAlignment()
 * @see llvm::AtomicRMWInst::setAlignment()
 * @see llvm::AtomicCmpXchgInst::setAlignment()
 * @see llvm::GlobalValue::setAlignment()
 */
public static native void LLVMSetAlignment(LLVMValueRef V, @Cast("unsigned") int Bytes);

/**
 * Sets a metadata attachment, erasing the existing metadata attachment if
 * it already exists for the given kind.
 *
 * @see llvm::GlobalObject::setMetadata()
 */
public static native void LLVMGlobalSetMetadata(LLVMValueRef Global, @Cast("unsigned") int Kind,
                           LLVMMetadataRef MD);

/**
 * Erases a metadata attachment of the given kind if it exists.
 *
 * @see llvm::GlobalObject::eraseMetadata()
 */
public static native void LLVMGlobalEraseMetadata(LLVMValueRef Global, @Cast("unsigned") int Kind);

/**
 * Removes all metadata attachments from this value.
 *
 * @see llvm::GlobalObject::clearMetadata()
 */
public static native void LLVMGlobalClearMetadata(LLVMValueRef Global);

/**
 * Retrieves an array of metadata entries representing the metadata attached to
 * this value. The caller is responsible for freeing this array by calling
 * \c LLVMDisposeValueMetadataEntries.
 *
 * @see llvm::GlobalObject::getAllMetadata()
 */
public static native LLVMValueMetadataEntry LLVMGlobalCopyAllMetadata(LLVMValueRef Value,
                                                  @Cast("size_t*") SizeTPointer NumEntries);

/**
 * Destroys value metadata entries.
 */
public static native void LLVMDisposeValueMetadataEntries(LLVMValueMetadataEntry Entries);

/**
 * Returns the kind of a value metadata entry at a specific index.
 */
public static native @Cast("unsigned") int LLVMValueMetadataEntriesGetKind(LLVMValueMetadataEntry Entries,
                                         @Cast("unsigned") int Index);

/**
 * Returns the underlying metadata node of a value metadata entry at a
 * specific index.
 */
public static native LLVMMetadataRef LLVMValueMetadataEntriesGetMetadata(LLVMValueMetadataEntry Entries,
                                    @Cast("unsigned") int Index);

/**
 * \}
 */

/**
 * \defgroup LLVMCoreValueConstantGlobalVariable Global Variables
 *
 * This group contains functions that operate on global variable values.
 *
 * @see llvm::GlobalVariable
 *
 * \{
 */
public static native LLVMValueRef LLVMAddGlobal(LLVMModuleRef M, LLVMTypeRef Ty, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMAddGlobal(LLVMModuleRef M, LLVMTypeRef Ty, String Name);
public static native LLVMValueRef LLVMAddGlobalInAddressSpace(LLVMModuleRef M, LLVMTypeRef Ty,
                                         @Cast("const char*") BytePointer Name,
                                         @Cast("unsigned") int AddressSpace);
public static native LLVMValueRef LLVMAddGlobalInAddressSpace(LLVMModuleRef M, LLVMTypeRef Ty,
                                         String Name,
                                         @Cast("unsigned") int AddressSpace);
public static native LLVMValueRef LLVMGetNamedGlobal(LLVMModuleRef M, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMGetNamedGlobal(LLVMModuleRef M, String Name);
public static native LLVMValueRef LLVMGetFirstGlobal(LLVMModuleRef M);
public static native LLVMValueRef LLVMGetLastGlobal(LLVMModuleRef M);
public static native LLVMValueRef LLVMGetNextGlobal(LLVMValueRef GlobalVar);
public static native LLVMValueRef LLVMGetPreviousGlobal(LLVMValueRef GlobalVar);
public static native void LLVMDeleteGlobal(LLVMValueRef GlobalVar);
public static native LLVMValueRef LLVMGetInitializer(LLVMValueRef GlobalVar);
public static native void LLVMSetInitializer(LLVMValueRef GlobalVar, LLVMValueRef ConstantVal);
public static native @Cast("LLVMBool") int LLVMIsThreadLocal(LLVMValueRef GlobalVar);
public static native void LLVMSetThreadLocal(LLVMValueRef GlobalVar, @Cast("LLVMBool") int IsThreadLocal);
public static native @Cast("LLVMBool") int LLVMIsGlobalConstant(LLVMValueRef GlobalVar);
public static native void LLVMSetGlobalConstant(LLVMValueRef GlobalVar, @Cast("LLVMBool") int IsConstant);
public static native @Cast("LLVMThreadLocalMode") int LLVMGetThreadLocalMode(LLVMValueRef GlobalVar);
public static native void LLVMSetThreadLocalMode(LLVMValueRef GlobalVar, @Cast("LLVMThreadLocalMode") int Mode);
public static native @Cast("LLVMBool") int LLVMIsExternallyInitialized(LLVMValueRef GlobalVar);
public static native void LLVMSetExternallyInitialized(LLVMValueRef GlobalVar, @Cast("LLVMBool") int IsExtInit);

/**
 * \}
 */

/**
 * \defgroup LLVMCoreValueConstantGlobalAlias Global Aliases
 *
 * This group contains function that operate on global alias values.
 *
 * @see llvm::GlobalAlias
 *
 * \{
 */



/**
 * Add a GlobalAlias with the given value type, address space and aliasee.
 *
 * @see llvm::GlobalAlias::create()
 */
public static native LLVMValueRef LLVMAddAlias2(LLVMModuleRef M, LLVMTypeRef ValueTy,
                           @Cast("unsigned") int AddrSpace, LLVMValueRef Aliasee,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMAddAlias2(LLVMModuleRef M, LLVMTypeRef ValueTy,
                           @Cast("unsigned") int AddrSpace, LLVMValueRef Aliasee,
                           String Name);

/**
 * Obtain a GlobalAlias value from a Module by its name.
 *
 * The returned value corresponds to a llvm::GlobalAlias value.
 *
 * @see llvm::Module::getNamedAlias()
 */
public static native LLVMValueRef LLVMGetNamedGlobalAlias(LLVMModuleRef M,
                                     @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen);
public static native LLVMValueRef LLVMGetNamedGlobalAlias(LLVMModuleRef M,
                                     String Name, @Cast("size_t") long NameLen);

/**
 * Obtain an iterator to the first GlobalAlias in a Module.
 *
 * @see llvm::Module::alias_begin()
 */
public static native LLVMValueRef LLVMGetFirstGlobalAlias(LLVMModuleRef M);

/**
 * Obtain an iterator to the last GlobalAlias in a Module.
 *
 * @see llvm::Module::alias_end()
 */
public static native LLVMValueRef LLVMGetLastGlobalAlias(LLVMModuleRef M);

/**
 * Advance a GlobalAlias iterator to the next GlobalAlias.
 *
 * Returns NULL if the iterator was already at the end and there are no more
 * global aliases.
 */
public static native LLVMValueRef LLVMGetNextGlobalAlias(LLVMValueRef GA);

/**
 * Decrement a GlobalAlias iterator to the previous GlobalAlias.
 *
 * Returns NULL if the iterator was already at the beginning and there are
 * no previous global aliases.
 */
public static native LLVMValueRef LLVMGetPreviousGlobalAlias(LLVMValueRef GA);

/**
 * Retrieve the target value of an alias.
 */
public static native LLVMValueRef LLVMAliasGetAliasee(LLVMValueRef Alias);

/**
 * Set the target value of an alias.
 */
public static native void LLVMAliasSetAliasee(LLVMValueRef Alias, LLVMValueRef Aliasee);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueFunction Function values
 *
 * Functions in this group operate on LLVMValueRef instances that
 * correspond to llvm::Function instances.
 *
 * @see llvm::Function
 *
 * \{
 */

/**
 * Remove a function from its containing module and deletes it.
 *
 * @see llvm::Function::eraseFromParent()
 */
public static native void LLVMDeleteFunction(LLVMValueRef Fn);

/**
 * Check whether the given function has a personality function.
 *
 * @see llvm::Function::hasPersonalityFn()
 */
public static native @Cast("LLVMBool") int LLVMHasPersonalityFn(LLVMValueRef Fn);

/**
 * Obtain the personality function attached to the function.
 *
 * @see llvm::Function::getPersonalityFn()
 */
public static native LLVMValueRef LLVMGetPersonalityFn(LLVMValueRef Fn);

/**
 * Set the personality function attached to the function.
 *
 * @see llvm::Function::setPersonalityFn()
 */
public static native void LLVMSetPersonalityFn(LLVMValueRef Fn, LLVMValueRef PersonalityFn);

/**
 * Obtain the intrinsic ID number which matches the given function name.
 *
 * @see llvm::Function::lookupIntrinsicID()
 */
public static native @Cast("unsigned") int LLVMLookupIntrinsicID(@Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen);
public static native @Cast("unsigned") int LLVMLookupIntrinsicID(String Name, @Cast("size_t") long NameLen);

/**
 * Obtain the ID number from a function instance.
 *
 * @see llvm::Function::getIntrinsicID()
 */
public static native @Cast("unsigned") int LLVMGetIntrinsicID(LLVMValueRef Fn);

/**
 * Create or insert the declaration of an intrinsic.  For overloaded intrinsics,
 * parameter types must be provided to uniquely identify an overload.
 *
 * @see llvm::Intrinsic::getDeclaration()
 */
public static native LLVMValueRef LLVMGetIntrinsicDeclaration(LLVMModuleRef Mod,
                                         @Cast("unsigned") int ID,
                                         @ByPtrPtr LLVMTypeRef ParamTypes,
                                         @Cast("size_t") long ParamCount);
public static native LLVMValueRef LLVMGetIntrinsicDeclaration(LLVMModuleRef Mod,
                                         @Cast("unsigned") int ID,
                                         @Cast("LLVMTypeRef*") PointerPointer ParamTypes,
                                         @Cast("size_t") long ParamCount);

/**
 * Retrieves the type of an intrinsic.  For overloaded intrinsics, parameter
 * types must be provided to uniquely identify an overload.
 *
 * @see llvm::Intrinsic::getType()
 */
public static native LLVMTypeRef LLVMIntrinsicGetType(LLVMContextRef Ctx, @Cast("unsigned") int ID,
                                 @ByPtrPtr LLVMTypeRef ParamTypes, @Cast("size_t") long ParamCount);
public static native LLVMTypeRef LLVMIntrinsicGetType(LLVMContextRef Ctx, @Cast("unsigned") int ID,
                                 @Cast("LLVMTypeRef*") PointerPointer ParamTypes, @Cast("size_t") long ParamCount);

/**
 * Retrieves the name of an intrinsic.
 *
 * @see llvm::Intrinsic::getName()
 */
public static native @Cast("const char*") BytePointer LLVMIntrinsicGetName(@Cast("unsigned") int ID, @Cast("size_t*") SizeTPointer NameLength);

/** Deprecated: Use LLVMIntrinsicCopyOverloadedName2 instead. */
public static native @Cast("const char*") BytePointer LLVMIntrinsicCopyOverloadedName(@Cast("unsigned") int ID,
                                            @ByPtrPtr LLVMTypeRef ParamTypes,
                                            @Cast("size_t") long ParamCount,
                                            @Cast("size_t*") SizeTPointer NameLength);
public static native String LLVMIntrinsicCopyOverloadedName(@Cast("unsigned") int ID,
                                            @Cast("LLVMTypeRef*") PointerPointer ParamTypes,
                                            @Cast("size_t") long ParamCount,
                                            @Cast("size_t*") SizeTPointer NameLength);

/**
 * Copies the name of an overloaded intrinsic identified by a given list of
 * parameter types.
 *
 * Unlike LLVMIntrinsicGetName, the caller is responsible for freeing the
 * returned string.
 *
 * This version also supports unnamed types.
 *
 * @see llvm::Intrinsic::getName()
 */
public static native @Cast("const char*") BytePointer LLVMIntrinsicCopyOverloadedName2(LLVMModuleRef Mod, @Cast("unsigned") int ID,
                                             @ByPtrPtr LLVMTypeRef ParamTypes,
                                             @Cast("size_t") long ParamCount,
                                             @Cast("size_t*") SizeTPointer NameLength);
public static native String LLVMIntrinsicCopyOverloadedName2(LLVMModuleRef Mod, @Cast("unsigned") int ID,
                                             @Cast("LLVMTypeRef*") PointerPointer ParamTypes,
                                             @Cast("size_t") long ParamCount,
                                             @Cast("size_t*") SizeTPointer NameLength);

/**
 * Obtain if the intrinsic identified by the given ID is overloaded.
 *
 * @see llvm::Intrinsic::isOverloaded()
 */
public static native @Cast("LLVMBool") int LLVMIntrinsicIsOverloaded(@Cast("unsigned") int ID);

/**
 * Obtain the calling function of a function.
 *
 * The returned value corresponds to the LLVMCallConv enumeration.
 *
 * @see llvm::Function::getCallingConv()
 */
public static native @Cast("unsigned") int LLVMGetFunctionCallConv(LLVMValueRef Fn);

/**
 * Set the calling convention of a function.
 *
 * @see llvm::Function::setCallingConv()
 *
 * @param Fn Function to operate on
 * @param CC LLVMCallConv to set calling convention to
 */
public static native void LLVMSetFunctionCallConv(LLVMValueRef Fn, @Cast("unsigned") int CC);

/**
 * Obtain the name of the garbage collector to use during code
 * generation.
 *
 * @see llvm::Function::getGC()
 */
public static native @Cast("const char*") BytePointer LLVMGetGC(LLVMValueRef Fn);

/**
 * Define the garbage collector to use during code generation.
 *
 * @see llvm::Function::setGC()
 */
public static native void LLVMSetGC(LLVMValueRef Fn, @Cast("const char*") BytePointer Name);
public static native void LLVMSetGC(LLVMValueRef Fn, String Name);

/**
 * Add an attribute to a function.
 *
 * @see llvm::Function::addAttribute()
 */
public static native void LLVMAddAttributeAtIndex(LLVMValueRef F, @Cast("LLVMAttributeIndex") int Idx,
                             LLVMAttributeRef A);
public static native @Cast("unsigned") int LLVMGetAttributeCountAtIndex(LLVMValueRef F, @Cast("LLVMAttributeIndex") int Idx);
public static native void LLVMGetAttributesAtIndex(LLVMValueRef F, @Cast("LLVMAttributeIndex") int Idx,
                              @ByPtrPtr LLVMAttributeRef Attrs);
public static native void LLVMGetAttributesAtIndex(LLVMValueRef F, @Cast("LLVMAttributeIndex") int Idx,
                              @Cast("LLVMAttributeRef*") PointerPointer Attrs);
public static native LLVMAttributeRef LLVMGetEnumAttributeAtIndex(LLVMValueRef F,
                                             @Cast("LLVMAttributeIndex") int Idx,
                                             @Cast("unsigned") int KindID);
public static native LLVMAttributeRef LLVMGetStringAttributeAtIndex(LLVMValueRef F,
                                               @Cast("LLVMAttributeIndex") int Idx,
                                               @Cast("const char*") BytePointer K, @Cast("unsigned") int KLen);
public static native LLVMAttributeRef LLVMGetStringAttributeAtIndex(LLVMValueRef F,
                                               @Cast("LLVMAttributeIndex") int Idx,
                                               String K, @Cast("unsigned") int KLen);
public static native void LLVMRemoveEnumAttributeAtIndex(LLVMValueRef F, @Cast("LLVMAttributeIndex") int Idx,
                                    @Cast("unsigned") int KindID);
public static native void LLVMRemoveStringAttributeAtIndex(LLVMValueRef F, @Cast("LLVMAttributeIndex") int Idx,
                                      @Cast("const char*") BytePointer K, @Cast("unsigned") int KLen);
public static native void LLVMRemoveStringAttributeAtIndex(LLVMValueRef F, @Cast("LLVMAttributeIndex") int Idx,
                                      String K, @Cast("unsigned") int KLen);

/**
 * Add a target-dependent attribute to a function
 * @see llvm::AttrBuilder::addAttribute()
 */
public static native void LLVMAddTargetDependentFunctionAttr(LLVMValueRef Fn, @Cast("const char*") BytePointer A,
                                        @Cast("const char*") BytePointer V);
public static native void LLVMAddTargetDependentFunctionAttr(LLVMValueRef Fn, String A,
                                        String V);

/**
 * \defgroup LLVMCCoreValueFunctionParameters Function Parameters
 *
 * Functions in this group relate to arguments/parameters on functions.
 *
 * Functions in this group expect LLVMValueRef instances that correspond
 * to llvm::Function instances.
 *
 * \{
 */

/**
 * Obtain the number of parameters in a function.
 *
 * @see llvm::Function::arg_size()
 */
public static native @Cast("unsigned") int LLVMCountParams(LLVMValueRef Fn);

/**
 * Obtain the parameters in a function.
 *
 * The takes a pointer to a pre-allocated array of LLVMValueRef that is
 * at least LLVMCountParams() long. This array will be filled with
 * LLVMValueRef instances which correspond to the parameters the
 * function receives. Each LLVMValueRef corresponds to a llvm::Argument
 * instance.
 *
 * @see llvm::Function::arg_begin()
 */
public static native void LLVMGetParams(LLVMValueRef Fn, @ByPtrPtr LLVMValueRef Params);
public static native void LLVMGetParams(LLVMValueRef Fn, @Cast("LLVMValueRef*") PointerPointer Params);

/**
 * Obtain the parameter at the specified index.
 *
 * Parameters are indexed from 0.
 *
 * @see llvm::Function::arg_begin()
 */
public static native LLVMValueRef LLVMGetParam(LLVMValueRef Fn, @Cast("unsigned") int Index);

/**
 * Obtain the function to which this argument belongs.
 *
 * Unlike other functions in this group, this one takes an LLVMValueRef
 * that corresponds to a llvm::Attribute.
 *
 * The returned LLVMValueRef is the llvm::Function to which this
 * argument belongs.
 */
public static native LLVMValueRef LLVMGetParamParent(LLVMValueRef Inst);

/**
 * Obtain the first parameter to a function.
 *
 * @see llvm::Function::arg_begin()
 */
public static native LLVMValueRef LLVMGetFirstParam(LLVMValueRef Fn);

/**
 * Obtain the last parameter to a function.
 *
 * @see llvm::Function::arg_end()
 */
public static native LLVMValueRef LLVMGetLastParam(LLVMValueRef Fn);

/**
 * Obtain the next parameter to a function.
 *
 * This takes an LLVMValueRef obtained from LLVMGetFirstParam() (which is
 * actually a wrapped iterator) and obtains the next parameter from the
 * underlying iterator.
 */
public static native LLVMValueRef LLVMGetNextParam(LLVMValueRef Arg);

/**
 * Obtain the previous parameter to a function.
 *
 * This is the opposite of LLVMGetNextParam().
 */
public static native LLVMValueRef LLVMGetPreviousParam(LLVMValueRef Arg);

/**
 * Set the alignment for a function parameter.
 *
 * @see llvm::Argument::addAttr()
 * @see llvm::AttrBuilder::addAlignmentAttr()
 */
public static native void LLVMSetParamAlignment(LLVMValueRef Arg, @Cast("unsigned") int Align);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueGlobalIFunc IFuncs
 *
 * Functions in this group relate to indirect functions.
 *
 * Functions in this group expect LLVMValueRef instances that correspond
 * to llvm::GlobalIFunc instances.
 *
 * \{
 */

/**
 * Add a global indirect function to a module under a specified name.
 *
 * @see llvm::GlobalIFunc::create()
 */
public static native LLVMValueRef LLVMAddGlobalIFunc(LLVMModuleRef M,
                                @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                                LLVMTypeRef Ty, @Cast("unsigned") int AddrSpace,
                                LLVMValueRef Resolver);
public static native LLVMValueRef LLVMAddGlobalIFunc(LLVMModuleRef M,
                                String Name, @Cast("size_t") long NameLen,
                                LLVMTypeRef Ty, @Cast("unsigned") int AddrSpace,
                                LLVMValueRef Resolver);

/**
 * Obtain a GlobalIFunc value from a Module by its name.
 *
 * The returned value corresponds to a llvm::GlobalIFunc value.
 *
 * @see llvm::Module::getNamedIFunc()
 */
public static native LLVMValueRef LLVMGetNamedGlobalIFunc(LLVMModuleRef M,
                                     @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen);
public static native LLVMValueRef LLVMGetNamedGlobalIFunc(LLVMModuleRef M,
                                     String Name, @Cast("size_t") long NameLen);

/**
 * Obtain an iterator to the first GlobalIFunc in a Module.
 *
 * @see llvm::Module::ifunc_begin()
 */
public static native LLVMValueRef LLVMGetFirstGlobalIFunc(LLVMModuleRef M);

/**
 * Obtain an iterator to the last GlobalIFunc in a Module.
 *
 * @see llvm::Module::ifunc_end()
 */
public static native LLVMValueRef LLVMGetLastGlobalIFunc(LLVMModuleRef M);

/**
 * Advance a GlobalIFunc iterator to the next GlobalIFunc.
 *
 * Returns NULL if the iterator was already at the end and there are no more
 * global aliases.
 */
public static native LLVMValueRef LLVMGetNextGlobalIFunc(LLVMValueRef IFunc);

/**
 * Decrement a GlobalIFunc iterator to the previous GlobalIFunc.
 *
 * Returns NULL if the iterator was already at the beginning and there are
 * no previous global aliases.
 */
public static native LLVMValueRef LLVMGetPreviousGlobalIFunc(LLVMValueRef IFunc);

/**
 * Retrieves the resolver function associated with this indirect function, or
 * NULL if it doesn't not exist.
 *
 * @see llvm::GlobalIFunc::getResolver()
 */
public static native LLVMValueRef LLVMGetGlobalIFuncResolver(LLVMValueRef IFunc);

/**
 * Sets the resolver function associated with this indirect function.
 *
 * @see llvm::GlobalIFunc::setResolver()
 */
public static native void LLVMSetGlobalIFuncResolver(LLVMValueRef IFunc, LLVMValueRef Resolver);

/**
 * Remove a global indirect function from its parent module and delete it.
 *
 * @see llvm::GlobalIFunc::eraseFromParent()
 */
public static native void LLVMEraseGlobalIFunc(LLVMValueRef IFunc);

/**
 * Remove a global indirect function from its parent module.
 *
 * This unlinks the global indirect function from its containing module but
 * keeps it alive.
 *
 * @see llvm::GlobalIFunc::removeFromParent()
 */
public static native void LLVMRemoveGlobalIFunc(LLVMValueRef IFunc);

/**
 * \}
 */

/**
 * \}
 */

/**
 * \}
 */

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueMetadata Metadata
 *
 * \{
 */

/**
 * Create an MDString value from a given string value.
 *
 * The MDString value does not take ownership of the given string, it remains
 * the responsibility of the caller to free it.
 *
 * @see llvm::MDString::get()
 */
public static native LLVMMetadataRef LLVMMDStringInContext2(LLVMContextRef C, @Cast("const char*") BytePointer Str,
                                       @Cast("size_t") long SLen);
public static native LLVMMetadataRef LLVMMDStringInContext2(LLVMContextRef C, String Str,
                                       @Cast("size_t") long SLen);

/**
 * Create an MDNode value with the given array of operands.
 *
 * @see llvm::MDNode::get()
 */
public static native LLVMMetadataRef LLVMMDNodeInContext2(LLVMContextRef C, @ByPtrPtr LLVMMetadataRef MDs,
                                     @Cast("size_t") long Count);
public static native LLVMMetadataRef LLVMMDNodeInContext2(LLVMContextRef C, @Cast("LLVMMetadataRef*") PointerPointer MDs,
                                     @Cast("size_t") long Count);

/**
 * Obtain a Metadata as a Value.
 */
public static native LLVMValueRef LLVMMetadataAsValue(LLVMContextRef C, LLVMMetadataRef MD);

/**
 * Obtain a Value as a Metadata.
 */
public static native LLVMMetadataRef LLVMValueAsMetadata(LLVMValueRef Val);

/**
 * Obtain the underlying string from a MDString value.
 *
 * @param V Instance to obtain string from.
 * @param Length Memory address which will hold length of returned string.
 * @return String data in MDString.
 */
public static native @Cast("const char*") BytePointer LLVMGetMDString(LLVMValueRef V, @Cast("unsigned*") IntPointer Length);
public static native String LLVMGetMDString(LLVMValueRef V, @Cast("unsigned*") IntBuffer Length);
public static native @Cast("const char*") BytePointer LLVMGetMDString(LLVMValueRef V, @Cast("unsigned*") int[] Length);

/**
 * Obtain the number of operands from an MDNode value.
 *
 * @param V MDNode to get number of operands from.
 * @return Number of operands of the MDNode.
 */
public static native @Cast("unsigned") int LLVMGetMDNodeNumOperands(LLVMValueRef V);

/**
 * Obtain the given MDNode's operands.
 *
 * The passed LLVMValueRef pointer should point to enough memory to hold all of
 * the operands of the given MDNode (see LLVMGetMDNodeNumOperands) as
 * LLVMValueRefs. This memory will be populated with the LLVMValueRefs of the
 * MDNode's operands.
 *
 * @param V MDNode to get the operands from.
 * @param Dest Destination array for operands.
 */
public static native void LLVMGetMDNodeOperands(LLVMValueRef V, @ByPtrPtr LLVMValueRef Dest);
public static native void LLVMGetMDNodeOperands(LLVMValueRef V, @Cast("LLVMValueRef*") PointerPointer Dest);

/** Deprecated: Use LLVMMDStringInContext2 instead. */
public static native LLVMValueRef LLVMMDStringInContext(LLVMContextRef C, @Cast("const char*") BytePointer Str,
                                   @Cast("unsigned") int SLen);
public static native LLVMValueRef LLVMMDStringInContext(LLVMContextRef C, String Str,
                                   @Cast("unsigned") int SLen);
/** Deprecated: Use LLVMMDStringInContext2 instead. */
public static native LLVMValueRef LLVMMDString(@Cast("const char*") BytePointer Str, @Cast("unsigned") int SLen);
public static native LLVMValueRef LLVMMDString(String Str, @Cast("unsigned") int SLen);
/** Deprecated: Use LLVMMDNodeInContext2 instead. */
public static native LLVMValueRef LLVMMDNodeInContext(LLVMContextRef C, @ByPtrPtr LLVMValueRef Vals,
                                 @Cast("unsigned") int Count);
public static native LLVMValueRef LLVMMDNodeInContext(LLVMContextRef C, @Cast("LLVMValueRef*") PointerPointer Vals,
                                 @Cast("unsigned") int Count);
/** Deprecated: Use LLVMMDNodeInContext2 instead. */
public static native LLVMValueRef LLVMMDNode(@ByPtrPtr LLVMValueRef Vals, @Cast("unsigned") int Count);
public static native LLVMValueRef LLVMMDNode(@Cast("LLVMValueRef*") PointerPointer Vals, @Cast("unsigned") int Count);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueBasicBlock Basic Block
 *
 * A basic block represents a single entry single exit section of code.
 * Basic blocks contain a list of instructions which form the body of
 * the block.
 *
 * Basic blocks belong to functions. They have the type of label.
 *
 * Basic blocks are themselves values. However, the C API models them as
 * LLVMBasicBlockRef.
 *
 * @see llvm::BasicBlock
 *
 * \{
 */

/**
 * Convert a basic block instance to a value type.
 */
public static native LLVMValueRef LLVMBasicBlockAsValue(LLVMBasicBlockRef BB);

/**
 * Determine whether an LLVMValueRef is itself a basic block.
 */
public static native @Cast("LLVMBool") int LLVMValueIsBasicBlock(LLVMValueRef Val);

/**
 * Convert an LLVMValueRef to an LLVMBasicBlockRef instance.
 */
public static native LLVMBasicBlockRef LLVMValueAsBasicBlock(LLVMValueRef Val);

/**
 * Obtain the string name of a basic block.
 */
public static native @Cast("const char*") BytePointer LLVMGetBasicBlockName(LLVMBasicBlockRef BB);

/**
 * Obtain the function to which a basic block belongs.
 *
 * @see llvm::BasicBlock::getParent()
 */
public static native LLVMValueRef LLVMGetBasicBlockParent(LLVMBasicBlockRef BB);

/**
 * Obtain the terminator instruction for a basic block.
 *
 * If the basic block does not have a terminator (it is not well-formed
 * if it doesn't), then NULL is returned.
 *
 * The returned LLVMValueRef corresponds to an llvm::Instruction.
 *
 * @see llvm::BasicBlock::getTerminator()
 */
public static native LLVMValueRef LLVMGetBasicBlockTerminator(LLVMBasicBlockRef BB);

/**
 * Obtain the number of basic blocks in a function.
 *
 * @param Fn Function value to operate on.
 */
public static native @Cast("unsigned") int LLVMCountBasicBlocks(LLVMValueRef Fn);

/**
 * Obtain all of the basic blocks in a function.
 *
 * This operates on a function value. The BasicBlocks parameter is a
 * pointer to a pre-allocated array of LLVMBasicBlockRef of at least
 * LLVMCountBasicBlocks() in length. This array is populated with
 * LLVMBasicBlockRef instances.
 */
public static native void LLVMGetBasicBlocks(LLVMValueRef Fn, @ByPtrPtr LLVMBasicBlockRef BasicBlocks);
public static native void LLVMGetBasicBlocks(LLVMValueRef Fn, @Cast("LLVMBasicBlockRef*") PointerPointer BasicBlocks);

/**
 * Obtain the first basic block in a function.
 *
 * The returned basic block can be used as an iterator. You will likely
 * eventually call into LLVMGetNextBasicBlock() with it.
 *
 * @see llvm::Function::begin()
 */
public static native LLVMBasicBlockRef LLVMGetFirstBasicBlock(LLVMValueRef Fn);

/**
 * Obtain the last basic block in a function.
 *
 * @see llvm::Function::end()
 */
public static native LLVMBasicBlockRef LLVMGetLastBasicBlock(LLVMValueRef Fn);

/**
 * Advance a basic block iterator.
 */
public static native LLVMBasicBlockRef LLVMGetNextBasicBlock(LLVMBasicBlockRef BB);

/**
 * Go backwards in a basic block iterator.
 */
public static native LLVMBasicBlockRef LLVMGetPreviousBasicBlock(LLVMBasicBlockRef BB);

/**
 * Obtain the basic block that corresponds to the entry point of a
 * function.
 *
 * @see llvm::Function::getEntryBlock()
 */
public static native LLVMBasicBlockRef LLVMGetEntryBasicBlock(LLVMValueRef Fn);

/**
 * Insert the given basic block after the insertion point of the given builder.
 *
 * The insertion point must be valid.
 *
 * @see llvm::Function::BasicBlockListType::insertAfter()
 */
public static native void LLVMInsertExistingBasicBlockAfterInsertBlock(LLVMBuilderRef Builder,
                                                  LLVMBasicBlockRef BB);

/**
 * Append the given basic block to the basic block list of the given function.
 *
 * @see llvm::Function::BasicBlockListType::push_back()
 */
public static native void LLVMAppendExistingBasicBlock(LLVMValueRef Fn,
                                  LLVMBasicBlockRef BB);

/**
 * Create a new basic block without inserting it into a function.
 *
 * @see llvm::BasicBlock::Create()
 */
public static native LLVMBasicBlockRef LLVMCreateBasicBlockInContext(LLVMContextRef C,
                                                @Cast("const char*") BytePointer Name);
public static native LLVMBasicBlockRef LLVMCreateBasicBlockInContext(LLVMContextRef C,
                                                String Name);

/**
 * Append a basic block to the end of a function.
 *
 * @see llvm::BasicBlock::Create()
 */
public static native LLVMBasicBlockRef LLVMAppendBasicBlockInContext(LLVMContextRef C,
                                                LLVMValueRef Fn,
                                                @Cast("const char*") BytePointer Name);
public static native LLVMBasicBlockRef LLVMAppendBasicBlockInContext(LLVMContextRef C,
                                                LLVMValueRef Fn,
                                                String Name);

/**
 * Append a basic block to the end of a function using the global
 * context.
 *
 * @see llvm::BasicBlock::Create()
 */
public static native LLVMBasicBlockRef LLVMAppendBasicBlock(LLVMValueRef Fn, @Cast("const char*") BytePointer Name);
public static native LLVMBasicBlockRef LLVMAppendBasicBlock(LLVMValueRef Fn, String Name);

/**
 * Insert a basic block in a function before another basic block.
 *
 * The function to add to is determined by the function of the
 * passed basic block.
 *
 * @see llvm::BasicBlock::Create()
 */
public static native LLVMBasicBlockRef LLVMInsertBasicBlockInContext(LLVMContextRef C,
                                                LLVMBasicBlockRef BB,
                                                @Cast("const char*") BytePointer Name);
public static native LLVMBasicBlockRef LLVMInsertBasicBlockInContext(LLVMContextRef C,
                                                LLVMBasicBlockRef BB,
                                                String Name);

/**
 * Insert a basic block in a function using the global context.
 *
 * @see llvm::BasicBlock::Create()
 */
public static native LLVMBasicBlockRef LLVMInsertBasicBlock(LLVMBasicBlockRef InsertBeforeBB,
                                       @Cast("const char*") BytePointer Name);
public static native LLVMBasicBlockRef LLVMInsertBasicBlock(LLVMBasicBlockRef InsertBeforeBB,
                                       String Name);

/**
 * Remove a basic block from a function and delete it.
 *
 * This deletes the basic block from its containing function and deletes
 * the basic block itself.
 *
 * @see llvm::BasicBlock::eraseFromParent()
 */
public static native void LLVMDeleteBasicBlock(LLVMBasicBlockRef BB);

/**
 * Remove a basic block from a function.
 *
 * This deletes the basic block from its containing function but keep
 * the basic block alive.
 *
 * @see llvm::BasicBlock::removeFromParent()
 */
public static native void LLVMRemoveBasicBlockFromParent(LLVMBasicBlockRef BB);

/**
 * Move a basic block to before another one.
 *
 * @see llvm::BasicBlock::moveBefore()
 */
public static native void LLVMMoveBasicBlockBefore(LLVMBasicBlockRef BB, LLVMBasicBlockRef MovePos);

/**
 * Move a basic block to after another one.
 *
 * @see llvm::BasicBlock::moveAfter()
 */
public static native void LLVMMoveBasicBlockAfter(LLVMBasicBlockRef BB, LLVMBasicBlockRef MovePos);

/**
 * Obtain the first instruction in a basic block.
 *
 * The returned LLVMValueRef corresponds to a llvm::Instruction
 * instance.
 */
public static native LLVMValueRef LLVMGetFirstInstruction(LLVMBasicBlockRef BB);

/**
 * Obtain the last instruction in a basic block.
 *
 * The returned LLVMValueRef corresponds to an LLVM:Instruction.
 */
public static native LLVMValueRef LLVMGetLastInstruction(LLVMBasicBlockRef BB);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueInstruction Instructions
 *
 * Functions in this group relate to the inspection and manipulation of
 * individual instructions.
 *
 * In the C++ API, an instruction is modeled by llvm::Instruction. This
 * class has a large number of descendents. llvm::Instruction is a
 * llvm::Value and in the C API, instructions are modeled by
 * LLVMValueRef.
 *
 * This group also contains sub-groups which operate on specific
 * llvm::Instruction types, e.g. llvm::CallInst.
 *
 * \{
 */

/**
 * Determine whether an instruction has any metadata attached.
 */
public static native int LLVMHasMetadata(LLVMValueRef Val);

/**
 * Return metadata associated with an instruction value.
 */
public static native LLVMValueRef LLVMGetMetadata(LLVMValueRef Val, @Cast("unsigned") int KindID);

/**
 * Set metadata associated with an instruction value.
 */
public static native void LLVMSetMetadata(LLVMValueRef Val, @Cast("unsigned") int KindID, LLVMValueRef Node);

/**
 * Returns the metadata associated with an instruction value, but filters out
 * all the debug locations.
 *
 * @see llvm::Instruction::getAllMetadataOtherThanDebugLoc()
 */
public static native LLVMValueMetadataEntry LLVMInstructionGetAllMetadataOtherThanDebugLoc(LLVMValueRef Instr,
                                               @Cast("size_t*") SizeTPointer NumEntries);

/**
 * Obtain the basic block to which an instruction belongs.
 *
 * @see llvm::Instruction::getParent()
 */
public static native LLVMBasicBlockRef LLVMGetInstructionParent(LLVMValueRef Inst);

/**
 * Obtain the instruction that occurs after the one specified.
 *
 * The next instruction will be from the same basic block.
 *
 * If this is the last instruction in a basic block, NULL will be
 * returned.
 */
public static native LLVMValueRef LLVMGetNextInstruction(LLVMValueRef Inst);

/**
 * Obtain the instruction that occurred before this one.
 *
 * If the instruction is the first instruction in a basic block, NULL
 * will be returned.
 */
public static native LLVMValueRef LLVMGetPreviousInstruction(LLVMValueRef Inst);

/**
 * Remove an instruction.
 *
 * The instruction specified is removed from its containing building
 * block but is kept alive.
 *
 * @see llvm::Instruction::removeFromParent()
 */
public static native void LLVMInstructionRemoveFromParent(LLVMValueRef Inst);

/**
 * Remove and delete an instruction.
 *
 * The instruction specified is removed from its containing building
 * block and then deleted.
 *
 * @see llvm::Instruction::eraseFromParent()
 */
public static native void LLVMInstructionEraseFromParent(LLVMValueRef Inst);

/**
 * Delete an instruction.
 *
 * The instruction specified is deleted. It must have previously been
 * removed from its containing building block.
 *
 * @see llvm::Value::deleteValue()
 */
public static native void LLVMDeleteInstruction(LLVMValueRef Inst);

/**
 * Obtain the code opcode for an individual instruction.
 *
 * @see llvm::Instruction::getOpCode()
 */
public static native @Cast("LLVMOpcode") int LLVMGetInstructionOpcode(LLVMValueRef Inst);

/**
 * Obtain the predicate of an instruction.
 *
 * This is only valid for instructions that correspond to llvm::ICmpInst
 * or llvm::ConstantExpr whose opcode is llvm::Instruction::ICmp.
 *
 * @see llvm::ICmpInst::getPredicate()
 */
public static native @Cast("LLVMIntPredicate") int LLVMGetICmpPredicate(LLVMValueRef Inst);

/**
 * Obtain the float predicate of an instruction.
 *
 * This is only valid for instructions that correspond to llvm::FCmpInst
 * or llvm::ConstantExpr whose opcode is llvm::Instruction::FCmp.
 *
 * @see llvm::FCmpInst::getPredicate()
 */
public static native @Cast("LLVMRealPredicate") int LLVMGetFCmpPredicate(LLVMValueRef Inst);

/**
 * Create a copy of 'this' instruction that is identical in all ways
 * except the following:
 *   * The instruction has no parent
 *   * The instruction has no name
 *
 * @see llvm::Instruction::clone()
 */
public static native LLVMValueRef LLVMInstructionClone(LLVMValueRef Inst);

/**
 * Determine whether an instruction is a terminator. This routine is named to
 * be compatible with historical functions that did this by querying the
 * underlying C++ type.
 *
 * @see llvm::Instruction::isTerminator()
 */
public static native LLVMValueRef LLVMIsATerminatorInst(LLVMValueRef Inst);

/**
 * \defgroup LLVMCCoreValueInstructionCall Call Sites and Invocations
 *
 * Functions in this group apply to instructions that refer to call
 * sites and invocations. These correspond to C++ types in the
 * llvm::CallInst class tree.
 *
 * \{
 */

/**
 * Obtain the argument count for a call instruction.
 *
 * This expects an LLVMValueRef that corresponds to a llvm::CallInst,
 * llvm::InvokeInst, or llvm:FuncletPadInst.
 *
 * @see llvm::CallInst::getNumArgOperands()
 * @see llvm::InvokeInst::getNumArgOperands()
 * @see llvm::FuncletPadInst::getNumArgOperands()
 */
public static native @Cast("unsigned") int LLVMGetNumArgOperands(LLVMValueRef Instr);

/**
 * Set the calling convention for a call instruction.
 *
 * This expects an LLVMValueRef that corresponds to a llvm::CallInst or
 * llvm::InvokeInst.
 *
 * @see llvm::CallInst::setCallingConv()
 * @see llvm::InvokeInst::setCallingConv()
 */
public static native void LLVMSetInstructionCallConv(LLVMValueRef Instr, @Cast("unsigned") int CC);

/**
 * Obtain the calling convention for a call instruction.
 *
 * This is the opposite of LLVMSetInstructionCallConv(). Reads its
 * usage.
 *
 * @see LLVMSetInstructionCallConv()
 */
public static native @Cast("unsigned") int LLVMGetInstructionCallConv(LLVMValueRef Instr);

public static native void LLVMSetInstrParamAlignment(LLVMValueRef Instr, @Cast("LLVMAttributeIndex") int Idx,
                                @Cast("unsigned") int Align);

public static native void LLVMAddCallSiteAttribute(LLVMValueRef C, @Cast("LLVMAttributeIndex") int Idx,
                              LLVMAttributeRef A);
public static native @Cast("unsigned") int LLVMGetCallSiteAttributeCount(LLVMValueRef C, @Cast("LLVMAttributeIndex") int Idx);
public static native void LLVMGetCallSiteAttributes(LLVMValueRef C, @Cast("LLVMAttributeIndex") int Idx,
                               @ByPtrPtr LLVMAttributeRef Attrs);
public static native void LLVMGetCallSiteAttributes(LLVMValueRef C, @Cast("LLVMAttributeIndex") int Idx,
                               @Cast("LLVMAttributeRef*") PointerPointer Attrs);
public static native LLVMAttributeRef LLVMGetCallSiteEnumAttribute(LLVMValueRef C,
                                              @Cast("LLVMAttributeIndex") int Idx,
                                              @Cast("unsigned") int KindID);
public static native LLVMAttributeRef LLVMGetCallSiteStringAttribute(LLVMValueRef C,
                                                @Cast("LLVMAttributeIndex") int Idx,
                                                @Cast("const char*") BytePointer K, @Cast("unsigned") int KLen);
public static native LLVMAttributeRef LLVMGetCallSiteStringAttribute(LLVMValueRef C,
                                                @Cast("LLVMAttributeIndex") int Idx,
                                                String K, @Cast("unsigned") int KLen);
public static native void LLVMRemoveCallSiteEnumAttribute(LLVMValueRef C, @Cast("LLVMAttributeIndex") int Idx,
                                     @Cast("unsigned") int KindID);
public static native void LLVMRemoveCallSiteStringAttribute(LLVMValueRef C, @Cast("LLVMAttributeIndex") int Idx,
                                       @Cast("const char*") BytePointer K, @Cast("unsigned") int KLen);
public static native void LLVMRemoveCallSiteStringAttribute(LLVMValueRef C, @Cast("LLVMAttributeIndex") int Idx,
                                       String K, @Cast("unsigned") int KLen);

/**
 * Obtain the function type called by this instruction.
 *
 * @see llvm::CallBase::getFunctionType()
 */
public static native LLVMTypeRef LLVMGetCalledFunctionType(LLVMValueRef C);

/**
 * Obtain the pointer to the function invoked by this instruction.
 *
 * This expects an LLVMValueRef that corresponds to a llvm::CallInst or
 * llvm::InvokeInst.
 *
 * @see llvm::CallInst::getCalledOperand()
 * @see llvm::InvokeInst::getCalledOperand()
 */
public static native LLVMValueRef LLVMGetCalledValue(LLVMValueRef Instr);

/**
 * Obtain whether a call instruction is a tail call.
 *
 * This only works on llvm::CallInst instructions.
 *
 * @see llvm::CallInst::isTailCall()
 */
public static native @Cast("LLVMBool") int LLVMIsTailCall(LLVMValueRef CallInst);

/**
 * Set whether a call instruction is a tail call.
 *
 * This only works on llvm::CallInst instructions.
 *
 * @see llvm::CallInst::setTailCall()
 */
public static native void LLVMSetTailCall(LLVMValueRef CallInst, @Cast("LLVMBool") int IsTailCall);

/**
 * Return the normal destination basic block.
 *
 * This only works on llvm::InvokeInst instructions.
 *
 * @see llvm::InvokeInst::getNormalDest()
 */
public static native LLVMBasicBlockRef LLVMGetNormalDest(LLVMValueRef InvokeInst);

/**
 * Return the unwind destination basic block.
 *
 * Works on llvm::InvokeInst, llvm::CleanupReturnInst, and
 * llvm::CatchSwitchInst instructions.
 *
 * @see llvm::InvokeInst::getUnwindDest()
 * @see llvm::CleanupReturnInst::getUnwindDest()
 * @see llvm::CatchSwitchInst::getUnwindDest()
 */
public static native LLVMBasicBlockRef LLVMGetUnwindDest(LLVMValueRef InvokeInst);

/**
 * Set the normal destination basic block.
 *
 * This only works on llvm::InvokeInst instructions.
 *
 * @see llvm::InvokeInst::setNormalDest()
 */
public static native void LLVMSetNormalDest(LLVMValueRef InvokeInst, LLVMBasicBlockRef B);

/**
 * Set the unwind destination basic block.
 *
 * Works on llvm::InvokeInst, llvm::CleanupReturnInst, and
 * llvm::CatchSwitchInst instructions.
 *
 * @see llvm::InvokeInst::setUnwindDest()
 * @see llvm::CleanupReturnInst::setUnwindDest()
 * @see llvm::CatchSwitchInst::setUnwindDest()
 */
public static native void LLVMSetUnwindDest(LLVMValueRef InvokeInst, LLVMBasicBlockRef B);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueInstructionTerminator Terminators
 *
 * Functions in this group only apply to instructions for which
 * LLVMIsATerminatorInst returns true.
 *
 * \{
 */

/**
 * Return the number of successors that this terminator has.
 *
 * @see llvm::Instruction::getNumSuccessors
 */
public static native @Cast("unsigned") int LLVMGetNumSuccessors(LLVMValueRef Term);

/**
 * Return the specified successor.
 *
 * @see llvm::Instruction::getSuccessor
 */
public static native LLVMBasicBlockRef LLVMGetSuccessor(LLVMValueRef Term, @Cast("unsigned") int i);

/**
 * Update the specified successor to point at the provided block.
 *
 * @see llvm::Instruction::setSuccessor
 */
public static native void LLVMSetSuccessor(LLVMValueRef Term, @Cast("unsigned") int i, LLVMBasicBlockRef block);

/**
 * Return if a branch is conditional.
 *
 * This only works on llvm::BranchInst instructions.
 *
 * @see llvm::BranchInst::isConditional
 */
public static native @Cast("LLVMBool") int LLVMIsConditional(LLVMValueRef Branch);

/**
 * Return the condition of a branch instruction.
 *
 * This only works on llvm::BranchInst instructions.
 *
 * @see llvm::BranchInst::getCondition
 */
public static native LLVMValueRef LLVMGetCondition(LLVMValueRef Branch);

/**
 * Set the condition of a branch instruction.
 *
 * This only works on llvm::BranchInst instructions.
 *
 * @see llvm::BranchInst::setCondition
 */
public static native void LLVMSetCondition(LLVMValueRef Branch, LLVMValueRef Cond);

/**
 * Obtain the default destination basic block of a switch instruction.
 *
 * This only works on llvm::SwitchInst instructions.
 *
 * @see llvm::SwitchInst::getDefaultDest()
 */
public static native LLVMBasicBlockRef LLVMGetSwitchDefaultDest(LLVMValueRef SwitchInstr);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueInstructionAlloca Allocas
 *
 * Functions in this group only apply to instructions that map to
 * llvm::AllocaInst instances.
 *
 * \{
 */

/**
 * Obtain the type that is being allocated by the alloca instruction.
 */
public static native LLVMTypeRef LLVMGetAllocatedType(LLVMValueRef Alloca);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueInstructionGetElementPointer GEPs
 *
 * Functions in this group only apply to instructions that map to
 * llvm::GetElementPtrInst instances.
 *
 * \{
 */

/**
 * Check whether the given GEP operator is inbounds.
 */
public static native @Cast("LLVMBool") int LLVMIsInBounds(LLVMValueRef GEP);

/**
 * Set the given GEP instruction to be inbounds or not.
 */
public static native void LLVMSetIsInBounds(LLVMValueRef GEP, @Cast("LLVMBool") int InBounds);

/**
 * Get the source element type of the given GEP operator.
 */
public static native LLVMTypeRef LLVMGetGEPSourceElementType(LLVMValueRef GEP);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueInstructionPHINode PHI Nodes
 *
 * Functions in this group only apply to instructions that map to
 * llvm::PHINode instances.
 *
 * \{
 */

/**
 * Add an incoming value to the end of a PHI list.
 */
public static native void LLVMAddIncoming(LLVMValueRef PhiNode, @ByPtrPtr LLVMValueRef IncomingValues,
                     @ByPtrPtr LLVMBasicBlockRef IncomingBlocks, @Cast("unsigned") int Count);
public static native void LLVMAddIncoming(LLVMValueRef PhiNode, @Cast("LLVMValueRef*") PointerPointer IncomingValues,
                     @Cast("LLVMBasicBlockRef*") PointerPointer IncomingBlocks, @Cast("unsigned") int Count);

/**
 * Obtain the number of incoming basic blocks to a PHI node.
 */
public static native @Cast("unsigned") int LLVMCountIncoming(LLVMValueRef PhiNode);

/**
 * Obtain an incoming value to a PHI node as an LLVMValueRef.
 */
public static native LLVMValueRef LLVMGetIncomingValue(LLVMValueRef PhiNode, @Cast("unsigned") int Index);

/**
 * Obtain an incoming value to a PHI node as an LLVMBasicBlockRef.
 */
public static native LLVMBasicBlockRef LLVMGetIncomingBlock(LLVMValueRef PhiNode, @Cast("unsigned") int Index);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreValueInstructionExtractValue ExtractValue
 * \defgroup LLVMCCoreValueInstructionInsertValue InsertValue
 *
 * Functions in this group only apply to instructions that map to
 * llvm::ExtractValue and llvm::InsertValue instances.
 *
 * \{
 */

/**
 * Obtain the number of indices.
 * NB: This also works on GEP operators.
 */
public static native @Cast("unsigned") int LLVMGetNumIndices(LLVMValueRef Inst);

/**
 * Obtain the indices as an array.
 */
public static native @Cast("const unsigned*") IntPointer LLVMGetIndices(LLVMValueRef Inst);

/**
 * \}
 */

/**
 * \}
 */

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreInstructionBuilder Instruction Builders
 *
 * An instruction builder represents a point within a basic block and is
 * the exclusive means of building instructions using the C interface.
 *
 * \{
 */

public static native LLVMBuilderRef LLVMCreateBuilderInContext(LLVMContextRef C);
public static native LLVMBuilderRef LLVMCreateBuilder();
public static native void LLVMPositionBuilder(LLVMBuilderRef Builder, LLVMBasicBlockRef Block,
                         LLVMValueRef Instr);
public static native void LLVMPositionBuilderBefore(LLVMBuilderRef Builder, LLVMValueRef Instr);
public static native void LLVMPositionBuilderAtEnd(LLVMBuilderRef Builder, LLVMBasicBlockRef Block);
public static native LLVMBasicBlockRef LLVMGetInsertBlock(LLVMBuilderRef Builder);
public static native void LLVMClearInsertionPosition(LLVMBuilderRef Builder);
public static native void LLVMInsertIntoBuilder(LLVMBuilderRef Builder, LLVMValueRef Instr);
public static native void LLVMInsertIntoBuilderWithName(LLVMBuilderRef Builder, LLVMValueRef Instr,
                                   @Cast("const char*") BytePointer Name);
public static native void LLVMInsertIntoBuilderWithName(LLVMBuilderRef Builder, LLVMValueRef Instr,
                                   String Name);
public static native void LLVMDisposeBuilder(LLVMBuilderRef Builder);

/* Metadata */

/**
 * Get location information used by debugging information.
 *
 * @see llvm::IRBuilder::getCurrentDebugLocation()
 */
public static native LLVMMetadataRef LLVMGetCurrentDebugLocation2(LLVMBuilderRef Builder);

/**
 * Set location information used by debugging information.
 *
 * To clear the location metadata of the given instruction, pass NULL to \p Loc.
 *
 * @see llvm::IRBuilder::SetCurrentDebugLocation()
 */
public static native void LLVMSetCurrentDebugLocation2(LLVMBuilderRef Builder, LLVMMetadataRef Loc);

/**
 * Attempts to set the debug location for the given instruction using the
 * current debug location for the given builder.  If the builder has no current
 * debug location, this function is a no-op.
 *
 * @deprecated LLVMSetInstDebugLocation is deprecated in favor of the more general
 *             LLVMAddMetadataToInst.
 *
 * @see llvm::IRBuilder::SetInstDebugLocation()
 */
public static native void LLVMSetInstDebugLocation(LLVMBuilderRef Builder, LLVMValueRef Inst);

/**
 * Adds the metadata registered with the given builder to the given instruction.
 *
 * @see llvm::IRBuilder::AddMetadataToInst()
 */
public static native void LLVMAddMetadataToInst(LLVMBuilderRef Builder, LLVMValueRef Inst);

/**
 * Get the dafult floating-point math metadata for a given builder.
 *
 * @see llvm::IRBuilder::getDefaultFPMathTag()
 */
public static native LLVMMetadataRef LLVMBuilderGetDefaultFPMathTag(LLVMBuilderRef Builder);

/**
 * Set the default floating-point math metadata for the given builder.
 *
 * To clear the metadata, pass NULL to \p FPMathTag.
 *
 * @see llvm::IRBuilder::setDefaultFPMathTag()
 */
public static native void LLVMBuilderSetDefaultFPMathTag(LLVMBuilderRef Builder,
                                    LLVMMetadataRef FPMathTag);

/**
 * Deprecated: Passing the NULL location will crash.
 * Use LLVMGetCurrentDebugLocation2 instead.
 */
public static native void LLVMSetCurrentDebugLocation(LLVMBuilderRef Builder, LLVMValueRef L);
/**
 * Deprecated: Returning the NULL location will crash.
 * Use LLVMGetCurrentDebugLocation2 instead.
 */
public static native LLVMValueRef LLVMGetCurrentDebugLocation(LLVMBuilderRef Builder);

/* Terminators */
public static native LLVMValueRef LLVMBuildRetVoid(LLVMBuilderRef arg0);
public static native LLVMValueRef LLVMBuildRet(LLVMBuilderRef arg0, LLVMValueRef V);
public static native LLVMValueRef LLVMBuildAggregateRet(LLVMBuilderRef arg0, @ByPtrPtr LLVMValueRef RetVals,
                                   @Cast("unsigned") int N);
public static native LLVMValueRef LLVMBuildAggregateRet(LLVMBuilderRef arg0, @Cast("LLVMValueRef*") PointerPointer RetVals,
                                   @Cast("unsigned") int N);
public static native LLVMValueRef LLVMBuildBr(LLVMBuilderRef arg0, LLVMBasicBlockRef Dest);
public static native LLVMValueRef LLVMBuildCondBr(LLVMBuilderRef arg0, LLVMValueRef If,
                             LLVMBasicBlockRef Then, LLVMBasicBlockRef Else);
public static native LLVMValueRef LLVMBuildSwitch(LLVMBuilderRef arg0, LLVMValueRef V,
                             LLVMBasicBlockRef Else, @Cast("unsigned") int NumCases);
public static native LLVMValueRef LLVMBuildIndirectBr(LLVMBuilderRef B, LLVMValueRef Addr,
                                 @Cast("unsigned") int NumDests);

public static native LLVMValueRef LLVMBuildInvoke2(LLVMBuilderRef arg0, LLVMTypeRef Ty, LLVMValueRef Fn,
                              @ByPtrPtr LLVMValueRef Args, @Cast("unsigned") int NumArgs,
                              LLVMBasicBlockRef Then, LLVMBasicBlockRef Catch,
                              @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildInvoke2(LLVMBuilderRef arg0, LLVMTypeRef Ty, LLVMValueRef Fn,
                              @Cast("LLVMValueRef*") PointerPointer Args, @Cast("unsigned") int NumArgs,
                              LLVMBasicBlockRef Then, LLVMBasicBlockRef Catch,
                              String Name);
public static native LLVMValueRef LLVMBuildUnreachable(LLVMBuilderRef arg0);

/* Exception Handling */
public static native LLVMValueRef LLVMBuildResume(LLVMBuilderRef B, LLVMValueRef Exn);
public static native LLVMValueRef LLVMBuildLandingPad(LLVMBuilderRef B, LLVMTypeRef Ty,
                                 LLVMValueRef PersFn, @Cast("unsigned") int NumClauses,
                                 @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildLandingPad(LLVMBuilderRef B, LLVMTypeRef Ty,
                                 LLVMValueRef PersFn, @Cast("unsigned") int NumClauses,
                                 String Name);
public static native LLVMValueRef LLVMBuildCleanupRet(LLVMBuilderRef B, LLVMValueRef CatchPad,
                                 LLVMBasicBlockRef BB);
public static native LLVMValueRef LLVMBuildCatchRet(LLVMBuilderRef B, LLVMValueRef CatchPad,
                               LLVMBasicBlockRef BB);
public static native LLVMValueRef LLVMBuildCatchPad(LLVMBuilderRef B, LLVMValueRef ParentPad,
                               @ByPtrPtr LLVMValueRef Args, @Cast("unsigned") int NumArgs,
                               @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildCatchPad(LLVMBuilderRef B, LLVMValueRef ParentPad,
                               @Cast("LLVMValueRef*") PointerPointer Args, @Cast("unsigned") int NumArgs,
                               String Name);
public static native LLVMValueRef LLVMBuildCleanupPad(LLVMBuilderRef B, LLVMValueRef ParentPad,
                                 @ByPtrPtr LLVMValueRef Args, @Cast("unsigned") int NumArgs,
                                 @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildCleanupPad(LLVMBuilderRef B, LLVMValueRef ParentPad,
                                 @Cast("LLVMValueRef*") PointerPointer Args, @Cast("unsigned") int NumArgs,
                                 String Name);
public static native LLVMValueRef LLVMBuildCatchSwitch(LLVMBuilderRef B, LLVMValueRef ParentPad,
                                  LLVMBasicBlockRef UnwindBB,
                                  @Cast("unsigned") int NumHandlers, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildCatchSwitch(LLVMBuilderRef B, LLVMValueRef ParentPad,
                                  LLVMBasicBlockRef UnwindBB,
                                  @Cast("unsigned") int NumHandlers, String Name);

/* Add a case to the switch instruction */
public static native void LLVMAddCase(LLVMValueRef Switch, LLVMValueRef OnVal,
                 LLVMBasicBlockRef Dest);

/* Add a destination to the indirectbr instruction */
public static native void LLVMAddDestination(LLVMValueRef IndirectBr, LLVMBasicBlockRef Dest);

/* Get the number of clauses on the landingpad instruction */
public static native @Cast("unsigned") int LLVMGetNumClauses(LLVMValueRef LandingPad);

/* Get the value of the clause at index Idx on the landingpad instruction */
public static native LLVMValueRef LLVMGetClause(LLVMValueRef LandingPad, @Cast("unsigned") int Idx);

/* Add a catch or filter clause to the landingpad instruction */
public static native void LLVMAddClause(LLVMValueRef LandingPad, LLVMValueRef ClauseVal);

/* Get the 'cleanup' flag in the landingpad instruction */
public static native @Cast("LLVMBool") int LLVMIsCleanup(LLVMValueRef LandingPad);

/* Set the 'cleanup' flag in the landingpad instruction */
public static native void LLVMSetCleanup(LLVMValueRef LandingPad, @Cast("LLVMBool") int Val);

/* Add a destination to the catchswitch instruction */
public static native void LLVMAddHandler(LLVMValueRef CatchSwitch, LLVMBasicBlockRef Dest);

/* Get the number of handlers on the catchswitch instruction */
public static native @Cast("unsigned") int LLVMGetNumHandlers(LLVMValueRef CatchSwitch);

/**
 * Obtain the basic blocks acting as handlers for a catchswitch instruction.
 *
 * The Handlers parameter should point to a pre-allocated array of
 * LLVMBasicBlockRefs at least LLVMGetNumHandlers() large. On return, the
 * first LLVMGetNumHandlers() entries in the array will be populated
 * with LLVMBasicBlockRef instances.
 *
 * @param CatchSwitch The catchswitch instruction to operate on.
 * @param Handlers Memory address of an array to be filled with basic blocks.
 */
public static native void LLVMGetHandlers(LLVMValueRef CatchSwitch, @ByPtrPtr LLVMBasicBlockRef Handlers);
public static native void LLVMGetHandlers(LLVMValueRef CatchSwitch, @Cast("LLVMBasicBlockRef*") PointerPointer Handlers);

/* Funclets */

/* Get the number of funcletpad arguments. */
public static native LLVMValueRef LLVMGetArgOperand(LLVMValueRef Funclet, @Cast("unsigned") int i);

/* Set a funcletpad argument at the given index. */
public static native void LLVMSetArgOperand(LLVMValueRef Funclet, @Cast("unsigned") int i, LLVMValueRef value);

/**
 * Get the parent catchswitch instruction of a catchpad instruction.
 *
 * This only works on llvm::CatchPadInst instructions.
 *
 * @see llvm::CatchPadInst::getCatchSwitch()
 */
public static native LLVMValueRef LLVMGetParentCatchSwitch(LLVMValueRef CatchPad);

/**
 * Set the parent catchswitch instruction of a catchpad instruction.
 *
 * This only works on llvm::CatchPadInst instructions.
 *
 * @see llvm::CatchPadInst::setCatchSwitch()
 */
public static native void LLVMSetParentCatchSwitch(LLVMValueRef CatchPad, LLVMValueRef CatchSwitch);

/* Arithmetic */
public static native LLVMValueRef LLVMBuildAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          String Name);
public static native LLVMValueRef LLVMBuildNSWAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNSWAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             String Name);
public static native LLVMValueRef LLVMBuildNUWAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNUWAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             String Name);
public static native LLVMValueRef LLVMBuildFAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFAdd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          String Name);
public static native LLVMValueRef LLVMBuildNSWSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNSWSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             String Name);
public static native LLVMValueRef LLVMBuildNUWSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNUWSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             String Name);
public static native LLVMValueRef LLVMBuildFSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFSub(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          String Name);
public static native LLVMValueRef LLVMBuildNSWMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNSWMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             String Name);
public static native LLVMValueRef LLVMBuildNUWMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNUWMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                             String Name);
public static native LLVMValueRef LLVMBuildFMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFMul(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildUDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildUDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildExactUDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                                @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildExactUDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                                String Name);
public static native LLVMValueRef LLVMBuildSDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildSDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildExactSDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                                @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildExactSDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                                String Name);
public static native LLVMValueRef LLVMBuildFDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFDiv(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildURem(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildURem(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildSRem(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildSRem(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildFRem(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFRem(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildShl(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildShl(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildLShr(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildLShr(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildAShr(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildAShr(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildAnd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildAnd(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          String Name);
public static native LLVMValueRef LLVMBuildOr(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildOr(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          String Name);
public static native LLVMValueRef LLVMBuildXor(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildXor(LLVMBuilderRef arg0, LLVMValueRef LHS, LLVMValueRef RHS,
                          String Name);
public static native LLVMValueRef LLVMBuildBinOp(LLVMBuilderRef B, @Cast("LLVMOpcode") int Op,
                            LLVMValueRef LHS, LLVMValueRef RHS,
                            @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildBinOp(LLVMBuilderRef B, @Cast("LLVMOpcode") int Op,
                            LLVMValueRef LHS, LLVMValueRef RHS,
                            String Name);
public static native LLVMValueRef LLVMBuildNeg(LLVMBuilderRef arg0, LLVMValueRef V, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNeg(LLVMBuilderRef arg0, LLVMValueRef V, String Name);
public static native LLVMValueRef LLVMBuildNSWNeg(LLVMBuilderRef B, LLVMValueRef V,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNSWNeg(LLVMBuilderRef B, LLVMValueRef V,
                             String Name);
public static native LLVMValueRef LLVMBuildNUWNeg(LLVMBuilderRef B, LLVMValueRef V,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNUWNeg(LLVMBuilderRef B, LLVMValueRef V,
                             String Name);
public static native LLVMValueRef LLVMBuildFNeg(LLVMBuilderRef arg0, LLVMValueRef V, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFNeg(LLVMBuilderRef arg0, LLVMValueRef V, String Name);
public static native LLVMValueRef LLVMBuildNot(LLVMBuilderRef arg0, LLVMValueRef V, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildNot(LLVMBuilderRef arg0, LLVMValueRef V, String Name);

/* Memory */
public static native LLVMValueRef LLVMBuildMalloc(LLVMBuilderRef arg0, LLVMTypeRef Ty, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildMalloc(LLVMBuilderRef arg0, LLVMTypeRef Ty, String Name);
public static native LLVMValueRef LLVMBuildArrayMalloc(LLVMBuilderRef arg0, LLVMTypeRef Ty,
                                  LLVMValueRef Val, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildArrayMalloc(LLVMBuilderRef arg0, LLVMTypeRef Ty,
                                  LLVMValueRef Val, String Name);

/**
 * Creates and inserts a memset to the specified pointer and the
 * specified value.
 *
 * @see llvm::IRRBuilder::CreateMemSet()
 */
public static native LLVMValueRef LLVMBuildMemSet(LLVMBuilderRef B, LLVMValueRef Ptr,
                             LLVMValueRef Val, LLVMValueRef Len,
                             @Cast("unsigned") int Align);
/**
 * Creates and inserts a memcpy between the specified pointers.
 *
 * @see llvm::IRRBuilder::CreateMemCpy()
 */
public static native LLVMValueRef LLVMBuildMemCpy(LLVMBuilderRef B,
                             LLVMValueRef Dst, @Cast("unsigned") int DstAlign,
                             LLVMValueRef Src, @Cast("unsigned") int SrcAlign,
                             LLVMValueRef Size);
/**
 * Creates and inserts a memmove between the specified pointers.
 *
 * @see llvm::IRRBuilder::CreateMemMove()
 */
public static native LLVMValueRef LLVMBuildMemMove(LLVMBuilderRef B,
                              LLVMValueRef Dst, @Cast("unsigned") int DstAlign,
                              LLVMValueRef Src, @Cast("unsigned") int SrcAlign,
                              LLVMValueRef Size);

public static native LLVMValueRef LLVMBuildAlloca(LLVMBuilderRef arg0, LLVMTypeRef Ty, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildAlloca(LLVMBuilderRef arg0, LLVMTypeRef Ty, String Name);
public static native LLVMValueRef LLVMBuildArrayAlloca(LLVMBuilderRef arg0, LLVMTypeRef Ty,
                                  LLVMValueRef Val, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildArrayAlloca(LLVMBuilderRef arg0, LLVMTypeRef Ty,
                                  LLVMValueRef Val, String Name);
public static native LLVMValueRef LLVMBuildFree(LLVMBuilderRef arg0, LLVMValueRef PointerVal);

public static native LLVMValueRef LLVMBuildLoad2(LLVMBuilderRef arg0, LLVMTypeRef Ty,
                            LLVMValueRef PointerVal, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildLoad2(LLVMBuilderRef arg0, LLVMTypeRef Ty,
                            LLVMValueRef PointerVal, String Name);
public static native LLVMValueRef LLVMBuildStore(LLVMBuilderRef arg0, LLVMValueRef Val, LLVMValueRef Ptr);



public static native LLVMValueRef LLVMBuildGEP2(LLVMBuilderRef B, LLVMTypeRef Ty,
                           LLVMValueRef Pointer, @ByPtrPtr LLVMValueRef Indices,
                           @Cast("unsigned") int NumIndices, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildGEP2(LLVMBuilderRef B, LLVMTypeRef Ty,
                           LLVMValueRef Pointer, @Cast("LLVMValueRef*") PointerPointer Indices,
                           @Cast("unsigned") int NumIndices, String Name);
public static native LLVMValueRef LLVMBuildInBoundsGEP2(LLVMBuilderRef B, LLVMTypeRef Ty,
                                   LLVMValueRef Pointer, @ByPtrPtr LLVMValueRef Indices,
                                   @Cast("unsigned") int NumIndices, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildInBoundsGEP2(LLVMBuilderRef B, LLVMTypeRef Ty,
                                   LLVMValueRef Pointer, @Cast("LLVMValueRef*") PointerPointer Indices,
                                   @Cast("unsigned") int NumIndices, String Name);
public static native LLVMValueRef LLVMBuildStructGEP2(LLVMBuilderRef B, LLVMTypeRef Ty,
                                 LLVMValueRef Pointer, @Cast("unsigned") int Idx,
                                 @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildStructGEP2(LLVMBuilderRef B, LLVMTypeRef Ty,
                                 LLVMValueRef Pointer, @Cast("unsigned") int Idx,
                                 String Name);
public static native LLVMValueRef LLVMBuildGlobalString(LLVMBuilderRef B, @Cast("const char*") BytePointer Str,
                                   @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildGlobalString(LLVMBuilderRef B, String Str,
                                   String Name);
public static native LLVMValueRef LLVMBuildGlobalStringPtr(LLVMBuilderRef B, @Cast("const char*") BytePointer Str,
                                      @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildGlobalStringPtr(LLVMBuilderRef B, String Str,
                                      String Name);
public static native @Cast("LLVMBool") int LLVMGetVolatile(LLVMValueRef MemoryAccessInst);
public static native void LLVMSetVolatile(LLVMValueRef MemoryAccessInst, @Cast("LLVMBool") int IsVolatile);
public static native @Cast("LLVMBool") int LLVMGetWeak(LLVMValueRef CmpXchgInst);
public static native void LLVMSetWeak(LLVMValueRef CmpXchgInst, @Cast("LLVMBool") int IsWeak);
public static native @Cast("LLVMAtomicOrdering") int LLVMGetOrdering(LLVMValueRef MemoryAccessInst);
public static native void LLVMSetOrdering(LLVMValueRef MemoryAccessInst, @Cast("LLVMAtomicOrdering") int Ordering);
public static native @Cast("LLVMAtomicRMWBinOp") int LLVMGetAtomicRMWBinOp(LLVMValueRef AtomicRMWInst);
public static native void LLVMSetAtomicRMWBinOp(LLVMValueRef AtomicRMWInst, @Cast("LLVMAtomicRMWBinOp") int BinOp);

/* Casts */
public static native LLVMValueRef LLVMBuildTrunc(LLVMBuilderRef arg0, LLVMValueRef Val,
                            LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildTrunc(LLVMBuilderRef arg0, LLVMValueRef Val,
                            LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildZExt(LLVMBuilderRef arg0, LLVMValueRef Val,
                           LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildZExt(LLVMBuilderRef arg0, LLVMValueRef Val,
                           LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildSExt(LLVMBuilderRef arg0, LLVMValueRef Val,
                           LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildSExt(LLVMBuilderRef arg0, LLVMValueRef Val,
                           LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildFPToUI(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFPToUI(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildFPToSI(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFPToSI(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildUIToFP(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildUIToFP(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildSIToFP(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildSIToFP(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildFPTrunc(LLVMBuilderRef arg0, LLVMValueRef Val,
                              LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFPTrunc(LLVMBuilderRef arg0, LLVMValueRef Val,
                              LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildFPExt(LLVMBuilderRef arg0, LLVMValueRef Val,
                            LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFPExt(LLVMBuilderRef arg0, LLVMValueRef Val,
                            LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildPtrToInt(LLVMBuilderRef arg0, LLVMValueRef Val,
                               LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildPtrToInt(LLVMBuilderRef arg0, LLVMValueRef Val,
                               LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildIntToPtr(LLVMBuilderRef arg0, LLVMValueRef Val,
                               LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildIntToPtr(LLVMBuilderRef arg0, LLVMValueRef Val,
                               LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                              LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                              LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildAddrSpaceCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                    LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildAddrSpaceCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                    LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildZExtOrBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                    LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildZExtOrBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                    LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildSExtOrBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                    LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildSExtOrBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                    LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildTruncOrBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                     LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildTruncOrBitCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                     LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildCast(LLVMBuilderRef B, @Cast("LLVMOpcode") int Op, LLVMValueRef Val,
                           LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildCast(LLVMBuilderRef B, @Cast("LLVMOpcode") int Op, LLVMValueRef Val,
                           LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildPointerCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                  LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildPointerCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                                  LLVMTypeRef DestTy, String Name);
public static native LLVMValueRef LLVMBuildIntCast2(LLVMBuilderRef arg0, LLVMValueRef Val,
                               LLVMTypeRef DestTy, @Cast("LLVMBool") int IsSigned,
                               @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildIntCast2(LLVMBuilderRef arg0, LLVMValueRef Val,
                               LLVMTypeRef DestTy, @Cast("LLVMBool") int IsSigned,
                               String Name);
public static native LLVMValueRef LLVMBuildFPCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFPCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                             LLVMTypeRef DestTy, String Name);

/** Deprecated: This cast is always signed. Use LLVMBuildIntCast2 instead. */
public static native LLVMValueRef LLVMBuildIntCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                              LLVMTypeRef DestTy, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildIntCast(LLVMBuilderRef arg0, LLVMValueRef Val,
                              LLVMTypeRef DestTy, String Name);

public static native @Cast("LLVMOpcode") int LLVMGetCastOpcode(LLVMValueRef Src, @Cast("LLVMBool") int SrcIsSigned,
                             LLVMTypeRef DestTy, @Cast("LLVMBool") int DestIsSigned);

/* Comparisons */
public static native LLVMValueRef LLVMBuildICmp(LLVMBuilderRef arg0, @Cast("LLVMIntPredicate") int Op,
                           LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildICmp(LLVMBuilderRef arg0, @Cast("LLVMIntPredicate") int Op,
                           LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);
public static native LLVMValueRef LLVMBuildFCmp(LLVMBuilderRef arg0, @Cast("LLVMRealPredicate") int Op,
                           LLVMValueRef LHS, LLVMValueRef RHS,
                           @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFCmp(LLVMBuilderRef arg0, @Cast("LLVMRealPredicate") int Op,
                           LLVMValueRef LHS, LLVMValueRef RHS,
                           String Name);

/* Miscellaneous instructions */
public static native LLVMValueRef LLVMBuildPhi(LLVMBuilderRef arg0, LLVMTypeRef Ty, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildPhi(LLVMBuilderRef arg0, LLVMTypeRef Ty, String Name);

public static native LLVMValueRef LLVMBuildCall2(LLVMBuilderRef arg0, LLVMTypeRef arg1, LLVMValueRef Fn,
                            @ByPtrPtr LLVMValueRef Args, @Cast("unsigned") int NumArgs,
                            @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildCall2(LLVMBuilderRef arg0, LLVMTypeRef arg1, LLVMValueRef Fn,
                            @Cast("LLVMValueRef*") PointerPointer Args, @Cast("unsigned") int NumArgs,
                            String Name);
public static native LLVMValueRef LLVMBuildSelect(LLVMBuilderRef arg0, LLVMValueRef If,
                             LLVMValueRef Then, LLVMValueRef Else,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildSelect(LLVMBuilderRef arg0, LLVMValueRef If,
                             LLVMValueRef Then, LLVMValueRef Else,
                             String Name);
public static native LLVMValueRef LLVMBuildVAArg(LLVMBuilderRef arg0, LLVMValueRef List, LLVMTypeRef Ty,
                            @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildVAArg(LLVMBuilderRef arg0, LLVMValueRef List, LLVMTypeRef Ty,
                            String Name);
public static native LLVMValueRef LLVMBuildExtractElement(LLVMBuilderRef arg0, LLVMValueRef VecVal,
                                     LLVMValueRef Index, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildExtractElement(LLVMBuilderRef arg0, LLVMValueRef VecVal,
                                     LLVMValueRef Index, String Name);
public static native LLVMValueRef LLVMBuildInsertElement(LLVMBuilderRef arg0, LLVMValueRef VecVal,
                                    LLVMValueRef EltVal, LLVMValueRef Index,
                                    @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildInsertElement(LLVMBuilderRef arg0, LLVMValueRef VecVal,
                                    LLVMValueRef EltVal, LLVMValueRef Index,
                                    String Name);
public static native LLVMValueRef LLVMBuildShuffleVector(LLVMBuilderRef arg0, LLVMValueRef V1,
                                    LLVMValueRef V2, LLVMValueRef Mask,
                                    @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildShuffleVector(LLVMBuilderRef arg0, LLVMValueRef V1,
                                    LLVMValueRef V2, LLVMValueRef Mask,
                                    String Name);
public static native LLVMValueRef LLVMBuildExtractValue(LLVMBuilderRef arg0, LLVMValueRef AggVal,
                                   @Cast("unsigned") int Index, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildExtractValue(LLVMBuilderRef arg0, LLVMValueRef AggVal,
                                   @Cast("unsigned") int Index, String Name);
public static native LLVMValueRef LLVMBuildInsertValue(LLVMBuilderRef arg0, LLVMValueRef AggVal,
                                  LLVMValueRef EltVal, @Cast("unsigned") int Index,
                                  @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildInsertValue(LLVMBuilderRef arg0, LLVMValueRef AggVal,
                                  LLVMValueRef EltVal, @Cast("unsigned") int Index,
                                  String Name);
public static native LLVMValueRef LLVMBuildFreeze(LLVMBuilderRef arg0, LLVMValueRef Val,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFreeze(LLVMBuilderRef arg0, LLVMValueRef Val,
                             String Name);

public static native LLVMValueRef LLVMBuildIsNull(LLVMBuilderRef arg0, LLVMValueRef Val,
                             @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildIsNull(LLVMBuilderRef arg0, LLVMValueRef Val,
                             String Name);
public static native LLVMValueRef LLVMBuildIsNotNull(LLVMBuilderRef arg0, LLVMValueRef Val,
                                @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildIsNotNull(LLVMBuilderRef arg0, LLVMValueRef Val,
                                String Name);

public static native LLVMValueRef LLVMBuildPtrDiff2(LLVMBuilderRef arg0, LLVMTypeRef ElemTy,
                               LLVMValueRef LHS, LLVMValueRef RHS,
                               @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildPtrDiff2(LLVMBuilderRef arg0, LLVMTypeRef ElemTy,
                               LLVMValueRef LHS, LLVMValueRef RHS,
                               String Name);
public static native LLVMValueRef LLVMBuildFence(LLVMBuilderRef B, @Cast("LLVMAtomicOrdering") int ordering,
                            @Cast("LLVMBool") int singleThread, @Cast("const char*") BytePointer Name);
public static native LLVMValueRef LLVMBuildFence(LLVMBuilderRef B, @Cast("LLVMAtomicOrdering") int ordering,
                            @Cast("LLVMBool") int singleThread, String Name);
public static native LLVMValueRef LLVMBuildAtomicRMW(LLVMBuilderRef B, @Cast("LLVMAtomicRMWBinOp") int op,
                                LLVMValueRef PTR, LLVMValueRef Val,
                                @Cast("LLVMAtomicOrdering") int ordering,
                                @Cast("LLVMBool") int singleThread);
public static native LLVMValueRef LLVMBuildAtomicCmpXchg(LLVMBuilderRef B, LLVMValueRef Ptr,
                                    LLVMValueRef Cmp, LLVMValueRef New,
                                    @Cast("LLVMAtomicOrdering") int SuccessOrdering,
                                    @Cast("LLVMAtomicOrdering") int FailureOrdering,
                                    @Cast("LLVMBool") int SingleThread);

/**
 * Get the number of elements in the mask of a ShuffleVector instruction.
 */
public static native @Cast("unsigned") int LLVMGetNumMaskElements(LLVMValueRef ShuffleVectorInst);

/**
 * @return a constant that specifies that the result of a \c ShuffleVectorInst
 * is undefined.
 */
public static native int LLVMGetUndefMaskElem();

/**
 * Get the mask value at position Elt in the mask of a ShuffleVector
 * instruction.
 *
 * \Returns the result of \c LLVMGetUndefMaskElem() if the mask value is undef
 * at that position.
 */
public static native int LLVMGetMaskValue(LLVMValueRef ShuffleVectorInst, @Cast("unsigned") int Elt);

public static native @Cast("LLVMBool") int LLVMIsAtomicSingleThread(LLVMValueRef AtomicInst);
public static native void LLVMSetAtomicSingleThread(LLVMValueRef AtomicInst, @Cast("LLVMBool") int SingleThread);

public static native @Cast("LLVMAtomicOrdering") int LLVMGetCmpXchgSuccessOrdering(LLVMValueRef CmpXchgInst);
public static native void LLVMSetCmpXchgSuccessOrdering(LLVMValueRef CmpXchgInst,
                                   @Cast("LLVMAtomicOrdering") int Ordering);
public static native @Cast("LLVMAtomicOrdering") int LLVMGetCmpXchgFailureOrdering(LLVMValueRef CmpXchgInst);
public static native void LLVMSetCmpXchgFailureOrdering(LLVMValueRef CmpXchgInst,
                                   @Cast("LLVMAtomicOrdering") int Ordering);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreModuleProvider Module Providers
 *
 * \{
 */

/**
 * Changes the type of M so it can be passed to FunctionPassManagers and the
 * JIT.  They take ModuleProviders for historical reasons.
 */
public static native LLVMModuleProviderRef LLVMCreateModuleProviderForExistingModule(LLVMModuleRef M);

/**
 * Destroys the module M.
 */
public static native void LLVMDisposeModuleProvider(LLVMModuleProviderRef M);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreMemoryBuffers Memory Buffers
 *
 * \{
 */

public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithContentsOfFile(@Cast("const char*") BytePointer Path,
                                                  @ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                                  @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithContentsOfFile(@Cast("const char*") BytePointer Path,
                                                  @ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                                  @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithContentsOfFile(String Path,
                                                  @Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf,
                                                  @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithContentsOfFile(@Cast("const char*") BytePointer Path,
                                                  @ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                                  @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithContentsOfFile(String Path,
                                                  @Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf,
                                                  @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithContentsOfFile(@Cast("const char*") BytePointer Path,
                                                  @ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                                  @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithContentsOfFile(String Path,
                                                  @Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf,
                                                  @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithSTDIN(@ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                         @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithSTDIN(@ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                         @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithSTDIN(@Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf,
                                         @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithSTDIN(@ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                         @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithSTDIN(@Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf,
                                         @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithSTDIN(@ByPtrPtr LLVMMemoryBufferRef OutMemBuf,
                                         @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMCreateMemoryBufferWithSTDIN(@Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf,
                                         @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native LLVMMemoryBufferRef LLVMCreateMemoryBufferWithMemoryRange(@Cast("const char*") BytePointer InputData,
                                                          @Cast("size_t") long InputDataLength,
                                                          @Cast("const char*") BytePointer BufferName,
                                                          @Cast("LLVMBool") int RequiresNullTerminator);
public static native LLVMMemoryBufferRef LLVMCreateMemoryBufferWithMemoryRange(String InputData,
                                                          @Cast("size_t") long InputDataLength,
                                                          String BufferName,
                                                          @Cast("LLVMBool") int RequiresNullTerminator);
public static native LLVMMemoryBufferRef LLVMCreateMemoryBufferWithMemoryRangeCopy(@Cast("const char*") BytePointer InputData,
                                                              @Cast("size_t") long InputDataLength,
                                                              @Cast("const char*") BytePointer BufferName);
public static native LLVMMemoryBufferRef LLVMCreateMemoryBufferWithMemoryRangeCopy(String InputData,
                                                              @Cast("size_t") long InputDataLength,
                                                              String BufferName);
public static native @Cast("const char*") BytePointer LLVMGetBufferStart(LLVMMemoryBufferRef MemBuf);
public static native @Cast("size_t") long LLVMGetBufferSize(LLVMMemoryBufferRef MemBuf);
public static native void LLVMDisposeMemoryBuffer(LLVMMemoryBufferRef MemBuf);

/**
 * \}
 */

/**
 * \defgroup LLVMCCorePassRegistry Pass Registry
 * \ingroup LLVMCCore
 *
 * \{
 */

/** Return the global pass registry, for use with initialization functions.
    @see llvm::PassRegistry::getPassRegistry */
public static native LLVMPassRegistryRef LLVMGetGlobalPassRegistry();

/**
 * \}
 */

/**
 * \defgroup LLVMCCorePassManagers Pass Managers
 * \ingroup LLVMCCore
 *
 * \{
 */

/** Constructs a new whole-module pass pipeline. This type of pipeline is
    suitable for link-time optimization and whole-module transformations.
    @see llvm::PassManager::PassManager */
public static native LLVMPassManagerRef LLVMCreatePassManager();

/** Constructs a new function-by-function pass pipeline over the module
    provider. It does not take ownership of the module provider. This type of
    pipeline is suitable for code generation and JIT compilation tasks.
    @see llvm::FunctionPassManager::FunctionPassManager */
public static native LLVMPassManagerRef LLVMCreateFunctionPassManagerForModule(LLVMModuleRef M);

/** Deprecated: Use LLVMCreateFunctionPassManagerForModule instead. */
public static native LLVMPassManagerRef LLVMCreateFunctionPassManager(LLVMModuleProviderRef MP);

/** Initializes, executes on the provided module, and finalizes all of the
    passes scheduled in the pass manager. Returns 1 if any of the passes
    modified the module, 0 otherwise.
    @see llvm::PassManager::run(Module&) */
public static native @Cast("LLVMBool") int LLVMRunPassManager(LLVMPassManagerRef PM, LLVMModuleRef M);

/** Initializes all of the function passes scheduled in the function pass
    manager. Returns 1 if any of the passes modified the module, 0 otherwise.
    @see llvm::FunctionPassManager::doInitialization */
public static native @Cast("LLVMBool") int LLVMInitializeFunctionPassManager(LLVMPassManagerRef FPM);

/** Executes all of the function passes scheduled in the function pass manager
    on the provided function. Returns 1 if any of the passes modified the
    function, false otherwise.
    @see llvm::FunctionPassManager::run(Function&) */
public static native @Cast("LLVMBool") int LLVMRunFunctionPassManager(LLVMPassManagerRef FPM, LLVMValueRef F);

/** Finalizes all of the function passes scheduled in the function pass
    manager. Returns 1 if any of the passes modified the module, 0 otherwise.
    @see llvm::FunctionPassManager::doFinalization */
public static native @Cast("LLVMBool") int LLVMFinalizeFunctionPassManager(LLVMPassManagerRef FPM);

/** Frees the memory of a pass pipeline. For function pipelines, does not free
    the module provider.
    @see llvm::PassManagerBase::~PassManagerBase. */
public static native void LLVMDisposePassManager(LLVMPassManagerRef PM);

/**
 * \}
 */

/**
 * \defgroup LLVMCCoreThreading Threading
 *
 * Handle the structures needed to make LLVM safe for multithreading.
 *
 * \{
 */

/** Deprecated: Multi-threading can only be enabled/disabled with the compile
    time define LLVM_ENABLE_THREADS.  This function always returns
    LLVMIsMultithreaded(). */
public static native @Cast("LLVMBool") int LLVMStartMultithreaded();

/** Deprecated: Multi-threading can only be enabled/disabled with the compile
    time define LLVM_ENABLE_THREADS. */
public static native void LLVMStopMultithreaded();

/** Check whether LLVM is executing in thread-safe mode or not.
    @see llvm::llvm_is_multithreaded */
public static native @Cast("LLVMBool") int LLVMIsMultithreaded();

/**
 * \}
 */

/**
 * \}
 */

/**
 * \}
 */

// #endif /* LLVM_C_CORE_H */


// Parsed from <llvm-c/Analysis.h>

/*===-- llvm-c/Analysis.h - Analysis Library C Interface --------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMAnalysis.a, which           *|
|* implements various analyses of the LLVM IR.                                *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_ANALYSIS_H
// #define LLVM_C_ANALYSIS_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCAnalysis Analysis
 * \ingroup LLVMC
 *
 * \{
 */

/** enum LLVMVerifierFailureAction */
public static final int
  LLVMAbortProcessAction = 0, /* verifier will print to stderr and abort() */
  LLVMPrintMessageAction = 1, /* verifier will print to stderr and return 1 */
  LLVMReturnStatusAction = 2;  /* verifier will just return 1 */


/* Verifies that a module is valid, taking the specified action if not.
   Optionally returns a human-readable description of any invalid constructs.
   OutMessage must be disposed with LLVMDisposeMessage. */
public static native @Cast("LLVMBool") int LLVMVerifyModule(LLVMModuleRef M, @Cast("LLVMVerifierFailureAction") int Action,
                          @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMVerifyModule(LLVMModuleRef M, @Cast("LLVMVerifierFailureAction") int Action,
                          @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMVerifyModule(LLVMModuleRef M, @Cast("LLVMVerifierFailureAction") int Action,
                          @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMVerifyModule(LLVMModuleRef M, @Cast("LLVMVerifierFailureAction") int Action,
                          @Cast("char**") @ByPtrPtr byte[] OutMessage);

/* Verifies that a single function is valid, taking the specified action. Useful
   for debugging. */
public static native @Cast("LLVMBool") int LLVMVerifyFunction(LLVMValueRef Fn, @Cast("LLVMVerifierFailureAction") int Action);

/* Open up a ghostview window that displays the CFG of the current function.
   Useful for debugging. */
public static native void LLVMViewFunctionCFG(LLVMValueRef Fn);
public static native void LLVMViewFunctionCFGOnly(LLVMValueRef Fn);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/BitReader.h>

/*===-- llvm-c/BitReader.h - BitReader Library C Interface ------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMBitReader.a, which          *|
|* implements input of the LLVM bitcode format.                               *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_BITREADER_H
// #define LLVM_C_BITREADER_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCBitReader Bit Reader
 * \ingroup LLVMC
 *
 * \{
 */

/* Builds a module from the bitcode in the specified memory buffer, returning a
   reference to the module via the OutModule parameter. Returns 0 on success.
   Optionally returns a human-readable error message via OutMessage.

   This is deprecated. Use LLVMParseBitcode2. */
public static native @Cast("LLVMBool") int LLVMParseBitcode(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutModule,
                          @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcode(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutModule,
                          @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcode(LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutModule,
                          @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcode(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutModule,
                          @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcode(LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutModule,
                          @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcode(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutModule,
                          @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcode(LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutModule,
                          @Cast("char**") @ByPtrPtr byte[] OutMessage);

/* Builds a module from the bitcode in the specified memory buffer, returning a
   reference to the module via the OutModule parameter. Returns 0 on success. */
public static native @Cast("LLVMBool") int LLVMParseBitcode2(LLVMMemoryBufferRef MemBuf,
                           @ByPtrPtr LLVMModuleRef OutModule);
public static native @Cast("LLVMBool") int LLVMParseBitcode2(LLVMMemoryBufferRef MemBuf,
                           @Cast("LLVMModuleRef*") PointerPointer OutModule);

/* This is deprecated. Use LLVMParseBitcodeInContext2. */
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext(LLVMContextRef ContextRef,
                                   LLVMMemoryBufferRef MemBuf,
                                   @ByPtrPtr LLVMModuleRef OutModule, @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext(LLVMContextRef ContextRef,
                                   LLVMMemoryBufferRef MemBuf,
                                   @ByPtrPtr LLVMModuleRef OutModule, @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext(LLVMContextRef ContextRef,
                                   LLVMMemoryBufferRef MemBuf,
                                   @Cast("LLVMModuleRef*") PointerPointer OutModule, @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext(LLVMContextRef ContextRef,
                                   LLVMMemoryBufferRef MemBuf,
                                   @ByPtrPtr LLVMModuleRef OutModule, @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext(LLVMContextRef ContextRef,
                                   LLVMMemoryBufferRef MemBuf,
                                   @Cast("LLVMModuleRef*") PointerPointer OutModule, @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext(LLVMContextRef ContextRef,
                                   LLVMMemoryBufferRef MemBuf,
                                   @ByPtrPtr LLVMModuleRef OutModule, @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext(LLVMContextRef ContextRef,
                                   LLVMMemoryBufferRef MemBuf,
                                   @Cast("LLVMModuleRef*") PointerPointer OutModule, @Cast("char**") @ByPtrPtr byte[] OutMessage);

public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext2(LLVMContextRef ContextRef,
                                    LLVMMemoryBufferRef MemBuf,
                                    @ByPtrPtr LLVMModuleRef OutModule);
public static native @Cast("LLVMBool") int LLVMParseBitcodeInContext2(LLVMContextRef ContextRef,
                                    LLVMMemoryBufferRef MemBuf,
                                    @Cast("LLVMModuleRef*") PointerPointer OutModule);

/** Reads a module from the specified path, returning via the OutMP parameter
    a module provider which performs lazy deserialization. Returns 0 on success.
    Optionally returns a human-readable error message via OutMessage.
    This is deprecated. Use LLVMGetBitcodeModuleInContext2. */
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext(LLVMContextRef ContextRef,
                                       LLVMMemoryBufferRef MemBuf,
                                       @ByPtrPtr LLVMModuleRef OutM, @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext(LLVMContextRef ContextRef,
                                       LLVMMemoryBufferRef MemBuf,
                                       @ByPtrPtr LLVMModuleRef OutM, @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext(LLVMContextRef ContextRef,
                                       LLVMMemoryBufferRef MemBuf,
                                       @Cast("LLVMModuleRef*") PointerPointer OutM, @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext(LLVMContextRef ContextRef,
                                       LLVMMemoryBufferRef MemBuf,
                                       @ByPtrPtr LLVMModuleRef OutM, @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext(LLVMContextRef ContextRef,
                                       LLVMMemoryBufferRef MemBuf,
                                       @Cast("LLVMModuleRef*") PointerPointer OutM, @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext(LLVMContextRef ContextRef,
                                       LLVMMemoryBufferRef MemBuf,
                                       @ByPtrPtr LLVMModuleRef OutM, @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext(LLVMContextRef ContextRef,
                                       LLVMMemoryBufferRef MemBuf,
                                       @Cast("LLVMModuleRef*") PointerPointer OutM, @Cast("char**") @ByPtrPtr byte[] OutMessage);

/** Reads a module from the given memory buffer, returning via the OutMP
 * parameter a module provider which performs lazy deserialization.
 *
 * Returns 0 on success.
 *
 * Takes ownership of \p MemBuf if (and only if) the module was read
 * successfully. */
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext2(LLVMContextRef ContextRef,
                                        LLVMMemoryBufferRef MemBuf,
                                        @ByPtrPtr LLVMModuleRef OutM);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModuleInContext2(LLVMContextRef ContextRef,
                                        LLVMMemoryBufferRef MemBuf,
                                        @Cast("LLVMModuleRef*") PointerPointer OutM);

/* This is deprecated. Use LLVMGetBitcodeModule2. */
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule(LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutM,
                              @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule(LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutM,
                              @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule(LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutM,
                              @Cast("char**") @ByPtrPtr byte[] OutMessage);

public static native @Cast("LLVMBool") int LLVMGetBitcodeModule2(LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM);
public static native @Cast("LLVMBool") int LLVMGetBitcodeModule2(LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutM);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/BitWriter.h>

/*===-- llvm-c/BitWriter.h - BitWriter Library C Interface ------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMBitWriter.a, which          *|
|* implements output of the LLVM bitcode format.                              *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_BITWRITER_H
// #define LLVM_C_BITWRITER_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCBitWriter Bit Writer
 * \ingroup LLVMC
 *
 * \{
 */

/*===-- Operations on modules ---------------------------------------------===*/

/** Writes a module to the specified path. Returns 0 on success. */
public static native int LLVMWriteBitcodeToFile(LLVMModuleRef M, @Cast("const char*") BytePointer Path);
public static native int LLVMWriteBitcodeToFile(LLVMModuleRef M, String Path);

/** Writes a module to an open file descriptor. Returns 0 on success. */
public static native int LLVMWriteBitcodeToFD(LLVMModuleRef M, int FD, int ShouldClose,
                         int Unbuffered);

/** Deprecated for LLVMWriteBitcodeToFD. Writes a module to an open file
    descriptor. Returns 0 on success. Closes the Handle. */
public static native int LLVMWriteBitcodeToFileHandle(LLVMModuleRef M, int Handle);

/** Writes a module to a new memory buffer and returns it. */
public static native LLVMMemoryBufferRef LLVMWriteBitcodeToMemoryBuffer(LLVMModuleRef M);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/DisassemblerTypes.h>

/*===-- llvm-c/DisassemblerTypedefs.h -----------------------------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_DISASSEMBLERTYPES_H
// #define LLVM_C_DISASSEMBLERTYPES_H

// #include "llvm-c/DataTypes.h"
// #ifdef __cplusplus
// #include <cstddef>
// #else
// #include <stddef.h>
// Targeting ../LLVM/LLVMDisasmContextRef.java


// Targeting ../LLVM/LLVMOpInfoCallback.java


// Targeting ../LLVM/LLVMOpInfoSymbol1.java


// Targeting ../LLVM/LLVMOpInfo1.java



/**
 * The operand VariantKinds for symbolic disassembly.
 */
public static final int LLVMDisassembler_VariantKind_None = 0; /* all targets */

/**
 * The ARM target VariantKinds.
 */
public static final int LLVMDisassembler_VariantKind_ARM_HI16 = 1; /* :upper16: */
public static final int LLVMDisassembler_VariantKind_ARM_LO16 = 2; /* :lower16: */

/**
 * The ARM64 target VariantKinds.
 */
public static final int LLVMDisassembler_VariantKind_ARM64_PAGE =       1; /* @page */
public static final int LLVMDisassembler_VariantKind_ARM64_PAGEOFF =    2; /* @pageoff */
public static final int LLVMDisassembler_VariantKind_ARM64_GOTPAGE =    3; /* @gotpage */
public static final int LLVMDisassembler_VariantKind_ARM64_GOTPAGEOFF = 4; /* @gotpageoff */
public static final int LLVMDisassembler_VariantKind_ARM64_TLVP =       5; /* @tvlppage */
public static final int LLVMDisassembler_VariantKind_ARM64_TLVOFF =     6;
// Targeting ../LLVM/LLVMSymbolLookupCallback.java


/**
 * The reference types on input and output.
 */
/* No input reference type or no output reference type. */
public static final int LLVMDisassembler_ReferenceType_InOut_None = 0;

/* The input reference is from a branch instruction. */
public static final int LLVMDisassembler_ReferenceType_In_Branch = 1;
/* The input reference is from a PC relative load instruction. */
public static final int LLVMDisassembler_ReferenceType_In_PCrel_Load = 2;

/* The input reference is from an ARM64::ADRP instruction. */
public static final long LLVMDisassembler_ReferenceType_In_ARM64_ADRP = 0x100000001L;
/* The input reference is from an ARM64::ADDXri instruction. */
public static final long LLVMDisassembler_ReferenceType_In_ARM64_ADDXri = 0x100000002L;
/* The input reference is from an ARM64::LDRXui instruction. */
public static final long LLVMDisassembler_ReferenceType_In_ARM64_LDRXui = 0x100000003L;
/* The input reference is from an ARM64::LDRXl instruction. */
public static final long LLVMDisassembler_ReferenceType_In_ARM64_LDRXl = 0x100000004L;
/* The input reference is from an ARM64::ADR instruction. */
public static final long LLVMDisassembler_ReferenceType_In_ARM64_ADR = 0x100000005L;

/* The output reference is to as symbol stub. */
public static final int LLVMDisassembler_ReferenceType_Out_SymbolStub = 1;
/* The output reference is to a symbol address in a literal pool. */
public static final int LLVMDisassembler_ReferenceType_Out_LitPool_SymAddr = 2;
/* The output reference is to a cstring address in a literal pool. */
public static final int LLVMDisassembler_ReferenceType_Out_LitPool_CstrAddr = 3;

/* The output reference is to a Objective-C CoreFoundation string. */
public static final int LLVMDisassembler_ReferenceType_Out_Objc_CFString_Ref = 4;
/* The output reference is to a Objective-C message. */
public static final int LLVMDisassembler_ReferenceType_Out_Objc_Message = 5;
/* The output reference is to a Objective-C message ref. */
public static final int LLVMDisassembler_ReferenceType_Out_Objc_Message_Ref = 6;
/* The output reference is to a Objective-C selector ref. */
public static final int LLVMDisassembler_ReferenceType_Out_Objc_Selector_Ref = 7;
/* The output reference is to a Objective-C class ref. */
public static final int LLVMDisassembler_ReferenceType_Out_Objc_Class_Ref = 8;

/* The output reference is to a C++ symbol name. */
public static final int LLVMDisassembler_ReferenceType_DeMangled_Name = 9;

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Disassembler.h>

/*===-- llvm-c/Disassembler.h - Disassembler Public C Interface ---*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header provides a public interface to a disassembler library.         *|
|* LLVM provides an implementation of this interface.                         *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_DISASSEMBLER_H
// #define LLVM_C_DISASSEMBLER_H

// #include "llvm-c/DisassemblerTypes.h"
// #include "llvm-c/ExternC.h"

/**
 * \defgroup LLVMCDisassembler Disassembler
 * \ingroup LLVMC
 *
 * \{
 */

/**
 * Create a disassembler for the TripleName.  Symbolic disassembly is supported
 * by passing a block of information in the DisInfo parameter and specifying the
 * TagType and callback functions as described above.  These can all be passed
 * as NULL.  If successful, this returns a disassembler context.  If not, it
 * returns NULL. This function is equivalent to calling
 * LLVMCreateDisasmCPUFeatures() with an empty CPU name and feature set.
 */
public static native LLVMDisasmContextRef LLVMCreateDisasm(@Cast("const char*") BytePointer TripleName, Pointer DisInfo,
                                      int TagType, LLVMOpInfoCallback GetOpInfo,
                                      LLVMSymbolLookupCallback SymbolLookUp);
public static native LLVMDisasmContextRef LLVMCreateDisasm(String TripleName, Pointer DisInfo,
                                      int TagType, LLVMOpInfoCallback GetOpInfo,
                                      LLVMSymbolLookupCallback SymbolLookUp);

/**
 * Create a disassembler for the TripleName and a specific CPU.  Symbolic
 * disassembly is supported by passing a block of information in the DisInfo
 * parameter and specifying the TagType and callback functions as described
 * above.  These can all be passed * as NULL.  If successful, this returns a
 * disassembler context.  If not, it returns NULL. This function is equivalent
 * to calling LLVMCreateDisasmCPUFeatures() with an empty feature set.
 */
public static native LLVMDisasmContextRef LLVMCreateDisasmCPU(@Cast("const char*") BytePointer Triple, @Cast("const char*") BytePointer CPU,
                                         Pointer DisInfo, int TagType,
                                         LLVMOpInfoCallback GetOpInfo,
                                         LLVMSymbolLookupCallback SymbolLookUp);
public static native LLVMDisasmContextRef LLVMCreateDisasmCPU(String Triple, String CPU,
                                         Pointer DisInfo, int TagType,
                                         LLVMOpInfoCallback GetOpInfo,
                                         LLVMSymbolLookupCallback SymbolLookUp);

/**
 * Create a disassembler for the TripleName, a specific CPU and specific feature
 * string.  Symbolic disassembly is supported by passing a block of information
 * in the DisInfo parameter and specifying the TagType and callback functions as
 * described above.  These can all be passed * as NULL.  If successful, this
 * returns a disassembler context.  If not, it returns NULL.
 */
public static native LLVMDisasmContextRef LLVMCreateDisasmCPUFeatures(@Cast("const char*") BytePointer Triple, @Cast("const char*") BytePointer CPU,
                            @Cast("const char*") BytePointer Features, Pointer DisInfo, int TagType,
                            LLVMOpInfoCallback GetOpInfo,
                            LLVMSymbolLookupCallback SymbolLookUp);
public static native LLVMDisasmContextRef LLVMCreateDisasmCPUFeatures(String Triple, String CPU,
                            String Features, Pointer DisInfo, int TagType,
                            LLVMOpInfoCallback GetOpInfo,
                            LLVMSymbolLookupCallback SymbolLookUp);

/**
 * Set the disassembler's options.  Returns 1 if it can set the Options and 0
 * otherwise.
 */
public static native int LLVMSetDisasmOptions(LLVMDisasmContextRef DC, @Cast("uint64_t") long Options);

/* The option to produce marked up assembly. */
public static final int LLVMDisassembler_Option_UseMarkup = 1;
/* The option to print immediates as hex. */
public static final int LLVMDisassembler_Option_PrintImmHex = 2;
/* The option use the other assembler printer variant */
public static final int LLVMDisassembler_Option_AsmPrinterVariant = 4;
/* The option to set comment on instructions */
public static final int LLVMDisassembler_Option_SetInstrComments = 8;
  /* The option to print latency information alongside instructions */
public static final int LLVMDisassembler_Option_PrintLatency = 16;

/**
 * Dispose of a disassembler context.
 */
public static native void LLVMDisasmDispose(LLVMDisasmContextRef DC);

/**
 * Disassemble a single instruction using the disassembler context specified in
 * the parameter DC.  The bytes of the instruction are specified in the
 * parameter Bytes, and contains at least BytesSize number of bytes.  The
 * instruction is at the address specified by the PC parameter.  If a valid
 * instruction can be disassembled, its string is returned indirectly in
 * OutString whose size is specified in the parameter OutStringSize.  This
 * function returns the number of bytes in the instruction or zero if there was
 * no valid instruction.
 */
public static native @Cast("size_t") long LLVMDisasmInstruction(LLVMDisasmContextRef DC, @Cast("uint8_t*") BytePointer Bytes,
                             @Cast("uint64_t") long BytesSize, @Cast("uint64_t") long PC,
                             @Cast("char*") BytePointer OutString, @Cast("size_t") long OutStringSize);
public static native @Cast("size_t") long LLVMDisasmInstruction(LLVMDisasmContextRef DC, @Cast("uint8_t*") ByteBuffer Bytes,
                             @Cast("uint64_t") long BytesSize, @Cast("uint64_t") long PC,
                             @Cast("char*") ByteBuffer OutString, @Cast("size_t") long OutStringSize);
public static native @Cast("size_t") long LLVMDisasmInstruction(LLVMDisasmContextRef DC, @Cast("uint8_t*") byte[] Bytes,
                             @Cast("uint64_t") long BytesSize, @Cast("uint64_t") long PC,
                             @Cast("char*") byte[] OutString, @Cast("size_t") long OutStringSize);

/**
 * \}
 */

// #endif /* LLVM_C_DISASSEMBLER_H */


// Parsed from <llvm-c/Initialization.h>

/*===-- llvm-c/Initialization.h - Initialization C Interface ------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to LLVM initialization routines,      *|
|* which must be called before you can use the functionality provided by      *|
|* the corresponding LLVM library.                                            *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_INITIALIZATION_H
// #define LLVM_C_INITIALIZATION_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCInitialization Initialization Routines
 * \ingroup LLVMC
 *
 * This module contains routines used to initialize the LLVM system.
 *
 * \{
 */
public static native void LLVMInitializeTransformUtils(LLVMPassRegistryRef R);
public static native void LLVMInitializeScalarOpts(LLVMPassRegistryRef R);
public static native void LLVMInitializeObjCARCOpts(LLVMPassRegistryRef R);
public static native void LLVMInitializeVectorization(LLVMPassRegistryRef R);
public static native void LLVMInitializeInstCombine(LLVMPassRegistryRef R);
public static native void LLVMInitializeAggressiveInstCombiner(LLVMPassRegistryRef R);
public static native void LLVMInitializeIPO(LLVMPassRegistryRef R);
public static native void LLVMInitializeInstrumentation(LLVMPassRegistryRef R);
public static native void LLVMInitializeAnalysis(LLVMPassRegistryRef R);
public static native void LLVMInitializeIPA(LLVMPassRegistryRef R);
public static native void LLVMInitializeCodeGen(LLVMPassRegistryRef R);
public static native void LLVMInitializeTarget(LLVMPassRegistryRef R);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/IRReader.h>

/*===-- llvm-c/IRReader.h - IR Reader C Interface -----------------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file defines the C interface to the IR Reader.                        *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_IRREADER_H
// #define LLVM_C_IRREADER_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCCoreIRReader IR Reader
 * \ingroup LLVMCCore
 *
 * \{
 */

/**
 * Read LLVM IR from a memory buffer and convert it into an in-memory Module
 * object. Returns 0 on success.
 * Optionally returns a human-readable description of any errors that
 * occurred during parsing IR. OutMessage must be disposed with
 * LLVMDisposeMessage.
 *
 * @see llvm::ParseIR()
 */
public static native @Cast("LLVMBool") int LLVMParseIRInContext(LLVMContextRef ContextRef,
                              LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") PointerPointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseIRInContext(LLVMContextRef ContextRef,
                              LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseIRInContext(LLVMContextRef ContextRef,
                              LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutM,
                              @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseIRInContext(LLVMContextRef ContextRef,
                              LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") @ByPtrPtr byte[] OutMessage);
public static native @Cast("LLVMBool") int LLVMParseIRInContext(LLVMContextRef ContextRef,
                              LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutM,
                              @Cast("char**") @ByPtrPtr BytePointer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseIRInContext(LLVMContextRef ContextRef,
                              LLVMMemoryBufferRef MemBuf, @ByPtrPtr LLVMModuleRef OutM,
                              @Cast("char**") @ByPtrPtr ByteBuffer OutMessage);
public static native @Cast("LLVMBool") int LLVMParseIRInContext(LLVMContextRef ContextRef,
                              LLVMMemoryBufferRef MemBuf, @Cast("LLVMModuleRef*") PointerPointer OutM,
                              @Cast("char**") @ByPtrPtr byte[] OutMessage);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Linker.h>

/*===-- llvm-c/Linker.h - Module Linker C Interface -------------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file defines the C interface to the module/file/archive linker.       *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_LINKER_H
// #define LLVM_C_LINKER_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCCoreLinker Linker
 * \ingroup LLVMCCore
 *
 * \{
 */

/* This enum is provided for backwards-compatibility only. It has no effect. */
/** enum LLVMLinkerMode */
public static final int
  LLVMLinkerDestroySource = 0, /* This is the default behavior. */
  LLVMLinkerPreserveSource_Removed = 1; /* This option has been deprecated and
                                          should not be used. */

/* Links the source module into the destination module. The source module is
 * destroyed.
 * The return value is true if an error occurred, false otherwise.
 * Use the diagnostic handler to get any diagnostic message.
*/
public static native @Cast("LLVMBool") int LLVMLinkModules2(LLVMModuleRef Dest, LLVMModuleRef Src);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/lto.h>

/*===-- llvm-c/lto.h - LTO Public C Interface ---------------------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header provides public interface to an abstract link time optimization*|
|* library.  LLVM provides an implementation of this interface for use with   *|
|* llvm bitcode files.                                                        *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_LTO_H
// #define LLVM_C_LTO_H

// #include "llvm-c/ExternC.h"

// #ifdef __cplusplus
// #include <cstddef>
// #else
// #include <stddef.h>
// #endif
// #include <sys/types.h>

// #ifndef __cplusplus
// #if !defined(_MSC_VER)
// #include <stdbool.h>
// #else
/* MSVC in particular does not have anything like _Bool or bool in C, but we can
   at least make sure the type is the same size.  The implementation side will
   use C++ bool. */
// #endif
// #else
// #endif

/**
 * \defgroup LLVMCLTO LTO
 * \ingroup LLVMC
 *
 * \{
 */

public static final int LTO_API_VERSION = 29;

/**
 * @since prior to LTO_API_VERSION=3
 */
/** enum lto_symbol_attributes */
public static final int
    LTO_SYMBOL_ALIGNMENT_MASK              = 0x0000001F, /* log2 of alignment */
    LTO_SYMBOL_PERMISSIONS_MASK            = 0x000000E0,
    LTO_SYMBOL_PERMISSIONS_CODE            = 0x000000A0,
    LTO_SYMBOL_PERMISSIONS_DATA            = 0x000000C0,
    LTO_SYMBOL_PERMISSIONS_RODATA          = 0x00000080,
    LTO_SYMBOL_DEFINITION_MASK             = 0x00000700,
    LTO_SYMBOL_DEFINITION_REGULAR          = 0x00000100,
    LTO_SYMBOL_DEFINITION_TENTATIVE        = 0x00000200,
    LTO_SYMBOL_DEFINITION_WEAK             = 0x00000300,
    LTO_SYMBOL_DEFINITION_UNDEFINED        = 0x00000400,
    LTO_SYMBOL_DEFINITION_WEAKUNDEF        = 0x00000500,
    LTO_SYMBOL_SCOPE_MASK                  = 0x00003800,
    LTO_SYMBOL_SCOPE_INTERNAL              = 0x00000800,
    LTO_SYMBOL_SCOPE_HIDDEN                = 0x00001000,
    LTO_SYMBOL_SCOPE_PROTECTED             = 0x00002000,
    LTO_SYMBOL_SCOPE_DEFAULT               = 0x00001800,
    LTO_SYMBOL_SCOPE_DEFAULT_CAN_BE_HIDDEN = 0x00002800,
    LTO_SYMBOL_COMDAT                      = 0x00004000,
    LTO_SYMBOL_ALIAS                       = 0x00008000;

/**
 * @since prior to LTO_API_VERSION=3
 */
/** enum lto_debug_model */
public static final int
    LTO_DEBUG_MODEL_NONE         = 0,
    LTO_DEBUG_MODEL_DWARF        = 1;

/**
 * @since prior to LTO_API_VERSION=3
 */
/** enum lto_codegen_model */
public static final int
    LTO_CODEGEN_PIC_MODEL_STATIC         = 0,
    LTO_CODEGEN_PIC_MODEL_DYNAMIC        = 1,
    LTO_CODEGEN_PIC_MODEL_DYNAMIC_NO_PIC = 2,
    LTO_CODEGEN_PIC_MODEL_DEFAULT        = 3;
// Targeting ../LLVM/lto_module_t.java


// Targeting ../LLVM/lto_code_gen_t.java


// Targeting ../LLVM/thinlto_code_gen_t.java



/**
 * Returns a printable string.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("const char*") BytePointer lto_get_version();

/**
 * Returns the last error string or NULL if last operation was successful.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("const char*") BytePointer lto_get_error_message();

/**
 * Checks if a file is a loadable object file.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_bool_t") boolean lto_module_is_object_file(@Cast("const char*") BytePointer path);
public static native @Cast("lto_bool_t") boolean lto_module_is_object_file(String path);

/**
 * Checks if a file is a loadable object compiled for requested target.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_bool_t") boolean lto_module_is_object_file_for_target(@Cast("const char*") BytePointer path,
                                     @Cast("const char*") BytePointer target_triple_prefix);
public static native @Cast("lto_bool_t") boolean lto_module_is_object_file_for_target(String path,
                                     String target_triple_prefix);

/**
 * Return true if \p Buffer contains a bitcode file with ObjC code (category
 * or class) in it.
 *
 * @since LTO_API_VERSION=20
 */
public static native @Cast("lto_bool_t") boolean lto_module_has_objc_category(@Const Pointer mem, @Cast("size_t") long length);

/**
 * Checks if a buffer is a loadable object file.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_bool_t") boolean lto_module_is_object_file_in_memory(@Const Pointer mem,
                                                      @Cast("size_t") long length);

/**
 * Checks if a buffer is a loadable object compiled for requested target.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_bool_t") boolean lto_module_is_object_file_in_memory_for_target(@Const Pointer mem, @Cast("size_t") long length,
                                              @Cast("const char*") BytePointer target_triple_prefix);
public static native @Cast("lto_bool_t") boolean lto_module_is_object_file_in_memory_for_target(@Const Pointer mem, @Cast("size_t") long length,
                                              String target_triple_prefix);

/**
 * Loads an object file from disk.
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native lto_module_t lto_module_create(@Cast("const char*") BytePointer path);
public static native lto_module_t lto_module_create(String path);

/**
 * Loads an object file from memory.
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native lto_module_t lto_module_create_from_memory(@Const Pointer mem, @Cast("size_t") long length);

/**
 * Loads an object file from memory with an extra path argument.
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=9
 */
public static native lto_module_t lto_module_create_from_memory_with_path(@Const Pointer mem, @Cast("size_t") long length,
                                        @Cast("const char*") BytePointer path);
public static native lto_module_t lto_module_create_from_memory_with_path(@Const Pointer mem, @Cast("size_t") long length,
                                        String path);

/**
 * Loads an object file in its own context.
 *
 * Loads an object file in its own LLVMContext.  This function call is
 * thread-safe.  However, modules created this way should not be merged into an
 * lto_code_gen_t using \a lto_codegen_add_module().
 *
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=11
 */
public static native lto_module_t lto_module_create_in_local_context(@Const Pointer mem, @Cast("size_t") long length,
                                   @Cast("const char*") BytePointer path);
public static native lto_module_t lto_module_create_in_local_context(@Const Pointer mem, @Cast("size_t") long length,
                                   String path);

/**
 * Loads an object file in the codegen context.
 *
 * Loads an object file into the same context as \c cg.  The module is safe to
 * add using \a lto_codegen_add_module().
 *
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=11
 */
public static native lto_module_t lto_module_create_in_codegen_context(@Const Pointer mem, @Cast("size_t") long length,
                                     @Cast("const char*") BytePointer path, lto_code_gen_t cg);
public static native lto_module_t lto_module_create_in_codegen_context(@Const Pointer mem, @Cast("size_t") long length,
                                     String path, lto_code_gen_t cg);

/**
 * Loads an object file from disk. The seek point of fd is not preserved.
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=5
 */
public static native lto_module_t lto_module_create_from_fd(int fd, @Cast("const char*") BytePointer path, @Cast("size_t") long file_size);
public static native lto_module_t lto_module_create_from_fd(int fd, String path, @Cast("size_t") long file_size);

/**
 * Loads an object file from disk. The seek point of fd is not preserved.
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=5
 */
public static native lto_module_t lto_module_create_from_fd_at_offset(int fd, @Cast("const char*") BytePointer path, @Cast("size_t") long file_size,
                                    @Cast("size_t") long map_size, @Cast("off_t") long offset);
public static native lto_module_t lto_module_create_from_fd_at_offset(int fd, String path, @Cast("size_t") long file_size,
                                    @Cast("size_t") long map_size, @Cast("off_t") long offset);

/**
 * Frees all memory internally allocated by the module.
 * Upon return the lto_module_t is no longer valid.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native void lto_module_dispose(lto_module_t mod);

/**
 * Returns triple string which the object module was compiled under.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("const char*") BytePointer lto_module_get_target_triple(lto_module_t mod);

/**
 * Sets triple string with which the object will be codegened.
 *
 * @since LTO_API_VERSION=4
 */
public static native void lto_module_set_target_triple(lto_module_t mod, @Cast("const char*") BytePointer triple);
public static native void lto_module_set_target_triple(lto_module_t mod, String triple);

/**
 * Returns the number of symbols in the object module.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("unsigned int") int lto_module_get_num_symbols(lto_module_t mod);

/**
 * Returns the name of the ith symbol in the object module.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("const char*") BytePointer lto_module_get_symbol_name(lto_module_t mod, @Cast("unsigned int") int index);

/**
 * Returns the attributes of the ith symbol in the object module.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_symbol_attributes") int lto_module_get_symbol_attribute(lto_module_t mod, @Cast("unsigned int") int index);

/**
 * Returns the module's linker options.
 *
 * The linker options may consist of multiple flags. It is the linker's
 * responsibility to split the flags using a platform-specific mechanism.
 *
 * @since LTO_API_VERSION=16
 */
public static native @Cast("const char*") BytePointer lto_module_get_linkeropts(lto_module_t mod);

/**
 * If targeting mach-o on darwin, this function gets the CPU type and subtype
 * that will end up being encoded in the mach-o header. These are the values
 * that can be found in mach/machine.h.
 *
 * \p out_cputype and \p out_cpusubtype must be non-NULL.
 *
 * Returns true on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=27
 */
public static native @Cast("lto_bool_t") boolean lto_module_get_macho_cputype(lto_module_t mod,
                                               @Cast("unsigned int*") IntPointer out_cputype,
                                               @Cast("unsigned int*") IntPointer out_cpusubtype);
public static native @Cast("lto_bool_t") boolean lto_module_get_macho_cputype(lto_module_t mod,
                                               @Cast("unsigned int*") IntBuffer out_cputype,
                                               @Cast("unsigned int*") IntBuffer out_cpusubtype);
public static native @Cast("lto_bool_t") boolean lto_module_get_macho_cputype(lto_module_t mod,
                                               @Cast("unsigned int*") int[] out_cputype,
                                               @Cast("unsigned int*") int[] out_cpusubtype);

/**
 * This function can be used by the linker to check if a given module has
 * any constructor or destructor functions.
 *
 * Returns true if the module has either the \llvm.global_ctors or the
 * \llvm.global_dtors symbol. Otherwise returns false.
 *
 * @since LTO_API_VERSION=29
 */
public static native @Cast("lto_bool_t") boolean lto_module_has_ctor_dtor(lto_module_t mod);
/**
 * Diagnostic severity.
 *
 * @since LTO_API_VERSION=7
 */
/** enum lto_codegen_diagnostic_severity_t */
public static final int
  LTO_DS_ERROR = 0,
  LTO_DS_WARNING = 1,
  LTO_DS_REMARK = 3, // Added in LTO_API_VERSION=10.
  LTO_DS_NOTE = 2;
// Targeting ../LLVM/lto_diagnostic_handler_t.java



/**
 * Set a diagnostic handler and the related context (void *).
 * This is more general than lto_get_error_message, as the diagnostic handler
 * can be called at anytime within lto.
 *
 * @since LTO_API_VERSION=7
 */
public static native void lto_codegen_set_diagnostic_handler(lto_code_gen_t arg0,
                                               lto_diagnostic_handler_t arg1,
                                               Pointer arg2);

/**
 * Instantiates a code generator.
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 * All modules added using \a lto_codegen_add_module() must have been created
 * in the same context as the codegen.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native lto_code_gen_t lto_codegen_create();

/**
 * Instantiate a code generator in its own context.
 *
 * Instantiates a code generator in its own context.  Modules added via \a
 * lto_codegen_add_module() must have all been created in the same context,
 * using \a lto_module_create_in_codegen_context().
 *
 * @since LTO_API_VERSION=11
 */
public static native lto_code_gen_t lto_codegen_create_in_local_context();

/**
 * Frees all code generator and all memory it internally allocated.
 * Upon return the lto_code_gen_t is no longer valid.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native void lto_codegen_dispose(lto_code_gen_t arg0);

/**
 * Add an object module to the set of modules for which code will be generated.
 * Returns true on error (check lto_get_error_message() for details).
 *
 * \c cg and \c mod must both be in the same context.  See \a
 * lto_codegen_create_in_local_context() and \a
 * lto_module_create_in_codegen_context().
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_bool_t") boolean lto_codegen_add_module(lto_code_gen_t cg, lto_module_t mod);

/**
 * Sets the object module for code generation. This will transfer the ownership
 * of the module to the code generator.
 *
 * \c cg and \c mod must both be in the same context.
 *
 * @since LTO_API_VERSION=13
 */
public static native void lto_codegen_set_module(lto_code_gen_t cg, lto_module_t mod);

/**
 * Sets if debug info should be generated.
 * Returns true on error (check lto_get_error_message() for details).
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_bool_t") boolean lto_codegen_set_debug_model(lto_code_gen_t cg, @Cast("lto_debug_model") int arg1);

/**
 * Sets which PIC code model to generated.
 * Returns true on error (check lto_get_error_message() for details).
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Cast("lto_bool_t") boolean lto_codegen_set_pic_model(lto_code_gen_t cg, @Cast("lto_codegen_model") int arg1);

/**
 * Sets the cpu to generate code for.
 *
 * @since LTO_API_VERSION=4
 */
public static native void lto_codegen_set_cpu(lto_code_gen_t cg, @Cast("const char*") BytePointer cpu);
public static native void lto_codegen_set_cpu(lto_code_gen_t cg, String cpu);

/**
 * Sets the location of the assembler tool to run. If not set, libLTO
 * will use gcc to invoke the assembler.
 *
 * @since LTO_API_VERSION=3
 */
public static native void lto_codegen_set_assembler_path(lto_code_gen_t cg, @Cast("const char*") BytePointer path);
public static native void lto_codegen_set_assembler_path(lto_code_gen_t cg, String path);

/**
 * Sets extra arguments that libLTO should pass to the assembler.
 *
 * @since LTO_API_VERSION=4
 */
public static native void lto_codegen_set_assembler_args(lto_code_gen_t cg, @Cast("const char**") PointerPointer args,
                               int nargs);
public static native void lto_codegen_set_assembler_args(lto_code_gen_t cg, @Cast("const char**") @ByPtrPtr BytePointer args,
                               int nargs);
public static native void lto_codegen_set_assembler_args(lto_code_gen_t cg, @Cast("const char**") @ByPtrPtr ByteBuffer args,
                               int nargs);
public static native void lto_codegen_set_assembler_args(lto_code_gen_t cg, @Cast("const char**") @ByPtrPtr byte[] args,
                               int nargs);

/**
 * Adds to a list of all global symbols that must exist in the final generated
 * code. If a function is not listed there, it might be inlined into every usage
 * and optimized away.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native void lto_codegen_add_must_preserve_symbol(lto_code_gen_t cg, @Cast("const char*") BytePointer symbol);
public static native void lto_codegen_add_must_preserve_symbol(lto_code_gen_t cg, String symbol);

/**
 * Writes a new object file at the specified path that contains the
 * merged contents of all modules added so far.
 * Returns true on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=5
 */
public static native @Cast("lto_bool_t") boolean lto_codegen_write_merged_modules(lto_code_gen_t cg, @Cast("const char*") BytePointer path);
public static native @Cast("lto_bool_t") boolean lto_codegen_write_merged_modules(lto_code_gen_t cg, String path);

/**
 * Generates code for all added modules into one native object file.
 * This calls lto_codegen_optimize then lto_codegen_compile_optimized.
 *
 * On success returns a pointer to a generated mach-o/ELF buffer and
 * length set to the buffer size.  The buffer is owned by the
 * lto_code_gen_t and will be freed when lto_codegen_dispose()
 * is called, or lto_codegen_compile() is called again.
 * On failure, returns NULL (check lto_get_error_message() for details).
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native @Const Pointer lto_codegen_compile(lto_code_gen_t cg, @Cast("size_t*") SizeTPointer length);

/**
 * Generates code for all added modules into one native object file.
 * This calls lto_codegen_optimize then lto_codegen_compile_optimized (instead
 * of returning a generated mach-o/ELF buffer, it writes to a file).
 *
 * The name of the file is written to name. Returns true on error.
 *
 * @since LTO_API_VERSION=5
 */
public static native @Cast("lto_bool_t") boolean lto_codegen_compile_to_file(lto_code_gen_t cg, @Cast("const char**") PointerPointer name);
public static native @Cast("lto_bool_t") boolean lto_codegen_compile_to_file(lto_code_gen_t cg, @Cast("const char**") @ByPtrPtr BytePointer name);
public static native @Cast("lto_bool_t") boolean lto_codegen_compile_to_file(lto_code_gen_t cg, @Cast("const char**") @ByPtrPtr ByteBuffer name);
public static native @Cast("lto_bool_t") boolean lto_codegen_compile_to_file(lto_code_gen_t cg, @Cast("const char**") @ByPtrPtr byte[] name);

/**
 * Runs optimization for the merged module. Returns true on error.
 *
 * @since LTO_API_VERSION=12
 */
public static native @Cast("lto_bool_t") boolean lto_codegen_optimize(lto_code_gen_t cg);

/**
 * Generates code for the optimized merged module into one native object file.
 * It will not run any IR optimizations on the merged module.
 *
 * On success returns a pointer to a generated mach-o/ELF buffer and length set
 * to the buffer size.  The buffer is owned by the lto_code_gen_t and will be
 * freed when lto_codegen_dispose() is called, or
 * lto_codegen_compile_optimized() is called again. On failure, returns NULL
 * (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=12
 */
public static native @Const Pointer lto_codegen_compile_optimized(lto_code_gen_t cg, @Cast("size_t*") SizeTPointer length);

/**
 * Returns the runtime API version.
 *
 * @since LTO_API_VERSION=12
 */
public static native @Cast("unsigned int") int lto_api_version();

/**
 * Parses options immediately, making them available as early as possible. For
 * example during executing codegen::InitTargetOptionsFromCodeGenFlags. Since
 * parsing shud only happen once, only one of lto_codegen_debug_options or
 * lto_set_debug_options should be called.
 *
 * This function takes one or more options separated by spaces.
 * Warning: passing file paths through this function may confuse the argument
 * parser if the paths contain spaces.
 *
 * @since LTO_API_VERSION=28
 */
public static native void lto_set_debug_options(@Cast("const char*const*") PointerPointer options, int number);
public static native void lto_set_debug_options(@Cast("const char*const*") @ByPtrPtr BytePointer options, int number);
public static native void lto_set_debug_options(@Cast("const char*const*") @ByPtrPtr ByteBuffer options, int number);
public static native void lto_set_debug_options(@Cast("const char*const*") @ByPtrPtr byte[] options, int number);

/**
 * Sets options to help debug codegen bugs. Since parsing shud only happen once,
 * only one of lto_codegen_debug_options or lto_set_debug_options
 * should be called.
 *
 * This function takes one or more options separated by spaces.
 * Warning: passing file paths through this function may confuse the argument
 * parser if the paths contain spaces.
 *
 * @since prior to LTO_API_VERSION=3
 */
public static native void lto_codegen_debug_options(lto_code_gen_t cg, @Cast("const char*") BytePointer arg1);
public static native void lto_codegen_debug_options(lto_code_gen_t cg, String arg1);

/**
 * Same as the previous function, but takes every option separately through an
 * array.
 *
 * @since prior to LTO_API_VERSION=26
 */
public static native void lto_codegen_debug_options_array(lto_code_gen_t cg,
                                            @Cast("const char*const*") PointerPointer arg1, int number);
public static native void lto_codegen_debug_options_array(lto_code_gen_t cg,
                                            @Cast("const char*const*") @ByPtrPtr BytePointer arg1, int number);
public static native void lto_codegen_debug_options_array(lto_code_gen_t cg,
                                            @Cast("const char*const*") @ByPtrPtr ByteBuffer arg1, int number);
public static native void lto_codegen_debug_options_array(lto_code_gen_t cg,
                                            @Cast("const char*const*") @ByPtrPtr byte[] arg1, int number);

/**
 * Initializes LLVM disassemblers.
 * FIXME: This doesn't really belong here.
 *
 * @since LTO_API_VERSION=5
 */
public static native void lto_initialize_disassembler();

/**
 * Sets if we should run internalize pass during optimization and code
 * generation.
 *
 * @since LTO_API_VERSION=14
 */
public static native void lto_codegen_set_should_internalize(lto_code_gen_t cg,
                                   @Cast("lto_bool_t") boolean ShouldInternalize);

/**
 * Set whether to embed uselists in bitcode.
 *
 * Sets whether \a lto_codegen_write_merged_modules() should embed uselists in
 * output bitcode.  This should be turned on for all -save-temps output.
 *
 * @since LTO_API_VERSION=15
 */
public static native void lto_codegen_set_should_embed_uselists(lto_code_gen_t cg,
                                      @Cast("lto_bool_t") boolean ShouldEmbedUselists);
// Targeting ../LLVM/lto_input_t.java



/**
  * Creates an LTO input file from a buffer. The path
  * argument is used for diagnotics as this function
  * otherwise does not know which file the given buffer
  * is associated with.
  *
  * @since LTO_API_VERSION=24
  */
public static native lto_input_t lto_input_create(@Const Pointer buffer,
                                    @Cast("size_t") long buffer_size,
                                    @Cast("const char*") BytePointer path);
public static native lto_input_t lto_input_create(@Const Pointer buffer,
                                    @Cast("size_t") long buffer_size,
                                    String path);

/**
  * Frees all memory internally allocated by the LTO input file.
  * Upon return the lto_module_t is no longer valid.
  *
  * @since LTO_API_VERSION=24
  */
public static native void lto_input_dispose(lto_input_t input);

/**
  * Returns the number of dependent library specifiers
  * for the given LTO input file.
  *
  * @since LTO_API_VERSION=24
  */
public static native @Cast("unsigned") int lto_input_get_num_dependent_libraries(lto_input_t input);

/**
  * Returns the ith dependent library specifier
  * for the given LTO input file. The returned
  * string is not null-terminated.
  *
  * @since LTO_API_VERSION=24
  */
public static native @Cast("const char*") BytePointer lto_input_get_dependent_library(lto_input_t input,
                                                    @Cast("size_t") long index,
                                                    @Cast("size_t*") SizeTPointer size);

/**
 * Returns the list of libcall symbols that can be generated by LTO
 * that might not be visible from the symbol table of bitcode files.
 *
 * @since prior to LTO_API_VERSION=25
 */
public static native @Cast("const char*const*") PointerPointer lto_runtime_lib_symbols_list(@Cast("size_t*") SizeTPointer size);
// Targeting ../LLVM/LTOObjectBuffer.java



/**
 * Instantiates a ThinLTO code generator.
 * Returns NULL on error (check lto_get_error_message() for details).
 *
 *
 * The ThinLTOCodeGenerator is not intended to be reuse for multiple
 * compilation: the model is that the client adds modules to the generator and
 * ask to perform the ThinLTO optimizations / codegen, and finally destroys the
 * codegenerator.
 *
 * @since LTO_API_VERSION=18
 */
public static native thinlto_code_gen_t thinlto_create_codegen();

/**
 * Frees the generator and all memory it internally allocated.
 * Upon return the thinlto_code_gen_t is no longer valid.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_dispose(thinlto_code_gen_t cg);

/**
 * Add a module to a ThinLTO code generator. Identifier has to be unique among
 * all the modules in a code generator. The data buffer stays owned by the
 * client, and is expected to be available for the entire lifetime of the
 * thinlto_code_gen_t it is added to.
 *
 * On failure, returns NULL (check lto_get_error_message() for details).
 *
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_add_module(thinlto_code_gen_t cg,
                                       @Cast("const char*") BytePointer identifier, @Cast("const char*") BytePointer data,
                                       int length);
public static native void thinlto_codegen_add_module(thinlto_code_gen_t cg,
                                       String identifier, String data,
                                       int length);

/**
 * Optimize and codegen all the modules added to the codegenerator using
 * ThinLTO. Resulting objects are accessible using thinlto_module_get_object().
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_process(thinlto_code_gen_t cg);

/**
 * Returns the number of object files produced by the ThinLTO CodeGenerator.
 *
 * It usually matches the number of input files, but this is not a guarantee of
 * the API and may change in future implementation, so the client should not
 * assume it.
 *
 * @since LTO_API_VERSION=18
 */
public static native @Cast("unsigned int") int thinlto_module_get_num_objects(thinlto_code_gen_t cg);

/**
 * Returns a reference to the ith object file produced by the ThinLTO
 * CodeGenerator.
 *
 * Client should use \p thinlto_module_get_num_objects() to get the number of
 * available objects.
 *
 * @since LTO_API_VERSION=18
 */
public static native @ByVal LTOObjectBuffer thinlto_module_get_object(thinlto_code_gen_t cg,
                                                 @Cast("unsigned int") int index);

/**
 * Returns the number of object files produced by the ThinLTO CodeGenerator.
 *
 * It usually matches the number of input files, but this is not a guarantee of
 * the API and may change in future implementation, so the client should not
 * assume it.
 *
 * @since LTO_API_VERSION=21
 */
public static native @Cast("unsigned int") int thinlto_module_get_num_object_files(thinlto_code_gen_t cg);

/**
 * Returns the path to the ith object file produced by the ThinLTO
 * CodeGenerator.
 *
 * Client should use \p thinlto_module_get_num_object_files() to get the number
 * of available objects.
 *
 * @since LTO_API_VERSION=21
 */
public static native @Cast("const char*") BytePointer thinlto_module_get_object_file(thinlto_code_gen_t cg,
                                           @Cast("unsigned int") int index);

/**
 * Sets which PIC code model to generate.
 * Returns true on error (check lto_get_error_message() for details).
 *
 * @since LTO_API_VERSION=18
 */
public static native @Cast("lto_bool_t") boolean thinlto_codegen_set_pic_model(thinlto_code_gen_t cg,
                                                @Cast("lto_codegen_model") int arg1);

/**
 * Sets the path to a directory to use as a storage for temporary bitcode files.
 * The intention is to make the bitcode files available for debugging at various
 * stage of the pipeline.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_set_savetemps_dir(thinlto_code_gen_t cg,
                                              @Cast("const char*") BytePointer save_temps_dir);
public static native void thinlto_codegen_set_savetemps_dir(thinlto_code_gen_t cg,
                                              String save_temps_dir);

/**
 * Set the path to a directory where to save generated object files. This
 * path can be used by a linker to request on-disk files instead of in-memory
 * buffers. When set, results are available through
 * thinlto_module_get_object_file() instead of thinlto_module_get_object().
 *
 * @since LTO_API_VERSION=21
 */
public static native void thinlto_set_generated_objects_dir(thinlto_code_gen_t cg,
                                       @Cast("const char*") BytePointer save_temps_dir);
public static native void thinlto_set_generated_objects_dir(thinlto_code_gen_t cg,
                                       String save_temps_dir);

/**
 * Sets the cpu to generate code for.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_set_cpu(thinlto_code_gen_t cg, @Cast("const char*") BytePointer cpu);
public static native void thinlto_codegen_set_cpu(thinlto_code_gen_t cg, String cpu);

/**
 * Disable CodeGen, only run the stages till codegen and stop. The output will
 * be bitcode.
 *
 * @since LTO_API_VERSION=19
 */
public static native void thinlto_codegen_disable_codegen(thinlto_code_gen_t cg,
                                            @Cast("lto_bool_t") boolean disable);

/**
 * Perform CodeGen only: disable all other stages.
 *
 * @since LTO_API_VERSION=19
 */
public static native void thinlto_codegen_set_codegen_only(thinlto_code_gen_t cg,
                                             @Cast("lto_bool_t") boolean codegen_only);

/**
 * Parse -mllvm style debug options.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_debug_options(@Cast("const char*const*") PointerPointer options, int number);
public static native void thinlto_debug_options(@Cast("const char*const*") @ByPtrPtr BytePointer options, int number);
public static native void thinlto_debug_options(@Cast("const char*const*") @ByPtrPtr ByteBuffer options, int number);
public static native void thinlto_debug_options(@Cast("const char*const*") @ByPtrPtr byte[] options, int number);

/**
 * Test if a module has support for ThinLTO linking.
 *
 * @since LTO_API_VERSION=18
 */
public static native @Cast("lto_bool_t") boolean lto_module_is_thinlto(lto_module_t mod);

/**
 * Adds a symbol to the list of global symbols that must exist in the final
 * generated code. If a function is not listed there, it might be inlined into
 * every usage and optimized away. For every single module, the functions
 * referenced from code outside of the ThinLTO modules need to be added here.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_add_must_preserve_symbol(thinlto_code_gen_t cg,
                                                     @Cast("const char*") BytePointer name,
                                                     int length);
public static native void thinlto_codegen_add_must_preserve_symbol(thinlto_code_gen_t cg,
                                                     String name,
                                                     int length);

/**
 * Adds a symbol to the list of global symbols that are cross-referenced between
 * ThinLTO files. If the ThinLTO CodeGenerator can ensure that every
 * references from a ThinLTO module to this symbol is optimized away, then
 * the symbol can be discarded.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_add_cross_referenced_symbol(thinlto_code_gen_t cg,
                                                        @Cast("const char*") BytePointer name,
                                                        int length);
public static native void thinlto_codegen_add_cross_referenced_symbol(thinlto_code_gen_t cg,
                                                        String name,
                                                        int length);

/**
 * \} // endgoup LLVMCTLTO
 * \defgroup LLVMCTLTO_CACHING ThinLTO Cache Control
 * \ingroup LLVMCTLTO
 *
 * These entry points control the ThinLTO cache. The cache is intended to
 * support incremental builds, and thus needs to be persistent across builds.
 * The client enables the cache by supplying a path to an existing directory.
 * The code generator will use this to store objects files that may be reused
 * during a subsequent build.
 * To avoid filling the disk space, a few knobs are provided:
 *  - The pruning interval limits the frequency at which the garbage collector
 *    will try to scan the cache directory to prune expired entries.
 *    Setting to a negative number disables the pruning.
 *  - The pruning expiration time indicates to the garbage collector how old an
 *    entry needs to be to be removed.
 *  - Finally, the garbage collector can be instructed to prune the cache until
 *    the occupied space goes below a threshold.
 * \{
 */

/**
 * Sets the path to a directory to use as a cache storage for incremental build.
 * Setting this activates caching.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_set_cache_dir(thinlto_code_gen_t cg,
                                          @Cast("const char*") BytePointer cache_dir);
public static native void thinlto_codegen_set_cache_dir(thinlto_code_gen_t cg,
                                          String cache_dir);

/**
 * Sets the cache pruning interval (in seconds). A negative value disables the
 * pruning. An unspecified default value will be applied, and a value of 0 will
 * force prunning to occur.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_set_cache_pruning_interval(thinlto_code_gen_t cg,
                                                       int interval);

/**
 * Sets the maximum cache size that can be persistent across build, in terms of
 * percentage of the available space on the disk. Set to 100 to indicate
 * no limit, 50 to indicate that the cache size will not be left over half the
 * available space. A value over 100 will be reduced to 100, a value of 0 will
 * be ignored. An unspecified default value will be applied.
 *
 * The formula looks like:
 *  AvailableSpace = FreeSpace + ExistingCacheSize
 *  NewCacheSize = AvailableSpace * P/100
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_set_final_cache_size_relative_to_available_space(
    thinlto_code_gen_t cg, @Cast("unsigned") int percentage);

/**
 * Sets the expiration (in seconds) for an entry in the cache. An unspecified
 * default value will be applied. A value of 0 will be ignored.
 *
 * @since LTO_API_VERSION=18
 */
public static native void thinlto_codegen_set_cache_entry_expiration(thinlto_code_gen_t cg,
                                                       @Cast("unsigned") int expiration);

/**
 * Sets the maximum size of the cache directory (in bytes). A value over the
 * amount of available space on the disk will be reduced to the amount of
 * available space. An unspecified default value will be applied. A value of 0
 * will be ignored.
 *
 * @since LTO_API_VERSION=22
 */
public static native void thinlto_codegen_set_cache_size_bytes(thinlto_code_gen_t cg,
                                                 @Cast("unsigned") int max_size_bytes);

/**
 * Same as thinlto_codegen_set_cache_size_bytes, except the maximum size is in
 * megabytes (2^20 bytes).
 *
 * @since LTO_API_VERSION=23
 */
public static native void thinlto_codegen_set_cache_size_megabytes(thinlto_code_gen_t cg,
                                         @Cast("unsigned") int max_size_megabytes);

/**
 * Sets the maximum number of files in the cache directory. An unspecified
 * default value will be applied. A value of 0 will be ignored.
 *
 * @since LTO_API_VERSION=22
 */
public static native void thinlto_codegen_set_cache_size_files(thinlto_code_gen_t cg,
                                                 @Cast("unsigned") int max_size_files);

/**
 * \} // endgroup LLVMCTLTO_CACHING
 */

// #endif /* LLVM_C_LTO_H */


// Parsed from <llvm-c/Object.h>

/*===-- llvm-c/Object.h - Object Lib C Iface --------------------*- C++ -*-===*/
/*                                                                            */
/* Part of the LLVM Project, under the Apache License v2.0 with LLVM          */
/* Exceptions.                                                                */
/* See https://llvm.org/LICENSE.txt for license information.                  */
/* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    */
/*                                                                            */
/*===----------------------------------------------------------------------===*/
/*                                                                            */
/* This header declares the C interface to libLLVMObject.a, which             */
/* implements object file reading and writing.                                */
/*                                                                            */
/* Many exotic languages can interoperate with C code but have a harder time  */
/* with C++ due to name mangling. So in addition to C, this interface enables */
/* tools written in such languages.                                           */
/*                                                                            */
/*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_OBJECT_H
// #define LLVM_C_OBJECT_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"
// #include "llvm/Config/llvm-config.h"
// Targeting ../LLVM/LLVMSectionIteratorRef.java


// Targeting ../LLVM/LLVMSymbolIteratorRef.java


// Targeting ../LLVM/LLVMRelocationIteratorRef.java



/** enum LLVMBinaryType */
public static final int
  /** Archive file. */
  LLVMBinaryTypeArchive = 0,
  /** Mach-O Universal Binary file. */
  LLVMBinaryTypeMachOUniversalBinary = 1,
  /** COFF Import file. */
  LLVMBinaryTypeCOFFImportFile = 2,
  /** LLVM IR. */
  LLVMBinaryTypeIR = 3,
  /** Windows resource (.res) file. */
  LLVMBinaryTypeWinRes = 4,
  /** COFF Object file. */
  LLVMBinaryTypeCOFF = 5,
  /** ELF 32-bit, little endian. */
  LLVMBinaryTypeELF32L = 6,
  /** ELF 32-bit, big endian. */
  LLVMBinaryTypeELF32B = 7,
  /** ELF 64-bit, little endian. */
  LLVMBinaryTypeELF64L = 8,
  /** ELF 64-bit, big endian. */
  LLVMBinaryTypeELF64B = 9,
  /** MachO 32-bit, little endian. */
  LLVMBinaryTypeMachO32L = 10,
  /** MachO 32-bit, big endian. */
  LLVMBinaryTypeMachO32B = 11,
  /** MachO 64-bit, little endian. */
  LLVMBinaryTypeMachO64L = 12,
  /** MachO 64-bit, big endian. */
  LLVMBinaryTypeMachO64B = 13,
  /** Web Assembly. */
  LLVMBinaryTypeWasm = 14,
  /** Offloading fatbinary. */
  LLVMBinaryTypeOffload = 15;

/**
 * Create a binary file from the given memory buffer.
 *
 * The exact type of the binary file will be inferred automatically, and the
 * appropriate implementation selected.  The context may be NULL except if
 * the resulting file is an LLVM IR file.
 *
 * The memory buffer is not consumed by this function.  It is the responsibilty
 * of the caller to free it with \c LLVMDisposeMemoryBuffer.
 *
 * If NULL is returned, the \p ErrorMessage parameter is populated with the
 * error's description.  It is then the caller's responsibility to free this
 * message by calling \c LLVMDisposeMessage.
 *
 * @see llvm::object::createBinary
 */
public static native LLVMBinaryRef LLVMCreateBinary(LLVMMemoryBufferRef MemBuf,
                               LLVMContextRef Context,
                               @Cast("char**") PointerPointer ErrorMessage);
public static native LLVMBinaryRef LLVMCreateBinary(LLVMMemoryBufferRef MemBuf,
                               LLVMContextRef Context,
                               @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native LLVMBinaryRef LLVMCreateBinary(LLVMMemoryBufferRef MemBuf,
                               LLVMContextRef Context,
                               @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native LLVMBinaryRef LLVMCreateBinary(LLVMMemoryBufferRef MemBuf,
                               LLVMContextRef Context,
                               @Cast("char**") @ByPtrPtr byte[] ErrorMessage);

/**
 * Dispose of a binary file.
 *
 * The binary file does not own its backing buffer.  It is the responsibilty
 * of the caller to free it with \c LLVMDisposeMemoryBuffer.
 */
public static native void LLVMDisposeBinary(LLVMBinaryRef BR);

/**
 * Retrieves a copy of the memory buffer associated with this object file.
 *
 * The returned buffer is merely a shallow copy and does not own the actual
 * backing buffer of the binary. Nevertheless, it is the responsibility of the
 * caller to free it with \c LLVMDisposeMemoryBuffer.
 *
 * @see llvm::object::getMemoryBufferRef
 */
public static native LLVMMemoryBufferRef LLVMBinaryCopyMemoryBuffer(LLVMBinaryRef BR);

/**
 * Retrieve the specific type of a binary.
 *
 * @see llvm::object::Binary::getType
 */
public static native @Cast("LLVMBinaryType") int LLVMBinaryGetType(LLVMBinaryRef BR);

/*
 * For a Mach-O universal binary file, retrieves the object file corresponding
 * to the given architecture if it is present as a slice.
 *
 * If NULL is returned, the \p ErrorMessage parameter is populated with the
 * error's description.  It is then the caller's responsibility to free this
 * message by calling \c LLVMDisposeMessage.
 *
 * It is the responsiblity of the caller to free the returned object file by
 * calling \c LLVMDisposeBinary.
 */
public static native LLVMBinaryRef LLVMMachOUniversalBinaryCopyObjectForArch(LLVMBinaryRef BR,
                                                        @Cast("const char*") BytePointer Arch,
                                                        @Cast("size_t") long ArchLen,
                                                        @Cast("char**") PointerPointer ErrorMessage);
public static native LLVMBinaryRef LLVMMachOUniversalBinaryCopyObjectForArch(LLVMBinaryRef BR,
                                                        @Cast("const char*") BytePointer Arch,
                                                        @Cast("size_t") long ArchLen,
                                                        @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native LLVMBinaryRef LLVMMachOUniversalBinaryCopyObjectForArch(LLVMBinaryRef BR,
                                                        String Arch,
                                                        @Cast("size_t") long ArchLen,
                                                        @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native LLVMBinaryRef LLVMMachOUniversalBinaryCopyObjectForArch(LLVMBinaryRef BR,
                                                        @Cast("const char*") BytePointer Arch,
                                                        @Cast("size_t") long ArchLen,
                                                        @Cast("char**") @ByPtrPtr byte[] ErrorMessage);
public static native LLVMBinaryRef LLVMMachOUniversalBinaryCopyObjectForArch(LLVMBinaryRef BR,
                                                        String Arch,
                                                        @Cast("size_t") long ArchLen,
                                                        @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native LLVMBinaryRef LLVMMachOUniversalBinaryCopyObjectForArch(LLVMBinaryRef BR,
                                                        @Cast("const char*") BytePointer Arch,
                                                        @Cast("size_t") long ArchLen,
                                                        @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native LLVMBinaryRef LLVMMachOUniversalBinaryCopyObjectForArch(LLVMBinaryRef BR,
                                                        String Arch,
                                                        @Cast("size_t") long ArchLen,
                                                        @Cast("char**") @ByPtrPtr byte[] ErrorMessage);

/**
 * Retrieve a copy of the section iterator for this object file.
 *
 * If there are no sections, the result is NULL.
 *
 * The returned iterator is merely a shallow copy. Nevertheless, it is
 * the responsibility of the caller to free it with
 * \c LLVMDisposeSectionIterator.
 *
 * @see llvm::object::sections()
 */
public static native LLVMSectionIteratorRef LLVMObjectFileCopySectionIterator(LLVMBinaryRef BR);

/**
 * Returns whether the given section iterator is at the end.
 *
 * @see llvm::object::section_end
 */
public static native @Cast("LLVMBool") int LLVMObjectFileIsSectionIteratorAtEnd(LLVMBinaryRef BR,
                                              LLVMSectionIteratorRef SI);

/**
 * Retrieve a copy of the symbol iterator for this object file.
 *
 * If there are no symbols, the result is NULL.
 *
 * The returned iterator is merely a shallow copy. Nevertheless, it is
 * the responsibility of the caller to free it with
 * \c LLVMDisposeSymbolIterator.
 *
 * @see llvm::object::symbols()
 */
public static native LLVMSymbolIteratorRef LLVMObjectFileCopySymbolIterator(LLVMBinaryRef BR);

/**
 * Returns whether the given symbol iterator is at the end.
 *
 * @see llvm::object::symbol_end
 */
public static native @Cast("LLVMBool") int LLVMObjectFileIsSymbolIteratorAtEnd(LLVMBinaryRef BR,
                                             LLVMSymbolIteratorRef SI);

public static native void LLVMDisposeSectionIterator(LLVMSectionIteratorRef SI);

public static native void LLVMMoveToNextSection(LLVMSectionIteratorRef SI);
public static native void LLVMMoveToContainingSection(LLVMSectionIteratorRef Sect,
                                 LLVMSymbolIteratorRef Sym);

// ObjectFile Symbol iterators
public static native void LLVMDisposeSymbolIterator(LLVMSymbolIteratorRef SI);
public static native void LLVMMoveToNextSymbol(LLVMSymbolIteratorRef SI);

// SectionRef accessors
public static native @Cast("const char*") BytePointer LLVMGetSectionName(LLVMSectionIteratorRef SI);
public static native @Cast("uint64_t") long LLVMGetSectionSize(LLVMSectionIteratorRef SI);
public static native @Cast("const char*") BytePointer LLVMGetSectionContents(LLVMSectionIteratorRef SI);
public static native @Cast("uint64_t") long LLVMGetSectionAddress(LLVMSectionIteratorRef SI);
public static native @Cast("LLVMBool") int LLVMGetSectionContainsSymbol(LLVMSectionIteratorRef SI,
                                 LLVMSymbolIteratorRef Sym);

// Section Relocation iterators
public static native LLVMRelocationIteratorRef LLVMGetRelocations(LLVMSectionIteratorRef Section);
public static native void LLVMDisposeRelocationIterator(LLVMRelocationIteratorRef RI);
public static native @Cast("LLVMBool") int LLVMIsRelocationIteratorAtEnd(LLVMSectionIteratorRef Section,
                                       LLVMRelocationIteratorRef RI);
public static native void LLVMMoveToNextRelocation(LLVMRelocationIteratorRef RI);


// SymbolRef accessors
public static native @Cast("const char*") BytePointer LLVMGetSymbolName(LLVMSymbolIteratorRef SI);
public static native @Cast("uint64_t") long LLVMGetSymbolAddress(LLVMSymbolIteratorRef SI);
public static native @Cast("uint64_t") long LLVMGetSymbolSize(LLVMSymbolIteratorRef SI);

// RelocationRef accessors
public static native @Cast("uint64_t") long LLVMGetRelocationOffset(LLVMRelocationIteratorRef RI);
public static native LLVMSymbolIteratorRef LLVMGetRelocationSymbol(LLVMRelocationIteratorRef RI);
public static native @Cast("uint64_t") long LLVMGetRelocationType(LLVMRelocationIteratorRef RI);
// NOTE: Caller takes ownership of returned string of the two
// following functions.
public static native @Cast("const char*") BytePointer LLVMGetRelocationTypeName(LLVMRelocationIteratorRef RI);
public static native @Cast("const char*") BytePointer LLVMGetRelocationValueString(LLVMRelocationIteratorRef RI);
// Targeting ../LLVM/LLVMObjectFileRef.java



/** Deprecated: Use LLVMCreateBinary instead. */
public static native LLVMObjectFileRef LLVMCreateObjectFile(LLVMMemoryBufferRef MemBuf);

/** Deprecated: Use LLVMDisposeBinary instead. */
public static native void LLVMDisposeObjectFile(LLVMObjectFileRef ObjectFile);

/** Deprecated: Use LLVMObjectFileCopySectionIterator instead. */
public static native LLVMSectionIteratorRef LLVMGetSections(LLVMObjectFileRef ObjectFile);

/** Deprecated: Use LLVMObjectFileIsSectionIteratorAtEnd instead. */
public static native @Cast("LLVMBool") int LLVMIsSectionIteratorAtEnd(LLVMObjectFileRef ObjectFile,
                                    LLVMSectionIteratorRef SI);

/** Deprecated: Use LLVMObjectFileCopySymbolIterator instead. */
public static native LLVMSymbolIteratorRef LLVMGetSymbols(LLVMObjectFileRef ObjectFile);

/** Deprecated: Use LLVMObjectFileIsSymbolIteratorAtEnd instead. */
public static native @Cast("LLVMBool") int LLVMIsSymbolIteratorAtEnd(LLVMObjectFileRef ObjectFile,
                                   LLVMSymbolIteratorRef SI);
/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Target.h>

/*===-- llvm-c/Target.h - Target Lib C Iface --------------------*- C++ -*-===*/
/*                                                                            */
/* Part of the LLVM Project, under the Apache License v2.0 with LLVM          */
/* Exceptions.                                                                */
/* See https://llvm.org/LICENSE.txt for license information.                  */
/* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    */
/*                                                                            */
/*===----------------------------------------------------------------------===*/
/*                                                                            */
/* This header declares the C interface to libLLVMTarget.a, which             */
/* implements target information.                                             */
/*                                                                            */
/* Many exotic languages can interoperate with C code but have a harder time  */
/* with C++ due to name mangling. So in addition to C, this interface enables */
/* tools written in such languages.                                           */
/*                                                                            */
/*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TARGET_H
// #define LLVM_C_TARGET_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"
// #include "llvm/Config/llvm-config.h"

/**
 * \defgroup LLVMCTarget Target information
 * \ingroup LLVMC
 *
 * \{
 */

/** enum LLVMByteOrdering */
public static final int LLVMBigEndian = 0, LLVMLittleEndian = 1;
// Targeting ../LLVM/LLVMTargetDataRef.java


// Targeting ../LLVM/LLVMTargetLibraryInfoRef.java



/* Declare all of the target-initialization functions that are available. */
// #define LLVM_TARGET(TargetName)
//   void LLVMInitialize##TargetName##TargetInfo(void);
// #include "llvm/Config/Targets.def"
// #undef LLVM_TARGET  /* Explicit undef to make SWIG happier */

// #define LLVM_TARGET(TargetName) void LLVMInitialize##TargetName##Target(void);
// #include "llvm/Config/Targets.def"
// #undef LLVM_TARGET  /* Explicit undef to make SWIG happier */

// #define LLVM_TARGET(TargetName)
//   void LLVMInitialize##TargetName##TargetMC(void);
// #include "llvm/Config/Targets.def"
// #undef LLVM_TARGET  /* Explicit undef to make SWIG happier */

/* Declare all of the available assembly printer initialization functions. */
// #define LLVM_ASM_PRINTER(TargetName)
//   void LLVMInitialize##TargetName##AsmPrinter(void);
// #include "llvm/Config/AsmPrinters.def"
// #undef LLVM_ASM_PRINTER  /* Explicit undef to make SWIG happier */

/* Declare all of the available assembly parser initialization functions. */
// #define LLVM_ASM_PARSER(TargetName)
//   void LLVMInitialize##TargetName##AsmParser(void);
// #include "llvm/Config/AsmParsers.def"
// #undef LLVM_ASM_PARSER  /* Explicit undef to make SWIG happier */

/* Declare all of the available disassembler initialization functions. */
// #define LLVM_DISASSEMBLER(TargetName)
//   void LLVMInitialize##TargetName##Disassembler(void);
// #include "llvm/Config/Disassemblers.def"
// #undef LLVM_DISASSEMBLER  /* Explicit undef to make SWIG happier */

/** LLVMInitializeAllTargetInfos - The main program should call this function if
    it wants access to all available targets that LLVM is configured to
    support. */
public static native void LLVMInitializeAllTargetInfos();

/** LLVMInitializeAllTargets - The main program should call this function if it
    wants to link in all available targets that LLVM is configured to
    support. */
public static native void LLVMInitializeAllTargets();

/** LLVMInitializeAllTargetMCs - The main program should call this function if
    it wants access to all available target MC that LLVM is configured to
    support. */
public static native void LLVMInitializeAllTargetMCs();

/** LLVMInitializeAllAsmPrinters - The main program should call this function if
    it wants all asm printers that LLVM is configured to support, to make them
    available via the TargetRegistry. */
public static native void LLVMInitializeAllAsmPrinters();

/** LLVMInitializeAllAsmParsers - The main program should call this function if
    it wants all asm parsers that LLVM is configured to support, to make them
    available via the TargetRegistry. */
public static native void LLVMInitializeAllAsmParsers();

/** LLVMInitializeAllDisassemblers - The main program should call this function
    if it wants all disassemblers that LLVM is configured to support, to make
    them available via the TargetRegistry. */
public static native void LLVMInitializeAllDisassemblers();

/** LLVMInitializeNativeTarget - The main program should call this function to
    initialize the native target corresponding to the host.  This is useful
    for JIT applications to ensure that the target gets linked in correctly. */
public static native @Cast("LLVMBool") int LLVMInitializeNativeTarget();

/** LLVMInitializeNativeTargetAsmParser - The main program should call this
    function to initialize the parser for the native target corresponding to the
    host. */
public static native @Cast("LLVMBool") int LLVMInitializeNativeAsmParser();

/** LLVMInitializeNativeTargetAsmPrinter - The main program should call this
    function to initialize the printer for the native target corresponding to
    the host. */
public static native @Cast("LLVMBool") int LLVMInitializeNativeAsmPrinter();

/** LLVMInitializeNativeTargetDisassembler - The main program should call this
    function to initialize the disassembler for the native target corresponding
    to the host. */
public static native @Cast("LLVMBool") int LLVMInitializeNativeDisassembler();

/*===-- Target Data -------------------------------------------------------===*/

/**
 * Obtain the data layout for a module.
 *
 * @see Module::getDataLayout()
 */
public static native LLVMTargetDataRef LLVMGetModuleDataLayout(LLVMModuleRef M);

/**
 * Set the data layout for a module.
 *
 * @see Module::setDataLayout()
 */
public static native void LLVMSetModuleDataLayout(LLVMModuleRef M, LLVMTargetDataRef DL);

/** Creates target data from a target layout string.
    See the constructor llvm::DataLayout::DataLayout. */
public static native LLVMTargetDataRef LLVMCreateTargetData(@Cast("const char*") BytePointer StringRep);
public static native LLVMTargetDataRef LLVMCreateTargetData(String StringRep);

/** Deallocates a TargetData.
    See the destructor llvm::DataLayout::~DataLayout. */
public static native void LLVMDisposeTargetData(LLVMTargetDataRef TD);

/** Adds target library information to a pass manager. This does not take
    ownership of the target library info.
    See the method llvm::PassManagerBase::add. */
public static native void LLVMAddTargetLibraryInfo(LLVMTargetLibraryInfoRef TLI,
                              LLVMPassManagerRef PM);

/** Converts target data to a target layout string. The string must be disposed
    with LLVMDisposeMessage.
    See the constructor llvm::DataLayout::DataLayout. */
public static native @Cast("char*") BytePointer LLVMCopyStringRepOfTargetData(LLVMTargetDataRef TD);

/** Returns the byte order of a target, either LLVMBigEndian or
    LLVMLittleEndian.
    See the method llvm::DataLayout::isLittleEndian. */
public static native @Cast("LLVMByteOrdering") int LLVMByteOrder(LLVMTargetDataRef TD);

/** Returns the pointer size in bytes for a target.
    See the method llvm::DataLayout::getPointerSize. */
public static native @Cast("unsigned") int LLVMPointerSize(LLVMTargetDataRef TD);

/** Returns the pointer size in bytes for a target for a specified
    address space.
    See the method llvm::DataLayout::getPointerSize. */
public static native @Cast("unsigned") int LLVMPointerSizeForAS(LLVMTargetDataRef TD, @Cast("unsigned") int AS);

/** Returns the integer type that is the same size as a pointer on a target.
    See the method llvm::DataLayout::getIntPtrType. */
public static native LLVMTypeRef LLVMIntPtrType(LLVMTargetDataRef TD);

/** Returns the integer type that is the same size as a pointer on a target.
    This version allows the address space to be specified.
    See the method llvm::DataLayout::getIntPtrType. */
public static native LLVMTypeRef LLVMIntPtrTypeForAS(LLVMTargetDataRef TD, @Cast("unsigned") int AS);

/** Returns the integer type that is the same size as a pointer on a target.
    See the method llvm::DataLayout::getIntPtrType. */
public static native LLVMTypeRef LLVMIntPtrTypeInContext(LLVMContextRef C, LLVMTargetDataRef TD);

/** Returns the integer type that is the same size as a pointer on a target.
    This version allows the address space to be specified.
    See the method llvm::DataLayout::getIntPtrType. */
public static native LLVMTypeRef LLVMIntPtrTypeForASInContext(LLVMContextRef C, LLVMTargetDataRef TD,
                                         @Cast("unsigned") int AS);

/** Computes the size of a type in bytes for a target.
    See the method llvm::DataLayout::getTypeSizeInBits. */
public static native @Cast("unsigned long long") long LLVMSizeOfTypeInBits(LLVMTargetDataRef TD, LLVMTypeRef Ty);

/** Computes the storage size of a type in bytes for a target.
    See the method llvm::DataLayout::getTypeStoreSize. */
public static native @Cast("unsigned long long") long LLVMStoreSizeOfType(LLVMTargetDataRef TD, LLVMTypeRef Ty);

/** Computes the ABI size of a type in bytes for a target.
    See the method llvm::DataLayout::getTypeAllocSize. */
public static native @Cast("unsigned long long") long LLVMABISizeOfType(LLVMTargetDataRef TD, LLVMTypeRef Ty);

/** Computes the ABI alignment of a type in bytes for a target.
    See the method llvm::DataLayout::getTypeABISize. */
public static native @Cast("unsigned") int LLVMABIAlignmentOfType(LLVMTargetDataRef TD, LLVMTypeRef Ty);

/** Computes the call frame alignment of a type in bytes for a target.
    See the method llvm::DataLayout::getTypeABISize. */
public static native @Cast("unsigned") int LLVMCallFrameAlignmentOfType(LLVMTargetDataRef TD, LLVMTypeRef Ty);

/** Computes the preferred alignment of a type in bytes for a target.
    See the method llvm::DataLayout::getTypeABISize. */
public static native @Cast("unsigned") int LLVMPreferredAlignmentOfType(LLVMTargetDataRef TD, LLVMTypeRef Ty);

/** Computes the preferred alignment of a global variable in bytes for a target.
    See the method llvm::DataLayout::getPreferredAlignment. */
public static native @Cast("unsigned") int LLVMPreferredAlignmentOfGlobal(LLVMTargetDataRef TD,
                                        LLVMValueRef GlobalVar);

/** Computes the structure element that contains the byte offset for a target.
    See the method llvm::StructLayout::getElementContainingOffset. */
public static native @Cast("unsigned") int LLVMElementAtOffset(LLVMTargetDataRef TD, LLVMTypeRef StructTy,
                             @Cast("unsigned long long") long Offset);

/** Computes the byte offset of the indexed struct element for a target.
    See the method llvm::StructLayout::getElementContainingOffset. */
public static native @Cast("unsigned long long") long LLVMOffsetOfElement(LLVMTargetDataRef TD,
                                       LLVMTypeRef StructTy, @Cast("unsigned") int Element);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/TargetMachine.h>

/*===-- llvm-c/TargetMachine.h - Target Machine Library C Interface - C++ -*-=*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to the Target and TargetMachine       *|
|* classes, which can be used to generate assembly or object files.           *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TARGETMACHINE_H
// #define LLVM_C_TARGETMACHINE_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Target.h"
// #include "llvm-c/Types.h"
// Targeting ../LLVM/LLVMTargetMachineRef.java


// Targeting ../LLVM/LLVMTargetRef.java



/** enum LLVMCodeGenOptLevel */
public static final int
    LLVMCodeGenLevelNone = 0,
    LLVMCodeGenLevelLess = 1,
    LLVMCodeGenLevelDefault = 2,
    LLVMCodeGenLevelAggressive = 3;

/** enum LLVMRelocMode */
public static final int
    LLVMRelocDefault = 0,
    LLVMRelocStatic = 1,
    LLVMRelocPIC = 2,
    LLVMRelocDynamicNoPic = 3,
    LLVMRelocROPI = 4,
    LLVMRelocRWPI = 5,
    LLVMRelocROPI_RWPI = 6;

/** enum LLVMCodeModel */
public static final int
    LLVMCodeModelDefault = 0,
    LLVMCodeModelJITDefault = 1,
    LLVMCodeModelTiny = 2,
    LLVMCodeModelSmall = 3,
    LLVMCodeModelKernel = 4,
    LLVMCodeModelMedium = 5,
    LLVMCodeModelLarge = 6;

/** enum LLVMCodeGenFileType */
public static final int
    LLVMAssemblyFile = 0,
    LLVMObjectFile = 1;

/** Returns the first llvm::Target in the registered targets list. */
public static native LLVMTargetRef LLVMGetFirstTarget();
/** Returns the next llvm::Target given a previous one (or null if there's none) */
public static native LLVMTargetRef LLVMGetNextTarget(LLVMTargetRef T);

/*===-- Target ------------------------------------------------------------===*/
/** Finds the target corresponding to the given name and stores it in \p T.
  Returns 0 on success. */
public static native LLVMTargetRef LLVMGetTargetFromName(@Cast("const char*") BytePointer Name);
public static native LLVMTargetRef LLVMGetTargetFromName(String Name);

/** Finds the target corresponding to the given triple and stores it in \p T.
  Returns 0 on success. Optionally returns any error in ErrorMessage.
  Use LLVMDisposeMessage to dispose the message. */
public static native @Cast("LLVMBool") int LLVMGetTargetFromTriple(@Cast("const char*") BytePointer Triple, @ByPtrPtr LLVMTargetRef T,
                                 @Cast("char**") PointerPointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMGetTargetFromTriple(@Cast("const char*") BytePointer Triple, @ByPtrPtr LLVMTargetRef T,
                                 @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMGetTargetFromTriple(String Triple, @Cast("LLVMTargetRef*") PointerPointer T,
                                 @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMGetTargetFromTriple(@Cast("const char*") BytePointer Triple, @ByPtrPtr LLVMTargetRef T,
                                 @Cast("char**") @ByPtrPtr byte[] ErrorMessage);
public static native @Cast("LLVMBool") int LLVMGetTargetFromTriple(String Triple, @Cast("LLVMTargetRef*") PointerPointer T,
                                 @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMGetTargetFromTriple(@Cast("const char*") BytePointer Triple, @ByPtrPtr LLVMTargetRef T,
                                 @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMGetTargetFromTriple(String Triple, @Cast("LLVMTargetRef*") PointerPointer T,
                                 @Cast("char**") @ByPtrPtr byte[] ErrorMessage);

/** Returns the name of a target. See llvm::Target::getName */
public static native @Cast("const char*") BytePointer LLVMGetTargetName(LLVMTargetRef T);

/** Returns the description  of a target. See llvm::Target::getDescription */
public static native @Cast("const char*") BytePointer LLVMGetTargetDescription(LLVMTargetRef T);

/** Returns if the target has a JIT */
public static native @Cast("LLVMBool") int LLVMTargetHasJIT(LLVMTargetRef T);

/** Returns if the target has a TargetMachine associated */
public static native @Cast("LLVMBool") int LLVMTargetHasTargetMachine(LLVMTargetRef T);

/** Returns if the target as an ASM backend (required for emitting output) */
public static native @Cast("LLVMBool") int LLVMTargetHasAsmBackend(LLVMTargetRef T);

/*===-- Target Machine ----------------------------------------------------===*/
/** Creates a new llvm::TargetMachine. See llvm::Target::createTargetMachine */
public static native LLVMTargetMachineRef LLVMCreateTargetMachine(LLVMTargetRef T,
  @Cast("const char*") BytePointer Triple, @Cast("const char*") BytePointer CPU, @Cast("const char*") BytePointer Features,
  @Cast("LLVMCodeGenOptLevel") int Level, @Cast("LLVMRelocMode") int Reloc, @Cast("LLVMCodeModel") int CodeModel);
public static native LLVMTargetMachineRef LLVMCreateTargetMachine(LLVMTargetRef T,
  String Triple, String CPU, String Features,
  @Cast("LLVMCodeGenOptLevel") int Level, @Cast("LLVMRelocMode") int Reloc, @Cast("LLVMCodeModel") int CodeModel);

/** Dispose the LLVMTargetMachineRef instance generated by
  LLVMCreateTargetMachine. */
public static native void LLVMDisposeTargetMachine(LLVMTargetMachineRef T);

/** Returns the Target used in a TargetMachine */
public static native LLVMTargetRef LLVMGetTargetMachineTarget(LLVMTargetMachineRef T);

/** Returns the triple used creating this target machine. See
  llvm::TargetMachine::getTriple. The result needs to be disposed with
  LLVMDisposeMessage. */
public static native @Cast("char*") BytePointer LLVMGetTargetMachineTriple(LLVMTargetMachineRef T);

/** Returns the cpu used creating this target machine. See
  llvm::TargetMachine::getCPU. The result needs to be disposed with
  LLVMDisposeMessage. */
public static native @Cast("char*") BytePointer LLVMGetTargetMachineCPU(LLVMTargetMachineRef T);

/** Returns the feature string used creating this target machine. See
  llvm::TargetMachine::getFeatureString. The result needs to be disposed with
  LLVMDisposeMessage. */
public static native @Cast("char*") BytePointer LLVMGetTargetMachineFeatureString(LLVMTargetMachineRef T);

/** Create a DataLayout based on the targetMachine. */
public static native LLVMTargetDataRef LLVMCreateTargetDataLayout(LLVMTargetMachineRef T);

/** Set the target machine's ASM verbosity. */
public static native void LLVMSetTargetMachineAsmVerbosity(LLVMTargetMachineRef T,
                                      @Cast("LLVMBool") int VerboseAsm);

/** Emits an asm or object file for the given module to the filename. This
  wraps several c++ only classes (among them a file stream). Returns any
  error in ErrorMessage. Use LLVMDisposeMessage to dispose the message. */
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToFile(LLVMTargetMachineRef T, LLVMModuleRef M,
                                     @Cast("const char*") BytePointer Filename,
                                     @Cast("LLVMCodeGenFileType") int codegen,
                                     @Cast("char**") PointerPointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToFile(LLVMTargetMachineRef T, LLVMModuleRef M,
                                     @Cast("const char*") BytePointer Filename,
                                     @Cast("LLVMCodeGenFileType") int codegen,
                                     @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToFile(LLVMTargetMachineRef T, LLVMModuleRef M,
                                     String Filename,
                                     @Cast("LLVMCodeGenFileType") int codegen,
                                     @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToFile(LLVMTargetMachineRef T, LLVMModuleRef M,
                                     @Cast("const char*") BytePointer Filename,
                                     @Cast("LLVMCodeGenFileType") int codegen,
                                     @Cast("char**") @ByPtrPtr byte[] ErrorMessage);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToFile(LLVMTargetMachineRef T, LLVMModuleRef M,
                                     String Filename,
                                     @Cast("LLVMCodeGenFileType") int codegen,
                                     @Cast("char**") @ByPtrPtr BytePointer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToFile(LLVMTargetMachineRef T, LLVMModuleRef M,
                                     @Cast("const char*") BytePointer Filename,
                                     @Cast("LLVMCodeGenFileType") int codegen,
                                     @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToFile(LLVMTargetMachineRef T, LLVMModuleRef M,
                                     String Filename,
                                     @Cast("LLVMCodeGenFileType") int codegen,
                                     @Cast("char**") @ByPtrPtr byte[] ErrorMessage);

/** Compile the LLVM IR stored in \p M and store the result in \p OutMemBuf. */
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToMemoryBuffer(LLVMTargetMachineRef T, LLVMModuleRef M,
  @Cast("LLVMCodeGenFileType") int codegen, @Cast("char**") PointerPointer ErrorMessage, @ByPtrPtr LLVMMemoryBufferRef OutMemBuf);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToMemoryBuffer(LLVMTargetMachineRef T, LLVMModuleRef M,
  @Cast("LLVMCodeGenFileType") int codegen, @Cast("char**") @ByPtrPtr BytePointer ErrorMessage, @ByPtrPtr LLVMMemoryBufferRef OutMemBuf);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToMemoryBuffer(LLVMTargetMachineRef T, LLVMModuleRef M,
  @Cast("LLVMCodeGenFileType") int codegen, @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage, @Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToMemoryBuffer(LLVMTargetMachineRef T, LLVMModuleRef M,
  @Cast("LLVMCodeGenFileType") int codegen, @Cast("char**") @ByPtrPtr byte[] ErrorMessage, @ByPtrPtr LLVMMemoryBufferRef OutMemBuf);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToMemoryBuffer(LLVMTargetMachineRef T, LLVMModuleRef M,
  @Cast("LLVMCodeGenFileType") int codegen, @Cast("char**") @ByPtrPtr BytePointer ErrorMessage, @Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToMemoryBuffer(LLVMTargetMachineRef T, LLVMModuleRef M,
  @Cast("LLVMCodeGenFileType") int codegen, @Cast("char**") @ByPtrPtr ByteBuffer ErrorMessage, @ByPtrPtr LLVMMemoryBufferRef OutMemBuf);
public static native @Cast("LLVMBool") int LLVMTargetMachineEmitToMemoryBuffer(LLVMTargetMachineRef T, LLVMModuleRef M,
  @Cast("LLVMCodeGenFileType") int codegen, @Cast("char**") @ByPtrPtr byte[] ErrorMessage, @Cast("LLVMMemoryBufferRef*") PointerPointer OutMemBuf);

/*===-- Triple ------------------------------------------------------------===*/
/** Get a triple for the host machine as a string. The result needs to be
  disposed with LLVMDisposeMessage. */
public static native @Cast("char*") BytePointer LLVMGetDefaultTargetTriple();

/** Normalize a target triple. The result needs to be disposed with
  LLVMDisposeMessage. */
public static native @Cast("char*") BytePointer LLVMNormalizeTargetTriple(@Cast("const char*") BytePointer triple);
public static native @Cast("char*") ByteBuffer LLVMNormalizeTargetTriple(String triple);

/** Get the host CPU as a string. The result needs to be disposed with
  LLVMDisposeMessage. */
public static native @Cast("char*") BytePointer LLVMGetHostCPUName();

/** Get the host CPU's features as a string. The result needs to be disposed
  with LLVMDisposeMessage. */
public static native @Cast("char*") BytePointer LLVMGetHostCPUFeatures();

/** Adds the target-specific analysis passes to the pass manager. */
public static native void LLVMAddAnalysisPasses(LLVMTargetMachineRef T, LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/ExecutionEngine.h>

/*===-- llvm-c/ExecutionEngine.h - ExecutionEngine Lib C Iface --*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMExecutionEngine.o, which    *|
|* implements various analyses of the LLVM IR.                                *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_EXECUTIONENGINE_H
// #define LLVM_C_EXECUTIONENGINE_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Target.h"
// #include "llvm-c/TargetMachine.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCExecutionEngine Execution Engine
 * \ingroup LLVMC
 *
 * \{
 */

public static native void LLVMLinkInMCJIT();
public static native void LLVMLinkInInterpreter();
// Targeting ../LLVM/LLVMGenericValueRef.java


// Targeting ../LLVM/LLVMExecutionEngineRef.java


// Targeting ../LLVM/LLVMMCJITMemoryManagerRef.java


// Targeting ../LLVM/LLVMMCJITCompilerOptions.java



/*===-- Operations on generic values --------------------------------------===*/

public static native LLVMGenericValueRef LLVMCreateGenericValueOfInt(LLVMTypeRef Ty,
                                                @Cast("unsigned long long") long N,
                                                @Cast("LLVMBool") int IsSigned);

public static native LLVMGenericValueRef LLVMCreateGenericValueOfPointer(Pointer P);

public static native LLVMGenericValueRef LLVMCreateGenericValueOfFloat(LLVMTypeRef Ty, double N);

public static native @Cast("unsigned") int LLVMGenericValueIntWidth(LLVMGenericValueRef GenValRef);

public static native @Cast("unsigned long long") long LLVMGenericValueToInt(LLVMGenericValueRef GenVal,
                                         @Cast("LLVMBool") int IsSigned);

public static native Pointer LLVMGenericValueToPointer(LLVMGenericValueRef GenVal);

public static native double LLVMGenericValueToFloat(LLVMTypeRef TyRef, LLVMGenericValueRef GenVal);

public static native void LLVMDisposeGenericValue(LLVMGenericValueRef GenVal);

/*===-- Operations on execution engines -----------------------------------===*/

public static native @Cast("LLVMBool") int LLVMCreateExecutionEngineForModule(@ByPtrPtr LLVMExecutionEngineRef OutEE,
                                            LLVMModuleRef M,
                                            @Cast("char**") PointerPointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateExecutionEngineForModule(@ByPtrPtr LLVMExecutionEngineRef OutEE,
                                            LLVMModuleRef M,
                                            @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateExecutionEngineForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutEE,
                                            LLVMModuleRef M,
                                            @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateExecutionEngineForModule(@ByPtrPtr LLVMExecutionEngineRef OutEE,
                                            LLVMModuleRef M,
                                            @Cast("char**") @ByPtrPtr byte[] OutError);
public static native @Cast("LLVMBool") int LLVMCreateExecutionEngineForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutEE,
                                            LLVMModuleRef M,
                                            @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateExecutionEngineForModule(@ByPtrPtr LLVMExecutionEngineRef OutEE,
                                            LLVMModuleRef M,
                                            @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateExecutionEngineForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutEE,
                                            LLVMModuleRef M,
                                            @Cast("char**") @ByPtrPtr byte[] OutError);

public static native @Cast("LLVMBool") int LLVMCreateInterpreterForModule(@ByPtrPtr LLVMExecutionEngineRef OutInterp,
                                        LLVMModuleRef M,
                                        @Cast("char**") PointerPointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateInterpreterForModule(@ByPtrPtr LLVMExecutionEngineRef OutInterp,
                                        LLVMModuleRef M,
                                        @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateInterpreterForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutInterp,
                                        LLVMModuleRef M,
                                        @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateInterpreterForModule(@ByPtrPtr LLVMExecutionEngineRef OutInterp,
                                        LLVMModuleRef M,
                                        @Cast("char**") @ByPtrPtr byte[] OutError);
public static native @Cast("LLVMBool") int LLVMCreateInterpreterForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutInterp,
                                        LLVMModuleRef M,
                                        @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateInterpreterForModule(@ByPtrPtr LLVMExecutionEngineRef OutInterp,
                                        LLVMModuleRef M,
                                        @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateInterpreterForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutInterp,
                                        LLVMModuleRef M,
                                        @Cast("char**") @ByPtrPtr byte[] OutError);

public static native @Cast("LLVMBool") int LLVMCreateJITCompilerForModule(@ByPtrPtr LLVMExecutionEngineRef OutJIT,
                                        LLVMModuleRef M,
                                        @Cast("unsigned") int OptLevel,
                                        @Cast("char**") PointerPointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateJITCompilerForModule(@ByPtrPtr LLVMExecutionEngineRef OutJIT,
                                        LLVMModuleRef M,
                                        @Cast("unsigned") int OptLevel,
                                        @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateJITCompilerForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutJIT,
                                        LLVMModuleRef M,
                                        @Cast("unsigned") int OptLevel,
                                        @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateJITCompilerForModule(@ByPtrPtr LLVMExecutionEngineRef OutJIT,
                                        LLVMModuleRef M,
                                        @Cast("unsigned") int OptLevel,
                                        @Cast("char**") @ByPtrPtr byte[] OutError);
public static native @Cast("LLVMBool") int LLVMCreateJITCompilerForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutJIT,
                                        LLVMModuleRef M,
                                        @Cast("unsigned") int OptLevel,
                                        @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateJITCompilerForModule(@ByPtrPtr LLVMExecutionEngineRef OutJIT,
                                        LLVMModuleRef M,
                                        @Cast("unsigned") int OptLevel,
                                        @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateJITCompilerForModule(@Cast("LLVMExecutionEngineRef*") PointerPointer OutJIT,
                                        LLVMModuleRef M,
                                        @Cast("unsigned") int OptLevel,
                                        @Cast("char**") @ByPtrPtr byte[] OutError);

public static native void LLVMInitializeMCJITCompilerOptions(
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions);

/**
 * Create an MCJIT execution engine for a module, with the given options. It is
 * the responsibility of the caller to ensure that all fields in Options up to
 * the given SizeOfOptions are initialized. It is correct to pass a smaller
 * value of SizeOfOptions that omits some fields. The canonical way of using
 * this is:
 *
 * LLVMMCJITCompilerOptions options;
 * LLVMInitializeMCJITCompilerOptions(&options, sizeof(options));
 * ... fill in those options you care about
 * LLVMCreateMCJITCompilerForModule(&jit, mod, &options, sizeof(options),
 *                                  &error);
 *
 * Note that this is also correct, though possibly suboptimal:
 *
 * LLVMCreateMCJITCompilerForModule(&jit, mod, 0, 0, &error);
 */
public static native @Cast("LLVMBool") int LLVMCreateMCJITCompilerForModule(
  @ByPtrPtr LLVMExecutionEngineRef OutJIT, LLVMModuleRef M,
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions,
  @Cast("char**") PointerPointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateMCJITCompilerForModule(
  @ByPtrPtr LLVMExecutionEngineRef OutJIT, LLVMModuleRef M,
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions,
  @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateMCJITCompilerForModule(
  @Cast("LLVMExecutionEngineRef*") PointerPointer OutJIT, LLVMModuleRef M,
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions,
  @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateMCJITCompilerForModule(
  @ByPtrPtr LLVMExecutionEngineRef OutJIT, LLVMModuleRef M,
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions,
  @Cast("char**") @ByPtrPtr byte[] OutError);
public static native @Cast("LLVMBool") int LLVMCreateMCJITCompilerForModule(
  @Cast("LLVMExecutionEngineRef*") PointerPointer OutJIT, LLVMModuleRef M,
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions,
  @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMCreateMCJITCompilerForModule(
  @ByPtrPtr LLVMExecutionEngineRef OutJIT, LLVMModuleRef M,
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions,
  @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMCreateMCJITCompilerForModule(
  @Cast("LLVMExecutionEngineRef*") PointerPointer OutJIT, LLVMModuleRef M,
  LLVMMCJITCompilerOptions Options, @Cast("size_t") long SizeOfOptions,
  @Cast("char**") @ByPtrPtr byte[] OutError);

public static native void LLVMDisposeExecutionEngine(LLVMExecutionEngineRef EE);

public static native void LLVMRunStaticConstructors(LLVMExecutionEngineRef EE);

public static native void LLVMRunStaticDestructors(LLVMExecutionEngineRef EE);

public static native int LLVMRunFunctionAsMain(LLVMExecutionEngineRef EE, LLVMValueRef F,
                          @Cast("unsigned") int ArgC, @Cast("const char*const*") PointerPointer ArgV,
                          @Cast("const char*const*") PointerPointer EnvP);
public static native int LLVMRunFunctionAsMain(LLVMExecutionEngineRef EE, LLVMValueRef F,
                          @Cast("unsigned") int ArgC, @Cast("const char*const*") @ByPtrPtr BytePointer ArgV,
                          @Cast("const char*const*") @ByPtrPtr BytePointer EnvP);
public static native int LLVMRunFunctionAsMain(LLVMExecutionEngineRef EE, LLVMValueRef F,
                          @Cast("unsigned") int ArgC, @Cast("const char*const*") @ByPtrPtr ByteBuffer ArgV,
                          @Cast("const char*const*") @ByPtrPtr ByteBuffer EnvP);
public static native int LLVMRunFunctionAsMain(LLVMExecutionEngineRef EE, LLVMValueRef F,
                          @Cast("unsigned") int ArgC, @Cast("const char*const*") @ByPtrPtr byte[] ArgV,
                          @Cast("const char*const*") @ByPtrPtr byte[] EnvP);

public static native LLVMGenericValueRef LLVMRunFunction(LLVMExecutionEngineRef EE, LLVMValueRef F,
                                    @Cast("unsigned") int NumArgs,
                                    @ByPtrPtr LLVMGenericValueRef Args);
public static native LLVMGenericValueRef LLVMRunFunction(LLVMExecutionEngineRef EE, LLVMValueRef F,
                                    @Cast("unsigned") int NumArgs,
                                    @Cast("LLVMGenericValueRef*") PointerPointer Args);

public static native void LLVMFreeMachineCodeForFunction(LLVMExecutionEngineRef EE, LLVMValueRef F);

public static native void LLVMAddModule(LLVMExecutionEngineRef EE, LLVMModuleRef M);

public static native @Cast("LLVMBool") int LLVMRemoveModule(LLVMExecutionEngineRef EE, LLVMModuleRef M,
                          @ByPtrPtr LLVMModuleRef OutMod, @Cast("char**") PointerPointer OutError);
public static native @Cast("LLVMBool") int LLVMRemoveModule(LLVMExecutionEngineRef EE, LLVMModuleRef M,
                          @ByPtrPtr LLVMModuleRef OutMod, @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMRemoveModule(LLVMExecutionEngineRef EE, LLVMModuleRef M,
                          @Cast("LLVMModuleRef*") PointerPointer OutMod, @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMRemoveModule(LLVMExecutionEngineRef EE, LLVMModuleRef M,
                          @ByPtrPtr LLVMModuleRef OutMod, @Cast("char**") @ByPtrPtr byte[] OutError);
public static native @Cast("LLVMBool") int LLVMRemoveModule(LLVMExecutionEngineRef EE, LLVMModuleRef M,
                          @Cast("LLVMModuleRef*") PointerPointer OutMod, @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMRemoveModule(LLVMExecutionEngineRef EE, LLVMModuleRef M,
                          @ByPtrPtr LLVMModuleRef OutMod, @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMRemoveModule(LLVMExecutionEngineRef EE, LLVMModuleRef M,
                          @Cast("LLVMModuleRef*") PointerPointer OutMod, @Cast("char**") @ByPtrPtr byte[] OutError);

public static native @Cast("LLVMBool") int LLVMFindFunction(LLVMExecutionEngineRef EE, @Cast("const char*") BytePointer Name,
                          @ByPtrPtr LLVMValueRef OutFn);
public static native @Cast("LLVMBool") int LLVMFindFunction(LLVMExecutionEngineRef EE, String Name,
                          @Cast("LLVMValueRef*") PointerPointer OutFn);

public static native Pointer LLVMRecompileAndRelinkFunction(LLVMExecutionEngineRef EE,
                                     LLVMValueRef Fn);

public static native LLVMTargetDataRef LLVMGetExecutionEngineTargetData(LLVMExecutionEngineRef EE);
public static native LLVMTargetMachineRef LLVMGetExecutionEngineTargetMachine(LLVMExecutionEngineRef EE);

public static native void LLVMAddGlobalMapping(LLVMExecutionEngineRef EE, LLVMValueRef Global,
                          Pointer Addr);

public static native Pointer LLVMGetPointerToGlobal(LLVMExecutionEngineRef EE, LLVMValueRef Global);

public static native @Cast("uint64_t") long LLVMGetGlobalValueAddress(LLVMExecutionEngineRef EE, @Cast("const char*") BytePointer Name);
public static native @Cast("uint64_t") long LLVMGetGlobalValueAddress(LLVMExecutionEngineRef EE, String Name);

public static native @Cast("uint64_t") long LLVMGetFunctionAddress(LLVMExecutionEngineRef EE, @Cast("const char*") BytePointer Name);
public static native @Cast("uint64_t") long LLVMGetFunctionAddress(LLVMExecutionEngineRef EE, String Name);

/** Returns true on error, false on success. If true is returned then the error
 *  message is copied to OutStr and cleared in the ExecutionEngine instance. */
public static native @Cast("LLVMBool") int LLVMExecutionEngineGetErrMsg(LLVMExecutionEngineRef EE,
                                      @Cast("char**") PointerPointer OutError);
public static native @Cast("LLVMBool") int LLVMExecutionEngineGetErrMsg(LLVMExecutionEngineRef EE,
                                      @Cast("char**") @ByPtrPtr BytePointer OutError);
public static native @Cast("LLVMBool") int LLVMExecutionEngineGetErrMsg(LLVMExecutionEngineRef EE,
                                      @Cast("char**") @ByPtrPtr ByteBuffer OutError);
public static native @Cast("LLVMBool") int LLVMExecutionEngineGetErrMsg(LLVMExecutionEngineRef EE,
                                      @Cast("char**") @ByPtrPtr byte[] OutError);
// Targeting ../LLVM/LLVMMemoryManagerAllocateCodeSectionCallback.java


// Targeting ../LLVM/LLVMMemoryManagerAllocateDataSectionCallback.java


// Targeting ../LLVM/LLVMMemoryManagerFinalizeMemoryCallback.java


// Targeting ../LLVM/LLVMMemoryManagerDestroyCallback.java



/**
 * Create a simple custom MCJIT memory manager. This memory manager can
 * intercept allocations in a module-oblivious way. This will return NULL
 * if any of the passed functions are NULL.
 *
 * @param Opaque An opaque client object to pass back to the callbacks.
 * @param AllocateCodeSection Allocate a block of memory for executable code.
 * @param AllocateDataSection Allocate a block of memory for data.
 * @param FinalizeMemory Set page permissions and flush cache. Return 0 on
 *   success, 1 on error.
 */
public static native LLVMMCJITMemoryManagerRef LLVMCreateSimpleMCJITMemoryManager(
  Pointer Opaque,
  LLVMMemoryManagerAllocateCodeSectionCallback AllocateCodeSection,
  LLVMMemoryManagerAllocateDataSectionCallback AllocateDataSection,
  LLVMMemoryManagerFinalizeMemoryCallback FinalizeMemory,
  LLVMMemoryManagerDestroyCallback Destroy);

public static native void LLVMDisposeMCJITMemoryManager(LLVMMCJITMemoryManagerRef MM);

/*===-- JIT Event Listener functions -------------------------------------===*/

public static native LLVMJITEventListenerRef LLVMCreateGDBRegistrationListener();
public static native LLVMJITEventListenerRef LLVMCreateIntelJITEventListener();
public static native LLVMJITEventListenerRef LLVMCreateOProfileJITEventListener();
public static native LLVMJITEventListenerRef LLVMCreatePerfJITEventListener();

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Comdat.h>

/*===-- llvm-c/Comdat.h - Module Comdat C Interface -------------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file defines the C interface to COMDAT.                               *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_COMDAT_H
// #define LLVM_C_COMDAT_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCCoreComdat Comdats
 * \ingroup LLVMCCore
 *
 * \{
 */

/** enum LLVMComdatSelectionKind */
public static final int
  /** The linker may choose any COMDAT. */
  LLVMAnyComdatSelectionKind = 0,
  /** The data referenced by the COMDAT must
 *  be the same. */
  LLVMExactMatchComdatSelectionKind = 1,
  /** The linker will choose the largest
 *  COMDAT. */
  LLVMLargestComdatSelectionKind = 2,
  /** No deduplication is performed. */
  LLVMNoDeduplicateComdatSelectionKind = 3,
  /** The data referenced by the COMDAT must be
 *  the same size. */
  LLVMSameSizeComdatSelectionKind = 4;

/**
 * Return the Comdat in the module with the specified name. It is created
 * if it didn't already exist.
 *
 * @see llvm::Module::getOrInsertComdat()
 */
public static native LLVMComdatRef LLVMGetOrInsertComdat(LLVMModuleRef M, @Cast("const char*") BytePointer Name);
public static native LLVMComdatRef LLVMGetOrInsertComdat(LLVMModuleRef M, String Name);

/**
 * Get the Comdat assigned to the given global object.
 *
 * @see llvm::GlobalObject::getComdat()
 */
public static native LLVMComdatRef LLVMGetComdat(LLVMValueRef V);

/**
 * Assign the Comdat to the given global object.
 *
 * @see llvm::GlobalObject::setComdat()
 */
public static native void LLVMSetComdat(LLVMValueRef V, LLVMComdatRef C);

/*
 * Get the conflict resolution selection kind for the Comdat.
 *
 * @see llvm::Comdat::getSelectionKind()
 */
public static native @Cast("LLVMComdatSelectionKind") int LLVMGetComdatSelectionKind(LLVMComdatRef C);

/*
 * Set the conflict resolution selection kind for the Comdat.
 *
 * @see llvm::Comdat::setSelectionKind()
 */
public static native void LLVMSetComdatSelectionKind(LLVMComdatRef C, @Cast("LLVMComdatSelectionKind") int Kind);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/DebugInfo.h>

//===------------ DebugInfo.h - LLVM C API Debug Info API -----------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
/**
 *  This file declares the C API endpoints for generating DWARF Debug Info
 * 
 *  Note: This interface is experimental. It is *NOT* stable, and may be
 *        changed without warning.
 *  */
//===----------------------------------------------------------------------===//

// #ifndef LLVM_C_DEBUGINFO_H
// #define LLVM_C_DEBUGINFO_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCCoreDebugInfo Debug Information
 * \ingroup LLVMCCore
 *
 * \{
 */

/**
 * Debug info flags.
 */
/** enum LLVMDIFlags */
public static final int
  LLVMDIFlagZero = 0,
  LLVMDIFlagPrivate = 1,
  LLVMDIFlagProtected = 2,
  LLVMDIFlagPublic = 3,
  LLVMDIFlagFwdDecl = 1 << 2,
  LLVMDIFlagAppleBlock = 1 << 3,
  LLVMDIFlagReservedBit4 = 1 << 4,
  LLVMDIFlagVirtual = 1 << 5,
  LLVMDIFlagArtificial = 1 << 6,
  LLVMDIFlagExplicit = 1 << 7,
  LLVMDIFlagPrototyped = 1 << 8,
  LLVMDIFlagObjcClassComplete = 1 << 9,
  LLVMDIFlagObjectPointer = 1 << 10,
  LLVMDIFlagVector = 1 << 11,
  LLVMDIFlagStaticMember = 1 << 12,
  LLVMDIFlagLValueReference = 1 << 13,
  LLVMDIFlagRValueReference = 1 << 14,
  LLVMDIFlagReserved = 1 << 15,
  LLVMDIFlagSingleInheritance = 1 << 16,
  LLVMDIFlagMultipleInheritance = 2 << 16,
  LLVMDIFlagVirtualInheritance = 3 << 16,
  LLVMDIFlagIntroducedVirtual = 1 << 18,
  LLVMDIFlagBitField = 1 << 19,
  LLVMDIFlagNoReturn = 1 << 20,
  LLVMDIFlagTypePassByValue = 1 << 22,
  LLVMDIFlagTypePassByReference = 1 << 23,
  LLVMDIFlagEnumClass = 1 << 24,
  LLVMDIFlagFixedEnum = LLVMDIFlagEnumClass, // Deprecated.
  LLVMDIFlagThunk = 1 << 25,
  LLVMDIFlagNonTrivial = 1 << 26,
  LLVMDIFlagBigEndian = 1 << 27,
  LLVMDIFlagLittleEndian = 1 << 28,
  LLVMDIFlagIndirectVirtualBase = (1 << 2) | (1 << 5),
  LLVMDIFlagAccessibility = LLVMDIFlagPrivate | LLVMDIFlagProtected |
                            LLVMDIFlagPublic,
  LLVMDIFlagPtrToMemberRep = LLVMDIFlagSingleInheritance |
                             LLVMDIFlagMultipleInheritance |
                             LLVMDIFlagVirtualInheritance;

/**
 * Source languages known by DWARF.
 */
/** enum LLVMDWARFSourceLanguage */
public static final int
  LLVMDWARFSourceLanguageC89 = 0,
  LLVMDWARFSourceLanguageC = 1,
  LLVMDWARFSourceLanguageAda83 = 2,
  LLVMDWARFSourceLanguageC_plus_plus = 3,
  LLVMDWARFSourceLanguageCobol74 = 4,
  LLVMDWARFSourceLanguageCobol85 = 5,
  LLVMDWARFSourceLanguageFortran77 = 6,
  LLVMDWARFSourceLanguageFortran90 = 7,
  LLVMDWARFSourceLanguagePascal83 = 8,
  LLVMDWARFSourceLanguageModula2 = 9,
  // New in DWARF v3:
  LLVMDWARFSourceLanguageJava = 10,
  LLVMDWARFSourceLanguageC99 = 11,
  LLVMDWARFSourceLanguageAda95 = 12,
  LLVMDWARFSourceLanguageFortran95 = 13,
  LLVMDWARFSourceLanguagePLI = 14,
  LLVMDWARFSourceLanguageObjC = 15,
  LLVMDWARFSourceLanguageObjC_plus_plus = 16,
  LLVMDWARFSourceLanguageUPC = 17,
  LLVMDWARFSourceLanguageD = 18,
  // New in DWARF v4:
  LLVMDWARFSourceLanguagePython = 19,
  // New in DWARF v5:
  LLVMDWARFSourceLanguageOpenCL = 20,
  LLVMDWARFSourceLanguageGo = 21,
  LLVMDWARFSourceLanguageModula3 = 22,
  LLVMDWARFSourceLanguageHaskell = 23,
  LLVMDWARFSourceLanguageC_plus_plus_03 = 24,
  LLVMDWARFSourceLanguageC_plus_plus_11 = 25,
  LLVMDWARFSourceLanguageOCaml = 26,
  LLVMDWARFSourceLanguageRust = 27,
  LLVMDWARFSourceLanguageC11 = 28,
  LLVMDWARFSourceLanguageSwift = 29,
  LLVMDWARFSourceLanguageJulia = 30,
  LLVMDWARFSourceLanguageDylan = 31,
  LLVMDWARFSourceLanguageC_plus_plus_14 = 32,
  LLVMDWARFSourceLanguageFortran03 = 33,
  LLVMDWARFSourceLanguageFortran08 = 34,
  LLVMDWARFSourceLanguageRenderScript = 35,
  LLVMDWARFSourceLanguageBLISS = 36,
  // Vendor extensions:
  LLVMDWARFSourceLanguageMips_Assembler = 37,
  LLVMDWARFSourceLanguageGOOGLE_RenderScript = 38,
  LLVMDWARFSourceLanguageBORLAND_Delphi = 39;

/**
 * The amount of debug information to emit.
 */
/** enum LLVMDWARFEmissionKind */
public static final int
    LLVMDWARFEmissionNone = 0,
    LLVMDWARFEmissionFull = 1,
    LLVMDWARFEmissionLineTablesOnly = 2;

/**
 * The kind of metadata nodes.
 */
/** enum  */
public static final int
  LLVMMDStringMetadataKind = 0,
  LLVMConstantAsMetadataMetadataKind = 1,
  LLVMLocalAsMetadataMetadataKind = 2,
  LLVMDistinctMDOperandPlaceholderMetadataKind = 3,
  LLVMMDTupleMetadataKind = 4,
  LLVMDILocationMetadataKind = 5,
  LLVMDIExpressionMetadataKind = 6,
  LLVMDIGlobalVariableExpressionMetadataKind = 7,
  LLVMGenericDINodeMetadataKind = 8,
  LLVMDISubrangeMetadataKind = 9,
  LLVMDIEnumeratorMetadataKind = 10,
  LLVMDIBasicTypeMetadataKind = 11,
  LLVMDIDerivedTypeMetadataKind = 12,
  LLVMDICompositeTypeMetadataKind = 13,
  LLVMDISubroutineTypeMetadataKind = 14,
  LLVMDIFileMetadataKind = 15,
  LLVMDICompileUnitMetadataKind = 16,
  LLVMDISubprogramMetadataKind = 17,
  LLVMDILexicalBlockMetadataKind = 18,
  LLVMDILexicalBlockFileMetadataKind = 19,
  LLVMDINamespaceMetadataKind = 20,
  LLVMDIModuleMetadataKind = 21,
  LLVMDITemplateTypeParameterMetadataKind = 22,
  LLVMDITemplateValueParameterMetadataKind = 23,
  LLVMDIGlobalVariableMetadataKind = 24,
  LLVMDILocalVariableMetadataKind = 25,
  LLVMDILabelMetadataKind = 26,
  LLVMDIObjCPropertyMetadataKind = 27,
  LLVMDIImportedEntityMetadataKind = 28,
  LLVMDIMacroMetadataKind = 29,
  LLVMDIMacroFileMetadataKind = 30,
  LLVMDICommonBlockMetadataKind = 31,
  LLVMDIStringTypeMetadataKind = 32,
  LLVMDIGenericSubrangeMetadataKind = 33,
  LLVMDIArgListMetadataKind = 34;

/**
 * An LLVM DWARF type encoding.
 */

/**
 * Describes the kind of macro declaration used for LLVMDIBuilderCreateMacro.
 * @see llvm::dwarf::MacinfoRecordType
 * \note Values are from DW_MACINFO_* constants in the DWARF specification.
 */
/** enum LLVMDWARFMacinfoRecordType */
public static final int
  LLVMDWARFMacinfoRecordTypeDefine = 0x01,
  LLVMDWARFMacinfoRecordTypeMacro = 0x02,
  LLVMDWARFMacinfoRecordTypeStartFile = 0x03,
  LLVMDWARFMacinfoRecordTypeEndFile = 0x04,
  LLVMDWARFMacinfoRecordTypeVendorExt = 0xff;

/**
 * The current debug metadata version number.
 */
public static native @Cast("unsigned") int LLVMDebugMetadataVersion();

/**
 * The version of debug metadata that's present in the provided \c Module.
 */
public static native @Cast("unsigned") int LLVMGetModuleDebugMetadataVersion(LLVMModuleRef Module);

/**
 * Strip debug info in the module if it exists.
 * To do this, we remove all calls to the debugger intrinsics and any named
 * metadata for debugging. We also remove debug locations for instructions.
 * Return true if module is modified.
 */
public static native @Cast("LLVMBool") int LLVMStripModuleDebugInfo(LLVMModuleRef Module);

/**
 * Construct a builder for a module, and do not allow for unresolved nodes
 * attached to the module.
 */
public static native LLVMDIBuilderRef LLVMCreateDIBuilderDisallowUnresolved(LLVMModuleRef M);

/**
 * Construct a builder for a module and collect unresolved nodes attached
 * to the module in order to resolve cycles during a call to
 * \c LLVMDIBuilderFinalize.
 */
public static native LLVMDIBuilderRef LLVMCreateDIBuilder(LLVMModuleRef M);

/**
 * Deallocates the \c DIBuilder and everything it owns.
 * \note You must call \c LLVMDIBuilderFinalize before this
 */
public static native void LLVMDisposeDIBuilder(LLVMDIBuilderRef Builder);

/**
 * Construct any deferred debug info descriptors.
 */
public static native void LLVMDIBuilderFinalize(LLVMDIBuilderRef Builder);

/**
 * Finalize a specific subprogram.
 * No new variables may be added to this subprogram afterwards.
 */
public static native void LLVMDIBuilderFinalizeSubprogram(LLVMDIBuilderRef Builder,
                                     LLVMMetadataRef Subprogram);

/**
 * A CompileUnit provides an anchor for all debugging
 * information generated during this instance of compilation.
 * @param Lang          Source programming language, eg.
 *                      \c LLVMDWARFSourceLanguageC99
 * @param FileRef       File info.
 * @param Producer      Identify the producer of debugging information
 *                      and code.  Usually this is a compiler
 *                      version string.
 * @param ProducerLen   The length of the C string passed to \c Producer.
 * @param isOptimized   A boolean flag which indicates whether optimization
 *                      is enabled or not.
 * @param Flags         This string lists command line options. This
 *                      string is directly embedded in debug info
 *                      output which may be used by a tool
 *                      analyzing generated debugging information.
 * @param FlagsLen      The length of the C string passed to \c Flags.
 * @param RuntimeVer    This indicates runtime version for languages like
 *                      Objective-C.
 * @param SplitName     The name of the file that we'll split debug info
 *                      out into.
 * @param SplitNameLen  The length of the C string passed to \c SplitName.
 * @param Kind          The kind of debug information to generate.
 * @param DWOId         The DWOId if this is a split skeleton compile unit.
 * @param SplitDebugInlining    Whether to emit inline debug info.
 * @param DebugInfoForProfiling Whether to emit extra debug info for
 *                              profile collection.
 * @param SysRoot         The Clang system root (value of -isysroot).
 * @param SysRootLen      The length of the C string passed to \c SysRoot.
 * @param SDK           The SDK. On Darwin, the last component of the sysroot.
 * @param SDKLen        The length of the C string passed to \c SDK.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateCompileUnit(
    LLVMDIBuilderRef Builder, @Cast("LLVMDWARFSourceLanguage") int Lang,
    LLVMMetadataRef FileRef, @Cast("const char*") BytePointer Producer, @Cast("size_t") long ProducerLen,
    @Cast("LLVMBool") int isOptimized, @Cast("const char*") BytePointer Flags, @Cast("size_t") long FlagsLen,
    @Cast("unsigned") int RuntimeVer, @Cast("const char*") BytePointer SplitName, @Cast("size_t") long SplitNameLen,
    @Cast("LLVMDWARFEmissionKind") int Kind, @Cast("unsigned") int DWOId, @Cast("LLVMBool") int SplitDebugInlining,
    @Cast("LLVMBool") int DebugInfoForProfiling, @Cast("const char*") BytePointer SysRoot, @Cast("size_t") long SysRootLen,
    @Cast("const char*") BytePointer SDK, @Cast("size_t") long SDKLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateCompileUnit(
    LLVMDIBuilderRef Builder, @Cast("LLVMDWARFSourceLanguage") int Lang,
    LLVMMetadataRef FileRef, String Producer, @Cast("size_t") long ProducerLen,
    @Cast("LLVMBool") int isOptimized, String Flags, @Cast("size_t") long FlagsLen,
    @Cast("unsigned") int RuntimeVer, String SplitName, @Cast("size_t") long SplitNameLen,
    @Cast("LLVMDWARFEmissionKind") int Kind, @Cast("unsigned") int DWOId, @Cast("LLVMBool") int SplitDebugInlining,
    @Cast("LLVMBool") int DebugInfoForProfiling, String SysRoot, @Cast("size_t") long SysRootLen,
    String SDK, @Cast("size_t") long SDKLen);

/**
 * Create a file descriptor to hold debugging information for a file.
 * @param Builder      The \c DIBuilder.
 * @param Filename     File name.
 * @param FilenameLen  The length of the C string passed to \c Filename.
 * @param Directory    Directory.
 * @param DirectoryLen The length of the C string passed to \c Directory.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateFile(LLVMDIBuilderRef Builder, @Cast("const char*") BytePointer Filename,
                        @Cast("size_t") long FilenameLen, @Cast("const char*") BytePointer Directory,
                        @Cast("size_t") long DirectoryLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateFile(LLVMDIBuilderRef Builder, String Filename,
                        @Cast("size_t") long FilenameLen, String Directory,
                        @Cast("size_t") long DirectoryLen);

/**
 * Creates a new descriptor for a module with the specified parent scope.
 * @param Builder         The \c DIBuilder.
 * @param ParentScope     The parent scope containing this module declaration.
 * @param Name            Module name.
 * @param NameLen         The length of the C string passed to \c Name.
 * @param ConfigMacros    A space-separated shell-quoted list of -D macro
                          definitions as they would appear on a command line.
 * @param ConfigMacrosLen The length of the C string passed to \c ConfigMacros.
 * @param IncludePath     The path to the module map file.
 * @param IncludePathLen  The length of the C string passed to \c IncludePath.
 * @param APINotesFile    The path to an API notes file for the module.
 * @param APINotesFileLen The length of the C string passed to \c APINotestFile.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateModule(LLVMDIBuilderRef Builder, LLVMMetadataRef ParentScope,
                          @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                          @Cast("const char*") BytePointer ConfigMacros, @Cast("size_t") long ConfigMacrosLen,
                          @Cast("const char*") BytePointer IncludePath, @Cast("size_t") long IncludePathLen,
                          @Cast("const char*") BytePointer APINotesFile, @Cast("size_t") long APINotesFileLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateModule(LLVMDIBuilderRef Builder, LLVMMetadataRef ParentScope,
                          String Name, @Cast("size_t") long NameLen,
                          String ConfigMacros, @Cast("size_t") long ConfigMacrosLen,
                          String IncludePath, @Cast("size_t") long IncludePathLen,
                          String APINotesFile, @Cast("size_t") long APINotesFileLen);

/**
 * Creates a new descriptor for a namespace with the specified parent scope.
 * @param Builder          The \c DIBuilder.
 * @param ParentScope      The parent scope containing this module declaration.
 * @param Name             NameSpace name.
 * @param NameLen          The length of the C string passed to \c Name.
 * @param ExportSymbols    Whether or not the namespace exports symbols, e.g.
 *                         this is true of C++ inline namespaces.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateNameSpace(LLVMDIBuilderRef Builder,
                             LLVMMetadataRef ParentScope,
                             @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                             @Cast("LLVMBool") int ExportSymbols);
public static native LLVMMetadataRef LLVMDIBuilderCreateNameSpace(LLVMDIBuilderRef Builder,
                             LLVMMetadataRef ParentScope,
                             String Name, @Cast("size_t") long NameLen,
                             @Cast("LLVMBool") int ExportSymbols);

/**
 * Create a new descriptor for the specified subprogram.
 * @param Builder         The \c DIBuilder.
 * @param Scope           Function scope.
 * @param Name            Function name.
 * @param NameLen         Length of enumeration name.
 * @param LinkageName     Mangled function name.
 * @param LinkageNameLen  Length of linkage name.
 * @param File            File where this variable is defined.
 * @param LineNo          Line number.
 * @param Ty              Function type.
 * @param IsLocalToUnit   True if this function is not externally visible.
 * @param IsDefinition    True if this is a function definition.
 * @param ScopeLine       Set to the beginning of the scope this starts
 * @param Flags           E.g.: \c LLVMDIFlagLValueReference. These flags are
 *                        used to emit dwarf attributes.
 * @param IsOptimized     True if optimization is ON.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateFunction(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, @Cast("const char*") BytePointer LinkageName, @Cast("size_t") long LinkageNameLen,
    LLVMMetadataRef File, @Cast("unsigned") int LineNo, LLVMMetadataRef Ty,
    @Cast("LLVMBool") int IsLocalToUnit, @Cast("LLVMBool") int IsDefinition,
    @Cast("unsigned") int ScopeLine, @Cast("LLVMDIFlags") int Flags, @Cast("LLVMBool") int IsOptimized);
public static native LLVMMetadataRef LLVMDIBuilderCreateFunction(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, String LinkageName, @Cast("size_t") long LinkageNameLen,
    LLVMMetadataRef File, @Cast("unsigned") int LineNo, LLVMMetadataRef Ty,
    @Cast("LLVMBool") int IsLocalToUnit, @Cast("LLVMBool") int IsDefinition,
    @Cast("unsigned") int ScopeLine, @Cast("LLVMDIFlags") int Flags, @Cast("LLVMBool") int IsOptimized);

/**
 * Create a descriptor for a lexical block with the specified parent context.
 * @param Builder      The \c DIBuilder.
 * @param Scope        Parent lexical block.
 * @param File         Source file.
 * @param Line         The line in the source file.
 * @param Column       The column in the source file.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateLexicalBlock(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope,
    LLVMMetadataRef File, @Cast("unsigned") int Line, @Cast("unsigned") int Column);

/**
 * Create a descriptor for a lexical block with a new file attached.
 * @param Builder        The \c DIBuilder.
 * @param Scope          Lexical block.
 * @param File           Source file.
 * @param Discriminator  DWARF path discriminator value.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateLexicalBlockFile(LLVMDIBuilderRef Builder,
                                    LLVMMetadataRef Scope,
                                    LLVMMetadataRef File,
                                    @Cast("unsigned") int Discriminator);

/**
 * Create a descriptor for an imported namespace. Suitable for e.g. C++
 * using declarations.
 * @param Builder    The \c DIBuilder.
 * @param Scope      The scope this module is imported into
 * @param File       File where the declaration is located.
 * @param Line       Line number of the declaration.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateImportedModuleFromNamespace(LLVMDIBuilderRef Builder,
                                               LLVMMetadataRef Scope,
                                               LLVMMetadataRef NS,
                                               LLVMMetadataRef File,
                                               @Cast("unsigned") int Line);

/**
 * Create a descriptor for an imported module that aliases another
 * imported entity descriptor.
 * @param Builder        The \c DIBuilder.
 * @param Scope          The scope this module is imported into
 * @param ImportedEntity Previous imported entity to alias.
 * @param File           File where the declaration is located.
 * @param Line           Line number of the declaration.
 * @param Elements       Renamed elements.
 * @param NumElements    Number of renamed elements.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateImportedModuleFromAlias(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope,
    LLVMMetadataRef ImportedEntity, LLVMMetadataRef File, @Cast("unsigned") int Line,
    @ByPtrPtr LLVMMetadataRef Elements, @Cast("unsigned") int NumElements);
public static native LLVMMetadataRef LLVMDIBuilderCreateImportedModuleFromAlias(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope,
    LLVMMetadataRef ImportedEntity, LLVMMetadataRef File, @Cast("unsigned") int Line,
    @Cast("LLVMMetadataRef*") PointerPointer Elements, @Cast("unsigned") int NumElements);

/**
 * Create a descriptor for an imported module.
 * @param Builder        The \c DIBuilder.
 * @param Scope          The scope this module is imported into
 * @param M              The module being imported here
 * @param File           File where the declaration is located.
 * @param Line           Line number of the declaration.
 * @param Elements       Renamed elements.
 * @param NumElements    Number of renamed elements.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateImportedModuleFromModule(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, LLVMMetadataRef M,
    LLVMMetadataRef File, @Cast("unsigned") int Line, @ByPtrPtr LLVMMetadataRef Elements,
    @Cast("unsigned") int NumElements);
public static native LLVMMetadataRef LLVMDIBuilderCreateImportedModuleFromModule(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, LLVMMetadataRef M,
    LLVMMetadataRef File, @Cast("unsigned") int Line, @Cast("LLVMMetadataRef*") PointerPointer Elements,
    @Cast("unsigned") int NumElements);

/**
 * Create a descriptor for an imported function, type, or variable.  Suitable
 * for e.g. FORTRAN-style USE declarations.
 * @param Builder        The DIBuilder.
 * @param Scope          The scope this module is imported into.
 * @param Decl           The declaration (or definition) of a function, type,
                         or variable.
 * @param File           File where the declaration is located.
 * @param Line           Line number of the declaration.
 * @param Name           A name that uniquely identifies this imported
 declaration.
 * @param NameLen        The length of the C string passed to \c Name.
 * @param Elements       Renamed elements.
 * @param NumElements    Number of renamed elements.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateImportedDeclaration(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, LLVMMetadataRef Decl,
    LLVMMetadataRef File, @Cast("unsigned") int Line, @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
    @ByPtrPtr LLVMMetadataRef Elements, @Cast("unsigned") int NumElements);
public static native LLVMMetadataRef LLVMDIBuilderCreateImportedDeclaration(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, LLVMMetadataRef Decl,
    LLVMMetadataRef File, @Cast("unsigned") int Line, String Name, @Cast("size_t") long NameLen,
    @Cast("LLVMMetadataRef*") PointerPointer Elements, @Cast("unsigned") int NumElements);

/**
 * Creates a new DebugLocation that describes a source location.
 * @param Line The line in the source file.
 * @param Column The column in the source file.
 * @param Scope The scope in which the location resides.
 * @param InlinedAt The scope where this location was inlined, if at all.
 *                  (optional).
 * \note If the item to which this location is attached cannot be
 *       attributed to a source line, pass 0 for the line and column.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateDebugLocation(LLVMContextRef Ctx, @Cast("unsigned") int Line,
                                 @Cast("unsigned") int Column, LLVMMetadataRef Scope,
                                 LLVMMetadataRef InlinedAt);

/**
 * Get the line number of this debug location.
 * @param Location     The debug location.
 *
 * @see DILocation::getLine()
 */
public static native @Cast("unsigned") int LLVMDILocationGetLine(LLVMMetadataRef Location);

/**
 * Get the column number of this debug location.
 * @param Location     The debug location.
 *
 * @see DILocation::getColumn()
 */
public static native @Cast("unsigned") int LLVMDILocationGetColumn(LLVMMetadataRef Location);

/**
 * Get the local scope associated with this debug location.
 * @param Location     The debug location.
 *
 * @see DILocation::getScope()
 */
public static native LLVMMetadataRef LLVMDILocationGetScope(LLVMMetadataRef Location);

/**
 * Get the "inline at" location associated with this debug location.
 * @param Location     The debug location.
 *
 * @see DILocation::getInlinedAt()
 */
public static native LLVMMetadataRef LLVMDILocationGetInlinedAt(LLVMMetadataRef Location);

/**
 * Get the metadata of the file associated with a given scope.
 * @param Scope     The scope object.
 *
 * @see DIScope::getFile()
 */
public static native LLVMMetadataRef LLVMDIScopeGetFile(LLVMMetadataRef Scope);

/**
 * Get the directory of a given file.
 * @param File     The file object.
 * @param Len      The length of the returned string.
 *
 * @see DIFile::getDirectory()
 */
public static native @Cast("const char*") BytePointer LLVMDIFileGetDirectory(LLVMMetadataRef File, @Cast("unsigned*") IntPointer Len);
public static native String LLVMDIFileGetDirectory(LLVMMetadataRef File, @Cast("unsigned*") IntBuffer Len);
public static native @Cast("const char*") BytePointer LLVMDIFileGetDirectory(LLVMMetadataRef File, @Cast("unsigned*") int[] Len);

/**
 * Get the name of a given file.
 * @param File     The file object.
 * @param Len      The length of the returned string.
 *
 * @see DIFile::getFilename()
 */
public static native @Cast("const char*") BytePointer LLVMDIFileGetFilename(LLVMMetadataRef File, @Cast("unsigned*") IntPointer Len);
public static native String LLVMDIFileGetFilename(LLVMMetadataRef File, @Cast("unsigned*") IntBuffer Len);
public static native @Cast("const char*") BytePointer LLVMDIFileGetFilename(LLVMMetadataRef File, @Cast("unsigned*") int[] Len);

/**
 * Get the source of a given file.
 * @param File     The file object.
 * @param Len      The length of the returned string.
 *
 * @see DIFile::getSource()
 */
public static native @Cast("const char*") BytePointer LLVMDIFileGetSource(LLVMMetadataRef File, @Cast("unsigned*") IntPointer Len);
public static native String LLVMDIFileGetSource(LLVMMetadataRef File, @Cast("unsigned*") IntBuffer Len);
public static native @Cast("const char*") BytePointer LLVMDIFileGetSource(LLVMMetadataRef File, @Cast("unsigned*") int[] Len);

/**
 * Create a type array.
 * @param Builder        The DIBuilder.
 * @param Data           The type elements.
 * @param NumElements    Number of type elements.
 */
public static native LLVMMetadataRef LLVMDIBuilderGetOrCreateTypeArray(LLVMDIBuilderRef Builder,
                                                  @ByPtrPtr LLVMMetadataRef Data,
                                                  @Cast("size_t") long NumElements);
public static native LLVMMetadataRef LLVMDIBuilderGetOrCreateTypeArray(LLVMDIBuilderRef Builder,
                                                  @Cast("LLVMMetadataRef*") PointerPointer Data,
                                                  @Cast("size_t") long NumElements);

/**
 * Create subroutine type.
 * @param Builder        The DIBuilder.
 * @param File            The file in which the subroutine resides.
 * @param ParameterTypes  An array of subroutine parameter types. This
 *                        includes return type at 0th index.
 * @param NumParameterTypes The number of parameter types in \c ParameterTypes
 * @param Flags           E.g.: \c LLVMDIFlagLValueReference.
 *                        These flags are used to emit dwarf attributes.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateSubroutineType(LLVMDIBuilderRef Builder,
                                  LLVMMetadataRef File,
                                  @ByPtrPtr LLVMMetadataRef ParameterTypes,
                                  @Cast("unsigned") int NumParameterTypes,
                                  @Cast("LLVMDIFlags") int Flags);
public static native LLVMMetadataRef LLVMDIBuilderCreateSubroutineType(LLVMDIBuilderRef Builder,
                                  LLVMMetadataRef File,
                                  @Cast("LLVMMetadataRef*") PointerPointer ParameterTypes,
                                  @Cast("unsigned") int NumParameterTypes,
                                  @Cast("LLVMDIFlags") int Flags);

/**
 * Create debugging information entry for a macro.
 * @param Builder         The DIBuilder.
 * @param ParentMacroFile Macro parent (could be NULL).
 * @param Line            Source line number where the macro is defined.
 * @param RecordType      DW_MACINFO_define or DW_MACINFO_undef.
 * @param Name            Macro name.
 * @param NameLen         Macro name length.
 * @param Value           Macro value.
 * @param ValueLen        Macro value length.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateMacro(LLVMDIBuilderRef Builder,
                                         LLVMMetadataRef ParentMacroFile,
                                         @Cast("unsigned") int Line,
                                         @Cast("LLVMDWARFMacinfoRecordType") int RecordType,
                                         @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                                         @Cast("const char*") BytePointer Value, @Cast("size_t") long ValueLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateMacro(LLVMDIBuilderRef Builder,
                                         LLVMMetadataRef ParentMacroFile,
                                         @Cast("unsigned") int Line,
                                         @Cast("LLVMDWARFMacinfoRecordType") int RecordType,
                                         String Name, @Cast("size_t") long NameLen,
                                         String Value, @Cast("size_t") long ValueLen);

/**
 * Create debugging information temporary entry for a macro file.
 * List of macro node direct children will be calculated by DIBuilder,
 * using the \p ParentMacroFile relationship.
 * @param Builder         The DIBuilder.
 * @param ParentMacroFile Macro parent (could be NULL).
 * @param Line            Source line number where the macro file is included.
 * @param File            File descriptor containing the name of the macro file.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateTempMacroFile(LLVMDIBuilderRef Builder,
                                 LLVMMetadataRef ParentMacroFile, @Cast("unsigned") int Line,
                                 LLVMMetadataRef File);

/**
 * Create debugging information entry for an enumerator.
 * @param Builder        The DIBuilder.
 * @param Name           Enumerator name.
 * @param NameLen        Length of enumerator name.
 * @param Value          Enumerator value.
 * @param IsUnsigned     True if the value is unsigned.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateEnumerator(LLVMDIBuilderRef Builder,
                                              @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                                              @Cast("int64_t") long Value,
                                              @Cast("LLVMBool") int IsUnsigned);
public static native LLVMMetadataRef LLVMDIBuilderCreateEnumerator(LLVMDIBuilderRef Builder,
                                              String Name, @Cast("size_t") long NameLen,
                                              @Cast("int64_t") long Value,
                                              @Cast("LLVMBool") int IsUnsigned);

/**
 * Create debugging information entry for an enumeration.
 * @param Builder        The DIBuilder.
 * @param Scope          Scope in which this enumeration is defined.
 * @param Name           Enumeration name.
 * @param NameLen        Length of enumeration name.
 * @param File           File where this member is defined.
 * @param LineNumber     Line number.
 * @param SizeInBits     Member size.
 * @param AlignInBits    Member alignment.
 * @param Elements       Enumeration elements.
 * @param NumElements    Number of enumeration elements.
 * @param ClassTy        Underlying type of a C++11/ObjC fixed enum.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateEnumerationType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @ByPtrPtr LLVMMetadataRef Elements,
    @Cast("unsigned") int NumElements, LLVMMetadataRef ClassTy);
public static native LLVMMetadataRef LLVMDIBuilderCreateEnumerationType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("LLVMMetadataRef*") PointerPointer Elements,
    @Cast("unsigned") int NumElements, LLVMMetadataRef ClassTy);

/**
 * Create debugging information entry for a union.
 * @param Builder      The DIBuilder.
 * @param Scope        Scope in which this union is defined.
 * @param Name         Union name.
 * @param NameLen      Length of union name.
 * @param File         File where this member is defined.
 * @param LineNumber   Line number.
 * @param SizeInBits   Member size.
 * @param AlignInBits  Member alignment.
 * @param Flags        Flags to encode member attribute, e.g. private
 * @param Elements     Union elements.
 * @param NumElements  Number of union elements.
 * @param RunTimeLang  Optional parameter, Objective-C runtime version.
 * @param UniqueId     A unique identifier for the union.
 * @param UniqueIdLen  Length of unique identifier.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateUnionType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("LLVMDIFlags") int Flags,
    @ByPtrPtr LLVMMetadataRef Elements, @Cast("unsigned") int NumElements, @Cast("unsigned") int RunTimeLang,
    @Cast("const char*") BytePointer UniqueId, @Cast("size_t") long UniqueIdLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateUnionType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("LLVMDIFlags") int Flags,
    @Cast("LLVMMetadataRef*") PointerPointer Elements, @Cast("unsigned") int NumElements, @Cast("unsigned") int RunTimeLang,
    String UniqueId, @Cast("size_t") long UniqueIdLen);


/**
 * Create debugging information entry for an array.
 * @param Builder      The DIBuilder.
 * @param Size         Array size.
 * @param AlignInBits  Alignment.
 * @param Ty           Element type.
 * @param Subscripts   Subscripts.
 * @param NumSubscripts Number of subscripts.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateArrayType(LLVMDIBuilderRef Builder, @Cast("uint64_t") long Size,
                             @Cast("uint32_t") int AlignInBits, LLVMMetadataRef Ty,
                             @ByPtrPtr LLVMMetadataRef Subscripts,
                             @Cast("unsigned") int NumSubscripts);
public static native LLVMMetadataRef LLVMDIBuilderCreateArrayType(LLVMDIBuilderRef Builder, @Cast("uint64_t") long Size,
                             @Cast("uint32_t") int AlignInBits, LLVMMetadataRef Ty,
                             @Cast("LLVMMetadataRef*") PointerPointer Subscripts,
                             @Cast("unsigned") int NumSubscripts);

/**
 * Create debugging information entry for a vector type.
 * @param Builder      The DIBuilder.
 * @param Size         Vector size.
 * @param AlignInBits  Alignment.
 * @param Ty           Element type.
 * @param Subscripts   Subscripts.
 * @param NumSubscripts Number of subscripts.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateVectorType(LLVMDIBuilderRef Builder, @Cast("uint64_t") long Size,
                              @Cast("uint32_t") int AlignInBits, LLVMMetadataRef Ty,
                              @ByPtrPtr LLVMMetadataRef Subscripts,
                              @Cast("unsigned") int NumSubscripts);
public static native LLVMMetadataRef LLVMDIBuilderCreateVectorType(LLVMDIBuilderRef Builder, @Cast("uint64_t") long Size,
                              @Cast("uint32_t") int AlignInBits, LLVMMetadataRef Ty,
                              @Cast("LLVMMetadataRef*") PointerPointer Subscripts,
                              @Cast("unsigned") int NumSubscripts);

/**
 * Create a DWARF unspecified type.
 * @param Builder   The DIBuilder.
 * @param Name      The unspecified type's name.
 * @param NameLen   Length of type name.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateUnspecifiedType(LLVMDIBuilderRef Builder, @Cast("const char*") BytePointer Name,
                                   @Cast("size_t") long NameLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateUnspecifiedType(LLVMDIBuilderRef Builder, String Name,
                                   @Cast("size_t") long NameLen);

/**
 * Create debugging information entry for a basic
 * type.
 * @param Builder     The DIBuilder.
 * @param Name        Type name.
 * @param NameLen     Length of type name.
 * @param SizeInBits  Size of the type.
 * @param Encoding    DWARF encoding code, e.g. \c LLVMDWARFTypeEncoding_float.
 * @param Flags       Flags to encode optional attribute like endianity
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateBasicType(LLVMDIBuilderRef Builder, @Cast("const char*") BytePointer Name,
                             @Cast("size_t") long NameLen, @Cast("uint64_t") long SizeInBits,
                             @Cast("LLVMDWARFTypeEncoding") int Encoding,
                             @Cast("LLVMDIFlags") int Flags);
public static native LLVMMetadataRef LLVMDIBuilderCreateBasicType(LLVMDIBuilderRef Builder, String Name,
                             @Cast("size_t") long NameLen, @Cast("uint64_t") long SizeInBits,
                             @Cast("LLVMDWARFTypeEncoding") int Encoding,
                             @Cast("LLVMDIFlags") int Flags);

/**
 * Create debugging information entry for a pointer.
 * @param Builder     The DIBuilder.
 * @param PointeeTy         Type pointed by this pointer.
 * @param SizeInBits        Size.
 * @param AlignInBits       Alignment. (optional, pass 0 to ignore)
 * @param AddressSpace      DWARF address space. (optional, pass 0 to ignore)
 * @param Name              Pointer type name. (optional)
 * @param NameLen           Length of pointer type name. (optional)
 */
public static native LLVMMetadataRef LLVMDIBuilderCreatePointerType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef PointeeTy,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("unsigned") int AddressSpace,
    @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen);
public static native LLVMMetadataRef LLVMDIBuilderCreatePointerType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef PointeeTy,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("unsigned") int AddressSpace,
    String Name, @Cast("size_t") long NameLen);

/**
 * Create debugging information entry for a struct.
 * @param Builder     The DIBuilder.
 * @param Scope        Scope in which this struct is defined.
 * @param Name         Struct name.
 * @param NameLen      Struct name length.
 * @param File         File where this member is defined.
 * @param LineNumber   Line number.
 * @param SizeInBits   Member size.
 * @param AlignInBits  Member alignment.
 * @param Flags        Flags to encode member attribute, e.g. private
 * @param Elements     Struct elements.
 * @param NumElements  Number of struct elements.
 * @param RunTimeLang  Optional parameter, Objective-C runtime version.
 * @param VTableHolder The object containing the vtable for the struct.
 * @param UniqueId     A unique identifier for the struct.
 * @param UniqueIdLen  Length of the unique identifier for the struct.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateStructType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("LLVMDIFlags") int Flags,
    LLVMMetadataRef DerivedFrom, @ByPtrPtr LLVMMetadataRef Elements,
    @Cast("unsigned") int NumElements, @Cast("unsigned") int RunTimeLang, LLVMMetadataRef VTableHolder,
    @Cast("const char*") BytePointer UniqueId, @Cast("size_t") long UniqueIdLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateStructType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("LLVMDIFlags") int Flags,
    LLVMMetadataRef DerivedFrom, @Cast("LLVMMetadataRef*") PointerPointer Elements,
    @Cast("unsigned") int NumElements, @Cast("unsigned") int RunTimeLang, LLVMMetadataRef VTableHolder,
    String UniqueId, @Cast("size_t") long UniqueIdLen);

/**
 * Create debugging information entry for a member.
 * @param Builder      The DIBuilder.
 * @param Scope        Member scope.
 * @param Name         Member name.
 * @param NameLen      Length of member name.
 * @param File         File where this member is defined.
 * @param LineNo       Line number.
 * @param SizeInBits   Member size.
 * @param AlignInBits  Member alignment.
 * @param OffsetInBits Member offset.
 * @param Flags        Flags to encode member attribute, e.g. private
 * @param Ty           Parent type.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateMemberType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNo,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("uint64_t") long OffsetInBits,
    @Cast("LLVMDIFlags") int Flags, LLVMMetadataRef Ty);
public static native LLVMMetadataRef LLVMDIBuilderCreateMemberType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNo,
    @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits, @Cast("uint64_t") long OffsetInBits,
    @Cast("LLVMDIFlags") int Flags, LLVMMetadataRef Ty);

/**
 * Create debugging information entry for a
 * C++ static data member.
 * @param Builder      The DIBuilder.
 * @param Scope        Member scope.
 * @param Name         Member name.
 * @param NameLen      Length of member name.
 * @param File         File where this member is declared.
 * @param LineNumber   Line number.
 * @param Type         Type of the static member.
 * @param Flags        Flags to encode member attribute, e.g. private.
 * @param ConstantVal  Const initializer of the member.
 * @param AlignInBits  Member alignment.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateStaticMemberType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    LLVMMetadataRef Type, @Cast("LLVMDIFlags") int Flags, LLVMValueRef ConstantVal,
    @Cast("uint32_t") int AlignInBits);
public static native LLVMMetadataRef LLVMDIBuilderCreateStaticMemberType(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
    LLVMMetadataRef Type, @Cast("LLVMDIFlags") int Flags, LLVMValueRef ConstantVal,
    @Cast("uint32_t") int AlignInBits);

/**
 * Create debugging information entry for a pointer to member.
 * @param Builder      The DIBuilder.
 * @param PointeeType  Type pointed to by this pointer.
 * @param ClassType    Type for which this pointer points to members of.
 * @param SizeInBits   Size.
 * @param AlignInBits  Alignment.
 * @param Flags        Flags.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateMemberPointerType(LLVMDIBuilderRef Builder,
                                     LLVMMetadataRef PointeeType,
                                     LLVMMetadataRef ClassType,
                                     @Cast("uint64_t") long SizeInBits,
                                     @Cast("uint32_t") int AlignInBits,
                                     @Cast("LLVMDIFlags") int Flags);
/**
 * Create debugging information entry for Objective-C instance variable.
 * @param Builder      The DIBuilder.
 * @param Name         Member name.
 * @param NameLen      The length of the C string passed to \c Name.
 * @param File         File where this member is defined.
 * @param LineNo       Line number.
 * @param SizeInBits   Member size.
 * @param AlignInBits  Member alignment.
 * @param OffsetInBits Member offset.
 * @param Flags        Flags to encode member attribute, e.g. private
 * @param Ty           Parent type.
 * @param PropertyNode Property associated with this ivar.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateObjCIVar(LLVMDIBuilderRef Builder,
                            @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                            LLVMMetadataRef File, @Cast("unsigned") int LineNo,
                            @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits,
                            @Cast("uint64_t") long OffsetInBits, @Cast("LLVMDIFlags") int Flags,
                            LLVMMetadataRef Ty, LLVMMetadataRef PropertyNode);
public static native LLVMMetadataRef LLVMDIBuilderCreateObjCIVar(LLVMDIBuilderRef Builder,
                            String Name, @Cast("size_t") long NameLen,
                            LLVMMetadataRef File, @Cast("unsigned") int LineNo,
                            @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits,
                            @Cast("uint64_t") long OffsetInBits, @Cast("LLVMDIFlags") int Flags,
                            LLVMMetadataRef Ty, LLVMMetadataRef PropertyNode);

/**
 * Create debugging information entry for Objective-C property.
 * @param Builder            The DIBuilder.
 * @param Name               Property name.
 * @param NameLen            The length of the C string passed to \c Name.
 * @param File               File where this property is defined.
 * @param LineNo             Line number.
 * @param GetterName         Name of the Objective C property getter selector.
 * @param GetterNameLen      The length of the C string passed to \c GetterName.
 * @param SetterName         Name of the Objective C property setter selector.
 * @param SetterNameLen      The length of the C string passed to \c SetterName.
 * @param PropertyAttributes Objective C property attributes.
 * @param Ty                 Type.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateObjCProperty(LLVMDIBuilderRef Builder,
                                @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                                LLVMMetadataRef File, @Cast("unsigned") int LineNo,
                                @Cast("const char*") BytePointer GetterName, @Cast("size_t") long GetterNameLen,
                                @Cast("const char*") BytePointer SetterName, @Cast("size_t") long SetterNameLen,
                                @Cast("unsigned") int PropertyAttributes,
                                LLVMMetadataRef Ty);
public static native LLVMMetadataRef LLVMDIBuilderCreateObjCProperty(LLVMDIBuilderRef Builder,
                                String Name, @Cast("size_t") long NameLen,
                                LLVMMetadataRef File, @Cast("unsigned") int LineNo,
                                String GetterName, @Cast("size_t") long GetterNameLen,
                                String SetterName, @Cast("size_t") long SetterNameLen,
                                @Cast("unsigned") int PropertyAttributes,
                                LLVMMetadataRef Ty);

/**
 * Create a uniqued DIType* clone with FlagObjectPointer and FlagArtificial set.
 * @param Builder   The DIBuilder.
 * @param Type      The underlying type to which this pointer points.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateObjectPointerType(LLVMDIBuilderRef Builder,
                                     LLVMMetadataRef Type);

/**
 * Create debugging information entry for a qualified
 * type, e.g. 'const int'.
 * @param Builder     The DIBuilder.
 * @param Tag         Tag identifying type,
 *                    e.g. LLVMDWARFTypeQualifier_volatile_type
 * @param Type        Base Type.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateQualifiedType(LLVMDIBuilderRef Builder, @Cast("unsigned") int Tag,
                                 LLVMMetadataRef Type);

/**
 * Create debugging information entry for a c++
 * style reference or rvalue reference type.
 * @param Builder   The DIBuilder.
 * @param Tag       Tag identifying type,
 * @param Type      Base Type.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateReferenceType(LLVMDIBuilderRef Builder, @Cast("unsigned") int Tag,
                                 LLVMMetadataRef Type);

/**
 * Create C++11 nullptr type.
 * @param Builder   The DIBuilder.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateNullPtrType(LLVMDIBuilderRef Builder);

/**
 * Create debugging information entry for a typedef.
 * @param Builder    The DIBuilder.
 * @param Type       Original type.
 * @param Name       Typedef name.
 * @param File       File where this type is defined.
 * @param LineNo     Line number.
 * @param Scope      The surrounding context for the typedef.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateTypedef(LLVMDIBuilderRef Builder, LLVMMetadataRef Type,
                           @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                           LLVMMetadataRef File, @Cast("unsigned") int LineNo,
                           LLVMMetadataRef Scope, @Cast("uint32_t") int AlignInBits);
public static native LLVMMetadataRef LLVMDIBuilderCreateTypedef(LLVMDIBuilderRef Builder, LLVMMetadataRef Type,
                           String Name, @Cast("size_t") long NameLen,
                           LLVMMetadataRef File, @Cast("unsigned") int LineNo,
                           LLVMMetadataRef Scope, @Cast("uint32_t") int AlignInBits);

/**
 * Create debugging information entry to establish inheritance relationship
 * between two types.
 * @param Builder       The DIBuilder.
 * @param Ty            Original type.
 * @param BaseTy        Base type. Ty is inherits from base.
 * @param BaseOffset    Base offset.
 * @param VBPtrOffset  Virtual base pointer offset.
 * @param Flags         Flags to describe inheritance attribute, e.g. private
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateInheritance(LLVMDIBuilderRef Builder,
                               LLVMMetadataRef Ty, LLVMMetadataRef BaseTy,
                               @Cast("uint64_t") long BaseOffset, @Cast("uint32_t") int VBPtrOffset,
                               @Cast("LLVMDIFlags") int Flags);

/**
 * Create a permanent forward-declared type.
 * @param Builder             The DIBuilder.
 * @param Tag                 A unique tag for this type.
 * @param Name                Type name.
 * @param NameLen             Length of type name.
 * @param Scope               Type scope.
 * @param File                File where this type is defined.
 * @param Line                Line number where this type is defined.
 * @param RuntimeLang         Indicates runtime version for languages like
 *                            Objective-C.
 * @param SizeInBits          Member size.
 * @param AlignInBits         Member alignment.
 * @param UniqueIdentifier    A unique identifier for the type.
 * @param UniqueIdentifierLen Length of the unique identifier.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateForwardDecl(
    LLVMDIBuilderRef Builder, @Cast("unsigned") int Tag, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef Scope, LLVMMetadataRef File, @Cast("unsigned") int Line,
    @Cast("unsigned") int RuntimeLang, @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits,
    @Cast("const char*") BytePointer UniqueIdentifier, @Cast("size_t") long UniqueIdentifierLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateForwardDecl(
    LLVMDIBuilderRef Builder, @Cast("unsigned") int Tag, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef Scope, LLVMMetadataRef File, @Cast("unsigned") int Line,
    @Cast("unsigned") int RuntimeLang, @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits,
    String UniqueIdentifier, @Cast("size_t") long UniqueIdentifierLen);

/**
 * Create a temporary forward-declared type.
 * @param Builder             The DIBuilder.
 * @param Tag                 A unique tag for this type.
 * @param Name                Type name.
 * @param NameLen             Length of type name.
 * @param Scope               Type scope.
 * @param File                File where this type is defined.
 * @param Line                Line number where this type is defined.
 * @param RuntimeLang         Indicates runtime version for languages like
 *                            Objective-C.
 * @param SizeInBits          Member size.
 * @param AlignInBits         Member alignment.
 * @param Flags               Flags.
 * @param UniqueIdentifier    A unique identifier for the type.
 * @param UniqueIdentifierLen Length of the unique identifier.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateReplaceableCompositeType(
    LLVMDIBuilderRef Builder, @Cast("unsigned") int Tag, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef Scope, LLVMMetadataRef File, @Cast("unsigned") int Line,
    @Cast("unsigned") int RuntimeLang, @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits,
    @Cast("LLVMDIFlags") int Flags, @Cast("const char*") BytePointer UniqueIdentifier,
    @Cast("size_t") long UniqueIdentifierLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateReplaceableCompositeType(
    LLVMDIBuilderRef Builder, @Cast("unsigned") int Tag, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef Scope, LLVMMetadataRef File, @Cast("unsigned") int Line,
    @Cast("unsigned") int RuntimeLang, @Cast("uint64_t") long SizeInBits, @Cast("uint32_t") int AlignInBits,
    @Cast("LLVMDIFlags") int Flags, String UniqueIdentifier,
    @Cast("size_t") long UniqueIdentifierLen);

/**
 * Create debugging information entry for a bit field member.
 * @param Builder             The DIBuilder.
 * @param Scope               Member scope.
 * @param Name                Member name.
 * @param NameLen             Length of member name.
 * @param File                File where this member is defined.
 * @param LineNumber          Line number.
 * @param SizeInBits          Member size.
 * @param OffsetInBits        Member offset.
 * @param StorageOffsetInBits Member storage offset.
 * @param Flags               Flags to encode member attribute.
 * @param Type                Parent type.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateBitFieldMemberType(LLVMDIBuilderRef Builder,
                                      LLVMMetadataRef Scope,
                                      @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
                                      LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
                                      @Cast("uint64_t") long SizeInBits,
                                      @Cast("uint64_t") long OffsetInBits,
                                      @Cast("uint64_t") long StorageOffsetInBits,
                                      @Cast("LLVMDIFlags") int Flags, LLVMMetadataRef Type);
public static native LLVMMetadataRef LLVMDIBuilderCreateBitFieldMemberType(LLVMDIBuilderRef Builder,
                                      LLVMMetadataRef Scope,
                                      String Name, @Cast("size_t") long NameLen,
                                      LLVMMetadataRef File, @Cast("unsigned") int LineNumber,
                                      @Cast("uint64_t") long SizeInBits,
                                      @Cast("uint64_t") long OffsetInBits,
                                      @Cast("uint64_t") long StorageOffsetInBits,
                                      @Cast("LLVMDIFlags") int Flags, LLVMMetadataRef Type);

/**
 * Create debugging information entry for a class.
 * @param Scope               Scope in which this class is defined.
 * @param Name                Class name.
 * @param NameLen             The length of the C string passed to \c Name.
 * @param File                File where this member is defined.
 * @param LineNumber          Line number.
 * @param SizeInBits          Member size.
 * @param AlignInBits         Member alignment.
 * @param OffsetInBits        Member offset.
 * @param Flags               Flags to encode member attribute, e.g. private.
 * @param DerivedFrom         Debug info of the base class of this type.
 * @param Elements            Class members.
 * @param NumElements         Number of class elements.
 * @param VTableHolder        Debug info of the base class that contains vtable
 *                            for this type. This is used in
 *                            DW_AT_containing_type. See DWARF documentation
 *                            for more info.
 * @param TemplateParamsNode  Template type parameters.
 * @param UniqueIdentifier    A unique identifier for the type.
 * @param UniqueIdentifierLen Length of the unique identifier.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateClassType(LLVMDIBuilderRef Builder,
    LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name, @Cast("size_t") long NameLen,
    LLVMMetadataRef File, @Cast("unsigned") int LineNumber, @Cast("uint64_t") long SizeInBits,
    @Cast("uint32_t") int AlignInBits, @Cast("uint64_t") long OffsetInBits, @Cast("LLVMDIFlags") int Flags,
    LLVMMetadataRef DerivedFrom,
    @ByPtrPtr LLVMMetadataRef Elements, @Cast("unsigned") int NumElements,
    LLVMMetadataRef VTableHolder, LLVMMetadataRef TemplateParamsNode,
    @Cast("const char*") BytePointer UniqueIdentifier, @Cast("size_t") long UniqueIdentifierLen);
public static native LLVMMetadataRef LLVMDIBuilderCreateClassType(LLVMDIBuilderRef Builder,
    LLVMMetadataRef Scope, String Name, @Cast("size_t") long NameLen,
    LLVMMetadataRef File, @Cast("unsigned") int LineNumber, @Cast("uint64_t") long SizeInBits,
    @Cast("uint32_t") int AlignInBits, @Cast("uint64_t") long OffsetInBits, @Cast("LLVMDIFlags") int Flags,
    LLVMMetadataRef DerivedFrom,
    @Cast("LLVMMetadataRef*") PointerPointer Elements, @Cast("unsigned") int NumElements,
    LLVMMetadataRef VTableHolder, LLVMMetadataRef TemplateParamsNode,
    String UniqueIdentifier, @Cast("size_t") long UniqueIdentifierLen);

/**
 * Create a uniqued DIType* clone with FlagArtificial set.
 * @param Builder     The DIBuilder.
 * @param Type        The underlying type.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateArtificialType(LLVMDIBuilderRef Builder,
                                  LLVMMetadataRef Type);

/**
 * Get the name of this DIType.
 * @param DType     The DIType.
 * @param Length    The length of the returned string.
 *
 * @see DIType::getName()
 */
public static native @Cast("const char*") BytePointer LLVMDITypeGetName(LLVMMetadataRef DType, @Cast("size_t*") SizeTPointer Length);

/**
 * Get the size of this DIType in bits.
 * @param DType     The DIType.
 *
 * @see DIType::getSizeInBits()
 */
public static native @Cast("uint64_t") long LLVMDITypeGetSizeInBits(LLVMMetadataRef DType);

/**
 * Get the offset of this DIType in bits.
 * @param DType     The DIType.
 *
 * @see DIType::getOffsetInBits()
 */
public static native @Cast("uint64_t") long LLVMDITypeGetOffsetInBits(LLVMMetadataRef DType);

/**
 * Get the alignment of this DIType in bits.
 * @param DType     The DIType.
 *
 * @see DIType::getAlignInBits()
 */
public static native @Cast("uint32_t") int LLVMDITypeGetAlignInBits(LLVMMetadataRef DType);

/**
 * Get the source line where this DIType is declared.
 * @param DType     The DIType.
 *
 * @see DIType::getLine()
 */
public static native @Cast("unsigned") int LLVMDITypeGetLine(LLVMMetadataRef DType);

/**
 * Get the flags associated with this DIType.
 * @param DType     The DIType.
 *
 * @see DIType::getFlags()
 */
public static native @Cast("LLVMDIFlags") int LLVMDITypeGetFlags(LLVMMetadataRef DType);

/**
 * Create a descriptor for a value range.
 * @param Builder    The DIBuilder.
 * @param LowerBound Lower bound of the subrange, e.g. 0 for C, 1 for Fortran.
 * @param Count      Count of elements in the subrange.
 */
public static native LLVMMetadataRef LLVMDIBuilderGetOrCreateSubrange(LLVMDIBuilderRef Builder,
                                                 @Cast("int64_t") long LowerBound,
                                                 @Cast("int64_t") long Count);

/**
 * Create an array of DI Nodes.
 * @param Builder        The DIBuilder.
 * @param Data           The DI Node elements.
 * @param NumElements    Number of DI Node elements.
 */
public static native LLVMMetadataRef LLVMDIBuilderGetOrCreateArray(LLVMDIBuilderRef Builder,
                                              @ByPtrPtr LLVMMetadataRef Data,
                                              @Cast("size_t") long NumElements);
public static native LLVMMetadataRef LLVMDIBuilderGetOrCreateArray(LLVMDIBuilderRef Builder,
                                              @Cast("LLVMMetadataRef*") PointerPointer Data,
                                              @Cast("size_t") long NumElements);

/**
 * Create a new descriptor for the specified variable which has a complex
 * address expression for its address.
 * @param Builder     The DIBuilder.
 * @param Addr        An array of complex address operations.
 * @param Length      Length of the address operation array.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateExpression(LLVMDIBuilderRef Builder,
                                              @Cast("uint64_t*") LongPointer Addr, @Cast("size_t") long Length);
public static native LLVMMetadataRef LLVMDIBuilderCreateExpression(LLVMDIBuilderRef Builder,
                                              @Cast("uint64_t*") LongBuffer Addr, @Cast("size_t") long Length);
public static native LLVMMetadataRef LLVMDIBuilderCreateExpression(LLVMDIBuilderRef Builder,
                                              @Cast("uint64_t*") long[] Addr, @Cast("size_t") long Length);

/**
 * Create a new descriptor for the specified variable that does not have an
 * address, but does have a constant value.
 * @param Builder     The DIBuilder.
 * @param Value       The constant value.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateConstantValueExpression(LLVMDIBuilderRef Builder,
                                           @Cast("uint64_t") long Value);

/**
 * Create a new descriptor for the specified variable.
 * @param Scope       Variable scope.
 * @param Name        Name of the variable.
 * @param NameLen     The length of the C string passed to \c Name.
 * @param Linkage     Mangled  name of the variable.
 * @param LinkLen     The length of the C string passed to \c Linkage.
 * @param File        File where this variable is defined.
 * @param LineNo      Line number.
 * @param Ty          Variable Type.
 * @param LocalToUnit Boolean flag indicate whether this variable is
 *                    externally visible or not.
 * @param Expr        The location of the global relative to the attached
 *                    GlobalVariable.
 * @param Decl        Reference to the corresponding declaration.
 *                    variables.
 * @param AlignInBits Variable alignment(or 0 if no alignment attr was
 *                    specified)
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateGlobalVariableExpression(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, @Cast("const char*") BytePointer Linkage, @Cast("size_t") long LinkLen, LLVMMetadataRef File,
    @Cast("unsigned") int LineNo, LLVMMetadataRef Ty, @Cast("LLVMBool") int LocalToUnit,
    LLVMMetadataRef Expr, LLVMMetadataRef Decl, @Cast("uint32_t") int AlignInBits);
public static native LLVMMetadataRef LLVMDIBuilderCreateGlobalVariableExpression(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, String Linkage, @Cast("size_t") long LinkLen, LLVMMetadataRef File,
    @Cast("unsigned") int LineNo, LLVMMetadataRef Ty, @Cast("LLVMBool") int LocalToUnit,
    LLVMMetadataRef Expr, LLVMMetadataRef Decl, @Cast("uint32_t") int AlignInBits);

/**
 * Retrieves the \c DIVariable associated with this global variable expression.
 * @param GVE    The global variable expression.
 *
 * @see llvm::DIGlobalVariableExpression::getVariable()
 */
public static native LLVMMetadataRef LLVMDIGlobalVariableExpressionGetVariable(LLVMMetadataRef GVE);

/**
 * Retrieves the \c DIExpression associated with this global variable expression.
 * @param GVE    The global variable expression.
 *
 * @see llvm::DIGlobalVariableExpression::getExpression()
 */
public static native LLVMMetadataRef LLVMDIGlobalVariableExpressionGetExpression(
    LLVMMetadataRef GVE);

/**
 * Get the metadata of the file associated with a given variable.
 * @param Var     The variable object.
 *
 * @see DIVariable::getFile()
 */
public static native LLVMMetadataRef LLVMDIVariableGetFile(LLVMMetadataRef Var);

/**
 * Get the metadata of the scope associated with a given variable.
 * @param Var     The variable object.
 *
 * @see DIVariable::getScope()
 */
public static native LLVMMetadataRef LLVMDIVariableGetScope(LLVMMetadataRef Var);

/**
 * Get the source line where this \c DIVariable is declared.
 * @param Var     The DIVariable.
 *
 * @see DIVariable::getLine()
 */
public static native @Cast("unsigned") int LLVMDIVariableGetLine(LLVMMetadataRef Var);

/**
 * Create a new temporary \c MDNode.  Suitable for use in constructing cyclic
 * \c MDNode structures. A temporary \c MDNode is not uniqued, may be RAUW'd,
 * and must be manually deleted with \c LLVMDisposeTemporaryMDNode.
 * @param Ctx            The context in which to construct the temporary node.
 * @param Data           The metadata elements.
 * @param NumElements    Number of metadata elements.
 */
public static native LLVMMetadataRef LLVMTemporaryMDNode(LLVMContextRef Ctx, @ByPtrPtr LLVMMetadataRef Data,
                                    @Cast("size_t") long NumElements);
public static native LLVMMetadataRef LLVMTemporaryMDNode(LLVMContextRef Ctx, @Cast("LLVMMetadataRef*") PointerPointer Data,
                                    @Cast("size_t") long NumElements);

/**
 * Deallocate a temporary node.
 *
 * Calls \c replaceAllUsesWith(nullptr) before deleting, so any remaining
 * references will be reset.
 * @param TempNode    The temporary metadata node.
 */
public static native void LLVMDisposeTemporaryMDNode(LLVMMetadataRef TempNode);

/**
 * Replace all uses of temporary metadata.
 * @param TempTargetMetadata    The temporary metadata node.
 * @param Replacement           The replacement metadata node.
 */
public static native void LLVMMetadataReplaceAllUsesWith(LLVMMetadataRef TempTargetMetadata,
                                    LLVMMetadataRef Replacement);

/**
 * Create a new descriptor for the specified global variable that is temporary
 * and meant to be RAUWed.
 * @param Scope       Variable scope.
 * @param Name        Name of the variable.
 * @param NameLen     The length of the C string passed to \c Name.
 * @param Linkage     Mangled  name of the variable.
 * @param LnkLen      The length of the C string passed to \c Linkage.
 * @param File        File where this variable is defined.
 * @param LineNo      Line number.
 * @param Ty          Variable Type.
 * @param LocalToUnit Boolean flag indicate whether this variable is
 *                    externally visible or not.
 * @param Decl        Reference to the corresponding declaration.
 * @param AlignInBits Variable alignment(or 0 if no alignment attr was
 *                    specified)
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateTempGlobalVariableFwdDecl(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, @Cast("const char*") BytePointer Linkage, @Cast("size_t") long LnkLen, LLVMMetadataRef File,
    @Cast("unsigned") int LineNo, LLVMMetadataRef Ty, @Cast("LLVMBool") int LocalToUnit,
    LLVMMetadataRef Decl, @Cast("uint32_t") int AlignInBits);
public static native LLVMMetadataRef LLVMDIBuilderCreateTempGlobalVariableFwdDecl(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, String Linkage, @Cast("size_t") long LnkLen, LLVMMetadataRef File,
    @Cast("unsigned") int LineNo, LLVMMetadataRef Ty, @Cast("LLVMBool") int LocalToUnit,
    LLVMMetadataRef Decl, @Cast("uint32_t") int AlignInBits);

/**
 * Insert a new llvm.dbg.declare intrinsic call before the given instruction.
 * @param Builder     The DIBuilder.
 * @param Storage     The storage of the variable to declare.
 * @param VarInfo     The variable's debug info descriptor.
 * @param Expr        A complex location expression for the variable.
 * @param DebugLoc    Debug info location.
 * @param Instr       Instruction acting as a location for the new intrinsic.
 */
public static native LLVMValueRef LLVMDIBuilderInsertDeclareBefore(
  LLVMDIBuilderRef Builder, LLVMValueRef Storage, LLVMMetadataRef VarInfo,
  LLVMMetadataRef Expr, LLVMMetadataRef DebugLoc, LLVMValueRef Instr);

/**
 * Insert a new llvm.dbg.declare intrinsic call at the end of the given basic
 * block. If the basic block has a terminator instruction, the intrinsic is
 * inserted before that terminator instruction.
 * @param Builder     The DIBuilder.
 * @param Storage     The storage of the variable to declare.
 * @param VarInfo     The variable's debug info descriptor.
 * @param Expr        A complex location expression for the variable.
 * @param DebugLoc    Debug info location.
 * @param Block       Basic block acting as a location for the new intrinsic.
 */
public static native LLVMValueRef LLVMDIBuilderInsertDeclareAtEnd(
    LLVMDIBuilderRef Builder, LLVMValueRef Storage, LLVMMetadataRef VarInfo,
    LLVMMetadataRef Expr, LLVMMetadataRef DebugLoc, LLVMBasicBlockRef Block);

/**
 * Insert a new llvm.dbg.value intrinsic call before the given instruction.
 * @param Builder     The DIBuilder.
 * @param Val         The value of the variable.
 * @param VarInfo     The variable's debug info descriptor.
 * @param Expr        A complex location expression for the variable.
 * @param DebugLoc    Debug info location.
 * @param Instr       Instruction acting as a location for the new intrinsic.
 */
public static native LLVMValueRef LLVMDIBuilderInsertDbgValueBefore(LLVMDIBuilderRef Builder,
                                               LLVMValueRef Val,
                                               LLVMMetadataRef VarInfo,
                                               LLVMMetadataRef Expr,
                                               LLVMMetadataRef DebugLoc,
                                               LLVMValueRef Instr);

/**
 * Insert a new llvm.dbg.value intrinsic call at the end of the given basic
 * block. If the basic block has a terminator instruction, the intrinsic is
 * inserted before that terminator instruction.
 * @param Builder     The DIBuilder.
 * @param Val         The value of the variable.
 * @param VarInfo     The variable's debug info descriptor.
 * @param Expr        A complex location expression for the variable.
 * @param DebugLoc    Debug info location.
 * @param Block       Basic block acting as a location for the new intrinsic.
 */
public static native LLVMValueRef LLVMDIBuilderInsertDbgValueAtEnd(LLVMDIBuilderRef Builder,
                                              LLVMValueRef Val,
                                              LLVMMetadataRef VarInfo,
                                              LLVMMetadataRef Expr,
                                              LLVMMetadataRef DebugLoc,
                                              LLVMBasicBlockRef Block);

/**
 * Create a new descriptor for a local auto variable.
 * @param Builder         The DIBuilder.
 * @param Scope           The local scope the variable is declared in.
 * @param Name            Variable name.
 * @param NameLen         Length of variable name.
 * @param File            File where this variable is defined.
 * @param LineNo          Line number.
 * @param Ty              Metadata describing the type of the variable.
 * @param AlwaysPreserve  If true, this descriptor will survive optimizations.
 * @param Flags           Flags.
 * @param AlignInBits     Variable alignment.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateAutoVariable(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNo, LLVMMetadataRef Ty,
    @Cast("LLVMBool") int AlwaysPreserve, @Cast("LLVMDIFlags") int Flags, @Cast("uint32_t") int AlignInBits);
public static native LLVMMetadataRef LLVMDIBuilderCreateAutoVariable(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, LLVMMetadataRef File, @Cast("unsigned") int LineNo, LLVMMetadataRef Ty,
    @Cast("LLVMBool") int AlwaysPreserve, @Cast("LLVMDIFlags") int Flags, @Cast("uint32_t") int AlignInBits);

/**
 * Create a new descriptor for a function parameter variable.
 * @param Builder         The DIBuilder.
 * @param Scope           The local scope the variable is declared in.
 * @param Name            Variable name.
 * @param NameLen         Length of variable name.
 * @param ArgNo           Unique argument number for this variable; starts at 1.
 * @param File            File where this variable is defined.
 * @param LineNo          Line number.
 * @param Ty              Metadata describing the type of the variable.
 * @param AlwaysPreserve  If true, this descriptor will survive optimizations.
 * @param Flags           Flags.
 */
public static native LLVMMetadataRef LLVMDIBuilderCreateParameterVariable(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, @Cast("const char*") BytePointer Name,
    @Cast("size_t") long NameLen, @Cast("unsigned") int ArgNo, LLVMMetadataRef File, @Cast("unsigned") int LineNo,
    LLVMMetadataRef Ty, @Cast("LLVMBool") int AlwaysPreserve, @Cast("LLVMDIFlags") int Flags);
public static native LLVMMetadataRef LLVMDIBuilderCreateParameterVariable(
    LLVMDIBuilderRef Builder, LLVMMetadataRef Scope, String Name,
    @Cast("size_t") long NameLen, @Cast("unsigned") int ArgNo, LLVMMetadataRef File, @Cast("unsigned") int LineNo,
    LLVMMetadataRef Ty, @Cast("LLVMBool") int AlwaysPreserve, @Cast("LLVMDIFlags") int Flags);

/**
 * Get the metadata of the subprogram attached to a function.
 *
 * @see llvm::Function::getSubprogram()
 */
public static native LLVMMetadataRef LLVMGetSubprogram(LLVMValueRef Func);

/**
 * Set the subprogram attached to a function.
 *
 * @see llvm::Function::setSubprogram()
 */
public static native void LLVMSetSubprogram(LLVMValueRef Func, LLVMMetadataRef SP);

/**
 * Get the line associated with a given subprogram.
 * @param Subprogram     The subprogram object.
 *
 * @see DISubprogram::getLine()
 */
public static native @Cast("unsigned") int LLVMDISubprogramGetLine(LLVMMetadataRef Subprogram);

/**
 * Get the debug location for the given instruction.
 *
 * @see llvm::Instruction::getDebugLoc()
 */
public static native LLVMMetadataRef LLVMInstructionGetDebugLoc(LLVMValueRef Inst);

/**
 * Set the debug location for the given instruction.
 *
 * To clear the location metadata of the given instruction, pass NULL to \p Loc.
 *
 * @see llvm::Instruction::setDebugLoc()
 */
public static native void LLVMInstructionSetDebugLoc(LLVMValueRef Inst, LLVMMetadataRef Loc);

/**
 * Obtain the enumerated type of a Metadata instance.
 *
 * @see llvm::Metadata::getMetadataID()
 */
public static native @Cast("LLVMMetadataKind") int LLVMGetMetadataKind(LLVMMetadataRef Metadata);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Error.h>

/*===------- llvm-c/Error.h - llvm::Error class C Interface -------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file defines the C interface to LLVM's Error class.                   *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_ERROR_H
// #define LLVM_C_ERROR_H

// #include "llvm-c/ExternC.h"

/**
 * \defgroup LLVMCError Error Handling
 * \ingroup LLVMC
 *
 * \{
 */

public static final int LLVMErrorSuccess = 0;
// Targeting ../LLVM/LLVMErrorRef.java


// Targeting ../LLVM/LLVMErrorTypeId.java



/**
 * Returns the type id for the given error instance, which must be a failure
 * value (i.e. non-null).
 */
public static native @Const LLVMErrorTypeId LLVMGetErrorTypeId(LLVMErrorRef Err);

/**
 * Dispose of the given error without handling it. This operation consumes the
 * error, and the given LLVMErrorRef value is not usable once this call returns.
 * Note: This method *only* needs to be called if the error is not being passed
 * to some other consuming operation, e.g. LLVMGetErrorMessage.
 */
public static native void LLVMConsumeError(LLVMErrorRef Err);

/**
 * Returns the given string's error message. This operation consumes the error,
 * and the given LLVMErrorRef value is not usable once this call returns.
 * The caller is responsible for disposing of the string by calling
 * LLVMDisposeErrorMessage.
 */
public static native @Cast("char*") BytePointer LLVMGetErrorMessage(LLVMErrorRef Err);

/**
 * Dispose of the given error message.
 */
public static native void LLVMDisposeErrorMessage(@Cast("char*") BytePointer ErrMsg);
public static native void LLVMDisposeErrorMessage(@Cast("char*") ByteBuffer ErrMsg);
public static native void LLVMDisposeErrorMessage(@Cast("char*") byte[] ErrMsg);

/**
 * Returns the type id for llvm StringError.
 */
public static native @Const LLVMErrorTypeId LLVMGetStringErrorTypeId();

/**
 * Create a StringError.
 */
public static native LLVMErrorRef LLVMCreateStringError(@Cast("const char*") BytePointer ErrMsg);
public static native LLVMErrorRef LLVMCreateStringError(String ErrMsg);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/ErrorHandling.h>

/*===-- llvm-c/ErrorHandling.h - Error Handling C Interface -------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This file defines the C interface to LLVM's error handling mechanism.      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_ERRORHANDLING_H
// #define LLVM_C_ERRORHANDLING_H

// #include "llvm-c/ExternC.h"
// Targeting ../LLVM/LLVMFatalErrorHandler.java



/**
 * Install a fatal error handler. By default, if LLVM detects a fatal error, it
 * will call exit(1). This may not be appropriate in many contexts. For example,
 * doing exit(1) will bypass many crash reporting/tracing system tools. This
 * function allows you to install a callback that will be invoked prior to the
 * call to exit(1).
 */
public static native void LLVMInstallFatalErrorHandler(LLVMFatalErrorHandler Handler);

/**
 * Reset the fatal error handler. This resets LLVM's fatal error handling
 * behavior to the default.
 */
public static native void LLVMResetFatalErrorHandler();

/**
 * Enable LLVM's built-in stack trace code. This intercepts the OS's crash
 * signals and prints which component of LLVM you were in at the time if the
 * crash.
 */
public static native void LLVMEnablePrettyStackTrace();

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Orc.h>

/*===---------------- llvm-c/Orc.h - OrcV2 C bindings -----------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMOrcJIT.a, which implements  *|
|* JIT compilation of LLVM IR. Minimal documentation of C API specific issues *|
|* (especially memory ownership rules) is provided. Core Orc concepts are     *|
|* documented in llvm/docs/ORCv2.rst and APIs are documented in the C++       *|
|* headers                                                                    *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
|* Note: This interface is experimental. It is *NOT* stable, and may be       *|
|*       changed without warning. Only C API usage documentation is           *|
|*       provided. See the C++ documentation for all higher level ORC API     *|
|*       details.                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_ORC_H
// #define LLVM_C_ORC_H

// #include "llvm-c/Error.h"
// #include "llvm-c/TargetMachine.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCExecutionEngineORC On-Request-Compilation
 * \ingroup LLVMCExecutionEngine
 *
 * \{
 */

/**
 * Represents an address in the executor process.
 */

/**
 * Represents an address in the executor process.
 */

/**
 * Represents generic linkage flags for a symbol definition.
 */
/** enum LLVMJITSymbolGenericFlags */
public static final int
  LLVMJITSymbolGenericFlagsNone = 0,
  LLVMJITSymbolGenericFlagsExported = 1 << 0,
  LLVMJITSymbolGenericFlagsWeak = 1 << 1,
  LLVMJITSymbolGenericFlagsCallable = 1 << 2,
  LLVMJITSymbolGenericFlagsMaterializationSideEffectsOnly = 1 << 3;

/**
 * Represents target specific flags for a symbol definition.
 */
// Targeting ../LLVM/LLVMJITSymbolFlags.java


// Targeting ../LLVM/LLVMJITEvaluatedSymbol.java


// Targeting ../LLVM/LLVMOrcExecutionSessionRef.java


// Targeting ../LLVM/LLVMOrcErrorReporterFunction.java


// Targeting ../LLVM/LLVMOrcSymbolStringPoolRef.java


// Targeting ../LLVM/LLVMOrcSymbolStringPoolEntryRef.java


// Targeting ../LLVM/LLVMOrcCSymbolFlagsMapPair.java



/**
 * Represents a list of (SymbolStringPtr, JITSymbolFlags) pairs that can be used
 * to construct a SymbolFlagsMap.
 */
// Targeting ../LLVM/LLVMOrcCSymbolMapPair.java



/**
 * Represents a list of (SymbolStringPtr, JITEvaluatedSymbol) pairs that can be
 * used to construct a SymbolMap.
 */
// Targeting ../LLVM/LLVMOrcCSymbolAliasMapEntry.java


// Targeting ../LLVM/LLVMOrcCSymbolAliasMapPair.java



/**
 * Represents a list of (SymbolStringPtr, (SymbolStringPtr, JITSymbolFlags))
 * pairs that can be used to construct a SymbolFlagsMap.
 */
// Targeting ../LLVM/LLVMOrcJITDylibRef.java


// Targeting ../LLVM/LLVMOrcCSymbolsList.java


// Targeting ../LLVM/LLVMOrcCDependenceMapPair.java



/**
 * Represents a list of (JITDylibRef, (LLVMOrcSymbolStringPoolEntryRef*,
 * size_t)) pairs that can be used to construct a SymbolDependenceMap.
 */

/**
 * Lookup kind. This can be used by definition generators when deciding whether
 * to produce a definition for a requested symbol.
 *
 * This enum should be kept in sync with llvm::orc::LookupKind.
 */
/** enum LLVMOrcLookupKind */
public static final int
  LLVMOrcLookupKindStatic = 0,
  LLVMOrcLookupKindDLSym = 1;

/**
 * JITDylib lookup flags. This can be used by definition generators when
 * deciding whether to produce a definition for a requested symbol.
 *
 * This enum should be kept in sync with llvm::orc::JITDylibLookupFlags.
 */
/** enum LLVMOrcJITDylibLookupFlags */
public static final int
  LLVMOrcJITDylibLookupFlagsMatchExportedSymbolsOnly = 0,
  LLVMOrcJITDylibLookupFlagsMatchAllSymbols = 1;
// Targeting ../LLVM/LLVMOrcCJITDylibSearchOrderElement.java



/**
 * A JITDylib search order.
 *
 * The list is terminated with an element containing a null pointer for the JD
 * field.
 */

/**
 * Symbol lookup flags for lookup sets. This should be kept in sync with
 * llvm::orc::SymbolLookupFlags.
 */
/** enum LLVMOrcSymbolLookupFlags */
public static final int
  LLVMOrcSymbolLookupFlagsRequiredSymbol = 0,
  LLVMOrcSymbolLookupFlagsWeaklyReferencedSymbol = 1;
// Targeting ../LLVM/LLVMOrcCLookupSetElement.java



/**
 * A set of symbols to look up / generate.
 *
 * The list is terminated with an element containing a null pointer for the
 * Name field.
 *
 * If a client creates an instance of this type then they are responsible for
 * freeing it, and for ensuring that all strings have been retained over the
 * course of its life. Clients receiving a copy from a callback are not
 * responsible for managing lifetime or retain counts.
 */
// Targeting ../LLVM/LLVMOrcMaterializationUnitRef.java


// Targeting ../LLVM/LLVMOrcMaterializationResponsibilityRef.java


// Targeting ../LLVM/LLVMOrcMaterializationUnitMaterializeFunction.java


// Targeting ../LLVM/LLVMOrcMaterializationUnitDiscardFunction.java


// Targeting ../LLVM/LLVMOrcMaterializationUnitDestroyFunction.java


// Targeting ../LLVM/LLVMOrcResourceTrackerRef.java


// Targeting ../LLVM/LLVMOrcDefinitionGeneratorRef.java


// Targeting ../LLVM/LLVMOrcLookupStateRef.java


// Targeting ../LLVM/LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction.java


// Targeting ../LLVM/LLVMOrcDisposeCAPIDefinitionGeneratorFunction.java


// Targeting ../LLVM/LLVMOrcSymbolPredicate.java


// Targeting ../LLVM/LLVMOrcThreadSafeContextRef.java


// Targeting ../LLVM/LLVMOrcThreadSafeModuleRef.java


// Targeting ../LLVM/LLVMOrcGenericIRModuleOperationFunction.java


// Targeting ../LLVM/LLVMOrcJITTargetMachineBuilderRef.java


// Targeting ../LLVM/LLVMOrcObjectLayerRef.java


// Targeting ../LLVM/LLVMOrcOpaqueObjectLinkingLayer.java


// Targeting ../LLVM/LLVMOrcIRTransformLayerRef.java


// Targeting ../LLVM/LLVMOrcIRTransformLayerTransformFunction.java


// Targeting ../LLVM/LLVMOrcObjectTransformLayerRef.java


// Targeting ../LLVM/LLVMOrcObjectTransformLayerTransformFunction.java


// Targeting ../LLVM/LLVMOrcIndirectStubsManagerRef.java


// Targeting ../LLVM/LLVMOrcLazyCallThroughManagerRef.java


// Targeting ../LLVM/LLVMOrcDumpObjectsRef.java



/**
 * Attach a custom error reporter function to the ExecutionSession.
 *
 * The error reporter will be called to deliver failure notices that can not be
 * directly reported to a caller. For example, failure to resolve symbols in
 * the JIT linker is typically reported via the error reporter (callers
 * requesting definitions from the JIT will typically be delivered a
 * FailureToMaterialize error instead).
 */
public static native void LLVMOrcExecutionSessionSetErrorReporter(
    LLVMOrcExecutionSessionRef ES, LLVMOrcErrorReporterFunction ReportError,
    Pointer Ctx);

/**
 * Return a reference to the SymbolStringPool for an ExecutionSession.
 *
 * Ownership of the pool remains with the ExecutionSession: The caller is
 * not required to free the pool.
 */
public static native LLVMOrcSymbolStringPoolRef LLVMOrcExecutionSessionGetSymbolStringPool(LLVMOrcExecutionSessionRef ES);

/**
 * Clear all unreferenced symbol string pool entries.
 *
 * This can be called at any time to release unused entries in the
 * ExecutionSession's string pool. Since it locks the pool (preventing
 * interning of any new strings) it is recommended that it only be called
 * infrequently, ideally when the caller has reason to believe that some
 * entries will have become unreferenced, e.g. after removing a module or
 * closing a JITDylib.
 */
public static native void LLVMOrcSymbolStringPoolClearDeadEntries(LLVMOrcSymbolStringPoolRef SSP);

/**
 * Intern a string in the ExecutionSession's SymbolStringPool and return a
 * reference to it. This increments the ref-count of the pool entry, and the
 * returned value should be released once the client is done with it by
 * calling LLVMOrReleaseSymbolStringPoolEntry.
 *
 * Since strings are uniqued within the SymbolStringPool
 * LLVMOrcSymbolStringPoolEntryRefs can be compared by value to test string
 * equality.
 *
 * Note that this function does not perform linker-mangling on the string.
 */
public static native LLVMOrcSymbolStringPoolEntryRef LLVMOrcExecutionSessionIntern(LLVMOrcExecutionSessionRef ES, @Cast("const char*") BytePointer Name);
public static native LLVMOrcSymbolStringPoolEntryRef LLVMOrcExecutionSessionIntern(LLVMOrcExecutionSessionRef ES, String Name);
// Targeting ../LLVM/LLVMOrcExecutionSessionLookupHandleResultFunction.java



/**
 * Look up symbols in an execution session.
 *
 * This is a wrapper around the general ExecutionSession::lookup function.
 *
 * The SearchOrder argument contains a list of (JITDylibs, JITDylibSearchFlags)
 * pairs that describe the search order. The JITDylibs will be searched in the
 * given order to try to find the symbols in the Symbols argument.
 *
 * The Symbols argument should contain a null-terminated array of
 * (SymbolStringPtr, SymbolLookupFlags) pairs describing the symbols to be
 * searched for. This function takes ownership of the elements of the Symbols
 * array. The Name fields of the Symbols elements are taken to have been
 * retained by the client for this function. The client should *not* release the
 * Name fields, but are still responsible for destroying the array itself.
 *
 * The HandleResult function will be called once all searched for symbols have
 * been found, or an error occurs. The HandleResult function will be passed an
 * LLVMErrorRef indicating success or failure, and (on success) a
 * null-terminated LLVMOrcCSymbolMapPairs array containing the function result,
 * and the Ctx value passed to the lookup function.
 *
 * The client is fully responsible for managing the lifetime of the Ctx object.
 * A common idiom is to allocate the context prior to the lookup and deallocate
 * it in the handler.
 *
 * THIS API IS EXPERIMENTAL AND LIKELY TO CHANGE IN THE NEAR FUTURE!
 */
public static native void LLVMOrcExecutionSessionLookup(
    LLVMOrcExecutionSessionRef ES, @Cast("LLVMOrcLookupKind") int K,
    @Cast("LLVMOrcCJITDylibSearchOrder") LLVMOrcCJITDylibSearchOrderElement SearchOrder, @Cast("size_t") long SearchOrderSize,
    @Cast("LLVMOrcCLookupSet") LLVMOrcCLookupSetElement Symbols, @Cast("size_t") long SymbolsSize,
    LLVMOrcExecutionSessionLookupHandleResultFunction HandleResult, Pointer Ctx);

/**
 * Increments the ref-count for a SymbolStringPool entry.
 */
public static native void LLVMOrcRetainSymbolStringPoolEntry(LLVMOrcSymbolStringPoolEntryRef S);

/**
 * Reduces the ref-count for of a SymbolStringPool entry.
 */
public static native void LLVMOrcReleaseSymbolStringPoolEntry(LLVMOrcSymbolStringPoolEntryRef S);

/**
 * Return the c-string for the given symbol. This string will remain valid until
 * the entry is freed (once all LLVMOrcSymbolStringPoolEntryRefs have been
 * released).
 */
public static native @Cast("const char*") BytePointer LLVMOrcSymbolStringPoolEntryStr(LLVMOrcSymbolStringPoolEntryRef S);

/**
 * Reduces the ref-count of a ResourceTracker.
 */
public static native void LLVMOrcReleaseResourceTracker(LLVMOrcResourceTrackerRef RT);

/**
 * Transfers tracking of all resources associated with resource tracker SrcRT
 * to resource tracker DstRT.
 */
public static native void LLVMOrcResourceTrackerTransferTo(LLVMOrcResourceTrackerRef SrcRT,
                                      LLVMOrcResourceTrackerRef DstRT);

/**
 * Remove all resources associated with the given tracker. See
 * ResourceTracker::remove().
 */
public static native LLVMErrorRef LLVMOrcResourceTrackerRemove(LLVMOrcResourceTrackerRef RT);

/**
 * Dispose of a JITDylib::DefinitionGenerator. This should only be called if
 * ownership has not been passed to a JITDylib (e.g. because some error
 * prevented the client from calling LLVMOrcJITDylibAddGenerator).
 */
public static native void LLVMOrcDisposeDefinitionGenerator(LLVMOrcDefinitionGeneratorRef DG);

/**
 * Dispose of a MaterializationUnit.
 */
public static native void LLVMOrcDisposeMaterializationUnit(LLVMOrcMaterializationUnitRef MU);

/**
 * Create a custom MaterializationUnit.
 *
 * Name is a name for this MaterializationUnit to be used for identification
 * and logging purposes (e.g. if this MaterializationUnit produces an
 * object buffer then the name of that buffer will be derived from this name).
 *
 * The Syms list contains the names and linkages of the symbols provided by this
 * unit. This function takes ownership of the elements of the Syms array. The
 * Name fields of the array elements are taken to have been retained for this
 * function. The client should *not* release the elements of the array, but is
 * still responsible for destroying the array itself.
 *
 * The InitSym argument indicates whether or not this MaterializationUnit
 * contains static initializers. If three are no static initializers (the common
 * case) then this argument should be null. If there are static initializers
 * then InitSym should be set to a unique name that also appears in the Syms
 * list with the LLVMJITSymbolGenericFlagsMaterializationSideEffectsOnly flag
 * set. This function takes ownership of the InitSym, which should have been
 * retained twice on behalf of this function: once for the Syms entry and once
 * for InitSym. If clients wish to use the InitSym value after this function
 * returns they must retain it once more for themselves.
 *
 * If any of the symbols in the Syms list is looked up then the Materialize
 * function will be called.
 *
 * If any of the symbols in the Syms list is overridden then the Discard
 * function will be called.
 *
 * The caller owns the underling MaterializationUnit and is responsible for
 * either passing it to a JITDylib (via LLVMOrcJITDylibDefine) or disposing
 * of it by calling LLVMOrcDisposeMaterializationUnit.
 */
public static native LLVMOrcMaterializationUnitRef LLVMOrcCreateCustomMaterializationUnit(
    @Cast("const char*") BytePointer Name, Pointer Ctx, @Cast("LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair Syms,
    @Cast("size_t") long NumSyms, LLVMOrcSymbolStringPoolEntryRef InitSym,
    LLVMOrcMaterializationUnitMaterializeFunction Materialize,
    LLVMOrcMaterializationUnitDiscardFunction Discard,
    LLVMOrcMaterializationUnitDestroyFunction Destroy);
public static native LLVMOrcMaterializationUnitRef LLVMOrcCreateCustomMaterializationUnit(
    String Name, Pointer Ctx, @Cast("LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair Syms,
    @Cast("size_t") long NumSyms, LLVMOrcSymbolStringPoolEntryRef InitSym,
    LLVMOrcMaterializationUnitMaterializeFunction Materialize,
    LLVMOrcMaterializationUnitDiscardFunction Discard,
    LLVMOrcMaterializationUnitDestroyFunction Destroy);

/**
 * Create a MaterializationUnit to define the given symbols as pointing to
 * the corresponding raw addresses.
 *
 * This function takes ownership of the elements of the Syms array. The Name
 * fields of the array elements are taken to have been retained for this
 * function. This allows the following pattern...
 *
 *   size_t NumPairs;
 *   LLVMOrcCSymbolMapPairs Sym;
 *   -- Build Syms array --
 *   LLVMOrcMaterializationUnitRef MU =
 *       LLVMOrcAbsoluteSymbols(Syms, NumPairs);
 *
 * ... without requiring cleanup of the elements of the Sym array afterwards.
 *
 * The client is still responsible for deleting the Sym array itself.
 *
 * If a client wishes to reuse elements of the Sym array after this call they
 * must explicitly retain each of the elements for themselves.
 */
public static native LLVMOrcMaterializationUnitRef LLVMOrcAbsoluteSymbols(@Cast("LLVMOrcCSymbolMapPairs") LLVMOrcCSymbolMapPair Syms, @Cast("size_t") long NumPairs);

/**
 * Create a MaterializationUnit to define lazy re-expots. These are callable
 * entry points that call through to the given symbols.
 *
 * This function takes ownership of the CallableAliases array. The Name
 * fields of the array elements are taken to have been retained for this
 * function. This allows the following pattern...
 *
 *   size_t NumPairs;
 *   LLVMOrcCSymbolAliasMapPairs CallableAliases;
 *   -- Build CallableAliases array --
 *   LLVMOrcMaterializationUnitRef MU =
 *      LLVMOrcLazyReexports(LCTM, ISM, JD, CallableAliases, NumPairs);
 *
 * ... without requiring cleanup of the elements of the CallableAliases array afterwards.
 *
 * The client is still responsible for deleting the CallableAliases array itself.
 *
 * If a client wishes to reuse elements of the CallableAliases array after this call they
 * must explicitly retain each of the elements for themselves.
 */
public static native LLVMOrcMaterializationUnitRef LLVMOrcLazyReexports(
    LLVMOrcLazyCallThroughManagerRef LCTM, LLVMOrcIndirectStubsManagerRef ISM,
    LLVMOrcJITDylibRef SourceRef, @Cast("LLVMOrcCSymbolAliasMapPairs") LLVMOrcCSymbolAliasMapPair CallableAliases,
    @Cast("size_t") long NumPairs);
// TODO: ImplSymbolMad SrcJDLoc

/**
 * Disposes of the passed MaterializationResponsibility object.
 *
 * This should only be done after the symbols covered by the object have either
 * been resolved and emitted (via
 * LLVMOrcMaterializationResponsibilityNotifyResolved and
 * LLVMOrcMaterializationResponsibilityNotifyEmitted) or failed (via
 * LLVMOrcMaterializationResponsibilityFailMaterialization).
 */
public static native void LLVMOrcDisposeMaterializationResponsibility(
    LLVMOrcMaterializationResponsibilityRef MR);

/**
 * Returns the target JITDylib that these symbols are being materialized into.
 */
public static native LLVMOrcJITDylibRef LLVMOrcMaterializationResponsibilityGetTargetDylib(
    LLVMOrcMaterializationResponsibilityRef MR);

/**
 * Returns the ExecutionSession for this MaterializationResponsibility.
 */
public static native LLVMOrcExecutionSessionRef LLVMOrcMaterializationResponsibilityGetExecutionSession(
    LLVMOrcMaterializationResponsibilityRef MR);

/**
 * Returns the symbol flags map for this responsibility instance.
 *
 * The length of the array is returned in NumPairs and the caller is responsible
 * for the returned memory and needs to call LLVMOrcDisposeCSymbolFlagsMap.
 *
 * To use the returned symbols beyond the livetime of the
 * MaterializationResponsibility requires the caller to retain the symbols
 * explicitly.
 */
public static native @Cast("LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair LLVMOrcMaterializationResponsibilityGetSymbols(
    LLVMOrcMaterializationResponsibilityRef MR, @Cast("size_t*") SizeTPointer NumPairs);

/**
 * Disposes of the passed LLVMOrcCSymbolFlagsMap.
 *
 * Does not release the entries themselves.
 */
public static native void LLVMOrcDisposeCSymbolFlagsMap(@Cast("LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair Pairs);

/**
 * Returns the initialization pseudo-symbol, if any. This symbol will also
 * be present in the SymbolFlagsMap for this MaterializationResponsibility
 * object.
 *
 * The returned symbol is not retained over any mutating operation of the
 * MaterializationResponsbility or beyond the lifetime thereof.
 */
public static native LLVMOrcSymbolStringPoolEntryRef LLVMOrcMaterializationResponsibilityGetInitializerSymbol(
    LLVMOrcMaterializationResponsibilityRef MR);

/**
 * Returns the names of any symbols covered by this
 * MaterializationResponsibility object that have queries pending. This
 * information can be used to return responsibility for unrequested symbols
 * back to the JITDylib via the delegate method.
 */
public static native @ByPtrPtr LLVMOrcSymbolStringPoolEntryRef LLVMOrcMaterializationResponsibilityGetRequestedSymbols(
    LLVMOrcMaterializationResponsibilityRef MR, @Cast("size_t*") SizeTPointer NumSymbols);

/**
 * Disposes of the passed LLVMOrcSymbolStringPoolEntryRef* .
 *
 * Does not release the symbols themselves.
 */
public static native void LLVMOrcDisposeSymbols(@ByPtrPtr LLVMOrcSymbolStringPoolEntryRef Symbols);
public static native void LLVMOrcDisposeSymbols(@Cast("LLVMOrcSymbolStringPoolEntryRef*") PointerPointer Symbols);

/**
 * Notifies the target JITDylib that the given symbols have been resolved.
 * This will update the given symbols' addresses in the JITDylib, and notify
 * any pending queries on the given symbols of their resolution. The given
 * symbols must be ones covered by this MaterializationResponsibility
 * instance. Individual calls to this method may resolve a subset of the
 * symbols, but all symbols must have been resolved prior to calling emit.
 *
 * This method will return an error if any symbols being resolved have been
 * moved to the error state due to the failure of a dependency. If this
 * method returns an error then clients should log it and call
 * LLVMOrcMaterializationResponsibilityFailMaterialization. If no dependencies
 * have been registered for the symbols covered by this
 * MaterializationResponsibiility then this method is guaranteed to return
 * LLVMErrorSuccess.
 */
public static native LLVMErrorRef LLVMOrcMaterializationResponsibilityNotifyResolved(
    LLVMOrcMaterializationResponsibilityRef MR, @Cast("LLVMOrcCSymbolMapPairs") LLVMOrcCSymbolMapPair Symbols,
    @Cast("size_t") long NumPairs);

/**
 * Notifies the target JITDylib (and any pending queries on that JITDylib)
 * that all symbols covered by this MaterializationResponsibility instance
 * have been emitted.
 *
 * This method will return an error if any symbols being resolved have been
 * moved to the error state due to the failure of a dependency. If this
 * method returns an error then clients should log it and call
 * LLVMOrcMaterializationResponsibilityFailMaterialization.
 * If no dependencies have been registered for the symbols covered by this
 * MaterializationResponsibiility then this method is guaranteed to return
 * LLVMErrorSuccess.
 */
public static native LLVMErrorRef LLVMOrcMaterializationResponsibilityNotifyEmitted(
    LLVMOrcMaterializationResponsibilityRef MR);

/**
 * Attempt to claim responsibility for new definitions. This method can be
 * used to claim responsibility for symbols that are added to a
 * materialization unit during the compilation process (e.g. literal pool
 * symbols). Symbol linkage rules are the same as for symbols that are
 * defined up front: duplicate strong definitions will result in errors.
 * Duplicate weak definitions will be discarded (in which case they will
 * not be added to this responsibility instance).
 *
 * This method can be used by materialization units that want to add
 * additional symbols at materialization time (e.g. stubs, compile
 * callbacks, metadata)
 */
public static native LLVMErrorRef LLVMOrcMaterializationResponsibilityDefineMaterializing(
    LLVMOrcMaterializationResponsibilityRef MR,
    @Cast("LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair Pairs, @Cast("size_t") long NumPairs);

/**
 * Notify all not-yet-emitted covered by this MaterializationResponsibility
 * instance that an error has occurred.
 * This will remove all symbols covered by this MaterializationResponsibilty
 * from the target JITDylib, and send an error to any queries waiting on
 * these symbols.
 */
public static native void LLVMOrcMaterializationResponsibilityFailMaterialization(
    LLVMOrcMaterializationResponsibilityRef MR);

/**
 * Transfers responsibility to the given MaterializationUnit for all
 * symbols defined by that MaterializationUnit. This allows
 * materializers to break up work based on run-time information (e.g.
 * by introspecting which symbols have actually been looked up and
 * materializing only those).
 */
public static native LLVMErrorRef LLVMOrcMaterializationResponsibilityReplace(
    LLVMOrcMaterializationResponsibilityRef MR,
    LLVMOrcMaterializationUnitRef MU);

/**
 * Delegates responsibility for the given symbols to the returned
 * materialization responsibility. Useful for breaking up work between
 * threads, or different kinds of materialization processes.
 *
 * The caller retains responsibility of the the passed
 * MaterializationResponsibility.
 */
public static native LLVMErrorRef LLVMOrcMaterializationResponsibilityDelegate(
    LLVMOrcMaterializationResponsibilityRef MR,
    @ByPtrPtr LLVMOrcSymbolStringPoolEntryRef Symbols, @Cast("size_t") long NumSymbols,
    @ByPtrPtr LLVMOrcMaterializationResponsibilityRef Result);
public static native LLVMErrorRef LLVMOrcMaterializationResponsibilityDelegate(
    LLVMOrcMaterializationResponsibilityRef MR,
    @Cast("LLVMOrcSymbolStringPoolEntryRef*") PointerPointer Symbols, @Cast("size_t") long NumSymbols,
    @Cast("LLVMOrcMaterializationResponsibilityRef*") PointerPointer Result);

/**
 * Adds dependencies to a symbol that the MaterializationResponsibility is
 * responsible for.
 *
 * This function takes ownership of Dependencies struct. The Names
 * array have been retained for this function. This allows the following
 * pattern...
 *
 *   LLVMOrcSymbolStringPoolEntryRef Names[] = {...};
 *   LLVMOrcCDependenceMapPair Dependence = {JD, {Names, sizeof(Names)}}
 *   LLVMOrcMaterializationResponsibilityAddDependencies(JD, Name, &Dependence,
 * 1);
 *
 * ... without requiring cleanup of the elements of the Names array afterwards.
 *
 * The client is still responsible for deleting the Dependencies.Names array
 * itself.
 */
public static native void LLVMOrcMaterializationResponsibilityAddDependencies(
    LLVMOrcMaterializationResponsibilityRef MR,
    LLVMOrcSymbolStringPoolEntryRef Name,
    @Cast("LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair Dependencies, @Cast("size_t") long NumPairs);

/**
 * Adds dependencies to all symbols that the MaterializationResponsibility is
 * responsible for. See LLVMOrcMaterializationResponsibilityAddDependencies for
 * notes about memory responsibility.
 */
public static native void LLVMOrcMaterializationResponsibilityAddDependenciesForAll(
    LLVMOrcMaterializationResponsibilityRef MR,
    @Cast("LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair Dependencies, @Cast("size_t") long NumPairs);

/**
 * Create a "bare" JITDylib.
 *
 * The client is responsible for ensuring that the JITDylib's name is unique,
 * e.g. by calling LLVMOrcExecutionSessionGetJTIDylibByName first.
 *
 * This call does not install any library code or symbols into the newly
 * created JITDylib. The client is responsible for all configuration.
 */
public static native LLVMOrcJITDylibRef LLVMOrcExecutionSessionCreateBareJITDylib(LLVMOrcExecutionSessionRef ES,
                                          @Cast("const char*") BytePointer Name);
public static native LLVMOrcJITDylibRef LLVMOrcExecutionSessionCreateBareJITDylib(LLVMOrcExecutionSessionRef ES,
                                          String Name);

/**
 * Create a JITDylib.
 *
 * The client is responsible for ensuring that the JITDylib's name is unique,
 * e.g. by calling LLVMOrcExecutionSessionGetJTIDylibByName first.
 *
 * If a Platform is attached to the ExecutionSession then
 * Platform::setupJITDylib will be called to install standard platform symbols
 * (e.g. standard library interposes). If no Platform is installed then this
 * call is equivalent to LLVMExecutionSessionRefCreateBareJITDylib and will
 * always return success.
 */
public static native LLVMErrorRef LLVMOrcExecutionSessionCreateJITDylib(LLVMOrcExecutionSessionRef ES,
                                      @ByPtrPtr LLVMOrcJITDylibRef Result,
                                      @Cast("const char*") BytePointer Name);
public static native LLVMErrorRef LLVMOrcExecutionSessionCreateJITDylib(LLVMOrcExecutionSessionRef ES,
                                      @Cast("LLVMOrcJITDylibRef*") PointerPointer Result,
                                      String Name);

/**
 * Returns the JITDylib with the given name, or NULL if no such JITDylib
 * exists.
 */
public static native LLVMOrcJITDylibRef LLVMOrcExecutionSessionGetJITDylibByName(LLVMOrcExecutionSessionRef ES,
                                         @Cast("const char*") BytePointer Name);
public static native LLVMOrcJITDylibRef LLVMOrcExecutionSessionGetJITDylibByName(LLVMOrcExecutionSessionRef ES,
                                         String Name);

/**
 * Return a reference to a newly created resource tracker associated with JD.
 * The tracker is returned with an initial ref-count of 1, and must be released
 * with LLVMOrcReleaseResourceTracker when no longer needed.
 */
public static native LLVMOrcResourceTrackerRef LLVMOrcJITDylibCreateResourceTracker(LLVMOrcJITDylibRef JD);

/**
 * Return a reference to the default resource tracker for the given JITDylib.
 * This operation will increase the retain count of the tracker: Clients should
 * call LLVMOrcReleaseResourceTracker when the result is no longer needed.
 */
public static native LLVMOrcResourceTrackerRef LLVMOrcJITDylibGetDefaultResourceTracker(LLVMOrcJITDylibRef JD);

/**
 * Add the given MaterializationUnit to the given JITDylib.
 *
 * If this operation succeeds then JITDylib JD will take ownership of MU.
 * If the operation fails then ownership remains with the caller who should
 * call LLVMOrcDisposeMaterializationUnit to destroy it.
 */
public static native LLVMErrorRef LLVMOrcJITDylibDefine(LLVMOrcJITDylibRef JD,
                                   LLVMOrcMaterializationUnitRef MU);

/**
 * Calls remove on all trackers associated with this JITDylib, see
 * JITDylib::clear().
 */
public static native LLVMErrorRef LLVMOrcJITDylibClear(LLVMOrcJITDylibRef JD);

/**
 * Add a DefinitionGenerator to the given JITDylib.
 *
 * The JITDylib will take ownership of the given generator: The client is no
 * longer responsible for managing its memory.
 */
public static native void LLVMOrcJITDylibAddGenerator(LLVMOrcJITDylibRef JD,
                                 LLVMOrcDefinitionGeneratorRef DG);

/**
 * Create a custom generator.
 *
 * The F argument will be used to implement the DefinitionGenerator's
 * tryToGenerate method (see
 * LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction).
 *
 * Ctx is a context object that will be passed to F. This argument is
 * permitted to be null.
 *
 * Dispose is the disposal function for Ctx. This argument is permitted to be
 * null (in which case the client is responsible for the lifetime of Ctx).
 */
public static native LLVMOrcDefinitionGeneratorRef LLVMOrcCreateCustomCAPIDefinitionGenerator(
    LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction F, Pointer Ctx,
    LLVMOrcDisposeCAPIDefinitionGeneratorFunction Dispose);

/**
 * Continue a lookup that was suspended in a generator (see
 * LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction).
 */
public static native void LLVMOrcLookupStateContinueLookup(LLVMOrcLookupStateRef S,
                                      LLVMErrorRef Err);

/**
 * Get a DynamicLibrarySearchGenerator that will reflect process symbols into
 * the JITDylib. On success the resulting generator is owned by the client.
 * Ownership is typically transferred by adding the instance to a JITDylib
 * using LLVMOrcJITDylibAddGenerator,
 *
 * The GlobalPrefix argument specifies the character that appears on the front
 * of linker-mangled symbols for the target platform (e.g. '_' on MachO).
 * If non-null, this character will be stripped from the start of all symbol
 * strings before passing the remaining substring to dlsym.
 *
 * The optional Filter and Ctx arguments can be used to supply a symbol name
 * filter: Only symbols for which the filter returns true will be visible to
 * JIT'd code. If the Filter argument is null then all process symbols will
 * be visible to JIT'd code. Note that the symbol name passed to the Filter
 * function is the full mangled symbol: The client is responsible for stripping
 * the global prefix if present.
 */
public static native LLVMErrorRef LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(
    @ByPtrPtr LLVMOrcDefinitionGeneratorRef Result, @Cast("char") byte GlobalPrefx,
    LLVMOrcSymbolPredicate Filter, Pointer FilterCtx);
public static native LLVMErrorRef LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(
    @Cast("LLVMOrcDefinitionGeneratorRef*") PointerPointer Result, @Cast("char") byte GlobalPrefx,
    LLVMOrcSymbolPredicate Filter, Pointer FilterCtx);

/**
 * Get a LLVMOrcCreateDynamicLibararySearchGeneratorForPath that will reflect
 * library symbols into the JITDylib. On success the resulting generator is
 * owned by the client. Ownership is typically transferred by adding the
 * instance to a JITDylib using LLVMOrcJITDylibAddGenerator,
 *
 * The GlobalPrefix argument specifies the character that appears on the front
 * of linker-mangled symbols for the target platform (e.g. '_' on MachO).
 * If non-null, this character will be stripped from the start of all symbol
 * strings before passing the remaining substring to dlsym.
 *
 * The optional Filter and Ctx arguments can be used to supply a symbol name
 * filter: Only symbols for which the filter returns true will be visible to
 * JIT'd code. If the Filter argument is null then all library symbols will
 * be visible to JIT'd code. Note that the symbol name passed to the Filter
 * function is the full mangled symbol: The client is responsible for stripping
 * the global prefix if present.
 * 
 * THIS API IS EXPERIMENTAL AND LIKELY TO CHANGE IN THE NEAR FUTURE!
 * 
 */
public static native LLVMErrorRef LLVMOrcCreateDynamicLibrarySearchGeneratorForPath(
    @ByPtrPtr LLVMOrcDefinitionGeneratorRef Result, @Cast("const char*") BytePointer FileName,
    @Cast("char") byte GlobalPrefix, LLVMOrcSymbolPredicate Filter, Pointer FilterCtx);
public static native LLVMErrorRef LLVMOrcCreateDynamicLibrarySearchGeneratorForPath(
    @Cast("LLVMOrcDefinitionGeneratorRef*") PointerPointer Result, String FileName,
    @Cast("char") byte GlobalPrefix, LLVMOrcSymbolPredicate Filter, Pointer FilterCtx);

/**
 * Get a LLVMOrcCreateStaticLibrarySearchGeneratorForPath that will reflect
 * static library symbols into the JITDylib. On success the resulting
 * generator is owned by the client. Ownership is typically transferred by
 * adding the instance to a JITDylib using LLVMOrcJITDylibAddGenerator,
 *
 * Call with the optional TargetTriple argument will succeed if the file at
 * the given path is a static library or a MachO universal binary containing a
 * static library that is compatible with the given triple. Otherwise it will
 * return an error.
 *
 * THIS API IS EXPERIMENTAL AND LIKELY TO CHANGE IN THE NEAR FUTURE!
 * 
 */
public static native LLVMErrorRef LLVMOrcCreateStaticLibrarySearchGeneratorForPath(
    @ByPtrPtr LLVMOrcDefinitionGeneratorRef Result, LLVMOrcObjectLayerRef ObjLayer,
    @Cast("const char*") BytePointer FileName, @Cast("const char*") BytePointer TargetTriple);
public static native LLVMErrorRef LLVMOrcCreateStaticLibrarySearchGeneratorForPath(
    @Cast("LLVMOrcDefinitionGeneratorRef*") PointerPointer Result, LLVMOrcObjectLayerRef ObjLayer,
    String FileName, String TargetTriple);

/**
 * Create a ThreadSafeContext containing a new LLVMContext.
 *
 * Ownership of the underlying ThreadSafeContext data is shared: Clients
 * can and should dispose of their ThreadSafeContext as soon as they no longer
 * need to refer to it directly. Other references (e.g. from ThreadSafeModules)
 * will keep the data alive as long as it is needed.
 */
public static native LLVMOrcThreadSafeContextRef LLVMOrcCreateNewThreadSafeContext();

/**
 * Get a reference to the wrapped LLVMContext.
 */
public static native LLVMContextRef LLVMOrcThreadSafeContextGetContext(LLVMOrcThreadSafeContextRef TSCtx);

/**
 * Dispose of a ThreadSafeContext.
 */
public static native void LLVMOrcDisposeThreadSafeContext(LLVMOrcThreadSafeContextRef TSCtx);

/**
 * Create a ThreadSafeModule wrapper around the given LLVM module. This takes
 * ownership of the M argument which should not be disposed of or referenced
 * after this function returns.
 *
 * Ownership of the ThreadSafeModule is unique: If it is transferred to the JIT
 * (e.g. by LLVMOrcLLJITAddLLVMIRModule) then the client is no longer
 * responsible for it. If it is not transferred to the JIT then the client
 * should call LLVMOrcDisposeThreadSafeModule to dispose of it.
 */
public static native LLVMOrcThreadSafeModuleRef LLVMOrcCreateNewThreadSafeModule(LLVMModuleRef M,
                                 LLVMOrcThreadSafeContextRef TSCtx);

/**
 * Dispose of a ThreadSafeModule. This should only be called if ownership has
 * not been passed to LLJIT (e.g. because some error prevented the client from
 * adding this to the JIT).
 */
public static native void LLVMOrcDisposeThreadSafeModule(LLVMOrcThreadSafeModuleRef TSM);

/**
 * Apply the given function to the module contained in this ThreadSafeModule.
 */
public static native LLVMErrorRef LLVMOrcThreadSafeModuleWithModuleDo(LLVMOrcThreadSafeModuleRef TSM,
                                    LLVMOrcGenericIRModuleOperationFunction F,
                                    Pointer Ctx);

/**
 * Create a JITTargetMachineBuilder by detecting the host.
 *
 * On success the client owns the resulting JITTargetMachineBuilder. It must be
 * passed to a consuming operation (e.g.
 * LLVMOrcLLJITBuilderSetJITTargetMachineBuilder) or disposed of by calling
 * LLVMOrcDisposeJITTargetMachineBuilder.
 */
public static native LLVMErrorRef LLVMOrcJITTargetMachineBuilderDetectHost(
    @ByPtrPtr LLVMOrcJITTargetMachineBuilderRef Result);
public static native LLVMErrorRef LLVMOrcJITTargetMachineBuilderDetectHost(
    @Cast("LLVMOrcJITTargetMachineBuilderRef*") PointerPointer Result);

/**
 * Create a JITTargetMachineBuilder from the given TargetMachine template.
 *
 * This operation takes ownership of the given TargetMachine and destroys it
 * before returing. The resulting JITTargetMachineBuilder is owned by the client
 * and must be passed to a consuming operation (e.g.
 * LLVMOrcLLJITBuilderSetJITTargetMachineBuilder) or disposed of by calling
 * LLVMOrcDisposeJITTargetMachineBuilder.
 */
public static native LLVMOrcJITTargetMachineBuilderRef LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine(LLVMTargetMachineRef TM);

/**
 * Dispose of a JITTargetMachineBuilder.
 */
public static native void LLVMOrcDisposeJITTargetMachineBuilder(
    LLVMOrcJITTargetMachineBuilderRef JTMB);

/**
 * Returns the target triple for the given JITTargetMachineBuilder as a string.
 *
 * The caller owns the resulting string as must dispose of it by calling
 * LLVMDisposeMessage
 */
public static native @Cast("char*") BytePointer LLVMOrcJITTargetMachineBuilderGetTargetTriple(
    LLVMOrcJITTargetMachineBuilderRef JTMB);

/**
 * Sets the target triple for the given JITTargetMachineBuilder to the given
 * string.
 */
public static native void LLVMOrcJITTargetMachineBuilderSetTargetTriple(
    LLVMOrcJITTargetMachineBuilderRef JTMB, @Cast("const char*") BytePointer TargetTriple);
public static native void LLVMOrcJITTargetMachineBuilderSetTargetTriple(
    LLVMOrcJITTargetMachineBuilderRef JTMB, String TargetTriple);

/**
 * Add an object to an ObjectLayer to the given JITDylib.
 *
 * Adds a buffer representing an object file to the given JITDylib using the
 * given ObjectLayer instance. This operation transfers ownership of the buffer
 * to the ObjectLayer instance. The buffer should not be disposed of or
 * referenced once this function returns.
 *
 * Resources associated with the given object will be tracked by the given
 * JITDylib's default ResourceTracker.
 */
public static native LLVMErrorRef LLVMOrcObjectLayerAddObjectFile(LLVMOrcObjectLayerRef ObjLayer,
                                             LLVMOrcJITDylibRef JD,
                                             LLVMMemoryBufferRef ObjBuffer);

/**
 * Add an object to an ObjectLayer using the given ResourceTracker.
 *
 * Adds a buffer representing an object file to the given ResourceTracker's
 * JITDylib using the given ObjectLayer instance. This operation transfers
 * ownership of the buffer to the ObjectLayer instance. The buffer should not
 * be disposed of or referenced once this function returns.
 *
 * Resources associated with the given object will be tracked by
 * ResourceTracker RT.
 */


/**
 * Emit an object buffer to an ObjectLayer.
 *
 * Ownership of the responsibility object and object buffer pass to this
 * function. The client is not responsible for cleanup.
 */
public static native void LLVMOrcObjectLayerEmit(LLVMOrcObjectLayerRef ObjLayer,
                            LLVMOrcMaterializationResponsibilityRef R,
                            LLVMMemoryBufferRef ObjBuffer);

/**
 * Dispose of an ObjectLayer.
 */
public static native void LLVMOrcDisposeObjectLayer(LLVMOrcObjectLayerRef ObjLayer);

public static native void LLVMOrcIRTransformLayerEmit(LLVMOrcIRTransformLayerRef IRTransformLayer,
                                 LLVMOrcMaterializationResponsibilityRef MR,
                                 LLVMOrcThreadSafeModuleRef TSM);

/**
 * Set the transform function of the provided transform layer, passing through a
 * pointer to user provided context.
 */
public static native void LLVMOrcIRTransformLayerSetTransform(
    LLVMOrcIRTransformLayerRef IRTransformLayer,
    LLVMOrcIRTransformLayerTransformFunction TransformFunction, Pointer Ctx);

/**
 * Set the transform function on an LLVMOrcObjectTransformLayer.
 */
public static native void LLVMOrcObjectTransformLayerSetTransform(
    LLVMOrcObjectTransformLayerRef ObjTransformLayer,
    LLVMOrcObjectTransformLayerTransformFunction TransformFunction, Pointer Ctx);

/**
 * Create a LocalIndirectStubsManager from the given target triple.
 *
 * The resulting IndirectStubsManager is owned by the client
 * and must be disposed of by calling LLVMOrcDisposeDisposeIndirectStubsManager.
 */
public static native LLVMOrcIndirectStubsManagerRef LLVMOrcCreateLocalIndirectStubsManager(@Cast("const char*") BytePointer TargetTriple);
public static native LLVMOrcIndirectStubsManagerRef LLVMOrcCreateLocalIndirectStubsManager(String TargetTriple);

/**
 * Dispose of an IndirectStubsManager.
 */
public static native void LLVMOrcDisposeIndirectStubsManager(LLVMOrcIndirectStubsManagerRef ISM);

public static native LLVMErrorRef LLVMOrcCreateLocalLazyCallThroughManager(
    @Cast("const char*") BytePointer TargetTriple, LLVMOrcExecutionSessionRef ES,
    @Cast("LLVMOrcJITTargetAddress") long ErrorHandlerAddr,
    @ByPtrPtr LLVMOrcLazyCallThroughManagerRef LCTM);
public static native LLVMErrorRef LLVMOrcCreateLocalLazyCallThroughManager(
    String TargetTriple, LLVMOrcExecutionSessionRef ES,
    @Cast("LLVMOrcJITTargetAddress") long ErrorHandlerAddr,
    @Cast("LLVMOrcLazyCallThroughManagerRef*") PointerPointer LCTM);

/**
 * Dispose of an LazyCallThroughManager.
 */
public static native void LLVMOrcDisposeLazyCallThroughManager(
    LLVMOrcLazyCallThroughManagerRef LCTM);

/**
 * Create a DumpObjects instance.
 *
 * DumpDir specifies the path to write dumped objects to. DumpDir may be empty
 * in which case files will be dumped to the working directory.
 *
 * IdentifierOverride specifies a file name stem to use when dumping objects.
 * If empty then each MemoryBuffer's identifier will be used (with a .o suffix
 * added if not already present). If an identifier override is supplied it will
 * be used instead, along with an incrementing counter (since all buffers will
 * use the same identifier, the resulting files will be named <ident>.o,
 * <ident>.2.o, <ident>.3.o, and so on). IdentifierOverride should not contain
 * an extension, as a .o suffix will be added by DumpObjects.
 */
public static native LLVMOrcDumpObjectsRef LLVMOrcCreateDumpObjects(@Cast("const char*") BytePointer DumpDir,
                                               @Cast("const char*") BytePointer IdentifierOverride);
public static native LLVMOrcDumpObjectsRef LLVMOrcCreateDumpObjects(String DumpDir,
                                               String IdentifierOverride);

/**
 * Dispose of a DumpObjects instance.
 */
public static native void LLVMOrcDisposeDumpObjects(LLVMOrcDumpObjectsRef DumpObjects);

/**
 * Dump the contents of the given MemoryBuffer.
 */
public static native LLVMErrorRef LLVMOrcDumpObjects_CallOperator(LLVMOrcDumpObjectsRef DumpObjects,
                                             @ByPtrPtr LLVMMemoryBufferRef ObjBuffer);
public static native LLVMErrorRef LLVMOrcDumpObjects_CallOperator(LLVMOrcDumpObjectsRef DumpObjects,
                                             @Cast("LLVMMemoryBufferRef*") PointerPointer ObjBuffer);

/**
 * \}
 */

// #endif /* LLVM_C_ORC_H */


// Parsed from <llvm-c/Remarks.h>

/*===-- llvm-c/Remarks.h - Remarks Public C Interface -------------*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header provides a public interface to a remark diagnostics library.   *|
|* LLVM provides an implementation of this interface.                         *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_REMARKS_H
// #define LLVM_C_REMARKS_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"
// #ifdef __cplusplus
// #include <cstddef>
// #else
// #include <stddef.h>
// #endif /* !defined(__cplusplus) */

/**
 * \defgroup LLVMCREMARKS Remarks
 * \ingroup LLVMC
 *
 * \{
 */

// 0 -> 1: Bitstream remarks support.
public static final int REMARKS_API_VERSION = 1;

/**
 * The type of the emitted remark.
 */
/** enum LLVMRemarkType */
public static final int
  LLVMRemarkTypeUnknown = 0,
  LLVMRemarkTypePassed = 1,
  LLVMRemarkTypeMissed = 2,
  LLVMRemarkTypeAnalysis = 3,
  LLVMRemarkTypeAnalysisFPCommute = 4,
  LLVMRemarkTypeAnalysisAliasing = 5,
  LLVMRemarkTypeFailure = 6;
// Targeting ../LLVM/LLVMRemarkStringRef.java



/**
 * Returns the buffer holding the string.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("const char*") BytePointer LLVMRemarkStringGetData(LLVMRemarkStringRef String);

/**
 * Returns the size of the string.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("uint32_t") int LLVMRemarkStringGetLen(LLVMRemarkStringRef String);
// Targeting ../LLVM/LLVMRemarkDebugLocRef.java



/**
 * Return the path to the source file for a debug location.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkStringRef LLVMRemarkDebugLocGetSourceFilePath(LLVMRemarkDebugLocRef DL);

/**
 * Return the line in the source file for a debug location.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("uint32_t") int LLVMRemarkDebugLocGetSourceLine(LLVMRemarkDebugLocRef DL);

/**
 * Return the column in the source file for a debug location.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("uint32_t") int LLVMRemarkDebugLocGetSourceColumn(LLVMRemarkDebugLocRef DL);
// Targeting ../LLVM/LLVMRemarkArgRef.java



/**
 * Returns the key of an argument. The key defines what the value is, and the
 * same key can appear multiple times in the list of arguments.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkStringRef LLVMRemarkArgGetKey(LLVMRemarkArgRef Arg);

/**
 * Returns the value of an argument. This is a string that can contain newlines.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkStringRef LLVMRemarkArgGetValue(LLVMRemarkArgRef Arg);

/**
 * Returns the debug location that is attached to the value of this argument.
 *
 * If there is no debug location, the return value will be {@code NULL}.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkDebugLocRef LLVMRemarkArgGetDebugLoc(LLVMRemarkArgRef Arg);
// Targeting ../LLVM/LLVMRemarkEntryRef.java



/**
 * Free the resources used by the remark entry.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native void LLVMRemarkEntryDispose(LLVMRemarkEntryRef Remark);

/**
 * The type of the remark. For example, it can allow users to only keep the
 * missed optimizations from the compiler.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("LLVMRemarkType") int LLVMRemarkEntryGetType(LLVMRemarkEntryRef Remark);

/**
 * Get the name of the pass that emitted this remark.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkStringRef LLVMRemarkEntryGetPassName(LLVMRemarkEntryRef Remark);

/**
 * Get an identifier of the remark.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkStringRef LLVMRemarkEntryGetRemarkName(LLVMRemarkEntryRef Remark);

/**
 * Get the name of the function being processed when the remark was emitted.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkStringRef LLVMRemarkEntryGetFunctionName(LLVMRemarkEntryRef Remark);

/**
 * Returns the debug location that is attached to this remark.
 *
 * If there is no debug location, the return value will be {@code NULL}.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkDebugLocRef LLVMRemarkEntryGetDebugLoc(LLVMRemarkEntryRef Remark);

/**
 * Return the hotness of the remark.
 *
 * A hotness of {@code 0} means this value is not set.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("uint64_t") long LLVMRemarkEntryGetHotness(LLVMRemarkEntryRef Remark);

/**
 * The number of arguments the remark holds.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("uint32_t") int LLVMRemarkEntryGetNumArgs(LLVMRemarkEntryRef Remark);

/**
 * Get a new iterator to iterate over a remark's argument.
 *
 * If there are no arguments in \p Remark, the return value will be {@code NULL}.
 *
 * The lifetime of the returned value is bound to the lifetime of \p Remark.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkArgRef LLVMRemarkEntryGetFirstArg(LLVMRemarkEntryRef Remark);

/**
 * Get the next argument in \p Remark from the position of \p It.
 *
 * Returns {@code NULL} if there are no more arguments available.
 *
 * The lifetime of the returned value is bound to the lifetime of \p Remark.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkArgRef LLVMRemarkEntryGetNextArg(LLVMRemarkArgRef It,
                                                  LLVMRemarkEntryRef Remark);
// Targeting ../LLVM/LLVMRemarkParserRef.java



/**
 * Creates a remark parser that can be used to parse the buffer located in \p
 * Buf of size \p Size bytes.
 *
 * \p Buf cannot be {@code NULL}.
 *
 * This function should be paired with LLVMRemarkParserDispose() to avoid
 * leaking resources.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkParserRef LLVMRemarkParserCreateYAML(@Const Pointer Buf,
                                                      @Cast("uint64_t") long Size);

/**
 * Creates a remark parser that can be used to parse the buffer located in \p
 * Buf of size \p Size bytes.
 *
 * \p Buf cannot be {@code NULL}.
 *
 * This function should be paired with LLVMRemarkParserDispose() to avoid
 * leaking resources.
 *
 * @since REMARKS_API_VERSION=1
 */
public static native LLVMRemarkParserRef LLVMRemarkParserCreateBitstream(@Const Pointer Buf,
                                                           @Cast("uint64_t") long Size);

/**
 * Returns the next remark in the file.
 *
 * The value pointed to by the return value needs to be disposed using a call to
 * LLVMRemarkEntryDispose().
 *
 * All the entries in the returned value that are of LLVMRemarkStringRef type
 * will become invalidated once a call to LLVMRemarkParserDispose is made.
 *
 * If the parser reaches the end of the buffer, the return value will be {@code NULL}.
 *
 * In the case of an error, the return value will be {@code NULL}, and:
 *
 * 1) LLVMRemarkParserHasError() will return {@code 1}.
 *
 * 2) LLVMRemarkParserGetErrorMessage() will return a descriptive error
 *    message.
 *
 * An error may occur if:
 *
 * 1) An argument is invalid.
 *
 * 2) There is a parsing error. This can occur on things like malformed YAML.
 *
 * 3) There is a Remark semantic error. This can occur on well-formed files with
 *    missing or extra fields.
 *
 * Here is a quick example of the usage:
 *
 * <pre>{@code
 * LLVMRemarkParserRef Parser = LLVMRemarkParserCreateYAML(Buf, Size);
 * LLVMRemarkEntryRef Remark = NULL;
 * while ((Remark = LLVMRemarkParserGetNext(Parser))) {
 *    // use Remark
 *    LLVMRemarkEntryDispose(Remark); // Release memory.
 * }
 * bool HasError = LLVMRemarkParserHasError(Parser);
 * LLVMRemarkParserDispose(Parser);
 * }</pre>
 *
 * @since REMARKS_API_VERSION=0
 */
public static native LLVMRemarkEntryRef LLVMRemarkParserGetNext(LLVMRemarkParserRef Parser);

/**
 * Returns {@code 1} if the parser encountered an error while parsing the buffer.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("LLVMBool") int LLVMRemarkParserHasError(LLVMRemarkParserRef Parser);

/**
 * Returns a null-terminated string containing an error message.
 *
 * In case of no error, the result is {@code NULL}.
 *
 * The memory of the string is bound to the lifetime of \p Parser. If
 * LLVMRemarkParserDispose() is called, the memory of the string will be
 * released.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("const char*") BytePointer LLVMRemarkParserGetErrorMessage(LLVMRemarkParserRef Parser);

/**
 * Releases all the resources used by \p Parser.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native void LLVMRemarkParserDispose(LLVMRemarkParserRef Parser);

/**
 * Returns the version of the remarks library.
 *
 * @since REMARKS_API_VERSION=0
 */
public static native @Cast("uint32_t") int LLVMRemarkVersion();

/**
 * \} // endgoup LLVMCREMARKS
 */

// #endif /* LLVM_C_REMARKS_H */


// Parsed from <llvm-c/OrcEE.h>

/*===-- llvm-c/OrcEE.h - OrcV2 C bindings ExecutionEngine utils -*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to ExecutionEngine based utils, e.g.  *|
|* RTDyldObjectLinkingLayer (based on RuntimeDyld) in Orc.                    *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
|* Note: This interface is experimental. It is *NOT* stable, and may be       *|
|*       changed without warning. Only C API usage documentation is           *|
|*       provided. See the C++ documentation for all higher level ORC API     *|
|*       details.                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_ORCEE_H
// #define LLVM_C_ORCEE_H

// #include "llvm-c/Error.h"
// #include "llvm-c/ExecutionEngine.h"
// #include "llvm-c/Orc.h"
// #include "llvm-c/TargetMachine.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCExecutionEngineORCEE ExecutionEngine-based ORC Utils
 * \ingroup LLVMCExecutionEngine
 *
 * \{
 */

/**
 * Create a RTDyldObjectLinkingLayer instance using the standard
 * SectionMemoryManager for memory management.
 */
public static native LLVMOrcObjectLayerRef LLVMOrcCreateRTDyldObjectLinkingLayerWithSectionMemoryManager(
    LLVMOrcExecutionSessionRef ES);

/**
 * Add the given listener to the given RTDyldObjectLinkingLayer.
 *
 * Note: Layer must be an RTDyldObjectLinkingLayer instance or
 * behavior is undefined.
 */
public static native void LLVMOrcRTDyldObjectLinkingLayerRegisterJITEventListener(
    LLVMOrcObjectLayerRef RTDyldObjLinkingLayer,
    LLVMJITEventListenerRef Listener);

/**
 * \}
 */

// #endif /* LLVM_C_ORCEE_H */


// Parsed from <llvm-c/LLJIT.h>

/*===----------- llvm-c/LLJIT.h - OrcV2 LLJIT C bindings --------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to the LLJIT class in                 *|
|* libLLVMOrcJIT.a, which provides a simple MCJIT-like ORC JIT.               *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
|* Note: This interface is experimental. It is *NOT* stable, and may be       *|
|*       changed without warning. Only C API usage documentation is           *|
|*       provided. See the C++ documentation for all higher level ORC API     *|
|*       details.                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_LLJIT_H
// #define LLVM_C_LLJIT_H

// #include "llvm-c/Error.h"
// #include "llvm-c/Orc.h"
// #include "llvm-c/TargetMachine.h"
// #include "llvm-c/Types.h"
// Targeting ../LLVM/LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunction.java


// Targeting ../LLVM/LLVMOrcLLJITBuilderRef.java


// Targeting ../LLVM/LLVMOrcLLJITRef.java



/**
 * Create an LLVMOrcLLJITBuilder.
 *
 * The client owns the resulting LLJITBuilder and should dispose of it using
 * LLVMOrcDisposeLLJITBuilder once they are done with it.
 */
public static native LLVMOrcLLJITBuilderRef LLVMOrcCreateLLJITBuilder();

/**
 * Dispose of an LLVMOrcLLJITBuilderRef. This should only be called if ownership
 * has not been passed to LLVMOrcCreateLLJIT (e.g. because some error prevented
 * that function from being called).
 */
public static native void LLVMOrcDisposeLLJITBuilder(LLVMOrcLLJITBuilderRef Builder);

/**
 * Set the JITTargetMachineBuilder to be used when constructing the LLJIT
 * instance. Calling this function is optional: if it is not called then the
 * LLJITBuilder will use JITTargeTMachineBuilder::detectHost to construct a
 * JITTargetMachineBuilder.
 *
 * This function takes ownership of the JTMB argument: clients should not
 * dispose of the JITTargetMachineBuilder after calling this function.
 */
public static native void LLVMOrcLLJITBuilderSetJITTargetMachineBuilder(
    LLVMOrcLLJITBuilderRef Builder, LLVMOrcJITTargetMachineBuilderRef JTMB);

/**
 * Set an ObjectLinkingLayer creator function for this LLJIT instance.
 */
public static native void LLVMOrcLLJITBuilderSetObjectLinkingLayerCreator(
    LLVMOrcLLJITBuilderRef Builder,
    LLVMOrcLLJITBuilderObjectLinkingLayerCreatorFunction F, Pointer Ctx);

/**
 * Create an LLJIT instance from an LLJITBuilder.
 *
 * This operation takes ownership of the Builder argument: clients should not
 * dispose of the builder after calling this function (even if the function
 * returns an error). If a null Builder argument is provided then a
 * default-constructed LLJITBuilder will be used.
 *
 * On success the resulting LLJIT instance is uniquely owned by the client and
 * automatically manages the memory of all JIT'd code and all modules that are
 * transferred to it (e.g. via LLVMOrcLLJITAddLLVMIRModule). Disposing of the
 * LLJIT instance will free all memory managed by the JIT, including JIT'd code
 * and not-yet compiled modules.
 */
public static native LLVMErrorRef LLVMOrcCreateLLJIT(@ByPtrPtr LLVMOrcLLJITRef Result,
                                LLVMOrcLLJITBuilderRef Builder);
public static native LLVMErrorRef LLVMOrcCreateLLJIT(@Cast("LLVMOrcLLJITRef*") PointerPointer Result,
                                LLVMOrcLLJITBuilderRef Builder);

/**
 * Dispose of an LLJIT instance.
 */
public static native LLVMErrorRef LLVMOrcDisposeLLJIT(LLVMOrcLLJITRef J);

/**
 * Get a reference to the ExecutionSession for this LLJIT instance.
 *
 * The ExecutionSession is owned by the LLJIT instance. The client is not
 * responsible for managing its memory.
 */
public static native LLVMOrcExecutionSessionRef LLVMOrcLLJITGetExecutionSession(LLVMOrcLLJITRef J);

/**
 * Return a reference to the Main JITDylib.
 *
 * The JITDylib is owned by the LLJIT instance. The client is not responsible
 * for managing its memory.
 */
public static native LLVMOrcJITDylibRef LLVMOrcLLJITGetMainJITDylib(LLVMOrcLLJITRef J);

/**
 * Return the target triple for this LLJIT instance. This string is owned by
 * the LLJIT instance and should not be freed by the client.
 */
public static native @Cast("const char*") BytePointer LLVMOrcLLJITGetTripleString(LLVMOrcLLJITRef J);

/**
 * Returns the global prefix character according to the LLJIT's DataLayout.
 */
public static native @Cast("char") byte LLVMOrcLLJITGetGlobalPrefix(LLVMOrcLLJITRef J);

/**
 * Mangles the given string according to the LLJIT instance's DataLayout, then
 * interns the result in the SymbolStringPool and returns a reference to the
 * pool entry. Clients should call LLVMOrcReleaseSymbolStringPoolEntry to
 * decrement the ref-count on the pool entry once they are finished with this
 * value.
 */
public static native LLVMOrcSymbolStringPoolEntryRef LLVMOrcLLJITMangleAndIntern(LLVMOrcLLJITRef J, @Cast("const char*") BytePointer UnmangledName);
public static native LLVMOrcSymbolStringPoolEntryRef LLVMOrcLLJITMangleAndIntern(LLVMOrcLLJITRef J, String UnmangledName);

/**
 * Add a buffer representing an object file to the given JITDylib in the given
 * LLJIT instance. This operation transfers ownership of the buffer to the
 * LLJIT instance. The buffer should not be disposed of or referenced once this
 * function returns.
 *
 * Resources associated with the given object will be tracked by the given
 * JITDylib's default resource tracker.
 */
public static native LLVMErrorRef LLVMOrcLLJITAddObjectFile(LLVMOrcLLJITRef J, LLVMOrcJITDylibRef JD,
                                       LLVMMemoryBufferRef ObjBuffer);

/**
 * Add a buffer representing an object file to the given ResourceTracker's
 * JITDylib in the given LLJIT instance. This operation transfers ownership of
 * the buffer to the LLJIT instance. The buffer should not be disposed of or
 * referenced once this function returns.
 *
 * Resources associated with the given object will be tracked by ResourceTracker
 * RT.
 */
public static native LLVMErrorRef LLVMOrcLLJITAddObjectFileWithRT(LLVMOrcLLJITRef J,
                                             LLVMOrcResourceTrackerRef RT,
                                             LLVMMemoryBufferRef ObjBuffer);

/**
 * Add an IR module to the given JITDylib in the given LLJIT instance. This
 * operation transfers ownership of the TSM argument to the LLJIT instance.
 * The TSM argument should not be disposed of or referenced once this
 * function returns.
 *
 * Resources associated with the given Module will be tracked by the given
 * JITDylib's default resource tracker.
 */
public static native LLVMErrorRef LLVMOrcLLJITAddLLVMIRModule(LLVMOrcLLJITRef J,
                                         LLVMOrcJITDylibRef JD,
                                         LLVMOrcThreadSafeModuleRef TSM);

/**
 * Add an IR module to the given ResourceTracker's JITDylib in the given LLJIT
 * instance. This operation transfers ownership of the TSM argument to the LLJIT
 * instance. The TSM argument should not be disposed of or referenced once this
 * function returns.
 *
 * Resources associated with the given Module will be tracked by ResourceTracker
 * RT.
 */
public static native LLVMErrorRef LLVMOrcLLJITAddLLVMIRModuleWithRT(LLVMOrcLLJITRef J,
                                               LLVMOrcResourceTrackerRef JD,
                                               LLVMOrcThreadSafeModuleRef TSM);

/**
 * Look up the given symbol in the main JITDylib of the given LLJIT instance.
 *
 * This operation does not take ownership of the Name argument.
 */
public static native LLVMErrorRef LLVMOrcLLJITLookup(LLVMOrcLLJITRef J,
                                @Cast("LLVMOrcExecutorAddress*") LongPointer Result,
                                @Cast("const char*") BytePointer Name);
public static native LLVMErrorRef LLVMOrcLLJITLookup(LLVMOrcLLJITRef J,
                                @Cast("LLVMOrcExecutorAddress*") LongBuffer Result,
                                String Name);
public static native LLVMErrorRef LLVMOrcLLJITLookup(LLVMOrcLLJITRef J,
                                @Cast("LLVMOrcExecutorAddress*") long[] Result,
                                @Cast("const char*") BytePointer Name);
public static native LLVMErrorRef LLVMOrcLLJITLookup(LLVMOrcLLJITRef J,
                                @Cast("LLVMOrcExecutorAddress*") LongPointer Result,
                                String Name);
public static native LLVMErrorRef LLVMOrcLLJITLookup(LLVMOrcLLJITRef J,
                                @Cast("LLVMOrcExecutorAddress*") LongBuffer Result,
                                @Cast("const char*") BytePointer Name);
public static native LLVMErrorRef LLVMOrcLLJITLookup(LLVMOrcLLJITRef J,
                                @Cast("LLVMOrcExecutorAddress*") long[] Result,
                                String Name);

/**
 * Returns a non-owning reference to the LLJIT instance's object linking layer.
 */
public static native LLVMOrcObjectLayerRef LLVMOrcLLJITGetObjLinkingLayer(LLVMOrcLLJITRef J);

/**
 * Returns a non-owning reference to the LLJIT instance's object linking layer.
 */
public static native LLVMOrcObjectTransformLayerRef LLVMOrcLLJITGetObjTransformLayer(LLVMOrcLLJITRef J);

/**
 * Returns a non-owning reference to the LLJIT instance's IR transform layer.
 */
public static native LLVMOrcIRTransformLayerRef LLVMOrcLLJITGetIRTransformLayer(LLVMOrcLLJITRef J);

/**
 * Get the LLJIT instance's default data layout string.
 *
 * This string is owned by the LLJIT instance and does not need to be freed
 * by the caller.
 */
public static native @Cast("const char*") BytePointer LLVMOrcLLJITGetDataLayoutStr(LLVMOrcLLJITRef J);

/**
 * \}
 */

// #endif /* LLVM_C_LLJIT_H */


// Parsed from <llvm-c/Transforms/AggressiveInstCombine.h>

/*===-- AggressiveInstCombine.h ---------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMAggressiveInstCombine.a,    *|
|* which combines instructions to form fewer, simple IR instructions.         *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_AGGRESSIVEINSTCOMBINE_H
// #define LLVM_C_TRANSFORMS_AGGRESSIVEINSTCOMBINE_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCTransformsAggressiveInstCombine Aggressive Instruction Combining transformations
 * \ingroup LLVMCTransforms
 *
 * \{
 */

/** See llvm::createAggressiveInstCombinerPass function. */
public static native void LLVMAddAggressiveInstCombinerPass(LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif



// Parsed from <llvm-c/Transforms/InstCombine.h>

/*===-- Scalar.h - Scalar Transformation Library C Interface ----*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMInstCombine.a, which        *|
|* combines instructions to form fewer, simple IR instructions.               *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_INSTCOMBINE_H
// #define LLVM_C_TRANSFORMS_INSTCOMBINE_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCTransformsInstCombine Instruction Combining transformations
 * \ingroup LLVMCTransforms
 *
 * \{
 */

/** See llvm::createInstructionCombiningPass function. */
public static native void LLVMAddInstructionCombiningPass(LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif



// Parsed from <llvm-c/Transforms/IPO.h>

/*===-- IPO.h - Interprocedural Transformations C Interface -----*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMIPO.a, which implements     *|
|* various interprocedural transformations of the LLVM IR.                    *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_IPO_H
// #define LLVM_C_TRANSFORMS_IPO_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCTransformsIPO Interprocedural transformations
 * \ingroup LLVMCTransforms
 *
 * \{
 */

/** See llvm::createConstantMergePass function. */
public static native void LLVMAddConstantMergePass(LLVMPassManagerRef PM);

/** See llvm::createMergeFunctionsPass function. */
public static native void LLVMAddMergeFunctionsPass(LLVMPassManagerRef PM);

/** See llvm::createCalledValuePropagationPass function. */
public static native void LLVMAddCalledValuePropagationPass(LLVMPassManagerRef PM);

/** See llvm::createDeadArgEliminationPass function. */
public static native void LLVMAddDeadArgEliminationPass(LLVMPassManagerRef PM);

/** See llvm::createFunctionAttrsPass function. */
public static native void LLVMAddFunctionAttrsPass(LLVMPassManagerRef PM);

/** See llvm::createFunctionInliningPass function. */
public static native void LLVMAddFunctionInliningPass(LLVMPassManagerRef PM);

/** See llvm::createAlwaysInlinerPass function. */
public static native void LLVMAddAlwaysInlinerPass(LLVMPassManagerRef PM);

/** See llvm::createGlobalDCEPass function. */
public static native void LLVMAddGlobalDCEPass(LLVMPassManagerRef PM);

/** See llvm::createGlobalOptimizerPass function. */
public static native void LLVMAddGlobalOptimizerPass(LLVMPassManagerRef PM);

/** See llvm::createPruneEHPass function. */
public static native void LLVMAddPruneEHPass(LLVMPassManagerRef PM);

/** See llvm::createIPSCCPPass function. */
public static native void LLVMAddIPSCCPPass(LLVMPassManagerRef PM);

/** See llvm::createInternalizePass function. */
public static native void LLVMAddInternalizePass(LLVMPassManagerRef arg0, @Cast("unsigned") int AllButMain);
// Targeting ../LLVM/MustPreserve_LLVMValueRef_Pointer.java


public static native void LLVMAddInternalizePassWithMustPreservePredicate(
    LLVMPassManagerRef PM,
    Pointer Context,
    MustPreserve_LLVMValueRef_Pointer MustPreserve);

/** See llvm::createStripDeadPrototypesPass function. */
public static native void LLVMAddStripDeadPrototypesPass(LLVMPassManagerRef PM);

/** See llvm::createStripSymbolsPass function. */
public static native void LLVMAddStripSymbolsPass(LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Transforms/PassManagerBuilder.h>

/*===-- llvm-c/Transform/PassManagerBuilder.h - PMB C Interface ---*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to the PassManagerBuilder class.      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_PASSMANAGERBUILDER_H
// #define LLVM_C_TRANSFORMS_PASSMANAGERBUILDER_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"
// Targeting ../LLVM/LLVMPassManagerBuilderRef.java



/**
 * \defgroup LLVMCTransformsPassManagerBuilder Pass manager builder
 * \ingroup LLVMCTransforms
 *
 * \{
 */

/** See llvm::PassManagerBuilder. */
public static native LLVMPassManagerBuilderRef LLVMPassManagerBuilderCreate();
public static native void LLVMPassManagerBuilderDispose(LLVMPassManagerBuilderRef PMB);

/** See llvm::PassManagerBuilder::OptLevel. */
public static native void LLVMPassManagerBuilderSetOptLevel(LLVMPassManagerBuilderRef PMB,
                                  @Cast("unsigned") int OptLevel);

/** See llvm::PassManagerBuilder::SizeLevel. */
public static native void LLVMPassManagerBuilderSetSizeLevel(LLVMPassManagerBuilderRef PMB,
                                   @Cast("unsigned") int SizeLevel);

/** See llvm::PassManagerBuilder::DisableUnitAtATime. */
public static native void LLVMPassManagerBuilderSetDisableUnitAtATime(LLVMPassManagerBuilderRef PMB,
                                            @Cast("LLVMBool") int Value);

/** See llvm::PassManagerBuilder::DisableUnrollLoops. */
public static native void LLVMPassManagerBuilderSetDisableUnrollLoops(LLVMPassManagerBuilderRef PMB,
                                            @Cast("LLVMBool") int Value);

/** See llvm::PassManagerBuilder::DisableSimplifyLibCalls */
public static native void LLVMPassManagerBuilderSetDisableSimplifyLibCalls(LLVMPassManagerBuilderRef PMB,
                                                 @Cast("LLVMBool") int Value);

/** See llvm::PassManagerBuilder::Inliner. */
public static native void LLVMPassManagerBuilderUseInlinerWithThreshold(LLVMPassManagerBuilderRef PMB,
                                              @Cast("unsigned") int Threshold);

/** See llvm::PassManagerBuilder::populateFunctionPassManager. */
public static native void LLVMPassManagerBuilderPopulateFunctionPassManager(LLVMPassManagerBuilderRef PMB,
                                                  LLVMPassManagerRef PM);

/** See llvm::PassManagerBuilder::populateModulePassManager. */
public static native void LLVMPassManagerBuilderPopulateModulePassManager(LLVMPassManagerBuilderRef PMB,
                                                LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Transforms/Scalar.h>

/*===-- Scalar.h - Scalar Transformation Library C Interface ----*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMScalarOpts.a, which         *|
|* implements various scalar transformations of the LLVM IR.                  *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_SCALAR_H
// #define LLVM_C_TRANSFORMS_SCALAR_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCTransformsScalar Scalar transformations
 * \ingroup LLVMCTransforms
 *
 * \{
 */

/** See llvm::createAggressiveDCEPass function. */
public static native void LLVMAddAggressiveDCEPass(LLVMPassManagerRef PM);

/** See llvm::createDeadCodeEliminationPass function. */
public static native void LLVMAddDCEPass(LLVMPassManagerRef PM);

/** See llvm::createBitTrackingDCEPass function. */
public static native void LLVMAddBitTrackingDCEPass(LLVMPassManagerRef PM);

/** See llvm::createAlignmentFromAssumptionsPass function. */
public static native void LLVMAddAlignmentFromAssumptionsPass(LLVMPassManagerRef PM);

/** See llvm::createCFGSimplificationPass function. */
public static native void LLVMAddCFGSimplificationPass(LLVMPassManagerRef PM);

/** See llvm::createDeadStoreEliminationPass function. */
public static native void LLVMAddDeadStoreEliminationPass(LLVMPassManagerRef PM);

/** See llvm::createScalarizerPass function. */
public static native void LLVMAddScalarizerPass(LLVMPassManagerRef PM);

/** See llvm::createMergedLoadStoreMotionPass function. */
public static native void LLVMAddMergedLoadStoreMotionPass(LLVMPassManagerRef PM);

/** See llvm::createGVNPass function. */
public static native void LLVMAddGVNPass(LLVMPassManagerRef PM);

/** See llvm::createGVNPass function. */
public static native void LLVMAddNewGVNPass(LLVMPassManagerRef PM);

/** See llvm::createIndVarSimplifyPass function. */
public static native void LLVMAddIndVarSimplifyPass(LLVMPassManagerRef PM);

/** See llvm::createInstructionCombiningPass function. */

/** See llvm::createInstSimplifyLegacyPass function. */
public static native void LLVMAddInstructionSimplifyPass(LLVMPassManagerRef PM);

/** See llvm::createJumpThreadingPass function. */
public static native void LLVMAddJumpThreadingPass(LLVMPassManagerRef PM);

/** See llvm::createLICMPass function. */
public static native void LLVMAddLICMPass(LLVMPassManagerRef PM);

/** See llvm::createLoopDeletionPass function. */
public static native void LLVMAddLoopDeletionPass(LLVMPassManagerRef PM);

/** See llvm::createLoopIdiomPass function */
public static native void LLVMAddLoopIdiomPass(LLVMPassManagerRef PM);

/** See llvm::createLoopRotatePass function. */
public static native void LLVMAddLoopRotatePass(LLVMPassManagerRef PM);

/** See llvm::createLoopRerollPass function. */
public static native void LLVMAddLoopRerollPass(LLVMPassManagerRef PM);

/** See llvm::createLoopUnrollPass function. */
public static native void LLVMAddLoopUnrollPass(LLVMPassManagerRef PM);

/** See llvm::createLoopUnrollAndJamPass function. */
public static native void LLVMAddLoopUnrollAndJamPass(LLVMPassManagerRef PM);

/** See llvm::createLowerAtomicPass function. */
public static native void LLVMAddLowerAtomicPass(LLVMPassManagerRef PM);

/** See llvm::createMemCpyOptPass function. */
public static native void LLVMAddMemCpyOptPass(LLVMPassManagerRef PM);

/** See llvm::createPartiallyInlineLibCallsPass function. */
public static native void LLVMAddPartiallyInlineLibCallsPass(LLVMPassManagerRef PM);

/** See llvm::createReassociatePass function. */
public static native void LLVMAddReassociatePass(LLVMPassManagerRef PM);

/** See llvm::createSCCPPass function. */
public static native void LLVMAddSCCPPass(LLVMPassManagerRef PM);

/** See llvm::createSROAPass function. */
public static native void LLVMAddScalarReplAggregatesPass(LLVMPassManagerRef PM);

/** See llvm::createSROAPass function. */
public static native void LLVMAddScalarReplAggregatesPassSSA(LLVMPassManagerRef PM);

/** See llvm::createSROAPass function. */
public static native void LLVMAddScalarReplAggregatesPassWithThreshold(LLVMPassManagerRef PM,
                                                  int Threshold);

/** See llvm::createSimplifyLibCallsPass function. */
public static native void LLVMAddSimplifyLibCallsPass(LLVMPassManagerRef PM);

/** See llvm::createTailCallEliminationPass function. */
public static native void LLVMAddTailCallEliminationPass(LLVMPassManagerRef PM);

/** See llvm::demotePromoteMemoryToRegisterPass function. */
public static native void LLVMAddDemoteMemoryToRegisterPass(LLVMPassManagerRef PM);

/** See llvm::createVerifierPass function. */
public static native void LLVMAddVerifierPass(LLVMPassManagerRef PM);

/** See llvm::createCorrelatedValuePropagationPass function */
public static native void LLVMAddCorrelatedValuePropagationPass(LLVMPassManagerRef PM);

/** See llvm::createEarlyCSEPass function */
public static native void LLVMAddEarlyCSEPass(LLVMPassManagerRef PM);

/** See llvm::createEarlyCSEPass function */
public static native void LLVMAddEarlyCSEMemSSAPass(LLVMPassManagerRef PM);

/** See llvm::createLowerExpectIntrinsicPass function */
public static native void LLVMAddLowerExpectIntrinsicPass(LLVMPassManagerRef PM);

/** See llvm::createLowerConstantIntrinsicsPass function */
public static native void LLVMAddLowerConstantIntrinsicsPass(LLVMPassManagerRef PM);

/** See llvm::createTypeBasedAliasAnalysisPass function */
public static native void LLVMAddTypeBasedAliasAnalysisPass(LLVMPassManagerRef PM);

/** See llvm::createScopedNoAliasAAPass function */
public static native void LLVMAddScopedNoAliasAAPass(LLVMPassManagerRef PM);

/** See llvm::createBasicAliasAnalysisPass function */
public static native void LLVMAddBasicAliasAnalysisPass(LLVMPassManagerRef PM);

/** See llvm::createUnifyFunctionExitNodesPass function */
public static native void LLVMAddUnifyFunctionExitNodesPass(LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Transforms/Utils.h>

/*===-- Utils.h - Transformation Utils Library C Interface ------*- C++ -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMTransformUtils.a, which     *|
|* implements various transformation utilities of the LLVM IR.                *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_UTILS_H
// #define LLVM_C_TRANSFORMS_UTILS_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCTransformsUtils Transformation Utilities
 * \ingroup LLVMCTransforms
 *
 * \{
 */

/** See llvm::createLowerSwitchPass function. */
public static native void LLVMAddLowerSwitchPass(LLVMPassManagerRef PM);

/** See llvm::createPromoteMemoryToRegisterPass function. */
public static native void LLVMAddPromoteMemoryToRegisterPass(LLVMPassManagerRef PM);

/** See llvm::createAddDiscriminatorsPass function. */
public static native void LLVMAddAddDiscriminatorsPass(LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif



// Parsed from <llvm-c/Transforms/Vectorize.h>

/*===---------------------------Vectorize.h --------------------- -*- C -*-===*\
|*===----------- Vectorization Transformation Library C Interface ---------===*|
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header declares the C interface to libLLVMVectorize.a, which          *|
|* implements various vectorization transformations of the LLVM IR.           *|
|*                                                                            *|
|* Many exotic languages can interoperate with C code but have a harder time  *|
|* with C++ due to name mangling. So in addition to C, this interface enables *|
|* tools written in such languages.                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_VECTORIZE_H
// #define LLVM_C_TRANSFORMS_VECTORIZE_H

// #include "llvm-c/ExternC.h"
// #include "llvm-c/Types.h"

/**
 * \defgroup LLVMCTransformsVectorize Vectorization transformations
 * \ingroup LLVMCTransforms
 *
 * \{
 */

/** See llvm::createLoopVectorizePass function. */
public static native void LLVMAddLoopVectorizePass(LLVMPassManagerRef PM);

/** See llvm::createSLPVectorizerPass function. */
public static native void LLVMAddSLPVectorizePass(LLVMPassManagerRef PM);

/**
 * \}
 */

// #endif


// Parsed from <llvm-c/Transforms/PassBuilder.h>

/*===-- llvm-c/Transform/PassBuilder.h - PassBuilder for LLVM C ---*- C -*-===*\
|*                                                                            *|
|* Part of the LLVM Project, under the Apache License v2.0 with LLVM          *|
|* Exceptions.                                                                *|
|* See https://llvm.org/LICENSE.txt for license information.                  *|
|* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    *|
|*                                                                            *|
|*===----------------------------------------------------------------------===*|
|*                                                                            *|
|* This header contains the LLVM-C interface into the new pass manager        *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// #ifndef LLVM_C_TRANSFORMS_PASSBUILDER_H
// #define LLVM_C_TRANSFORMS_PASSBUILDER_H

// #include "llvm-c/Error.h"
// #include "llvm-c/TargetMachine.h"
// #include "llvm-c/Types.h"
// Targeting ../LLVM/LLVMPassBuilderOptionsRef.java



/**
 * Construct and run a set of passes over a module
 *
 * This function takes a string with the passes that should be used. The format
 * of this string is the same as opt's -passes argument for the new pass
 * manager. Individual passes may be specified, separated by commas. Full
 * pipelines may also be invoked using {@code default<O3>} and friends. See opt for
 * full reference of the Passes format.
 */
public static native LLVMErrorRef LLVMRunPasses(LLVMModuleRef M, @Cast("const char*") BytePointer Passes,
                           LLVMTargetMachineRef TM,
                           LLVMPassBuilderOptionsRef Options);
public static native LLVMErrorRef LLVMRunPasses(LLVMModuleRef M, String Passes,
                           LLVMTargetMachineRef TM,
                           LLVMPassBuilderOptionsRef Options);

/**
 * Create a new set of options for a PassBuilder
 *
 * Ownership of the returned instance is given to the client, and they are
 * responsible for it. The client should call LLVMDisposePassBuilderOptions
 * to free the pass builder options.
 */
public static native LLVMPassBuilderOptionsRef LLVMCreatePassBuilderOptions();

/**
 * Toggle adding the VerifierPass for the PassBuilder, ensuring all functions
 * inside the module is valid.
 */
public static native void LLVMPassBuilderOptionsSetVerifyEach(LLVMPassBuilderOptionsRef Options,
                                         @Cast("LLVMBool") int VerifyEach);

/**
 * Toggle debug logging when running the PassBuilder
 */
public static native void LLVMPassBuilderOptionsSetDebugLogging(LLVMPassBuilderOptionsRef Options,
                                           @Cast("LLVMBool") int DebugLogging);

public static native void LLVMPassBuilderOptionsSetLoopInterleaving(
    LLVMPassBuilderOptionsRef Options, @Cast("LLVMBool") int LoopInterleaving);

public static native void LLVMPassBuilderOptionsSetLoopVectorization(
    LLVMPassBuilderOptionsRef Options, @Cast("LLVMBool") int LoopVectorization);

public static native void LLVMPassBuilderOptionsSetSLPVectorization(
    LLVMPassBuilderOptionsRef Options, @Cast("LLVMBool") int SLPVectorization);

public static native void LLVMPassBuilderOptionsSetLoopUnrolling(LLVMPassBuilderOptionsRef Options,
                                            @Cast("LLVMBool") int LoopUnrolling);

public static native void LLVMPassBuilderOptionsSetForgetAllSCEVInLoopUnroll(
    LLVMPassBuilderOptionsRef Options, @Cast("LLVMBool") int ForgetAllSCEVInLoopUnroll);

public static native void LLVMPassBuilderOptionsSetLicmMssaOptCap(LLVMPassBuilderOptionsRef Options,
                                             @Cast("unsigned") int LicmMssaOptCap);

public static native void LLVMPassBuilderOptionsSetLicmMssaNoAccForPromotionCap(
    LLVMPassBuilderOptionsRef Options, @Cast("unsigned") int LicmMssaNoAccForPromotionCap);

public static native void LLVMPassBuilderOptionsSetCallGraphProfile(
    LLVMPassBuilderOptionsRef Options, @Cast("LLVMBool") int CallGraphProfile);

public static native void LLVMPassBuilderOptionsSetMergeFunctions(LLVMPassBuilderOptionsRef Options,
                                             @Cast("LLVMBool") int MergeFunctions);

/**
 * Dispose of a heap-allocated PassBuilderOptions instance
 */
public static native void LLVMDisposePassBuilderOptions(LLVMPassBuilderOptionsRef Options);

/**
 * \}
 */

// #endif // LLVM_C_TRANSFORMS_PASSBUILDER_H


// Parsed from <polly/LinkAllPasses.h>

//===- polly/LinkAllPasses.h ----------- Reference All Passes ---*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// This header file pulls in all transformation and analysis passes for tools
// like opt and bugpoint that need this functionality.
//
//===----------------------------------------------------------------------===//

// #ifndef POLLY_LINKALLPASSES_H
// #define POLLY_LINKALLPASSES_H

// #include "polly/CodeGen/PPCGCodeGeneration.h"
// #include "polly/Config/config.h"
// #include "polly/Support/DumpFunctionPass.h"
// #include "polly/Support/DumpModulePass.h"
// #include "llvm/ADT/StringRef.h"
// #include <cstdlib>
// Targeting ../LLVM/Pass.java


// Targeting ../LLVM/PassRegistry.java


 // namespace llvm
@Namespace("polly") public static native Pass createCodePreparationPass();
@Namespace("polly") public static native Pass createScopInlinerPass();
@Namespace("polly") public static native Pass createDeadCodeElimWrapperPass();
@Namespace("polly") public static native Pass createDependenceInfoPass();
@Namespace("polly") public static native Pass createDependenceInfoPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createDependenceInfoWrapperPassPass();
@Namespace("polly") public static native Pass createDependenceInfoPrinterLegacyFunctionPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createDOTOnlyPrinterWrapperPass();
@Namespace("polly") public static native Pass createDOTOnlyViewerWrapperPass();
@Namespace("polly") public static native Pass createDOTPrinterWrapperPass();
@Namespace("polly") public static native Pass createDOTViewerWrapperPass();
@Namespace("polly") public static native Pass createJSONExporterPass();
@Namespace("polly") public static native Pass createJSONImporterPass();
@Namespace("polly") public static native Pass createJSONImporterPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createPollyCanonicalizePass();
@Namespace("polly") public static native Pass createPolyhedralInfoPass();
@Namespace("polly") public static native Pass createPolyhedralInfoPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createScopDetectionWrapperPassPass();
@Namespace("polly") public static native Pass createScopDetectionPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createScopInfoRegionPassPass();
@Namespace("polly") public static native Pass createScopInfoPrinterLegacyRegionPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createScopInfoWrapperPassPass();
@Namespace("polly") public static native Pass createScopInfoPrinterLegacyFunctionPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createIslAstInfoWrapperPassPass();
@Namespace("polly") public static native Pass createIslAstInfoPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createCodeGenerationPass();
// #ifdef GPU_CODEGEN
// #endif
@Namespace("polly") public static native Pass createIslScheduleOptimizerWrapperPass();
@Namespace("polly") public static native Pass createIslScheduleOptimizerPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createFlattenSchedulePass();
@Namespace("polly") public static native Pass createFlattenSchedulePrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createForwardOpTreeWrapperPass();
@Namespace("polly") public static native Pass createForwardOpTreePrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createDeLICMWrapperPass();
@Namespace("polly") public static native Pass createDeLICMPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createMaximalStaticExpansionPass();
@Namespace("polly") public static native Pass createSimplifyWrapperPass(int arg0);
@Namespace("polly") public static native Pass createSimplifyPrinterLegacyPass(@Cast("llvm::raw_ostream*") @ByRef Pointer OS);
@Namespace("polly") public static native Pass createPruneUnprofitableWrapperPass();

@Namespace("polly") public static native @Cast("char*") @ByRef BytePointer CodePreparationID(); public static native void CodePreparationID(BytePointer setter);

// Targeting ../LLVM/PollyForcePassLinking.java

 // Force link by creating a global definition.
 // namespace
@Namespace("llvm") public static native void initializeCodePreparationPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeScopInlinerPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeScopDetectionWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeScopDetectionPrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeScopInfoRegionPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeScopInfoPrinterLegacyRegionPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeScopInfoWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeScopInfoPrinterLegacyFunctionPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeDeadCodeElimWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeJSONExporterPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeJSONImporterPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeJSONImporterPrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeDependenceInfoPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeDependenceInfoPrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeDependenceInfoWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeDependenceInfoPrinterLegacyFunctionPassPass(
    @ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeIslAstInfoWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeIslAstInfoPrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeCodeGenerationPass(@ByRef PassRegistry arg0);
// #ifdef GPU_CODEGEN
// #endif
@Namespace("llvm") public static native void initializeIslScheduleOptimizerWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeIslScheduleOptimizerPrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeMaximalStaticExpanderWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializePollyCanonicalizePass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeFlattenSchedulePass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeFlattenSchedulePrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeForwardOpTreeWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeForwardOpTreePrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeDeLICMWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeDeLICMPrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeSimplifyWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializeSimplifyPrinterLegacyPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializePruneUnprofitableWrapperPassPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializePolyhedralInfoPass(@ByRef PassRegistry arg0);
@Namespace("llvm") public static native void initializePolyhedralInfoPrinterLegacyPassPass(@ByRef PassRegistry arg0);
 // namespace llvm

// #endif


// Parsed from <FullOptimization.h>

/*
 * Copyright (C) 2020 Yu Kobayashi
 *
 * Licensed either under the Apache License, Version 2.0, or (at your option)
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation (subject to the "Classpath" exception),
 * either version 2, or any later version (collectively, the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     http://www.gnu.org/licenses/
 *     http://www.gnu.org/software/classpath/license.html
 *
 * or as provided in the LICENSE.txt file that accompanied this code.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #ifndef FULL_OPTIMIZATION_H
// #define FULL_OPTIMIZATION_H

// #include "llvm/ExecutionEngine/ExecutionEngine.h"
// #include "llvm/Target/TargetMachine.h"
// #include "llvm/Transforms/IPO.h"
// #include "llvm/Transforms/IPO/PassManagerBuilder.h"
// #include "llvm/IR/Verifier.h"
// #include "llvm/IR/LegacyPassManager.h"
// #include "llvm/CodeGen/TargetPassConfig.h"
// #include "llvm/MC/TargetRegistry.h"
// #include "llvm/Analysis/TargetLibraryInfo.h"
// #include "llvm/Analysis/TargetTransformInfo.h"
// #include "llvm/MC/SubtargetFeature.h"
// #include "llvm/Pass.h"
// #include "llvm-c/Transforms/PassManagerBuilder.h"
// #include "llvm-c/Types.h"
// #include "llvm-c/Error.h"

/**
 * This function does the standard LLVM optimization.
 * This function is based on main() of llvm/tools/opt/opt.cpp.
 * Use LLVMGetHostCPUName() for the cpu argument.
 */
public static native LLVMErrorRef optimizeModule(
    LLVMModuleRef moduleRef,
    @Cast("const char*") BytePointer cpu,
    @Cast("unsigned") int optLevel,
    @Cast("unsigned") int sizeLevel
);
public static native LLVMErrorRef optimizeModule(
    LLVMModuleRef moduleRef,
    String cpu,
    @Cast("unsigned") int optLevel,
    @Cast("unsigned") int sizeLevel
);

/**
 * This function is similar to LLVMCreateJITCompilerForModule() but does CPU specific optimization.
 * Use LLVMGetHostCPUName() for the cpu argument.
 */
public static native LLVMErrorRef createOptimizedJITCompilerForModule(
    @ByPtrPtr LLVMExecutionEngineRef outJIT,
    LLVMModuleRef moduleRef,
    @Cast("const char*") BytePointer cpu,
    @Cast("unsigned") int optLevel
);
public static native LLVMErrorRef createOptimizedJITCompilerForModule(
    @Cast("LLVMExecutionEngineRef*") PointerPointer outJIT,
    LLVMModuleRef moduleRef,
    String cpu,
    @Cast("unsigned") int optLevel
);

// #endif


// Parsed from <NamedMetadataOperations.h>

/*
 * Copyright (C) 2021 Mats Larsen
 *
 * Licensed either under the Apache License, Version 2.0, or (at your option)
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation (subject to the "Classpath" exception),
 * either version 2, or any later version (collectively, the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     http://www.gnu.org/licenses/
 *     http://www.gnu.org/software/classpath/license.html
 *
 * or as provided in the LICENSE.txt file that accompanied this code.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #ifndef NAMED_METADATA_OPERATIONS_H
// #define NAMED_METADATA_OPERATIONS_H

// #include "llvm/IR/LLVMContext.h"
// #include "llvm/IR/Metadata.h"
// #include "llvm-c/Core.h"
// #include "llvm-c/Types.h"

/**
 * Exact re-implementation of LLVMGetNamedMetadataNumOperands without providing
 * a LLVMModuleRef parameter
 *
 * Pass a LLVMNamedMDNodeRef instead, which is the true owner for the data
 * anyways
 *
 * See /llvm/lib/IR/Core.cpp for original implementation
 */
@Namespace("llvm") public static native @Cast("unsigned") int getNamedMDNodeNumOperands(LLVMNamedMDNodeRef NodeRef);

/**
 * Exact re-implementation of LLVMGetNamedMetadataOperands without providing
 * a LLVMModuleRef parameter.
 *
 * This requires a LLVMContextRef instance because conversion from Metadata to
 * Value requires a context in which the new Value will reside in.
 *
 * See /llvm/lib/IR/Core.cpp for original implementation
 */
@Namespace("llvm") public static native void getNamedMDNodeOperands(
    LLVMNamedMDNodeRef NodeRef,
    @ByPtrPtr LLVMValueRef Dest,
    LLVMContextRef InContext
);
@Namespace("llvm") public static native void getNamedMDNodeOperands(
    LLVMNamedMDNodeRef NodeRef,
    @Cast("LLVMValueRef*") PointerPointer Dest,
    LLVMContextRef InContext
);

/**
 * Inlined re-implementation of LLVMAddNamedMetadataOperand without providing
 * a LLVMModuleRef parameter.
 *
 * This implementation inlines the statically defined "extractMDNode" in
 * Core.cpp which the original implementation uses.
 *
 * See /llvm/lib/IR/Core.cpp for original implementation
 */
@Namespace("llvm") public static native void addNamedMDNodeOperand(
    LLVMNamedMDNodeRef NodeRef,
    LLVMValueRef Val
);

/**
 * Inlined re-implementation of LLVMGetMDString without providing a wrapped
 * MetadataAsValue instance
 *
 * See /llvm/lib/IR/Core.cpp for original implementation
 */
@Namespace("llvm") public static native @Cast("const char*") BytePointer getMDString(LLVMMetadataRef M, @Cast("unsigned*") IntPointer Length);
@Namespace("llvm") public static native String getMDString(LLVMMetadataRef M, @Cast("unsigned*") IntBuffer Length);
@Namespace("llvm") public static native @Cast("const char*") BytePointer getMDString(LLVMMetadataRef M, @Cast("unsigned*") int[] Length);

/**
 * Inlined re-implementation of LLVMGetMDNodeNumOperands
 *
 * See /llvm/lib/IR/Core.cpp for original implementation
 */
@Namespace("llvm") public static native @Cast("unsigned") int getMDNodeNumOperands(LLVMMetadataRef M);

/**
 * Inlined re-implementation of LLVMGetMDNodeOperands
 *
 * Accepts an additional LLVMContextRef argument in which all ConstantAsMetadata
 * values will be unwrapped and stored in. (see C API implementation)
 *
 * This implementation inlines the statically defined "getMDNodeOperandsImpl" in
 * Core.cpp which the original implementation uses.
 *
 * See /llvm/lib/IR/Core.cpp for original implementation
 */
@Namespace("llvm") public static native void getMDNodeOperands(
    LLVMMetadataRef M,
    LLVMContextRef C,
    @ByPtrPtr LLVMValueRef Dest);
@Namespace("llvm") public static native void getMDNodeOperands(
    LLVMMetadataRef M,
    LLVMContextRef C,
    @Cast("LLVMValueRef*") PointerPointer Dest);

 // namespace llvm

// #endif // NAMED_METADATA_OPERATIONS_H

// Parsed from <TargetStubs.h>

/*
 * Copyright (C) 2015-2020 Mats Larsen
 *
 * Licensed either under the Apache License, Version 2.0, or (at your option)
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation (subject to the "Classpath" exception),
 * either version 2, or any later version (collectively, the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *     http://www.gnu.org/licenses/
 *     http://www.gnu.org/software/classpath/license.html
 *
 * or as provided in the LICENSE.txt file that accompanied this code.
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Stubs for all LLVM Target initialization routines
 *
 * See #935 https://github.com/bytedeco/javacpp-presets/issues/935
 */
// #define LLVM_TARGET(TargetName)
// void LLVMInitialize##TargetName##TargetInfo(void);
// void LLVMInitialize##TargetName##Target(void);
// void LLVMInitialize##TargetName##TargetMC(void);
// void LLVMInitialize##TargetName##AsmPrinter(void);
// void LLVMInitialize##TargetName##AsmParser(void);
// void LLVMInitialize##TargetName##Disassembler(void);

// Stable Targets
public static native void LLVMInitializeAArch64TargetInfo();
public static native void LLVMInitializeAArch64Target();
public static native void LLVMInitializeAArch64TargetMC();
public static native void LLVMInitializeAArch64AsmPrinter();
public static native void LLVMInitializeAArch64AsmParser();
public static native void LLVMInitializeAArch64Disassembler();
public static native void LLVMInitializeAMDGPUTargetInfo();
public static native void LLVMInitializeAMDGPUTarget();
public static native void LLVMInitializeAMDGPUTargetMC();
public static native void LLVMInitializeAMDGPUAsmPrinter();
public static native void LLVMInitializeAMDGPUAsmParser();
public static native void LLVMInitializeAMDGPUDisassembler();
public static native void LLVMInitializeARMTargetInfo();
public static native void LLVMInitializeARMTarget();
public static native void LLVMInitializeARMTargetMC();
public static native void LLVMInitializeARMAsmPrinter();
public static native void LLVMInitializeARMAsmParser();
public static native void LLVMInitializeARMDisassembler();
public static native void LLVMInitializeAVRTargetInfo();
public static native void LLVMInitializeAVRTarget();
public static native void LLVMInitializeAVRTargetMC();
public static native void LLVMInitializeAVRAsmPrinter();
public static native void LLVMInitializeAVRAsmParser();
public static native void LLVMInitializeAVRDisassembler();
public static native void LLVMInitializeBPFTargetInfo();
public static native void LLVMInitializeBPFTarget();
public static native void LLVMInitializeBPFTargetMC();
public static native void LLVMInitializeBPFAsmPrinter();
public static native void LLVMInitializeBPFAsmParser();
public static native void LLVMInitializeBPFDisassembler();
public static native void LLVMInitializeHexagonTargetInfo();
public static native void LLVMInitializeHexagonTarget();
public static native void LLVMInitializeHexagonTargetMC();
public static native void LLVMInitializeHexagonAsmPrinter();
public static native void LLVMInitializeHexagonAsmParser();
public static native void LLVMInitializeHexagonDisassembler();
public static native void LLVMInitializeLanaiTargetInfo();
public static native void LLVMInitializeLanaiTarget();
public static native void LLVMInitializeLanaiTargetMC();
public static native void LLVMInitializeLanaiAsmPrinter();
public static native void LLVMInitializeLanaiAsmParser();
public static native void LLVMInitializeLanaiDisassembler();
public static native void LLVMInitializeMSP430TargetInfo();
public static native void LLVMInitializeMSP430Target();
public static native void LLVMInitializeMSP430TargetMC();
public static native void LLVMInitializeMSP430AsmPrinter();
public static native void LLVMInitializeMSP430AsmParser();
public static native void LLVMInitializeMSP430Disassembler();
public static native void LLVMInitializeMipsTargetInfo();
public static native void LLVMInitializeMipsTarget();
public static native void LLVMInitializeMipsTargetMC();
public static native void LLVMInitializeMipsAsmPrinter();
public static native void LLVMInitializeMipsAsmParser();
public static native void LLVMInitializeMipsDisassembler();
public static native void LLVMInitializePowerPCTargetInfo();
public static native void LLVMInitializePowerPCTarget();
public static native void LLVMInitializePowerPCTargetMC();
public static native void LLVMInitializePowerPCAsmPrinter();
public static native void LLVMInitializePowerPCAsmParser();
public static native void LLVMInitializePowerPCDisassembler();
public static native void LLVMInitializeRISCVTargetInfo();
public static native void LLVMInitializeRISCVTarget();
public static native void LLVMInitializeRISCVTargetMC();
public static native void LLVMInitializeRISCVAsmPrinter();
public static native void LLVMInitializeRISCVAsmParser();
public static native void LLVMInitializeRISCVDisassembler();
public static native void LLVMInitializeSparcTargetInfo();
public static native void LLVMInitializeSparcTarget();
public static native void LLVMInitializeSparcTargetMC();
public static native void LLVMInitializeSparcAsmPrinter();
public static native void LLVMInitializeSparcAsmParser();
public static native void LLVMInitializeSparcDisassembler();
public static native void LLVMInitializeSystemZTargetInfo();
public static native void LLVMInitializeSystemZTarget();
public static native void LLVMInitializeSystemZTargetMC();
public static native void LLVMInitializeSystemZAsmPrinter();
public static native void LLVMInitializeSystemZAsmParser();
public static native void LLVMInitializeSystemZDisassembler();
public static native void LLVMInitializeWebAssemblyTargetInfo();
public static native void LLVMInitializeWebAssemblyTarget();
public static native void LLVMInitializeWebAssemblyTargetMC();
public static native void LLVMInitializeWebAssemblyAsmPrinter();
public static native void LLVMInitializeWebAssemblyAsmParser();
public static native void LLVMInitializeWebAssemblyDisassembler();
public static native void LLVMInitializeX86TargetInfo();
public static native void LLVMInitializeX86Target();
public static native void LLVMInitializeX86TargetMC();
public static native void LLVMInitializeX86AsmPrinter();
public static native void LLVMInitializeX86AsmParser();
public static native void LLVMInitializeX86Disassembler();

// XCore Target - Does not ship AsmParser
public static native void LLVMInitializeXCoreTargetInfo();
public static native void LLVMInitializeXCoreTarget();
public static native void LLVMInitializeXCoreTargetMC();
public static native void LLVMInitializeXCoreAsmPrinter();
public static native void LLVMInitializeXCoreDisassembler();

// NVPTX Target - Does not ship with AsmParser or Disassembler
public static native void LLVMInitializeNVPTXTargetInfo();
public static native void LLVMInitializeNVPTXTarget();
public static native void LLVMInitializeNVPTXTargetMC();
public static native void LLVMInitializeNVPTXAsmPrinter();

/*
JavaCPP Presets does currently not build experimental targets.

LLVM_TARGET(ARC)
LLVM_TARGET(VE)
*/
// #undef LLVM_TARGET


}
