/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.awt.GraphicsEnvironment;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.netbeans.MainImpl;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        int required = 17;
        if (Boolean.getBoolean("bootstrap.disableJDKCheck")) {
            System.err.println(Main.getMessage("MSG_WarnJavaCheckDisabled"));
        } else if (!Main.checkJavaVersion(required)) {
            System.err.println(Main.getMessage("MSG_InstallJava", required));
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, Main.getMessage("MSG_InstallJava", required), Main.getMessage("MSG_NeedsJava", required), 2);
            }
            System.exit(10);
        }
        MainImpl.main(args);
    }

    private static boolean checkJavaVersion(int required) {
        if (required < 11) {
            throw new IllegalArgumentException();
        }
        try {
            Object runtimeVersion = Runtime.class.getMethod("version", new Class[0]).invoke(null, new Object[0]);
            return (Integer)runtimeVersion.getClass().getMethod("feature", new Class[0]).invoke(runtimeVersion, new Object[0]) >= required;
        }
        catch (ReflectiveOperationException ex) {
            return false;
        }
    }

    private static String getMessage(String key) {
        return ResourceBundle.getBundle("org.netbeans.Bundle").getString(key);
    }

    private static String getMessage(String key, int arg) {
        return Main.getMessage(key).replace("{0}", String.valueOf(arg));
    }

    public static void finishInitialization() {
        MainImpl.finishInitialization();
    }
}

