/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.upgrader;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Pattern;
import org.graalvm.visualizer.upgrader.PathTransformation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class Copy {
    private FileObject sourceRoot;
    private FileObject targetRoot;
    private Set thoseToCopy;
    private PathTransformation transformation;

    private Copy(FileObject source, FileObject target, Set thoseToCopy, PathTransformation transformation) {
        this.sourceRoot = source;
        this.targetRoot = target;
        this.thoseToCopy = thoseToCopy;
        this.transformation = transformation;
    }

    public static void copyDeep(FileObject source, FileObject target, Set thoseToCopy) throws IOException {
        Copy.copyDeep(source, target, thoseToCopy, null);
    }

    public static void copyDeep(FileObject source, FileObject target, Set thoseToCopy, PathTransformation transformation) throws IOException {
        Copy instance = new Copy(source, target, thoseToCopy, transformation);
        instance.copyFolder(instance.sourceRoot);
    }

    private void copyFolder(FileObject sourceFolder) throws IOException {
        FileObject[] srcChildren = sourceFolder.getChildren();
        for (int i = 0; i < srcChildren.length; ++i) {
            FileObject child = srcChildren[i];
            if (child.isFolder()) {
                this.copyFolder(child);
                if (!this.thoseToCopy.contains(child.getPath()) && !this.thoseToCopy.contains(child.getPath() + "/") || !child.getAttributes().hasMoreElements()) continue;
                this.copyFolderAttributes(child);
                continue;
            }
            if (!this.thoseToCopy.contains(child.getPath())) continue;
            this.copyFile(child);
        }
    }

    private void copyFolderAttributes(FileObject sourceFolder) throws IOException {
        FileObject targetFolder = FileUtil.createFolder((FileObject)this.targetRoot, (String)sourceFolder.getPath());
        if (sourceFolder.getAttributes().hasMoreElements()) {
            FileUtil.copyAttributes((FileObject)sourceFolder, (FileObject)targetFolder);
        }
    }

    private void copyFile(FileObject sourceFile) throws IOException {
        String targetPath = this.transformation != null ? this.transformation.transformPath(sourceFile.getPath()) : sourceFile.getPath();
        boolean isTransformed = !targetPath.equals(sourceFile.getPath());
        FileObject tg = this.targetRoot.getFileObject(targetPath);
        try {
            if (tg == null) {
                FileObject targetFolder = null;
                String name = null;
                String ext = null;
                if (isTransformed) {
                    FileObject targetFile = FileUtil.createData((FileObject)this.targetRoot, (String)targetPath);
                    targetFolder = targetFile.getParent();
                    name = targetFile.getName();
                    ext = targetFile.getExt();
                    targetFile.delete();
                } else {
                    targetFolder = FileUtil.createFolder((FileObject)this.targetRoot, (String)sourceFile.getParent().getPath());
                    name = sourceFile.getName();
                    ext = sourceFile.getExt();
                }
                tg = FileUtil.copyFile((FileObject)sourceFile, (FileObject)targetFolder, (String)name, (String)ext);
            }
        }
        catch (IOException ex) {
            if (sourceFile.getNameExt().endsWith("_hidden")) {
                return;
            }
            throw ex;
        }
        FileUtil.copyAttributes((FileObject)sourceFile, (FileObject)tg);
    }

    /*
     * Unable to fully structure code
     */
    public static void appendSelectedLines(File sourceFile, File targetFolder, String[] regexForSelection) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        linePattern = new Pattern[regexForSelection.length];
        for (i = 0; i < linePattern.length; ++i) {
            linePattern[i] = Pattern.compile(regexForSelection[i]);
        }
        bos = new ByteArrayOutputStream();
        targetFile = new File(targetFolder, sourceFile.getName());
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        if (!Copy.$assertionsDisabled && !targetFolder.exists()) {
            throw new AssertionError();
        }
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        } else {
            targetIS = new FileInputStream(targetFile);
            try {
                FileUtil.copy((InputStream)targetIS, (OutputStream)bos);
            }
            finally {
                targetIS.close();
            }
        }
        if (!Copy.$assertionsDisabled && !targetFile.exists()) {
            throw new AssertionError();
        }
        line = null;
        sourceReader = new BufferedReader(new FileReader(sourceFile));
lbl30:
        // 2 sources

        try {
            block21: while ((line = sourceReader.readLine()) != null) {
                block32: {
                    if (linePattern == null) break block32;
                    for (i = 0; i < linePattern.length; ++i) {
                        m = linePattern[i].matcher(line);
                        if (!m.matches()) continue;
                        bos.write(line.getBytes());
                        bos.write(10);
                        continue block21;
                    }
                    ** GOTO lbl30
                }
                bos.write(line.getBytes());
                bos.write(10);
            }
        }
        finally {
            sourceReader.close();
        }
        bin = new ByteArrayInputStream(bos.toByteArray());
        try {
            targetOS = new FileOutputStream(targetFile);
            try {
                FileUtil.copy((InputStream)bin, (OutputStream)targetOS);
            }
            finally {
                targetOS.close();
            }
        }
        finally {
            bin.close();
        }
    }
}

