/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.upgrader;

public class PathTransformation {
    private String version;

    private PathTransformation(String version) {
        this.version = version;
    }

    public static PathTransformation getInstance(String version) {
        return new PathTransformation(version);
    }

    public String transformPath(String path) {
        boolean isCreator = this.version.startsWith("2_");
        if (isCreator) {
            return this.transformCreatorPath(path);
        }
        boolean i118364 = path.startsWith("Templates/Classes/");
        if (i118364 && !this.version.startsWith("6")) {
            return this.transformTemplatePath118364(path);
        }
        return path;
    }

    private String transformTemplatePath118364(String path) {
        return path.replace("Templates/Classes/", "Templates/Oldies/Classes/");
    }

    private String transformCreatorPath(String path) {
        String[] keysToReplace;
        String keyToReplace = null;
        for (String key : keysToReplace = new String[]{"context.xml"}) {
            if (!path.startsWith(key)) continue;
            keyToReplace = key;
            break;
        }
        if (keyToReplace != null) {
            return path.replace(keyToReplace, "config/" + this.version + "/" + keyToReplace);
        }
        return path;
    }
}

