/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.upgrader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.graalvm.visualizer.upgrader.AutoUpgradePanel;
import org.graalvm.visualizer.upgrader.CopyFiles;
import org.graalvm.visualizer.upgrader.impl.UpgradeFromOldDev;
import org.graalvm.visualizer.upgrader.impl.UpgradeFrom_0_26;
import org.netbeans.util.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public abstract class Upgrader {
    private static final Logger LOGGER = Logger.getLogger(Upgrader.class.getName());
    private static final List<String> FORMER_VERSIONS = Arrays.asList("0.26", "dev");
    private static final List<Upgrader> KNOWN_UPGRADERS = Arrays.asList(new UpgradeFrom_0_26(), new UpgradeFromOldDev());
    protected static final String NETBEANS_USERDIR_ROOT = "netbeans.default_userdir_root";
    protected static final String IMPORTED_MARK = "var/imported";
    protected static final String NETBEANS_USER = "netbeans.user";
    protected static String importingFromVersion;
    private static final Stack<Upgrader> versionUpgrade;

    public static void main(String[] args) {
        File sourceFolder;
        LOGGER.fine("Starting importer");
        if (LOGGER.isLoggable(Level.FINEST)) {
            Upgrader.logAllPossibleInfo();
        }
        if ((sourceFolder = Upgrader.findFormerVersionFolder()) == null) {
            LOGGER.fine("Didn't found former or dev dir to import from.");
            return;
        }
        Upgrader.prepareImport();
        LOGGER.fine("Using dir: " + sourceFolder.getAbsolutePath() + " for import.");
        Upgrader.showUpgradeDialog(sourceFolder);
    }

    private static File findFormerVersionFolder() {
        File userHomeFile;
        LOGGER.fine("Looking for former version dir.");
        String defaultUserdirRoot = System.getProperty(NETBEANS_USERDIR_ROOT);
        if (defaultUserdirRoot != null) {
            userHomeFile = new File(defaultUserdirRoot);
        } else {
            LOGGER.fine("User dir: netbeans.default_userdir_root not found.");
            defaultUserdirRoot = System.getProperty(NETBEANS_USER);
            if (defaultUserdirRoot == null) {
                LOGGER.fine("User dir: netbeans.user not found.");
                return null;
            }
            userHomeFile = new File(defaultUserdirRoot).getParentFile();
        }
        LOGGER.fine("Using userdir root: " + userHomeFile.getAbsolutePath());
        for (String version : FORMER_VERSIONS) {
            File sourceFolder = new File(userHomeFile.getAbsolutePath(), version);
            if (!sourceFolder.exists() || !sourceFolder.isDirectory()) continue;
            if (version.equals("dev") && (Upgrader.wasDev(sourceFolder) || Upgrader.newDev(sourceFolder))) {
                LOGGER.fine("Former dev version dir: " + sourceFolder.getAbsolutePath() + " won't be used.");
                return null;
            }
            importingFromVersion = version;
            LOGGER.fine("Found former version dir: " + sourceFolder.getAbsolutePath());
            return sourceFolder;
        }
        LOGGER.fine("Former version dir not found.");
        return null;
    }

    private static boolean newDev(File devUserFile) {
        File importedFile = new File(devUserFile, IMPORTED_MARK);
        return importedFile.exists();
    }

    private static boolean wasDev(File sourceFolder) {
        String currentUserDir = System.getProperty(NETBEANS_USER);
        return currentUserDir == null || new File(currentUserDir).equals(sourceFolder);
    }

    private static boolean showUpgradeDialog(File source) {
        Util.setDefaultLookAndFeel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new AutoUpgradePanel(source.getAbsolutePath()), "Center");
        JProgressBar progressBar = new JProgressBar(0, 100);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        progressBar.setIndeterminate(true);
        panel.add((Component)progressBar, "South");
        progressBar.setVisible(false);
        JButton bYES = new JButton("Yes");
        bYES.setMnemonic(89);
        JButton bNO = new JButton("No");
        bNO.setMnemonic(78);
        Object[] options = new JButton[]{bYES, bNO};
        JOptionPane p = new JOptionPane(panel, 3, 0, null, options, bYES);
        JDialog d = Util.createJOptionProgressDialog(p, NbBundle.getMessage(Upgrader.class, (String)"MSG_Confirmation_Title"), source, progressBar);
        if (Boolean.getBoolean("netbeans.startup.autoupgrade")) {
            SwingUtilities.invokeLater(() -> p.setValue(0));
        }
        d.setVisible(true);
        return new Integer(0).equals(p.getValue());
    }

    public static void doCopyToUserDir(File source) throws IOException {
        File userdir = new File(System.getProperty(NETBEANS_USER, ""));
        File netBeansDir = InstalledFileLocator.getDefault().locate("modules", null, false).getParentFile().getParentFile();
        File importFile = new File(netBeansDir, "etc/igv.import");
        LOGGER.fine("Import file: " + importFile);
        LOGGER.info("Importing from " + source + " to " + userdir);
        CopyFiles.copyDeep(source, userdir, importFile);
    }

    public static void doImport() {
        if (versionUpgrade.empty() && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("No issued Upgraders.");
        }
        while (!versionUpgrade.empty()) {
            Upgrader upgrader = versionUpgrade.pop();
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Importing using Upgrader: " + upgrader.getClass().getName());
            }
            upgrader.doVersionImport();
        }
    }

    private static void logAllPossibleInfo() {
        LOGGER.finest("netbeans.user = " + System.getProperty(NETBEANS_USER));
        LOGGER.finest("netbeans.default_userdir_root = " + System.getProperty(NETBEANS_USERDIR_ROOT));
        LOGGER.finest("Former versions = [" + FORMER_VERSIONS.stream().reduce("", (m, n) -> m + ", " + n).substring(2) + "]");
        LOGGER.finest(Upgrader.buildUpgradersInfo());
    }

    private static String buildUpgradersInfo() {
        StringBuilder sb = new StringBuilder();
        for (Upgrader upgrader : KNOWN_UPGRADERS) {
            sb.append("\n\t").append(upgrader.getClass().getName());
            sb.append("\n\t\t").append("Importing from version: ").append(upgrader.getImportingVersion());
            sb.append("\n\t\t").append("Changes: ").append(upgrader.getChangesInfo());
        }
        return sb.toString();
    }

    private static void prepareImport() {
        HashMap<String, Upgrader> upgraders = new HashMap<String, Upgrader>(KNOWN_UPGRADERS.size());
        for (Upgrader upgrader : KNOWN_UPGRADERS) {
            upgraders.put(upgrader.getImportingVersion(), upgrader);
        }
        for (String version : FORMER_VERSIONS) {
            Upgrader upgrader = (Upgrader)upgraders.get(version);
            if (upgrader != null) {
                versionUpgrade.push(upgrader);
            }
            if (!version.equals(importingFromVersion)) continue;
            return;
        }
    }

    protected abstract String getImportingVersion();

    protected abstract String getChangesInfo();

    protected abstract void doVersionImport();

    static {
        versionUpgrade = new Stack();
    }
}

