/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.upgrader.impl;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.visualizer.upgrader.Upgrader;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class UpgradeFromOldDev
extends Upgrader {
    private static final String IMPORTING_VERSION = "dev";
    private static final String PATTERN_STRING = "(?<func>(?:colorize|split))\\(\\p{Space}*['\"]class['\"]\\p{Space}*,\\p{Space}*.(?<value>['\"][\\p{Alnum}_$]+['\"]).*";
    private static final Pattern USE_CLASS_PATTERN = Pattern.compile("(?<func>(?:colorize|split))\\(\\p{Space}*['\"]class['\"]\\p{Space}*,\\p{Space}*.(?<value>['\"][\\p{Alnum}_$]+['\"]).*");
    private static final String GROUP_VALUE = "value";

    @Override
    protected void doVersionImport() {
        UpgradeFromOldDev.doImport();
    }

    public static void doImport() {
        FileObject root = FileUtil.getConfigFile((String)"Filters");
        if (root == null) {
            return;
        }
        for (FileObject f : root.getChildren()) {
            StringBuilder sb = new StringBuilder();
            boolean changed = false;
            try {
                for (Object line : f.asLines("UTF-8")) {
                    Matcher m = USE_CLASS_PATTERN.matcher((CharSequence)line);
                    int start = 0;
                    String orig = line;
                    while (start < ((String)line).length() && m.find(start)) {
                        start = m.end();
                        String func = m.group("func");
                        String val = m.group(GROUP_VALUE);
                        if (func == null || val == null) continue;
                        int valStart = m.start(GROUP_VALUE);
                        int valEnd = m.end(GROUP_VALUE);
                        String replacement = "classSimpleName(" + val + ")";
                        line = ((String)line).substring(0, valStart) + replacement + ((String)line).substring(valEnd);
                        start += replacement.length() - val.length();
                    }
                    line = ((String)line).replaceAll("com.sun.hotspot.igv", "org.graalvm.visualizer");
                    sb.append((String)line).append("\n");
                    changed |= orig.equals(line);
                }
                if (!changed) continue;
                try (OutputStreamWriter w = new OutputStreamWriter(f.getOutputStream(), "UTF-8");){
                    w.write(sb.toString());
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
            }
        }
    }

    @Override
    protected String getImportingVersion() {
        return IMPORTING_VERSION;
    }

    @Override
    protected String getChangesInfo() {
        return "Updating filter definitions used in old IGV, using pattern: (?<func>(?:colorize|split))\\(\\p{Space}*['\"]class['\"]\\p{Space}*,\\p{Space}*.(?<value>['\"][\\p{Alnum}_$]+['\"]).*";
    }
}

