/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell;

import java.io.IOException;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.graalvm.visualizer.filter.FilterEnvironment;
import org.graalvm.visualizer.filter.FilterEvent;
import org.graalvm.visualizer.filter.FilterExecution;
import org.graalvm.visualizer.filter.FilterListener;
import org.graalvm.visualizer.script.ScriptEnvironment;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public final class ShellSession {
    private final SharedScriptEnv environment = new SharedScriptEnv();
    private final SL execListener = new SL();
    private final FilterListener weakL = (FilterListener)WeakListeners.create(FilterListener.class, (EventListener)((Object)this.execListener), (Object)FilterExecution.getExecutionService());
    private static ShellSession current;

    public ShellSession() {
        FilterExecution.getExecutionService().addFilterListener(this.weakL);
    }

    public static synchronized ShellSession getCurrentSession() {
        if (current == null) {
            current = new ShellSession();
        }
        return current;
    }

    private void close() throws IOException {
        this.getSharedEnvironment().close();
        FilterExecution.getExecutionService().removeFilterListener(this.weakL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShellSession recycle() {
        Class<ShellSession> clazz = ShellSession.class;
        synchronized (ShellSession.class) {
            ShellSession c = current;
            ShellSession r = current = new ShellSession();
            // ** MonitorExit[var2] (shouldn't be in output)
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return r;
        }
    }

    public ScriptEnvironment getSharedEnvironment() {
        return this.environment;
    }

    static class SharedScriptEnv
    extends ScriptEnvironment {
        private volatile Thread executionThread;
        private final Map<Object, Object> vals = new HashMap<Object, Object>();

        SharedScriptEnv() {
        }

        public Thread getExecutionThread() {
            return this.executionThread;
        }

        public void setExecutionThread(Thread executionThread) {
            this.executionThread = executionThread;
        }

        private void checkThread() {
            Thread t = this.executionThread;
            if (t == null || t == Thread.currentThread()) {
                return;
            }
            throw new IllegalStateException("Multiple threads are not supported");
        }

        public <T> T setValue(Object key, T val) {
            this.checkThread();
            return (T)this.vals.put(key, val);
        }

        public <T> T getValue(Object key) {
            this.checkThread();
            return (T)this.vals.get(key);
        }

        public Set keys() {
            this.checkThread();
            return this.vals.keySet();
        }

        public Iterable values() {
            return this.vals.values();
        }
    }

    class SL
    implements FilterListener {
        SL() {
        }

        public void filterStart(FilterEvent e) {
        }

        public void filterEnd(FilterEvent e) {
            FilterEnvironment fenv = e.getExecution().getEnvironment();
        }

        public void executionStart(FilterEvent e) {
            FilterEnvironment fenv = e.getExecution().getEnvironment();
            if (fenv.getScriptEnvironment() == ShellSession.this.getSharedEnvironment()) {
                ShellSession.this.environment.setExecutionThread(Thread.currentThread());
            }
        }

        public void executionEnd(FilterEvent e) {
            FilterEnvironment fenv = e.getExecution().getEnvironment();
            if (fenv.getScriptEnvironment() == ShellSession.this.getSharedEnvironment()) {
                ShellSession.this.environment.setExecutionThread(null);
            }
        }
    }
}

