/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.graal.compiler.graphio.parsing.model.Group;
import org.graalvm.visualizer.script.UserScriptEngine;
import org.graalvm.visualizer.shell.Bundle;
import org.graalvm.visualizer.util.FileHelpers;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;

public class ShellUtils {
    private static final Logger LOG = Logger.getLogger(ShellUtils.class.getName());
    public static final String SCRIPT_ROOT_FOLDER = "scripts";
    public static final String SCRIPT_TEMPLATES_FOLDER = "Templates/Scripts";
    public static final String SCRAP_FOLDER_PATH = "igv-shell";
    public static final String SHELL_EXTENSION = "shell";
    public static final String ATTR_GRAPH_SCRIPT = "igv.diagramScript";
    public static final String ATTR_HIDDEN = "igv.hidden";
    private static final String PREF_LAST_TEMPLATE = "lastScriptTemplate";
    private static final String DEF_LAST_TEMPLATE = "Templates/Scripts/JSFilter.js";
    private static EngineCache engCache;
    private static final String ATTR_SCRAP_TEMPLATE = "scrapTemplate";
    private static final Predicate<FileObject> VISIBLE_PREDICATE;
    static final Map<FileObject, List<Consumer<FileObject>>> scrapNotifyList;
    static final List<Consumer<FileObject>> globalScrapNotifyList;
    private static final FileChangeListener SCRAP_SHARED_LISTENER;

    public static FileObject getScriptRoot() throws IOException {
        FileObject f = FileUtil.getConfigFile((String)SCRIPT_ROOT_FOLDER);
        if (f == null) {
            throw new FileNotFoundException(SHELL_EXTENSION);
        }
        return f;
    }

    public static DataObject createScrapScript(DataObject template) throws IOException {
        DataObject selected = template;
        if (template == null) {
            DataFolder templates = ShellUtils.getTemplatesFolder();
            for (DataObject tmpl : templates.getChildren()) {
                if (tmpl.getPrimaryFile().getAttribute(ATTR_SCRAP_TEMPLATE) == null) continue;
                selected = tmpl;
                break;
            }
        }
        if (selected == null) {
            throw new IOException(Bundle.ERR_NoScrapTemplate());
        }
        final DataObject fSelected = selected;
        FileObject scriptRoot = ShellUtils.ensureScriptRoot();
        final DataFolder fld = DataFolder.findFolder((FileObject)scriptRoot);
        final DataObject[] result = new DataObject[1];
        fld.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                DataObject scriptData = fSelected.createFromTemplate(fld);
                FileObject sc = scriptData.getPrimaryFile();
                sc.setAttribute(ShellUtils.ATTR_HIDDEN, (Object)true);
                sc.setAttribute(ShellUtils.ATTR_SCRAP_TEMPLATE, null);
                result[0] = scriptData;
            }
        });
        return result[0];
    }

    public static FileObject ensureScriptRoot() throws IOException {
        return FileHelpers.ensureConfigWritable((String)SCRIPT_ROOT_FOLDER);
    }

    public static FileObject createGrouShellDirectory(Group compilationGroup) throws IOException {
        String path;
        String n = compilationGroup.getName();
        File f = Places.getCacheSubdirectory((String)SCRAP_FOLDER_PATH);
        FileObject fo = FileUtil.toFileObject((File)f);
        FileObject dir = fo.getFileObject(path = n + ".shell");
        if (dir == null) {
            dir = fo.createFolder(path);
        }
        return dir;
    }

    public static String getLanguageName(String mimeType) {
        FileObject f = FileUtil.getConfigFile((String)("Editors/" + mimeType));
        if (f == null) {
            return null;
        }
        try {
            String dispName = f.getFileSystem().getDecorator().annotateName(null, Collections.singleton(f));
            if (dispName != null) {
                return dispName;
            }
            Object[] bundleInfo = ShellUtils.findResourceBundle(f);
            if (bundleInfo[1] != null) {
                try {
                    return ((ResourceBundle)bundleInfo[1]).getString(mimeType);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return mimeType;
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return mimeType;
        }
    }

    private static Object[] findResourceBundle(FileObject fo) {
        assert (fo != null) : "FileObject can't be null";
        Object[] bundleInfo = null;
        String bundleName = null;
        Object attrValue = fo.getAttribute("SystemFileSystem.localizingBundle");
        if (attrValue instanceof String) {
            bundleName = (String)attrValue;
        }
        if (bundleName != null) {
            try {
                bundleInfo = new Object[]{bundleName, NbBundle.getBundle((String)bundleName)};
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (bundleInfo == null) {
            bundleInfo = new Object[]{bundleName, null};
        }
        return bundleInfo;
    }

    public static DataObject getLastScriptTemplate() {
        DataObject d;
        String x = NbPreferences.forModule(ShellUtils.class).get(PREF_LAST_TEMPLATE, DEF_LAST_TEMPLATE);
        FileObject ft = FileUtil.getConfigFile((String)x);
        if (ft == null || !ft.isValid()) {
            return null;
        }
        try {
            d = DataObject.find((FileObject)ft);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        return d.isTemplate() ? d : null;
    }

    public static void setLastScriptTemplate(DataObject selected) {
        NbPreferences.forModule(ShellUtils.class).put(PREF_LAST_TEMPLATE, selected.getPrimaryFile().getPath());
    }

    public static DataFolder getTemplatesFolder() throws IOException {
        FileObject f = FileUtil.getConfigFile((String)SCRIPT_TEMPLATES_FOLDER);
        if (f == null || !f.isFolder()) {
            throw new FileNotFoundException(f == null ? "Not found" : f.getPath());
        }
        return (DataFolder)DataObject.find((FileObject)f);
    }

    public static void markScriptObject(FileObject f, boolean markOn) throws IOException {
        DataObject d = DataObject.find((FileObject)f);
        FileObject orig = DataShadow.findOriginal((FileObject)f);
        if (orig == null) {
            orig = d.getPrimaryFile();
        }
        if (orig == null) {
            throw new FileNotFoundException(f.getPath());
        }
        orig.setAttribute(ATTR_GRAPH_SCRIPT, (Object)(markOn ? Boolean.TRUE : null));
    }

    public static boolean isScriptObject(FileObject f) {
        return f != null && (Boolean.TRUE.equals(f.getAttribute(ATTR_GRAPH_SCRIPT)) || f.getPath().startsWith("Filters/") || f.getPath().startsWith("IGV/") || f.getPath().startsWith("_"));
    }

    public static Predicate<FileObject> visibleScriptObjects() {
        return VISIBLE_PREDICATE;
    }

    public static Collection<String> getSupportedLanguages() {
        return ShellUtils.engCache().supportedMimes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EngineCache engCache() {
        Class<ShellUtils> clazz = ShellUtils.class;
        synchronized (ShellUtils.class) {
            EngineCache c = engCache;
            if (c == null) {
                engCache = c = new EngineCache();
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            return c;
        }
    }

    public static boolean isScriptMimeType(String mime) {
        return ShellUtils.engCache().supportedMimes().contains(mime);
    }

    public static void materializeScrapFile(FileObject script) {
        if (script == null || !script.isValid()) {
            return;
        }
        try {
            script.setAttribute(ATTR_HIDDEN, null);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not un-hide file {0}", script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyScriptMaterialized(FileObject script) {
        ArrayList<Consumer<FileObject>> cons;
        Map<FileObject, List<Consumer<FileObject>>> map = scrapNotifyList;
        synchronized (map) {
            cons = new ArrayList<Consumer<FileObject>>(Optional.ofNullable(scrapNotifyList.remove(script)).orElse(Collections.emptyList()));
            cons.addAll(globalScrapNotifyList);
        }
        for (Consumer consumer : cons) {
            consumer.accept(script);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onScrapMaterialize(FileObject scrap, Consumer<FileObject> scrapCallback) {
        List refs;
        Map<FileObject, List<Consumer<FileObject>>> map = scrapNotifyList;
        synchronized (map) {
            if (scrap == null) {
                globalScrapNotifyList.add(scrapCallback);
                return;
            }
            refs = scrapNotifyList.computeIfAbsent(scrap, f -> new ArrayList());
        }
        if (refs.isEmpty()) {
            scrap.addFileChangeListener(SCRAP_SHARED_LISTENER);
        }
        refs.add(scrapCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMaterializeCallback(FileObject scrap, Consumer<FileObject> listener) {
        Map<FileObject, List<Consumer<FileObject>>> map = scrapNotifyList;
        synchronized (map) {
            if (scrap == null) {
                globalScrapNotifyList.remove(listener);
                return;
            }
            List<Consumer<FileObject>> refs = scrapNotifyList.get(scrap);
            if (refs == null) {
                return;
            }
            refs.remove(listener);
        }
    }

    public static FileObject lookupFilterFile(Lookup lkp) {
        try {
            FileObject f = (FileObject)lkp.lookup(FileObject.class);
            if (f == null || !f.isValid()) {
                return null;
            }
            FileObject linked = DataShadow.findOriginal((FileObject)f);
            if (linked != null) {
                f = linked;
            }
            return ShellUtils.isScriptObject(f) ? f : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private ShellUtils() {
    }

    static {
        VISIBLE_PREDICATE = new Predicate<FileObject>(){

            @Override
            public boolean test(FileObject t) {
                return t != null && t.getAttribute(ShellUtils.ATTR_HIDDEN) != Boolean.TRUE;
            }
        };
        scrapNotifyList = new WeakHashMap<FileObject, List<Consumer<FileObject>>>();
        globalScrapNotifyList = new ArrayList<Consumer<FileObject>>();
        SCRAP_SHARED_LISTENER = new ScrapListener();
    }

    static class EngineCache {
        private final Lookup.Result<UserScriptEngine> engines;
        private Set<String> mimes = null;
        private final LookupListener ll;
        private final AtomicInteger version = new AtomicInteger(0);

        public EngineCache() {
            this.engines = Lookup.getDefault().lookupResult(UserScriptEngine.class);
            this.ll = ev -> this.invalidate();
            this.engines.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.ll, this.engines));
        }

        private synchronized void invalidate() {
            this.mimes = null;
            this.version.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<String> supportedMimes() {
            int v = this.version.get();
            EngineCache engineCache = this;
            synchronized (engineCache) {
                if (this.mimes != null) {
                    return Collections.unmodifiableCollection(this.mimes);
                }
            }
            HashSet<String> m = new HashSet<String>();
            for (UserScriptEngine e : this.engines.allInstances()) {
                m.addAll(e.supportedLanguages());
            }
            EngineCache engineCache2 = this;
            synchronized (engineCache2) {
                if (this.version.get() == v) {
                    this.mimes = Collections.unmodifiableSet(m);
                }
            }
            return m;
        }
    }

    static class ScrapListener
    extends FileChangeAdapter {
        ScrapListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            if (!ShellUtils.ATTR_HIDDEN.equals(fe.getName())) {
                return;
            }
            FileObject file = fe.getFile();
            file.removeFileChangeListener((FileChangeListener)this);
            ShellUtils.notifyScriptMaterialized(file);
        }
    }
}

