/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualizer.shell.actions;

import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.graalvm.visualizer.filter.FilterProvider;
import org.graalvm.visualizer.filter.Filters;
import org.graalvm.visualizer.shell.actions.EditorContextActionBase;
import org.graalvm.visualizer.view.api.DiagramModel;
import org.graalvm.visualizer.view.api.DiagramViewer;
import org.graalvm.visualizer.view.api.DiagramViewerLocator;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public abstract class AbstractGraphShellAction
extends EditorContextActionBase {
    private final FilterProvider source;
    private final Lookup lkp;
    private volatile Reference<DiagramModel> modelRef = new WeakReference<Object>(null);
    private final DiagramViewerLocator viewLocator;
    private static final WeakReference<DiagramModel> NO_DIAGRAM = new WeakReference<Object>(null);
    private boolean initialized;
    private final ChangeListener l = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            boolean checkDiagram;
            boolean bl = checkDiagram = AbstractGraphShellAction.this.viewLocator == e.getSource();
            if (SwingUtilities.isEventDispatchThread()) {
                AbstractGraphShellAction.this.computeEnabledAWT(checkDiagram);
            } else {
                SwingUtilities.invokeLater(() -> AbstractGraphShellAction.this.computeEnabledAWT(checkDiagram));
            }
        }
    };

    public AbstractGraphShellAction() {
        this((Map<String, ?>)null, (Lookup)null);
    }

    AbstractGraphShellAction(Map<String, ?> attrs, Lookup lkp) {
        super(attrs);
        this.lkp = lkp == null ? Utilities.actionsGlobalContext() : lkp;
        this.source = AbstractGraphShellAction.findSource(lkp);
        if (this.source != null) {
            this.source.addChangeListener(WeakListeners.change((ChangeListener)this.l, (Object)this.source));
        }
        this.viewLocator = (DiagramViewerLocator)Lookup.getDefault().lookup(DiagramViewerLocator.class);
        if (this.viewLocator != null) {
            this.viewLocator.addChangeListener(WeakListeners.change((ChangeListener)this.l, (Object)this.viewLocator));
        }
        this.setEnabled(this.source != null);
        if (this.source == null) {
            this.putValue("hideWhenDisabled", Boolean.TRUE);
        }
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.computeEnabledAWT(false);
    }

    protected final Lookup getLookup() {
        return this.lkp;
    }

    private static FilterProvider findSource(Lookup lkp) {
        return Filters.locateChainSource((Lookup)lkp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEnabledAWT(boolean checkDiagram) {
        DiagramModel oldModel;
        if (this.source == null || this.viewLocator == null) {
            this.setEnabled(false);
            return;
        }
        AbstractGraphShellAction abstractGraphShellAction = this;
        synchronized (abstractGraphShellAction) {
            oldModel = this.modelRef.get();
            if (checkDiagram) {
                this.modelRef = null;
            }
        }
        DiagramModel current = this.findDiagramModel();
        if ((checkDiagram || oldModel == null) && current != oldModel) {
            this.diagramModelChanged(oldModel, current);
        }
        if (this.source != null && this.viewLocator != null) {
            this.setEnabled(this.computeEnabled(current, this.source));
        } else {
            this.setEnabled(false);
        }
    }

    protected final void refresh() {
        this.computeEnabledAWT(true);
    }

    protected void diagramModelChanged(DiagramModel previous, DiagramModel current) {
    }

    protected final DiagramViewer findViewer() {
        return this.viewLocator.getActiveViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DiagramModel findDiagramModel() {
        DiagramModel mdl;
        Reference<DiagramModel> mr = this.modelRef;
        if (mr != null && ((mdl = mr.get()) != null || mr == NO_DIAGRAM)) {
            return mdl;
        }
        mdl = this.viewLocator.getActiveModel();
        AbstractGraphShellAction abstractGraphShellAction = this;
        synchronized (abstractGraphShellAction) {
            if (mr == this.modelRef) {
                this.modelRef = mdl == null ? NO_DIAGRAM : new WeakReference<DiagramModel>(mdl);
            }
        }
        return mdl;
    }

    protected final FilterProvider getFilterSource() {
        return this.source;
    }

    protected abstract boolean computeEnabled(DiagramModel var1, FilterProvider var2);

    @Override
    public JMenuItem getPopupPresenter() {
        this.initialize();
        return super.getPopupPresenter();
    }

    @Override
    public JMenuItem getMenuPresenter() {
        this.initialize();
        return super.getMenuPresenter();
    }

    @Override
    public Component getToolbarPresenter() {
        this.initialize();
        return super.getToolbarPresenter();
    }
}

